/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.services.AbfsListStatusRemoteIterator;
import org.apache.hadoop.fs.azurebfs.services.ListingSupport;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ITestAbfsListStatusRemoteIterator
extends AbstractAbfsIntegrationTest {
    private static final int TEST_FILES_NUMBER = 1000;

    @Test
    public void testAbfsIteratorWithHasNext() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        List<String> fileNames = this.createFilesUnderDirectory(1000, testDir, "testListPath");
        ListingSupport listngSupport = (ListingSupport)Mockito.spy((Object)this.getFileSystem().getAbfsStore());
        AbfsListStatusRemoteIterator fsItr = new AbfsListStatusRemoteIterator(this.getFileSystem().getFileStatus(testDir), listngSupport, this.getTestTracingContext(this.getFileSystem(), true));
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should be instance of AbfsListStatusRemoteIterator by default", new Object[0])).isInstanceOf(AbfsListStatusRemoteIterator.class);
        int itrCount = 0;
        while (fsItr.hasNext()) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            String pathStr = fileStatus.getPath().toString();
            fileNames.remove(pathStr);
            ++itrCount;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)itrCount).describedAs("Number of iterations should be equal to the files created", new Object[0])).isEqualTo(1000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileNames.size()).describedAs("After removing every iterm found from the iterator, there should be no more elements in the fileNames", new Object[0])).isEqualTo(0);
        int minNumberOfInvokations = 100;
        ((ListingSupport)Mockito.verify((Object)listngSupport, (VerificationMode)Mockito.atLeast((int)minNumberOfInvokations))).listStatus((Path)ArgumentMatchers.any(Path.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyList(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    @Test
    public void testAbfsIteratorWithoutHasNext() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        List<String> fileNames = this.createFilesUnderDirectory(1000, testDir, "testListPath");
        ListingSupport listngSupport = (ListingSupport)Mockito.spy((Object)this.getFileSystem().getAbfsStore());
        AbfsListStatusRemoteIterator fsItr = new AbfsListStatusRemoteIterator(this.getFileSystem().getFileStatus(testDir), listngSupport, this.getTestTracingContext(this.getFileSystem(), true));
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should be instance of AbfsListStatusRemoteIterator by default", new Object[0])).isInstanceOf(AbfsListStatusRemoteIterator.class);
        int itrCount = 0;
        for (int i = 0; i < 1000; ++i) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            String pathStr = fileStatus.getPath().toString();
            fileNames.remove(pathStr);
            ++itrCount;
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ITestAbfsListStatusRemoteIterator.lambda$testAbfsIteratorWithoutHasNext$0((RemoteIterator)fsItr)).describedAs("next() should throw NoSuchElementException since next has been called 1000 times", new Object[0])).isInstanceOf(NoSuchElementException.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)itrCount).describedAs("Number of iterations should be equal to the files created", new Object[0])).isEqualTo(1000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileNames.size()).describedAs("After removing every iterm found from the iterator, there should be no more elements in the fileNames", new Object[0])).isEqualTo(0);
        int minNumberOfInvokations = 100;
        ((ListingSupport)Mockito.verify((Object)listngSupport, (VerificationMode)Mockito.atLeast((int)minNumberOfInvokations))).listStatus((Path)ArgumentMatchers.any(Path.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyList(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class), (TracingContext)ArgumentMatchers.any(TracingContext.class));
    }

    @Test
    public void testWithAbfsIteratorDisabled() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        this.setEnableAbfsIterator(false);
        List<String> fileNames = this.createFilesUnderDirectory(1000, testDir, "testListPath");
        RemoteIterator fsItr = this.getFileSystem().listStatusIterator(testDir);
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should not be instance of AbfsListStatusRemoteIterator when it is disabled", new Object[0])).isNotInstanceOf(AbfsListStatusRemoteIterator.class);
        int itrCount = 0;
        while (fsItr.hasNext()) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            String pathStr = fileStatus.getPath().toString();
            fileNames.remove(pathStr);
            ++itrCount;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)itrCount).describedAs("Number of iterations should be equal to the files created", new Object[0])).isEqualTo(1000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileNames.size()).describedAs("After removing every iterm found from the iterator, there should be no more elements in the fileNames", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testWithAbfsIteratorDisabledWithoutHasNext() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        this.setEnableAbfsIterator(false);
        List<String> fileNames = this.createFilesUnderDirectory(1000, testDir, "testListPath");
        RemoteIterator fsItr = this.getFileSystem().listStatusIterator(testDir);
        ((ObjectAssert)Assertions.assertThat((Object)fsItr).describedAs("RemoteIterator should not be instance of AbfsListStatusRemoteIterator when it is disabled", new Object[0])).isNotInstanceOf(AbfsListStatusRemoteIterator.class);
        int itrCount = 0;
        for (int i = 0; i < 1000; ++i) {
            FileStatus fileStatus = (FileStatus)fsItr.next();
            String pathStr = fileStatus.getPath().toString();
            fileNames.remove(pathStr);
            ++itrCount;
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fsItr.next()).describedAs("next() should throw NoSuchElementException since next has been called 1000 times", new Object[0])).isInstanceOf(NoSuchElementException.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)itrCount).describedAs("Number of iterations should be equal to the files created", new Object[0])).isEqualTo(1000);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileNames.size()).describedAs("After removing every iterm found from the iterator, there should be no more elements in the fileNames", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testNextWhenNoMoreElementsPresent() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        AbfsListStatusRemoteIterator fsItr = new AbfsListStatusRemoteIterator(this.getFileSystem().getFileStatus(testDir), (ListingSupport)this.getFileSystem().getAbfsStore(), this.getTestTracingContext(this.getFileSystem(), true));
        fsItr = (RemoteIterator)Mockito.spy((Object)fsItr);
        ((RemoteIterator)Mockito.doReturn((Object)false).when((Object)fsItr)).hasNext();
        AbfsListStatusRemoteIterator finalFsItr = fsItr;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ITestAbfsListStatusRemoteIterator.lambda$testNextWhenNoMoreElementsPresent$2((RemoteIterator)finalFsItr)).describedAs("next() should throw NoSuchElementException if hasNext() return false", new Object[0])).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    public void testHasNextForEmptyDir() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        RemoteIterator fsItr = this.getFileSystem().listStatusIterator(testDir);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsItr.hasNext()).describedAs("hasNext returns false for empty directory", new Object[0])).isFalse();
    }

    @Test
    public void testHasNextForFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String testFileName = "testFile";
        Path testFile = new Path(testFileName);
        this.getFileSystem().create(testFile);
        this.setPageSize(10);
        RemoteIterator fsItr = fs.listStatusIterator(testFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsItr.hasNext()).describedAs("hasNext returns true for file", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)((FileStatus)fsItr.next()).getPath().toString()).describedAs("next returns the file itself", new Object[0])).endsWith((CharSequence)testFileName);
    }

    @Test
    public void testIOException() throws Exception {
        Path testDir = this.createTestDirectory();
        this.setPageSize(10);
        this.getFileSystem().mkdirs(testDir);
        String exceptionMessage = "test exception";
        ListingSupport lsSupport = this.getMockListingSupport(exceptionMessage);
        AbfsListStatusRemoteIterator fsItr = new AbfsListStatusRemoteIterator(this.getFileSystem().getFileStatus(testDir), lsSupport, this.getTestTracingContext(this.getFileSystem(), true));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ITestAbfsListStatusRemoteIterator.lambda$testIOException$3((RemoteIterator)fsItr)).describedAs("When ioException is not null and queue is empty exception should be thrown", new Object[0])).isInstanceOf(IOException.class)).hasMessage(exceptionMessage);
    }

    @Test
    public void testNonExistingPath() throws Throwable {
        Path nonExistingDir = new Path("nonExistingPath");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getFileSystem().listStatusIterator(nonExistingDir)).describedAs("test the listStatusIterator call on a path which is not present should result in FileNotFoundException", new Object[0])).isInstanceOf(FileNotFoundException.class);
    }

    private ListingSupport getMockListingSupport(final String exceptionMessage) {
        return new ListingSupport(){

            public FileStatus[] listStatus(Path path, TracingContext tracingContext) throws IOException {
                return null;
            }

            public FileStatus[] listStatus(Path path, String startFrom, TracingContext tracingContext) throws IOException {
                return null;
            }

            public String listStatus(Path path, String startFrom, List<FileStatus> fileStatuses, boolean fetchAll, String continuation, TracingContext tracingContext) throws IOException {
                throw new IOException(exceptionMessage);
            }
        };
    }

    private Path createTestDirectory() throws IOException {
        String testDirectoryName = "testDirectory" + System.currentTimeMillis();
        Path testDirectory = new Path(testDirectoryName);
        this.getFileSystem().mkdirs(testDirectory);
        return testDirectory;
    }

    private void setEnableAbfsIterator(boolean shouldEnable) throws IOException {
        AzureBlobFileSystemStore abfsStore = this.getAbfsStore(this.getFileSystem());
        abfsStore.getAbfsConfiguration().setEnableAbfsListIterator(shouldEnable);
    }

    private void setPageSize(int pageSize) throws IOException {
        AzureBlobFileSystemStore abfsStore = this.getAbfsStore(this.getFileSystem());
        abfsStore.getAbfsConfiguration().setListMaxResults(pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> createFilesUnderDirectory(int numFiles, Path rootPath, String filenamePrefix) throws ExecutionException, InterruptedException, IOException {
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ArrayList<String> fileNames = new ArrayList<String>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        try {
            for (int i = 0; i < numFiles; ++i) {
                Path path = new Path(rootPath, filenamePrefix + i);
                Callable<Void> callable = () -> {
                    this.getFileSystem().create(filePath);
                    fileNames.add(this.makeQualified(filePath).toString());
                    return null;
                };
                tasks.add(es.submit(callable));
            }
            for (Future future : tasks) {
                future.get();
            }
        }
        finally {
            es.shutdownNow();
        }
        return fileNames;
    }

    private static /* synthetic */ void lambda$testIOException$3(RemoteIterator fsItr) throws Throwable {
        fsItr.next();
    }

    private static /* synthetic */ void lambda$testNextWhenNoMoreElementsPresent$2(RemoteIterator finalFsItr) throws Throwable {
        finalFsItr.next();
    }

    private static /* synthetic */ void lambda$testAbfsIteratorWithoutHasNext$0(RemoteIterator fsItr) throws Throwable {
        fsItr.next();
    }
}

