/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.util.HashMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOutOfBandAzureBlobOperations {
    private AzureBlobStorageTestAccount testAccount;
    private FileSystem fs;
    private InMemoryBlockBlobStore backingStore;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createMock();
        this.fs = this.testAccount.getFileSystem();
        this.backingStore = this.testAccount.getMockStorage().getBackingStore();
    }

    @After
    public void tearDown() throws Exception {
        this.testAccount.cleanup();
        this.fs = null;
        this.backingStore = null;
    }

    private void createEmptyBlobOutOfBand(String path) {
        this.backingStore.setContent(AzureBlobStorageTestAccount.toMockUri(path), new byte[]{1, 2}, new HashMap<String, String>(), false, 0L);
    }

    @Test
    public void testImplicitFolderListed() throws Exception {
        this.createEmptyBlobOutOfBand("root/b");
        FileStatus[] obtained = this.fs.listStatus(new Path("/root/b"));
        Assert.assertNotNull((Object)obtained);
        Assert.assertEquals((long)1L, (long)obtained.length);
        Assert.assertFalse((boolean)obtained[0].isDir());
        Assert.assertEquals((Object)"/root/b", (Object)obtained[0].getPath().toUri().getPath());
        obtained = this.fs.listStatus(new Path("/root"));
        Assert.assertNotNull((Object)obtained);
        Assert.assertEquals((long)1L, (long)obtained.length);
        Assert.assertFalse((boolean)obtained[0].isDir());
        Assert.assertEquals((Object)"/root/b", (Object)obtained[0].getPath().toUri().getPath());
        FileStatus dirStatus = this.fs.getFileStatus(new Path("/root"));
        Assert.assertNotNull((Object)dirStatus);
        Assert.assertTrue((boolean)dirStatus.isDir());
        Assert.assertEquals((Object)"/root", (Object)dirStatus.getPath().toUri().getPath());
    }

    @Test
    public void testImplicitFolderDeleted() throws Exception {
        this.createEmptyBlobOutOfBand("root/b");
        Assert.assertTrue((boolean)this.fs.exists(new Path("/root")));
        Assert.assertTrue((boolean)this.fs.delete(new Path("/root"), true));
        Assert.assertFalse((boolean)this.fs.exists(new Path("/root")));
    }

    @Test
    public void testFileInImplicitFolderDeleted() throws Exception {
        this.createEmptyBlobOutOfBand("root/b");
        Assert.assertTrue((boolean)this.fs.exists(new Path("/root")));
        Assert.assertTrue((boolean)this.fs.delete(new Path("/root/b"), true));
        Assert.assertTrue((boolean)this.fs.exists(new Path("/root")));
    }

    @Test
    public void testFileAndImplicitFolderSameName() throws Exception {
        this.createEmptyBlobOutOfBand("root/b");
        this.createEmptyBlobOutOfBand("root/b/c");
        FileStatus[] listResult = this.fs.listStatus(new Path("/root/b"));
        Assert.assertEquals((long)1L, (long)listResult.length);
        Assert.assertFalse((boolean)listResult[0].isDir());
        try {
            this.fs.delete(new Path("/root/b/c"), true);
            Assert.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (AzureException e) {
            Assert.assertEquals((Object)"File /root/b/c has a parent directory /root/b which is also a file. Can't resolve.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreatingDeepFileCreatesExplicitFolder() throws Exception {
        for (DeepCreateTestVariation variation : DeepCreateTestVariation.values()) {
            switch (variation) {
                case File: {
                    Assert.assertTrue((boolean)this.fs.createNewFile(new Path("/x/y/z")));
                    break;
                }
                case Folder: {
                    Assert.assertTrue((boolean)this.fs.mkdirs(new Path("/x/y/z")));
                }
            }
            Assert.assertTrue((boolean)this.backingStore.exists(AzureBlobStorageTestAccount.toMockUri("x")));
            Assert.assertTrue((boolean)this.backingStore.exists(AzureBlobStorageTestAccount.toMockUri("x/y")));
            this.fs.delete(new Path("/x"), true);
        }
    }

    @Test
    public void testSetPermissionOnImplicitFolder() throws Exception {
        this.createEmptyBlobOutOfBand("root/b");
        FsPermission newPermission = new FsPermission(384);
        this.fs.setPermission(new Path("/root"), newPermission);
        FileStatus newStatus = this.fs.getFileStatus(new Path("/root"));
        Assert.assertNotNull((Object)newStatus);
        Assert.assertEquals((Object)newPermission, (Object)newStatus.getPermission());
    }

    @Test
    public void testSetOwnerOnImplicitFolder() throws Exception {
        this.createEmptyBlobOutOfBand("root/b");
        this.fs.setOwner(new Path("/root"), "newOwner", null);
        FileStatus newStatus = this.fs.getFileStatus(new Path("/root"));
        Assert.assertNotNull((Object)newStatus);
        Assert.assertEquals((Object)"newOwner", (Object)newStatus.getOwner());
    }

    private static enum DeepCreateTestVariation {
        File,
        Folder;

    }
}

