/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestNativeAzureFileSystemUploadLogic {
    private AzureBlobStorageTestAccount testAccount;
    static final int byteValuePeriod = 47;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createMock();
    }

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
        }
    }

    @Test
    @Ignore
    public void testConsistencyAfterSmallFlushes() throws Exception {
        this.testConsistencyAfterManyFlushes(FlushFrequencyVariation.BeforeSingleBufferFull);
    }

    @Test
    @Ignore
    public void testConsistencyAfterMediumFlushes() throws Exception {
        this.testConsistencyAfterManyFlushes(FlushFrequencyVariation.AfterSingleBufferFull);
    }

    @Test
    @Ignore
    public void testConsistencyAfterLargeFlushes() throws Exception {
        this.testConsistencyAfterManyFlushes(FlushFrequencyVariation.AfterAllRingBufferFull);
    }

    private void assertDataInStream(InputStream inStream, int expectedSize) throws Exception {
        int byteRead;
        int countBytes = 0;
        while ((byteRead = inStream.read()) != -1) {
            Assert.assertEquals((long)(countBytes % 47), (long)byteRead);
            ++countBytes;
        }
        Assert.assertEquals((long)expectedSize, (long)countBytes);
    }

    private void assertDataInFile(Path file, int expectedSize) throws Exception {
        FSDataInputStream inStream = this.testAccount.getFileSystem().open(file);
        this.assertDataInStream((InputStream)inStream, expectedSize);
        inStream.close();
    }

    private void assertDataInTempBlob(int expectedSize) throws Exception {
        InMemoryBlockBlobStore backingStore = this.testAccount.getMockStorage().getBackingStore();
        String tempKey = null;
        for (String key : backingStore.getKeys()) {
            if (!key.contains("_$azuretmpfolder$")) continue;
            tempKey = key;
            break;
        }
        Assert.assertNotNull(tempKey);
        ByteArrayInputStream inStream = new ByteArrayInputStream(backingStore.getContent(tempKey));
        this.assertDataInStream(inStream, expectedSize);
        ((InputStream)inStream).close();
    }

    private void testConsistencyAfterManyFlushes(FlushFrequencyVariation variation) throws Exception {
        int flushPeriod;
        Path uploadedFile = new Path("/uploadedFile");
        FSDataOutputStream outStream = this.testAccount.getFileSystem().create(uploadedFile);
        int totalSize = 9123;
        switch (variation) {
            case BeforeSingleBufferFull: {
                flushPeriod = 300;
                break;
            }
            case AfterSingleBufferFull: {
                flushPeriod = 600;
                break;
            }
            case AfterAllRingBufferFull: {
                flushPeriod = 1600;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variation: " + variation);
            }
        }
        for (int i = 0; i < 9123; ++i) {
            outStream.write(i % 47);
            if ((i + 1) % flushPeriod != 0) continue;
            outStream.flush();
            this.assertDataInTempBlob(i + 1);
        }
        outStream.close();
        this.assertDataInFile(uploadedFile, 9123);
    }

    private static enum FlushFrequencyVariation {
        BeforeSingleBufferFull,
        AfterSingleBufferFull,
        AfterAllRingBufferFull;

    }
}

