/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.common.Parallelized;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parallelized.class)
public class TestAdlDifferentSizeWritesLive {
    private static Random rand = new Random();
    private int totalSize;
    private int chunkSize;

    public TestAdlDifferentSizeWritesLive(int totalSize, int chunkSize) {
        this.totalSize = totalSize;
        this.chunkSize = chunkSize;
    }

    public static byte[] getRandomByteArrayData(int size) {
        byte[] b = new byte[size];
        rand.nextBytes(b);
        return b;
    }

    @Parameterized.Parameters(name="{index}: Data Size [{0}] ; Chunk Size [{1}]")
    public static Collection testDataForIntegrityTest() {
        return Arrays.asList({4096, 1024}, {4096, 7168}, {4096, 10}, {2048, 10}, {1024, 10}, {100, 1}, {4096, 1024}, {7168, 2048}, {9216, 2048}, {10240, 3072}, {10240, 1024}, {10240, 8192});
    }

    @BeforeClass
    public static void cleanUpParent() throws IOException, URISyntaxException {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            Path path = new Path("/test/dataIntegrityCheck/");
            FileSystem fs = AdlStorageConfiguration.createStorageConnector();
            fs.delete(path, true);
        }
    }

    @Before
    public void setup() throws Exception {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
    }

    @Test
    public void testDataIntegrity() throws IOException {
        Path path = new Path("/test/dataIntegrityCheck/" + UUID.randomUUID().toString());
        FileSystem fs = null;
        AdlStorageConfiguration.getConfiguration().setInt("adl.feature.client.cache.drop.behind.writes", 4096);
        try {
            fs = AdlStorageConfiguration.createStorageConnector();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can not initialize ADL FileSystem. Please check test.fs.adl.name property.", e);
        }
        byte[] expectedData = TestAdlDifferentSizeWritesLive.getRandomByteArrayData(this.totalSize);
        FSDataOutputStream out = fs.create(path, true);
        int iteration = this.totalSize / this.chunkSize;
        int reminderIteration = this.totalSize % this.chunkSize;
        int offset = 0;
        for (int i = 0; i < iteration; ++i) {
            out.write(expectedData, offset, this.chunkSize);
            offset += this.chunkSize;
        }
        out.write(expectedData, offset, reminderIteration);
        out.close();
        byte[] actualData = new byte[this.totalSize];
        FSDataInputStream in = fs.open(path);
        in.readFully(0L, actualData);
        in.close();
        Assert.assertArrayEquals((byte[])expectedData, (byte[])actualData);
        Assert.assertTrue((boolean)fs.delete(path, true));
    }
}

