/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.util.ReflectionUtils;

public final class AdlStorageConfiguration {
    static final String CONTRACT_XML = "adls.xml";
    private static final String CONTRACT_ENABLE_KEY = "dfs.adl.test.contract.enable";
    private static final boolean CONTRACT_ENABLE_DEFAULT = false;
    private static final String FILE_SYSTEM_KEY = String.format("test.fs.%s.name", "adl");
    private static final String FILE_SYSTEM_IMPL_KEY = String.format("fs.%s.impl", "adl");
    private static final Class<?> FILE_SYSTEM_IMPL_DEFAULT = AdlFileSystem.class;
    private static boolean isContractTestEnabled = false;
    private static Configuration conf = null;

    private AdlStorageConfiguration() {
    }

    public static synchronized Configuration getConfiguration() {
        Configuration newConf = new Configuration();
        newConf.addResource(CONTRACT_XML);
        return newConf;
    }

    public static synchronized boolean isContractTestEnabled() {
        if (conf == null) {
            conf = AdlStorageConfiguration.getConfiguration();
        }
        isContractTestEnabled = conf.getBoolean(CONTRACT_ENABLE_KEY, false);
        return isContractTestEnabled;
    }

    public static synchronized FileSystem createStorageConnector() throws URISyntaxException, IOException {
        if (conf == null) {
            conf = AdlStorageConfiguration.getConfiguration();
        }
        if (!AdlStorageConfiguration.isContractTestEnabled()) {
            return null;
        }
        String fileSystem = conf.get(FILE_SYSTEM_KEY);
        if (fileSystem == null || fileSystem.trim().length() == 0) {
            throw new IOException("Default file system not configured.");
        }
        Class clazz = conf.getClass(FILE_SYSTEM_IMPL_KEY, FILE_SYSTEM_IMPL_DEFAULT);
        FileSystem fs = (FileSystem)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        fs.initialize(new URI(fileSystem), conf);
        return fs;
    }
}

