/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.impl.ExecutingStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StatusProbeEnum;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MkdirOperation
extends ExecutingStoreOperation<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(MkdirOperation.class);
    private final Path dir;
    private final MkdirCallbacks callbacks;
    private final boolean performanceMkdir;
    private final boolean isMagicPath;

    public MkdirOperation(StoreContext storeContext, Path dir, MkdirCallbacks callbacks, boolean isMagicPath, boolean performanceMkdir) {
        super(storeContext);
        this.dir = dir;
        this.callbacks = callbacks;
        this.isMagicPath = isMagicPath;
        this.performanceMkdir = performanceMkdir;
    }

    @Override
    public Boolean execute() throws IOException {
        LOG.debug("Making directory: {}", (Object)this.dir);
        if (this.dir.isRoot()) {
            return true;
        }
        S3AFileStatus fileStatus = this.getPathStatusExpectingDir(this.dir);
        if (fileStatus != null) {
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + this.dir);
        }
        if (this.isMagicPath) {
            this.callbacks.createFakeDirectory(this.dir, true);
            return true;
        }
        if (!this.performanceMkdir) {
            this.verifyFileStatusOfClosestAncestor();
        }
        this.callbacks.createFakeDirectory(this.dir, false);
        return true;
    }

    private void verifyFileStatusOfClosestAncestor() throws IOException {
        Path fPart;
        try {
            for (fPart = this.dir.getParent(); fPart != null && !fPart.isRoot(); fPart = fPart.getParent()) {
                S3AFileStatus fileStatus = this.getPathStatusExpectingDir(fPart);
                if (fileStatus == null) {
                    continue;
                }
                if (fileStatus.isDirectory()) break;
                throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", fPart));
            }
        }
        catch (AccessDeniedException e) {
            LOG.info("mkdirs({}}: Access denied when looking for parent directory {}; skipping checks", (Object)this.dir, (Object)fPart);
            LOG.debug("{}", (Object)e, (Object)e);
        }
    }

    private S3AFileStatus probePathStatusOrNull(Path path, Set<StatusProbeEnum> probes) throws IOException {
        try {
            return this.callbacks.probePathStatus(path, probes);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    private S3AFileStatus getPathStatusExpectingDir(Path path) throws IOException {
        S3AFileStatus status = this.probePathStatusOrNull(path, StatusProbeEnum.DIRECTORIES);
        if (status == null && !this.isMagicPath) {
            status = this.probePathStatusOrNull(path, StatusProbeEnum.FILE);
        }
        return status;
    }

    public static interface MkdirCallbacks {
        public S3AFileStatus probePathStatus(Path var1, Set<StatusProbeEnum> var2) throws IOException;

        public void createFakeDirectory(Path var1, boolean var2) throws IOException;
    }
}

