/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.keytab.KeytabEntry;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestKerberosUtil {
    static String testKeytab = "test.keytab";
    static String[] testPrincipals = new String[]{"HTTP@testRealm", "test/testhost@testRealm", "HTTP/testhost@testRealm", "HTTP1/testhost@testRealm", "HTTP/testhostanother@testRealm"};

    @After
    public void deleteKeytab() {
        File keytabFile = new File(testKeytab);
        if (keytabFile.exists()) {
            keytabFile.delete();
        }
    }

    @Test
    public void testGetServerPrincipal() throws IOException {
        String service = "TestKerberosUtil";
        String localHostname = KerberosUtil.getLocalHostName();
        String testHost = "FooBar";
        Assert.assertEquals((String)"When no hostname is sent", (Object)(service + "/" + localHostname.toLowerCase(Locale.ENGLISH)), (Object)KerberosUtil.getServicePrincipal((String)service, null));
        Assert.assertEquals((String)"When empty hostname is sent", (Object)(service + "/" + localHostname.toLowerCase(Locale.ENGLISH)), (Object)KerberosUtil.getServicePrincipal((String)service, (String)""));
        Assert.assertEquals((String)"When 0.0.0.0 hostname is sent", (Object)(service + "/" + localHostname.toLowerCase(Locale.ENGLISH)), (Object)KerberosUtil.getServicePrincipal((String)service, (String)"0.0.0.0"));
        Assert.assertEquals((String)"When uppercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase(Locale.ENGLISH)), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost));
        Assert.assertEquals((String)"When lowercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase(Locale.ENGLISH)), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost.toLowerCase(Locale.ENGLISH)));
    }

    @Test
    public void testGetPrincipalNamesMissingKeytab() {
        try {
            KerberosUtil.getPrincipalNames((String)testKeytab);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPrincipalNamesMissingPattern() throws IOException {
        this.createKeyTab(testKeytab, new String[]{"test/testhost@testRealm"});
        try {
            KerberosUtil.getPrincipalNames((String)testKeytab, null);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetPrincipalNamesFromKeytab() throws IOException {
        this.createKeyTab(testKeytab, testPrincipals);
        String[] principals = KerberosUtil.getPrincipalNames((String)testKeytab);
        Assert.assertNotNull((String)"principals cannot be null", (Object)principals);
        int expectedSize = 0;
        List<String> principalList = Arrays.asList(principals);
        for (String principal : testPrincipals) {
            Assert.assertTrue((String)("missing principal " + principal), (boolean)principalList.contains(principal));
            ++expectedSize;
        }
        Assert.assertEquals((long)expectedSize, (long)principals.length);
    }

    @Test
    public void testGetPrincipalNamesFromKeytabWithPattern() throws IOException {
        this.createKeyTab(testKeytab, testPrincipals);
        Pattern httpPattern = Pattern.compile("HTTP/.*");
        String[] httpPrincipals = KerberosUtil.getPrincipalNames((String)testKeytab, (Pattern)httpPattern);
        Assert.assertNotNull((String)"principals cannot be null", (Object)httpPrincipals);
        int expectedSize = 0;
        List<String> httpPrincipalList = Arrays.asList(httpPrincipals);
        for (String principal : testPrincipals) {
            if (!httpPattern.matcher(principal).matches()) continue;
            Assert.assertTrue((String)("missing principal " + principal), (boolean)httpPrincipalList.contains(principal));
            ++expectedSize;
        }
        Assert.assertEquals((long)expectedSize, (long)httpPrincipals.length);
    }

    private void createKeyTab(String fileName, String[] principalNames) throws IOException {
        ArrayList<KeytabEntry> lstEntries = new ArrayList<KeytabEntry>();
        for (String principal : principalNames) {
            for (int kvno = 1; kvno <= 3; ++kvno) {
                EncryptionKey key = new EncryptionKey(EncryptionType.NONE, "samplekey1".getBytes(), kvno);
                KeytabEntry keytabEntry = new KeytabEntry(new PrincipalName(principal), new KerberosTime(), 1, key);
                lstEntries.add(keytabEntry);
            }
        }
        Keytab keytab = new Keytab();
        keytab.addKeytabEntries(lstEntries);
        keytab.store(new File(testKeytab));
    }
}

