/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.test.util.SQLJobClientMode;
import org.apache.flink.util.Preconditions;

public class SQLJobSubmission {
    private final SQLJobClientMode clientMode;
    private final List<String> sqlLines;
    private final List<String> jars;
    private final Consumer<Map<String, String>> envProcessor;

    private SQLJobSubmission(SQLJobClientMode clientMode, List<String> sqlLines, List<String> jars, Consumer<Map<String, String>> envProcessor) {
        this.clientMode = clientMode;
        this.sqlLines = (List)Preconditions.checkNotNull(sqlLines);
        this.jars = (List)Preconditions.checkNotNull(jars);
        this.envProcessor = envProcessor;
    }

    public SQLJobClientMode getClientMode() {
        return this.clientMode;
    }

    public List<String> getJars() {
        return this.jars;
    }

    public List<String> getSqlLines() {
        return this.sqlLines;
    }

    public Consumer<Map<String, String>> getEnvProcessor() {
        return this.envProcessor;
    }

    public static class SQLJobSubmissionBuilder {
        private SQLJobClientMode clientMode = SQLJobClientMode.getEmbeddedSqlClient();
        private final List<String> sqlLines;
        private final List<String> jars = new ArrayList<String>();
        private Consumer<Map<String, String>> envProcessor = map -> {};

        public SQLJobSubmissionBuilder(List<String> sqlLines) {
            this.sqlLines = sqlLines;
        }

        public SQLJobSubmissionBuilder setClientMode(SQLJobClientMode clientMode) {
            this.clientMode = clientMode;
            return this;
        }

        public SQLJobSubmissionBuilder addJar(URI jarFile) {
            this.jars.add(jarFile.toString());
            return this;
        }

        public SQLJobSubmissionBuilder addJar(Path jarFile) {
            this.jars.add(jarFile.toAbsolutePath().toString());
            return this;
        }

        public SQLJobSubmissionBuilder addJars(URI ... jarFiles) {
            for (URI jarFile : jarFiles) {
                this.addJar(jarFile);
            }
            return this;
        }

        public SQLJobSubmissionBuilder addJars(Path ... jarFiles) {
            for (Path jarFile : jarFiles) {
                this.addJar(jarFile);
            }
            return this;
        }

        public SQLJobSubmissionBuilder addJars(List<Path> jarFiles) {
            jarFiles.forEach(this::addJar);
            return this;
        }

        public SQLJobSubmissionBuilder setEnvProcessor(Consumer<Map<String, String>> envProcessor) {
            this.envProcessor = envProcessor;
            return this;
        }

        public SQLJobSubmission build() {
            return new SQLJobSubmission(this.clientMode, this.sqlLines, this.jars, this.envProcessor);
        }
    }
}

