/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.networking;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EchoServer
extends Thread
implements AutoCloseable {
    private final ServerSocket serverSocket = new ServerSocket(0);
    private final int socketTimeout;
    private final List<EchoWorkerThread> workerThreads = Collections.synchronizedList(new ArrayList());
    private volatile boolean close = false;
    private Exception threadException;

    public EchoServer(int socketTimeout) throws IOException {
        this.serverSocket.setSoTimeout(socketTimeout);
        this.socketTimeout = socketTimeout;
    }

    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void run() {
        while (!this.close) {
            try {
                EchoWorkerThread thread = new EchoWorkerThread(this.serverSocket.accept(), this.socketTimeout);
                thread.start();
            }
            catch (IOException e) {
                this.threadException = e;
            }
        }
    }

    @Override
    public void close() throws Exception {
        for (EchoWorkerThread thread : this.workerThreads) {
            thread.close();
            thread.join();
        }
        this.close = true;
        if (this.threadException != null) {
            throw this.threadException;
        }
        this.serverSocket.close();
        this.join();
    }

    private static class EchoWorkerThread
    extends Thread
    implements AutoCloseable {
        private final PrintWriter output;
        private final BufferedReader input;
        private volatile boolean close;
        private Exception threadException;

        public EchoWorkerThread(Socket clientSocket, int socketTimeout) throws IOException {
            this.output = new PrintWriter(clientSocket.getOutputStream(), true);
            this.input = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            clientSocket.setSoTimeout(socketTimeout);
        }

        @Override
        public void run() {
            try {
                String inputLine;
                while (!this.close && (inputLine = this.input.readLine()) != null) {
                    this.output.println(inputLine);
                }
            }
            catch (IOException e) {
                this.threadException = e;
            }
        }

        @Override
        public void close() throws Exception {
            this.close = true;
            if (this.threadException != null) {
                throw this.threadException;
            }
            this.input.close();
            this.output.close();
            this.join();
        }
    }
}

