/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.tvf.operator;

import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.MergingState;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalMergingState;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.dataview.PerWindowStateDataViewStore;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunctionBase;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.GroupWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.MergingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.groupwindow.internal.MergingWindowProcessFunction;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.Trigger;
import org.apache.flink.table.runtime.operators.window.tvf.operator.WindowTableFunctionOperatorBase;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;

public class UnalignedWindowTableFunctionOperator
extends WindowTableFunctionOperatorBase
implements Triggerable<RowData, TimeWindow> {
    private static final long serialVersionUID = 1L;
    private static final String LATE_ELEMENTS_DROPPED_METRIC_NAME = "numLateRecordsDropped";
    private static final String LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME = "lateRecordsDroppedRate";
    private static final String WATERMARK_LATENCY_METRIC_NAME = "watermarkLatency";
    private final Trigger<TimeWindow> trigger;
    private final TypeSerializer<RowData> inputSerializer;
    private final TypeSerializer<TimeWindow> windowSerializer;
    private transient InternalTimerService<TimeWindow> internalTimerService;
    private transient ValueState<Long> counterState;
    private transient InternalMapState<RowData, TimeWindow, Long, RowData> windowState;
    private transient TriggerContextImpl triggerContext;
    private transient MergingWindowProcessFunction<RowData, TimeWindow> windowFunction;
    private transient NamespaceAggsHandleFunctionBase<TimeWindow> windowAggregator;
    private transient Counter numLateRecordsDropped;
    private transient Meter lateRecordsDroppedRate;
    private transient Gauge<Long> watermarkLatency;

    public UnalignedWindowTableFunctionOperator(GroupWindowAssigner<TimeWindow> windowAssigner, TypeSerializer<TimeWindow> windowSerializer, TypeSerializer<RowData> inputSerializer, int rowtimeIndex, ZoneId shiftTimeZone) {
        super(windowAssigner, rowtimeIndex, shiftTimeZone);
        this.trigger = UnalignedWindowTableFunctionOperator.createTrigger(windowAssigner);
        this.windowSerializer = (TypeSerializer)Preconditions.checkNotNull(windowSerializer);
        this.inputSerializer = (TypeSerializer)Preconditions.checkNotNull(inputSerializer);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.internalTimerService = this.getInternalTimerService("session-window-tvf-timers", this.windowSerializer, this);
        this.triggerContext = new TriggerContextImpl();
        this.triggerContext.open();
        ValueStateDescriptor counterStateDescriptor = new ValueStateDescriptor("session-window-tvf-counter", (TypeSerializer)LongSerializer.INSTANCE);
        this.counterState = this.getRuntimeContext().getState(counterStateDescriptor);
        MapStateDescriptor windowStateDescriptor = new MapStateDescriptor("session-window-tvf-acc", (TypeSerializer)LongSerializer.INSTANCE, this.inputSerializer);
        this.windowState = (InternalMapState)this.getOrCreateKeyedState(this.windowSerializer, (StateDescriptor)windowStateDescriptor);
        this.windowAggregator = new DummyWindowAggregator();
        this.windowAggregator.open(new PerWindowStateDataViewStore(this.getKeyedStateBackend(), this.windowSerializer, (RuntimeContext)this.getRuntimeContext()));
        WindowContextImpl windowContext = new WindowContextImpl();
        this.windowFunction = new MergingWindowProcessFunction((MergingWindowAssigner)this.windowAssigner, this.windowAggregator, this.windowSerializer, 0L);
        this.windowFunction.open(windowContext);
        this.numLateRecordsDropped = this.metrics.counter(LATE_ELEMENTS_DROPPED_METRIC_NAME);
        this.lateRecordsDroppedRate = this.metrics.meter(LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME, (Meter)new MeterView(this.numLateRecordsDropped));
        this.watermarkLatency = this.metrics.gauge(WATERMARK_LATENCY_METRIC_NAME, () -> {
            long watermark = this.internalTimerService.currentWatermark();
            if (watermark < 0L) {
                return 0L;
            }
            return this.internalTimerService.currentProcessingTime() - watermark;
        });
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.windowAggregator != null) {
            this.windowAggregator.close();
        }
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        long timestamp;
        RowData inputRow = (RowData)element.getValue();
        if (this.windowAssigner.isEventTime()) {
            if (inputRow.isNullAt(this.rowtimeIndex)) {
                this.numNullRowTimeRecordsDropped.inc();
                return;
            }
            timestamp = inputRow.getTimestamp(this.rowtimeIndex, 3).getMillisecond();
        } else {
            timestamp = this.getProcessingTimeService().getCurrentProcessingTime();
        }
        Long order = (Long)this.counterState.value();
        if (null == order) {
            order = 0L;
        }
        this.counterState.update((Object)(order + 1L));
        timestamp = TimeWindowUtil.toUtcTimestampMills(timestamp, this.shiftTimeZone);
        Collection<TimeWindow> affectedWindows = this.windowFunction.assignStateNamespace(inputRow, timestamp);
        boolean isElementDropped = true;
        for (TimeWindow window : affectedWindows) {
            isElementDropped = false;
            this.windowState.setCurrentNamespace((Object)window);
            this.windowState.put((Object)order, (Object)inputRow);
        }
        Collection<TimeWindow> actualWindows = this.windowFunction.assignActualWindows(inputRow, timestamp);
        Preconditions.checkArgument((affectedWindows.isEmpty() && actualWindows.isEmpty() || !affectedWindows.isEmpty() && !actualWindows.isEmpty() ? 1 : 0) != 0);
        for (TimeWindow window : actualWindows) {
            this.triggerContext.setWindow(window);
            boolean triggerResult = this.triggerContext.onElement(inputRow, timestamp);
            if (triggerResult) {
                this.emitWindowResult(window);
            }
            this.registerCleanupTimer(window);
        }
        if (isElementDropped) {
            this.lateRecordsDroppedRate.markEvent();
        }
    }

    private void registerCleanupTimer(TimeWindow window) {
        long cleanupTime = this.getCleanupTime(window);
        if (cleanupTime == Long.MAX_VALUE) {
            return;
        }
        if (this.windowAssigner.isEventTime()) {
            this.triggerContext.registerEventTimeTimer(cleanupTime);
        } else {
            this.triggerContext.registerProcessingTimeTimer(cleanupTime);
        }
    }

    private void emitWindowResult(TimeWindow window) throws Exception {
        TimeWindow stateWindow = this.windowFunction.getStateWindow(window);
        this.windowState.setCurrentNamespace((Object)stateWindow);
        Iterator iterator = this.windowState.iterator();
        TreeMap<Long, RowData> sortedMap = new TreeMap<Long, RowData>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            sortedMap.put((Long)entry.getKey(), (RowData)entry.getValue());
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            this.collect((RowData)entry.getValue(), Collections.singletonList(window));
        }
    }

    public void onEventTime(InternalTimer<RowData, TimeWindow> timer) throws Exception {
        this.triggerContext.setWindow((TimeWindow)timer.getNamespace());
        if (this.triggerContext.onEventTime(timer.getTimestamp())) {
            this.emitWindowResult(this.triggerContext.window);
        }
        if (this.windowAssigner.isEventTime()) {
            this.windowFunction.cleanWindowIfNeeded(this.triggerContext.window, timer.getTimestamp());
        }
    }

    public void onProcessingTime(InternalTimer<RowData, TimeWindow> timer) throws Exception {
        this.triggerContext.setWindow((TimeWindow)timer.getNamespace());
        if (this.triggerContext.onProcessingTime(timer.getTimestamp())) {
            this.emitWindowResult(this.triggerContext.window);
        }
        if (!this.windowAssigner.isEventTime()) {
            this.windowFunction.cleanWindowIfNeeded(this.triggerContext.window, timer.getTimestamp());
        }
    }

    private long getCleanupTime(TimeWindow window) {
        long cleanupTime = Math.max(0L, window.maxTimestamp());
        cleanupTime = cleanupTime >= window.maxTimestamp() ? cleanupTime : Long.MAX_VALUE;
        return TimeWindowUtil.toEpochMillsForTimer(cleanupTime, this.shiftTimeZone);
    }

    private static Trigger<TimeWindow> createTrigger(GroupWindowAssigner<TimeWindow> windowAssigner) {
        if (windowAssigner.isEventTime()) {
            return EventTimeTriggers.afterEndOfWindow();
        }
        return ProcessingTimeTriggers.afterEndOfWindow();
    }

    @VisibleForTesting
    public Counter getNumLateRecordsDropped() {
        return this.numLateRecordsDropped;
    }

    @VisibleForTesting
    public Gauge<Long> getWatermarkLatency() {
        return this.watermarkLatency;
    }

    private class TriggerContextImpl
    implements Trigger.OnMergeContext {
        private TimeWindow window;
        private Collection<TimeWindow> mergedWindows;

        private TriggerContextImpl() {
        }

        public void open() throws Exception {
            UnalignedWindowTableFunctionOperator.this.trigger.open(this);
        }

        public boolean onElement(RowData row, long timestamp) throws Exception {
            return UnalignedWindowTableFunctionOperator.this.trigger.onElement(row, timestamp, this.window);
        }

        public boolean onProcessingTime(long time) throws Exception {
            return UnalignedWindowTableFunctionOperator.this.trigger.onProcessingTime(time, this.window);
        }

        public boolean onEventTime(long time) throws Exception {
            return UnalignedWindowTableFunctionOperator.this.trigger.onEventTime(time, this.window);
        }

        public void onMerge() throws Exception {
            UnalignedWindowTableFunctionOperator.this.trigger.onMerge(this.window, this);
        }

        public void setWindow(TimeWindow window) {
            this.window = window;
        }

        public void setMergedWindows(Collection<TimeWindow> mergedWindows) {
            this.mergedWindows = mergedWindows;
        }

        @Override
        public long getCurrentProcessingTime() {
            return UnalignedWindowTableFunctionOperator.this.internalTimerService.currentProcessingTime();
        }

        @Override
        public long getCurrentWatermark() {
            return UnalignedWindowTableFunctionOperator.this.internalTimerService.currentWatermark();
        }

        @Override
        public void registerProcessingTimeTimer(long time) {
            UnalignedWindowTableFunctionOperator.this.internalTimerService.registerProcessingTimeTimer((Object)this.window, time);
        }

        @Override
        public void registerEventTimeTimer(long time) {
            UnalignedWindowTableFunctionOperator.this.internalTimerService.registerEventTimeTimer((Object)this.window, time);
        }

        @Override
        public void deleteProcessingTimeTimer(long time) {
            UnalignedWindowTableFunctionOperator.this.internalTimerService.deleteProcessingTimeTimer((Object)this.window, time);
        }

        @Override
        public void deleteEventTimeTimer(long time) {
            UnalignedWindowTableFunctionOperator.this.internalTimerService.deleteEventTimeTimer((Object)this.window, time);
        }

        @Override
        public ZoneId getShiftTimeZone() {
            return UnalignedWindowTableFunctionOperator.this.shiftTimeZone;
        }

        public void clear() throws Exception {
            UnalignedWindowTableFunctionOperator.this.trigger.clear(this.window);
        }

        @Override
        public <S extends MergingState<?, ?>> void mergePartitionedState(StateDescriptor<S, ?> stateDescriptor) {
            if (this.mergedWindows != null && !this.mergedWindows.isEmpty()) {
                try {
                    State state = UnalignedWindowTableFunctionOperator.this.getOrCreateKeyedState(UnalignedWindowTableFunctionOperator.this.windowSerializer, stateDescriptor);
                    if (!(state instanceof InternalMergingState)) {
                        throw new IllegalArgumentException("The given state descriptor does not refer to a mergeable state (MergingState)");
                    }
                    ((InternalMergingState)state).mergeNamespaces((Object)this.window, this.mergedWindows);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while merging state.", e);
                }
            }
        }

        @Override
        public MetricGroup getMetricGroup() {
            return UnalignedWindowTableFunctionOperator.this.getMetricGroup();
        }

        @Override
        public <S extends State> S getPartitionedState(StateDescriptor<S, ?> stateDescriptor) {
            try {
                return (S)UnalignedWindowTableFunctionOperator.this.getPartitionedState(this.window, UnalignedWindowTableFunctionOperator.this.windowSerializer, stateDescriptor);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve state", e);
            }
        }
    }

    private static class DummyWindowAggregator
    implements NamespaceAggsHandleFunctionBase<TimeWindow> {
        private final IllegalStateException thrown = new IllegalStateException("The function should not be called in DummyWindowAggregator");

        private DummyWindowAggregator() {
        }

        @Override
        public void open(StateDataViewStore store) throws Exception {
        }

        @Override
        public void setAccumulators(TimeWindow namespace, RowData accumulators) throws Exception {
            throw this.thrown;
        }

        @Override
        public void accumulate(RowData inputRow) throws Exception {
            throw this.thrown;
        }

        @Override
        public void retract(RowData inputRow) throws Exception {
            throw this.thrown;
        }

        @Override
        public void merge(TimeWindow namespace, RowData otherAcc) throws Exception {
            throw this.thrown;
        }

        @Override
        public RowData createAccumulators() throws Exception {
            throw this.thrown;
        }

        @Override
        public RowData getAccumulators() throws Exception {
            throw this.thrown;
        }

        @Override
        public void cleanup(TimeWindow namespace) throws Exception {
            throw this.thrown;
        }

        @Override
        public void close() throws Exception {
        }
    }

    private class WindowContextImpl
    implements MergingWindowProcessFunction.MergingContext<RowData, TimeWindow> {
        private WindowContextImpl() {
        }

        @Override
        public void deleteCleanupTimer(TimeWindow window) throws Exception {
            long cleanupTime = UnalignedWindowTableFunctionOperator.this.getCleanupTime(window);
            if (cleanupTime == Long.MAX_VALUE) {
                return;
            }
            if (UnalignedWindowTableFunctionOperator.this.windowAssigner.isEventTime()) {
                UnalignedWindowTableFunctionOperator.this.triggerContext.deleteEventTimeTimer(cleanupTime);
            } else {
                UnalignedWindowTableFunctionOperator.this.triggerContext.deleteProcessingTimeTimer(cleanupTime);
            }
        }

        @Override
        public <S extends State> S getPartitionedState(StateDescriptor<S, ?> stateDescriptor) throws Exception {
            Objects.requireNonNull(stateDescriptor, "The state properties must not be null");
            return (S)UnalignedWindowTableFunctionOperator.this.getPartitionedState(stateDescriptor);
        }

        @Override
        public RowData currentKey() {
            return (RowData)UnalignedWindowTableFunctionOperator.this.getCurrentKey();
        }

        @Override
        public long currentProcessingTime() {
            return UnalignedWindowTableFunctionOperator.this.internalTimerService.currentProcessingTime();
        }

        @Override
        public long currentWatermark() {
            return UnalignedWindowTableFunctionOperator.this.internalTimerService.currentWatermark();
        }

        @Override
        public ZoneId getShiftTimeZone() {
            return UnalignedWindowTableFunctionOperator.this.shiftTimeZone;
        }

        @Override
        public void clearWindowState(TimeWindow window) throws Exception {
            UnalignedWindowTableFunctionOperator.this.windowState.setCurrentNamespace((Object)window);
            UnalignedWindowTableFunctionOperator.this.windowState.clear();
        }

        @Override
        public void clearTrigger(TimeWindow window) throws Exception {
            UnalignedWindowTableFunctionOperator.this.triggerContext.setWindow(window);
            UnalignedWindowTableFunctionOperator.this.triggerContext.clear();
        }

        @Override
        public void onMerge(TimeWindow newWindow, Collection<TimeWindow> mergedWindows) throws Exception {
            UnalignedWindowTableFunctionOperator.this.triggerContext.setWindow(newWindow);
            UnalignedWindowTableFunctionOperator.this.triggerContext.setMergedWindows(mergedWindows);
            UnalignedWindowTableFunctionOperator.this.triggerContext.onMerge();
        }

        @Override
        public void clearPreviousState(TimeWindow window) throws Exception {
        }

        @Override
        public RowData getWindowAccumulators(TimeWindow window) throws Exception {
            return null;
        }

        @Override
        public void setWindowAccumulators(TimeWindow window, RowData acc) throws Exception {
        }

        @Override
        public BiConsumerWithException<TimeWindow, Collection<TimeWindow>, Throwable> getWindowStateMergingConsumer() {
            return new MergingConsumer(UnalignedWindowTableFunctionOperator.this.windowState);
        }
    }

    private static class MergingConsumer
    implements BiConsumerWithException<TimeWindow, Collection<TimeWindow>, Throwable> {
        private final InternalMapState<RowData, TimeWindow, Long, RowData> windowState;

        public MergingConsumer(InternalMapState<RowData, TimeWindow, Long, RowData> windowState) {
            this.windowState = windowState;
        }

        public void accept(TimeWindow stateWindowResult, Collection<TimeWindow> stateWindowsToBeMerged) throws Throwable {
            for (TimeWindow mergedWindow : stateWindowsToBeMerged) {
                this.windowState.setCurrentNamespace((Object)mergedWindow);
                Iterator iterator = this.windowState.iterator();
                this.windowState.setCurrentNamespace((Object)stateWindowResult);
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    this.windowState.put((Object)((Long)entry.getKey()), (Object)((RowData)entry.getValue()));
                }
            }
        }
    }
}

