/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.shaded.guava32.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava32.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.SimpleCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompileUtils {
    private static final Logger CODE_LOG = LoggerFactory.getLogger(CompileUtils.class);
    static final Cache<ClassKey, Class<?>> COMPILED_CLASS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).maximumSize(300L).softValues().build();
    static final Cache<ExpressionKey, ExpressionEvaluator> COMPILED_EXPRESSION_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).maximumSize(100L).softValues().build();

    public static void cleanUp() {
        COMPILED_CLASS_CACHE.cleanUp();
        COMPILED_EXPRESSION_CACHE.cleanUp();
    }

    public static <T> Class<T> compile(ClassLoader cl, String name, String code) {
        try {
            ClassKey classKey = new ClassKey(cl.hashCode(), code);
            return (Class)COMPILED_CLASS_CACHE.get((Object)classKey, () -> CompileUtils.doCompile(cl, name, code));
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static <T> Class<T> doCompile(ClassLoader cl, String name, String code) {
        Preconditions.checkNotNull((Object)cl, (String)"Classloader must not be null.");
        CODE_LOG.debug("Compiling: {} \n\n Code:\n{}", (Object)name, (Object)code);
        SimpleCompiler compiler = new SimpleCompiler();
        compiler.setParentClassLoader(cl);
        try {
            compiler.cook(code);
        }
        catch (Throwable t) {
            System.out.println(CompileUtils.addLineNumber(code));
            throw new InvalidProgramException("Table program cannot be compiled. This is a bug. Please file an issue.", t);
        }
        try {
            return compiler.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can not load class " + name, e);
        }
    }

    private static String addLineNumber(String code) {
        String[] lines = code.split("\n");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            builder.append("/* ").append(i + 1).append(" */").append(lines[i]).append("\n");
        }
        return builder.toString();
    }

    public static ExpressionEvaluator compileExpression(String code, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass) {
        try {
            ExpressionKey key = new ExpressionKey(code, argumentNames, argumentClasses, returnClass);
            return (ExpressionEvaluator)COMPILED_EXPRESSION_CACHE.get((Object)key, () -> {
                ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
                expressionEvaluator.setParameters(argumentNames.toArray(new String[0]), argumentClasses.toArray(new Class[0]));
                expressionEvaluator.setExpressionType(returnClass);
                try {
                    expressionEvaluator.cook(code);
                }
                catch (CompileException e) {
                    throw new InvalidProgramException("Table program cannot be compiled. This is a bug. Please file an issue.\nExpression: " + code, (Throwable)e);
                }
                return expressionEvaluator;
            });
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static class ClassKey {
        private final int classLoaderId;
        private final String code;

        private ClassKey(int classLoaderId, String code) {
            this.classLoaderId = classLoaderId;
            this.code = code;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassKey classKey = (ClassKey)o;
            return this.classLoaderId == classKey.classLoaderId && this.code.equals(classKey.code);
        }

        public int hashCode() {
            return Objects.hash(this.classLoaderId, this.code);
        }
    }

    private static class ExpressionKey {
        private final String code;
        private final List<String> argumentNames;
        private final List<Class<?>> argumentClasses;
        private final Class<?> returnClass;

        private ExpressionKey(String code, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass) {
            this.code = code;
            this.argumentNames = argumentNames;
            this.argumentClasses = argumentClasses;
            this.returnClass = returnClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionKey that = (ExpressionKey)o;
            return this.code.equals(that.code) && this.argumentNames.equals(that.argumentNames) && this.argumentClasses.equals(that.argumentClasses) && this.returnClass.equals(that.returnClass);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.argumentNames, this.argumentClasses, this.returnClass);
        }
    }
}

