/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.runtime.dataview.NullAwareMapIterator;
import org.apache.flink.table.runtime.dataview.StateDataView;
import org.apache.flink.util.IterableIterator;

@Internal
public abstract class StateMapView<N, EK, EV>
extends MapView<EK, EV>
implements StateDataView<N> {
    public Map<EK, EV> getMap() {
        HashMap map = new HashMap();
        try {
            this.entries().forEach(entry -> map.put(entry.getKey(), entry.getValue()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public void setMap(Map<EK, EV> map) {
        this.clear();
        try {
            this.putAll(map);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final class NamespacedStateMapViewWithKeysNullable<N, EK, EV>
    extends StateMapViewWithKeysNullable<N, EK, EV> {
        private final InternalMapState<?, N, EK, EV> internalMapState;
        private final InternalValueState<?, N, EV> internalNullState;
        private N namespace;

        public NamespacedStateMapViewWithKeysNullable(InternalMapState<?, N, EK, EV> internalMapState, InternalValueState<?, N, EV> internalNullState) {
            this.internalMapState = internalMapState;
            this.internalNullState = internalNullState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            this.namespace = namespace;
        }

        @Override
        protected MapState<EK, EV> getMapState() {
            this.internalMapState.setCurrentNamespace(this.namespace);
            return this.internalMapState;
        }

        @Override
        protected ValueState<EV> getNullState() {
            this.internalNullState.setCurrentNamespace(this.namespace);
            return this.internalNullState;
        }
    }

    public static final class KeyedStateMapViewWithKeysNullable<N, EK, EV>
    extends StateMapViewWithKeysNullable<N, EK, EV> {
        private final MapState<EK, EV> mapState;
        private final ValueState<EV> nullState;

        public KeyedStateMapViewWithKeysNullable(MapState<EK, EV> mapState, ValueState<EV> nullState) {
            this.mapState = mapState;
            this.nullState = nullState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected MapState<EK, EV> getMapState() {
            return this.mapState;
        }

        @Override
        protected ValueState<EV> getNullState() {
            return this.nullState;
        }
    }

    public static final class NamespacedStateMapViewWithKeysNotNull<N, EK, EV>
    extends StateMapViewWithKeysNotNull<N, EK, EV> {
        private final InternalMapState<?, N, EK, EV> internalMapState;
        private N namespace;

        public NamespacedStateMapViewWithKeysNotNull(InternalMapState<?, N, EK, EV> internalMapState) {
            this.internalMapState = internalMapState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            this.namespace = namespace;
        }

        @Override
        protected MapState<EK, EV> getMapState() {
            this.internalMapState.setCurrentNamespace(this.namespace);
            return this.internalMapState;
        }
    }

    public static final class KeyedStateMapViewWithKeysNotNull<N, EK, EV>
    extends StateMapViewWithKeysNotNull<N, EK, EV> {
        private final MapState<EK, EV> mapState;

        public KeyedStateMapViewWithKeysNotNull(MapState<EK, EV> mapState) {
            this.mapState = mapState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected MapState<EK, EV> getMapState() {
            return this.mapState;
        }
    }

    private static abstract class StateMapViewWithKeysNullable<N, EK, EV>
    extends StateMapView<N, EK, EV> {
        private StateMapViewWithKeysNullable() {
        }

        public EV get(EK key) throws Exception {
            if (key == null) {
                return (EV)this.getNullState().value();
            }
            return (EV)this.getMapState().get(key);
        }

        public void put(EK key, EV value) throws Exception {
            if (key == null) {
                this.getNullState().update(value);
            } else {
                this.getMapState().put(key, value);
            }
        }

        public void putAll(Map<EK, EV> map) throws Exception {
            for (Map.Entry<EK, EV> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public void remove(EK key) throws Exception {
            if (key == null) {
                this.getNullState().clear();
            } else {
                this.getMapState().remove(key);
            }
        }

        public boolean contains(EK key) throws Exception {
            if (key == null) {
                return this.getNullState().value() != null;
            }
            return this.getMapState().contains(key);
        }

        public Iterable<Map.Entry<EK, EV>> entries() throws Exception {
            Iterator iterator = this.iterator();
            return () -> iterator;
        }

        public Iterable<EK> keys() throws Exception {
            return new KeysIterable(this.iterator());
        }

        public Iterable<EV> values() throws Exception {
            return new ValuesIterable(this.iterator());
        }

        public Iterator<Map.Entry<EK, EV>> iterator() throws Exception {
            return new NullAwareMapIterator(this.getMapState().iterator(), new NullMapEntryImpl());
        }

        public boolean isEmpty() throws Exception {
            return this.getMapState().isEmpty() && this.getNullState().value() == null;
        }

        public void clear() {
            this.getMapState().clear();
            this.getNullState().clear();
        }

        protected abstract MapState<EK, EV> getMapState();

        protected abstract ValueState<EV> getNullState();

        private class KeysIterable
        implements IterableIterator<EK> {
            private final Iterator<Map.Entry<EK, EV>> iterator;

            private KeysIterable(Iterator<Map.Entry<EK, EV>> iterator) {
                this.iterator = iterator;
            }

            public Iterator<EK> iterator() {
                return this;
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public EK next() {
                return this.iterator.next().getKey();
            }
        }

        private class ValuesIterable
        implements IterableIterator<EV> {
            private final Iterator<Map.Entry<EK, EV>> iterator;

            private ValuesIterable(Iterator<Map.Entry<EK, EV>> iterator) {
                this.iterator = iterator;
            }

            public Iterator<EV> iterator() {
                return this;
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public EV next() {
                return this.iterator.next().getValue();
            }
        }

        private class NullMapEntryImpl
        implements NullAwareMapIterator.NullMapEntry<EK, EV> {
            private NullMapEntryImpl() {
            }

            @Override
            public EV getValue() {
                try {
                    return StateMapViewWithKeysNullable.this.getNullState().value();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public EV setValue(EV value) {
                try {
                    Object oldValue = StateMapViewWithKeysNullable.this.getNullState().value();
                    StateMapViewWithKeysNullable.this.getNullState().update(value);
                    return oldValue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                StateMapViewWithKeysNullable.this.getNullState().clear();
            }
        }
    }

    private static abstract class StateMapViewWithKeysNotNull<N, EK, EV>
    extends StateMapView<N, EK, EV> {
        private final Map<EK, EV> emptyState = Collections.emptyMap();

        private StateMapViewWithKeysNotNull() {
        }

        protected abstract MapState<EK, EV> getMapState();

        public EV get(EK key) throws Exception {
            return (EV)this.getMapState().get(key);
        }

        public void put(EK key, EV value) throws Exception {
            this.getMapState().put(key, value);
        }

        public void putAll(Map<EK, EV> map) throws Exception {
            this.getMapState().putAll(map);
        }

        public void remove(EK key) throws Exception {
            this.getMapState().remove(key);
        }

        public boolean contains(EK key) throws Exception {
            return this.getMapState().contains(key);
        }

        public Iterable<Map.Entry<EK, EV>> entries() throws Exception {
            Set<Map.Entry<EK, EV>> original = this.getMapState().entries();
            return original != null ? original : this.emptyState.entrySet();
        }

        public Iterable<EK> keys() throws Exception {
            Set<EK> original = this.getMapState().keys();
            return original != null ? original : this.emptyState.keySet();
        }

        public Iterable<EV> values() throws Exception {
            Collection<EV> original = this.getMapState().values();
            return original != null ? original : this.emptyState.values();
        }

        public Iterator<Map.Entry<EK, EV>> iterator() throws Exception {
            Iterator<Map.Entry<EK, EV>> original = this.getMapState().iterator();
            return original != null ? original : this.emptyState.entrySet().iterator();
        }

        public boolean isEmpty() throws Exception {
            return this.getMapState().isEmpty();
        }

        public void clear() {
            this.getMapState().clear();
        }
    }
}

