/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.assigners;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.MergeCallback;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.SessionWindowAssigner;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SessionWindowAssignerTest {
    private static final RowData ELEMENT = GenericRowData.of((Object[])new Object[]{"String"});

    SessionWindowAssignerTest() {
    }

    @Test
    void testWindowAssignment() {
        int sessionGap = 5000;
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 0L)).contains((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 4999L)).contains((Object[])new TimeWindow[]{new TimeWindow(4999L, 9999L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 5000L)).contains((Object[])new TimeWindow[]{new TimeWindow(5000L, 10000L)});
    }

    @Test
    void testMergeEmptyWindow() throws Exception {
        MergeCallback callback = (MergeCallback)Mockito.mock(MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        assigner.mergeWindows(TimeWindow.of((long)0L, (long)1L), new TreeSet(), callback);
        ((MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge((Object)((TimeWindow)ArgumentMatchers.any()), (Object)ArgumentMatchers.anyCollection());
    }

    @Test
    void testMergeSingleWindow() throws Exception {
        MergeCallback callback = (MergeCallback)Mockito.mock(MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        TreeSet<TimeWindow> sortedWindows = new TreeSet<TimeWindow>();
        sortedWindows.add(TimeWindow.of((long)6000L, (long)6001L));
        assigner.mergeWindows(TimeWindow.of((long)0L, (long)1L), sortedWindows, callback);
        ((MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).merge((Object)((TimeWindow)ArgumentMatchers.any()), (Object)ArgumentMatchers.anyCollection());
    }

    @Test
    void testMergeConsecutiveWindows() throws Exception {
        MergeCallback callback = (MergeCallback)Mockito.mock(MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        TreeSet<TimeWindow> sortedWindows = new TreeSet<TimeWindow>();
        sortedWindows.addAll(Arrays.asList(new TimeWindow(0L, 1L), new TimeWindow(2L, 3L), new TimeWindow(4L, 5L), new TimeWindow(7L, 8L)));
        assigner.mergeWindows(new TimeWindow(1L, 2L), sortedWindows, callback);
        ((MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Object)((TimeWindow)ArgumentMatchers.eq((Object)new TimeWindow(0L, 3L))), (Object)((Collection)ArgumentMatchers.argThat(timeWindows -> Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 1L), new TimeWindow(1L, 2L), new TimeWindow(2L, 3L)}).matches(timeWindows))));
    }

    @Test
    void testMergeCoveringWindow() throws Exception {
        MergeCallback callback = (MergeCallback)Mockito.mock(MergeCallback.class);
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        TreeSet<TimeWindow> sortedWindows = new TreeSet<TimeWindow>();
        sortedWindows.addAll(Arrays.asList(new TimeWindow(1L, 4L), new TimeWindow(5L, 7L), new TimeWindow(9L, 10L)));
        assigner.mergeWindows(new TimeWindow(3L, 6L), sortedWindows, callback);
        ((MergeCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).merge((Object)((TimeWindow)ArgumentMatchers.eq((Object)new TimeWindow(1L, 7L))), (Object)((Collection)ArgumentMatchers.argThat(timeWindows -> Matchers.containsInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1L, 4L), new TimeWindow(5L, 7L), new TimeWindow(3L, 6L)}).matches(timeWindows))));
    }

    @Test
    void testProperties() {
        SessionWindowAssigner assigner = SessionWindowAssigner.withGap((Duration)Duration.ofMillis(5000L));
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((boolean)assigner.withEventTime().isEventTime()).isTrue();
        Assertions.assertThat((boolean)assigner.withProcessingTime().isEventTime()).isFalse();
    }
}

