/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DataStructureConvertersTest {
    DataStructureConvertersTest() {
    }

    static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.forDataType(DataTypes.CHAR((int)5)).convertedTo(String.class, "12345").convertedTo(byte[].class, "12345".getBytes(StandardCharsets.UTF_8)).convertedTo(StringData.class, StringData.fromString((String)"12345")), TestSpec.forDataType(DataTypes.VARCHAR((int)100)).convertedTo(String.class, "12345").convertedTo(byte[].class, "12345".getBytes(StandardCharsets.UTF_8)).convertedTo(StringData.class, StringData.fromString((String)"12345")), TestSpec.forDataType(DataTypes.BOOLEAN().notNull()).convertedTo(Boolean.class, true).convertedTo(Boolean.TYPE, true), TestSpec.forDataType(DataTypes.BINARY((int)5)).convertedTo(byte[].class, new byte[]{1, 2, 3, 4, 5}), TestSpec.forDataType(DataTypes.VARBINARY((int)100)).convertedTo(byte[].class, new byte[]{1, 2, 3, 4, 5}), TestSpec.forDataType(DataTypes.DECIMAL((int)3, (int)2)).convertedTo(BigDecimal.class, new BigDecimal("1.23")).convertedTo(DecimalData.class, DecimalData.fromUnscaledLong((long)123L, (int)3, (int)2)), TestSpec.forDataType(DataTypes.DATE()).convertedTo(Date.class, Date.valueOf("2010-11-12")).convertedTo(LocalDate.class, LocalDate.parse("2010-11-12")).convertedTo(Integer.class, 14925), TestSpec.forDataType(DataTypes.TIME((int)0)).convertedTo(Time.class, Time.valueOf("12:34:56")).convertedTo(LocalTime.class, LocalTime.parse("12:34:56")).convertedTo(Integer.class, 45296000).convertedTo(Long.class, 45296000000000L), TestSpec.forDataType(DataTypes.TIME((int)3)).convertedTo(LocalTime.class, LocalTime.parse("12:34:56.001")).convertedTo(Integer.class, 45296001), TestSpec.forDataType(DataTypes.TIMESTAMP((int)9)).convertedTo(Timestamp.class, Timestamp.valueOf("2010-11-12 12:34:56.000000001")).convertedTo(LocalDateTime.class, LocalDateTime.parse("2010-11-12T12:34:56.000000001")).convertedTo(TimestampData.class, TimestampData.fromEpochMillis((long)1289565296000L, (int)1)), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)0)).convertedTo(ZonedDateTime.class, ZonedDateTime.ofInstant(Instant.EPOCH, ZoneId.of("UTC"))).convertedTo(OffsetDateTime.class, ZonedDateTime.ofInstant(Instant.EPOCH, ZoneId.of("UTC")).toOffsetDateTime()).expectErrorMessage("Unsupported data type: TIMESTAMP(0) WITH TIME ZONE"), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)0)).convertedTo(Instant.class, Instant.ofEpochSecond(12345L)).convertedTo(Integer.class, 12345).convertedTo(Long.class, 12345000L).convertedTo(Timestamp.class, new Timestamp(12345000L)).convertedTo(TimestampData.class, TimestampData.fromEpochMillis((long)12345000L)), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)).convertedTo(Instant.class, Instant.ofEpochSecond(12345L, 1000000L)).convertedTo(Long.class, 12345001L).convertedTo(Timestamp.class, new Timestamp(12345001L)).convertedTo(TimestampData.class, TimestampData.fromEpochMillis((long)12345001L)), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)).convertedTo(Instant.class, Instant.ofEpochSecond(12345L, 1L)).convertedTo(TimestampData.class, TimestampData.fromEpochMillis((long)12345000L, (int)1)), TestSpec.forDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR((int)2), (DataTypes.Resolution)DataTypes.MONTH())).convertedTo(Period.class, Period.of(2, 6, 0)).convertedTo(Integer.class, 30), TestSpec.forDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).convertedTo(Period.class, Period.of(0, 30, 0)).convertedTo(Integer.class, 30), TestSpec.forDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND((int)3))).convertedTo(Duration.class, Duration.ofMillis(123L)).convertedTo(Long.class, 123L), TestSpec.forDataType(DataTypes.ARRAY((DataType)((DataType)DataTypes.BOOLEAN().notNull()))).convertedTo(boolean[].class, new boolean[]{true, false, true, true}).convertedTo(ArrayData.class, new GenericArrayData(new boolean[]{true, false, true, true})), TestSpec.forDataType(DataTypes.ARRAY((DataType)DataTypes.BOOLEAN())).convertedTo(Boolean[].class, new Boolean[]{true, null, true, true}).convertedTo(List.class, Arrays.asList(true, null, true, true)).convertedTo(ArrayData.class, new GenericArrayData((Object[])new Boolean[]{true, null, true, true})), TestSpec.forDataType(DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))).convertedTo(int[].class, new int[]{1, 2, 3, 4}).convertedTo(Integer[].class, new Integer[]{1, 2, 3, 4}).convertedTo(List.class, new LinkedList<Integer>(Arrays.asList(1, 2, 3, 4))), TestSpec.forDataType(DataTypes.ARRAY((DataType)DataTypes.DATE())).convertedTo(LocalDate[].class, new LocalDate[]{null, LocalDate.parse("2010-11-12"), null, LocalDate.parse("2010-11-12")}).convertedTo(List.class, Arrays.asList(null, LocalDate.parse("2010-11-12"), null, LocalDate.parse("2010-11-12"))), TestSpec.forDataType(DataTypes.MAP((DataType)((DataType)DataTypes.INT().bridgedTo(Integer.TYPE)), (DataType)DataTypes.BOOLEAN())).convertedTo(Map.class, DataStructureConvertersTest.createIdentityMap()).convertedTo(MapData.class, new GenericMapData(DataStructureConvertersTest.createIdentityMap())), TestSpec.forDataType(DataTypes.MAP((DataType)DataTypes.DATE(), (DataType)DataTypes.BOOLEAN())).convertedTo(Map.class, DataStructureConvertersTest.createLocalDateMap()), TestSpec.forDataType(DataTypes.MULTISET((DataType)DataTypes.BOOLEAN())).convertedTo(Map.class, DataStructureConvertersTest.createIdentityMultiset()).convertedTo(MapData.class, new GenericMapData(DataStructureConvertersTest.createIdentityMultiset())), TestSpec.forDataType(DataTypes.MULTISET((DataType)DataTypes.DATE())).convertedTo(Map.class, DataStructureConvertersTest.createLocalDateMultiset()), TestSpec.forDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b_1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"b_2", (DataType)DataTypes.BOOLEAN())}))})).convertedTo(Row.class, Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{12, Row.of((Object[])new Object[]{2.0, null})})).convertedToSupplier(Row.class, () -> {
            Row namedRow = Row.withNames((RowKind)RowKind.DELETE);
            namedRow.setField("a", (Object)12);
            Row sparseNamedRow = Row.withNames();
            sparseNamedRow.setField("b_1", (Object)2.0);
            namedRow.setField("b", (Object)sparseNamedRow);
            return namedRow;
        }).convertedTo(RowData.class, GenericRowData.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{12, GenericRowData.of((Object[])new Object[]{2.0, null})})), TestSpec.forDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b_1", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"b_2", (DataType)DataTypes.DATE())}))})).convertedTo(Row.class, Row.of((Object[])new Object[]{12, Row.of((Object[])new Object[]{LocalDate.ofEpochDay(1L), null})})), TestSpec.forClass(PojoWithMutableFields.class).convertedToSupplier(PojoWithMutableFields.class, () -> {
            PojoWithMutableFields pojo = new PojoWithMutableFields();
            pojo.age = 42;
            pojo.name = "Bob";
            return pojo;
        }).convertedTo(Row.class, Row.of((Object[])new Object[]{42, "Bob"})).convertedTo(RowData.class, GenericRowData.of((Object[])new Object[]{42, StringData.fromString((String)"Bob")})), TestSpec.forClass(PojoWithImmutableFields.class).convertedTo(PojoWithImmutableFields.class, new PojoWithImmutableFields(42, "Bob")).convertedTo(Row.class, Row.of((Object[])new Object[]{42, "Bob"})).convertedTo(RowData.class, GenericRowData.of((Object[])new Object[]{42, StringData.fromString((String)"Bob")})), TestSpec.forClass(PojoWithGettersAndSetters.class).convertedToSupplier(PojoWithGettersAndSetters.class, () -> {
            PojoWithGettersAndSetters pojo = new PojoWithGettersAndSetters();
            pojo.setAge(42);
            pojo.setName("Bob");
            return pojo;
        }).convertedTo(Row.class, Row.of((Object[])new Object[]{42, "Bob"})).convertedTo(RowData.class, GenericRowData.of((Object[])new Object[]{42, StringData.fromString((String)"Bob")})), TestSpec.forClass(ComplexPojo.class).convertedToSupplier(ComplexPojo.class, () -> {
            ComplexPojo pojo = new ComplexPojo();
            pojo.setTimestamp(Timestamp.valueOf("2010-11-12 13:14:15.000000001"));
            pojo.setPreferences(Row.of((Object[])new Object[]{42, "Bob", new Boolean[]{true, null, false}}));
            pojo.setBalance(new BigDecimal("1.23"));
            return pojo;
        }).convertedTo(Row.class, Row.of((Object[])new Object[]{Timestamp.valueOf("2010-11-12 13:14:15.000000001"), Row.of((Object[])new Object[]{42, "Bob", new Boolean[]{true, null, false}}), new BigDecimal("1.23")})), TestSpec.forClass(PojoAsSuperclass.class).convertedToSupplier(PojoWithMutableFields.class, () -> {
            PojoWithMutableFields pojo = new PojoWithMutableFields();
            pojo.age = 42;
            pojo.name = "Bob";
            return pojo;
        }).convertedTo(Row.class, Row.of((Object[])new Object[]{42})), TestSpec.forDataType(DataTypes.MAP((AbstractDataType)DataTypes.STRING(), (AbstractDataType)DataTypes.of(PojoWithImmutableFields.class))).convertedTo(Map.class, DataStructureConvertersTest.createPojoWithImmutableFieldsMap()), TestSpec.forDataType(DataTypes.ARRAY((AbstractDataType)DataTypes.of(PojoWithNestedPojo.class))).convertedTo(PojoWithNestedPojo[].class, DataStructureConvertersTest.createPojoWithNestedPojoArray()).convertedTo(Row[].class, new Row[]{Row.of((Object[])new Object[]{new PojoWithImmutableFields(42, "Bob"), new PojoWithImmutableFields[]{new PojoWithImmutableFields(42, "Bob"), null}}), null, Row.of((Object[])new Object[]{null, new PojoWithImmutableFields[3]}), Row.of((Object[])new Object[]{null, null})}).convertedToWithAnotherValue(Row[].class, new Row[]{Row.of((Object[])new Object[]{null, null}), Row.of((Object[])new Object[]{new PojoWithImmutableFields(10, "Bob"), null})}), TestSpec.forDataType(DataTypes.of(PojoWithList.class)).convertedTo(PojoWithList.class, new PojoWithList(Arrays.asList(Arrays.asList(1.0, null, 2.0, null), Collections.emptyList(), null))).convertedTo(Row.class, Row.of((Object[])new Object[]{Arrays.asList(Arrays.asList(1.0, null, 2.0, null), Collections.emptyList(), null)})), TestSpec.forDataType(DataTypes.STRUCTURED(GenericPojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"value", (DataType)DataTypes.INT())})).convertedTo(GenericPojo.class, new GenericPojo<Integer>(12)), TestSpec.forDataType(DataTypes.STRUCTURED(GenericPojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"value", (DataType)DataTypes.DATE())})).convertedTo(GenericPojo.class, new GenericPojo<LocalDate>(LocalDate.ofEpochDay(123L))));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testConversions(TestSpec testSpec) {
        for (Map.Entry<Class<?>, Object> from : testSpec.conversions.entrySet()) {
            DataType fromDataType = (DataType)testSpec.dataType.bridgedTo(from.getKey());
            if (testSpec.expectedErrorMessage != null) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DataStructureConverters.getConverter((DataType)fromDataType)).isInstanceOf(TableException.class)).hasMessage(testSpec.expectedErrorMessage);
                continue;
            }
            DataStructureConverter<Object, Object> fromConverter = DataStructureConvertersTest.simulateSerialization((DataStructureConverter<Object, Object>)DataStructureConverters.getConverter((DataType)fromDataType));
            fromConverter.open(DataStructureConvertersTest.class.getClassLoader());
            Object internalValue = fromConverter.toInternalOrNull(from.getValue());
            Object anotherValue = testSpec.conversionsWithAnotherValue.get(from.getKey());
            if (anotherValue != null) {
                fromConverter.toInternalOrNull(anotherValue);
            }
            for (Map.Entry<Class<?>, Object> to : testSpec.conversions.entrySet()) {
                DataType toDataType = (DataType)testSpec.dataType.bridgedTo(to.getKey());
                DataStructureConverter<Object, Object> toConverter = DataStructureConvertersTest.simulateSerialization((DataStructureConverter<Object, Object>)DataStructureConverters.getConverter((DataType)toDataType));
                toConverter.open(DataStructureConvertersTest.class.getClassLoader());
                Assertions.assertThat((Object)toConverter.toExternalOrNull(internalValue)).isEqualTo(to.getValue());
            }
        }
    }

    private static DataStructureConverter<Object, Object> simulateSerialization(DataStructureConverter<Object, Object> converter) {
        try {
            byte[] bytes = InstantiationUtil.serializeObject(converter);
            return (DataStructureConverter)InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)DataStructureConverter.class.getClassLoader());
        }
        catch (Exception e) {
            throw new AssertionError("Serialization failed.", e);
        }
    }

    private static Map<Integer, Boolean> createIdentityMap() {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        map.put(1, true);
        map.put(2, false);
        map.put(3, null);
        map.put(null, true);
        return map;
    }

    private static Map<LocalDate, Boolean> createLocalDateMap() {
        HashMap<LocalDate, Boolean> map = new HashMap<LocalDate, Boolean>();
        map.put(LocalDate.ofEpochDay(0L), true);
        map.put(LocalDate.ofEpochDay(1L), false);
        map.put(LocalDate.ofEpochDay(3L), null);
        map.put(null, true);
        return map;
    }

    private static Map<String, PojoWithImmutableFields> createPojoWithImmutableFieldsMap() {
        HashMap<String, PojoWithImmutableFields> map = new HashMap<String, PojoWithImmutableFields>();
        map.put("Alice", new PojoWithImmutableFields(12, "Alice"));
        map.put("Bob", new PojoWithImmutableFields(42, "Bob"));
        map.put("Unknown", null);
        return map;
    }

    private static PojoWithNestedPojo[] createPojoWithNestedPojoArray() {
        PojoWithNestedPojo pojo1 = new PojoWithNestedPojo();
        pojo1.inner = new PojoWithImmutableFields(42, "Bob");
        pojo1.innerArray = new PojoWithImmutableFields[]{new PojoWithImmutableFields(42, "Bob"), null};
        PojoWithNestedPojo pojo2 = new PojoWithNestedPojo();
        pojo2.inner = null;
        pojo2.innerArray = new PojoWithImmutableFields[3];
        PojoWithNestedPojo pojo3 = new PojoWithNestedPojo();
        return new PojoWithNestedPojo[]{pojo1, null, pojo2, pojo3};
    }

    private static Map<Boolean, Integer> createIdentityMultiset() {
        HashMap<Boolean, Integer> map = new HashMap<Boolean, Integer>();
        map.put(true, 1);
        map.put(false, 2);
        map.put(null, 3);
        return map;
    }

    private static Map<LocalDate, Integer> createLocalDateMultiset() {
        HashMap<LocalDate, Integer> map = new HashMap<LocalDate, Integer>();
        map.put(LocalDate.ofEpochDay(0L), 1);
        map.put(LocalDate.ofEpochDay(1L), 2);
        map.put(null, 3);
        return map;
    }

    private static class TestSpec {
        private final String description;
        private final DataType dataType;
        private final Map<Class<?>, Object> conversions;
        private final Map<Class<?>, Object> conversionsWithAnotherValue;
        @Nullable
        private String expectedErrorMessage;

        private TestSpec(String description, DataType dataType) {
            this.description = description;
            this.dataType = dataType;
            this.conversions = new LinkedHashMap();
            this.conversionsWithAnotherValue = new LinkedHashMap();
        }

        static TestSpec forDataType(AbstractDataType<?> dataType) {
            DataTypeFactoryMock factoryMock = new DataTypeFactoryMock();
            DataType resolvedDataType = factoryMock.createDataType(dataType);
            return new TestSpec(resolvedDataType.toString(), resolvedDataType);
        }

        static TestSpec forClass(Class<?> clazz) {
            return TestSpec.forDataType(DataTypes.of(clazz));
        }

        <T> TestSpec convertedTo(Class<T> clazz, T value) {
            this.conversions.put(clazz, value);
            return this;
        }

        <T> TestSpec convertedToWithAnotherValue(Class<T> clazz, T value) {
            this.conversionsWithAnotherValue.put(clazz, value);
            return this;
        }

        <T> TestSpec convertedToSupplier(Class<T> clazz, Supplier<T> supplier) {
            this.conversions.put(clazz, supplier.get());
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.description;
        }
    }

    public static class PojoWithMutableFields
    extends PojoAsSuperclass {
        public String name;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (o.getClass() == PojoAsSuperclass.class) {
                return true;
            }
            PojoWithMutableFields that = (PojoWithMutableFields)o;
            return Objects.equals(this.name, that.name);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.name);
        }
    }

    public static class PojoWithImmutableFields {
        public final int age;
        public final String name;

        public PojoWithImmutableFields(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoWithImmutableFields that = (PojoWithImmutableFields)o;
            return this.age == that.age && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.age, this.name);
        }
    }

    public static class PojoWithGettersAndSetters {
        private int age;
        private String name;

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoWithGettersAndSetters that = (PojoWithGettersAndSetters)o;
            return this.age == that.age && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.age, this.name);
        }
    }

    public static class ComplexPojo {
        private Timestamp timestamp;
        @DataTypeHint(value="ROW<age INT, name STRING, mask ARRAY<BOOLEAN>>")
        private Row preferences;
        @DataTypeHint(value="DECIMAL(3, 2)")
        private BigDecimal balance;

        public ComplexPojo() {
        }

        public ComplexPojo(Timestamp timestamp, Row preferences, BigDecimal balance) {
            this.timestamp = timestamp;
            this.preferences = preferences;
            this.balance = balance;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public Row getPreferences() {
            return this.preferences;
        }

        public void setPreferences(Row preferences) {
            this.preferences = preferences;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public void setBalance(BigDecimal balance) {
            this.balance = balance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComplexPojo that = (ComplexPojo)o;
            return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.preferences, that.preferences) && Objects.equals(this.balance, that.balance);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.preferences, this.balance);
        }
    }

    public static class PojoAsSuperclass {
        public int age;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PojoAsSuperclass)) {
                return false;
            }
            PojoAsSuperclass that = (PojoAsSuperclass)o;
            return this.age == that.age;
        }

        public int hashCode() {
            return Objects.hash(this.age);
        }
    }

    public static class PojoWithNestedPojo {
        public PojoWithImmutableFields inner;
        public PojoWithImmutableFields[] innerArray;

        public PojoWithNestedPojo() {
        }

        public PojoWithNestedPojo(PojoWithImmutableFields inner, PojoWithImmutableFields[] innerArray) {
            this.inner = inner;
            this.innerArray = innerArray;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoWithNestedPojo that = (PojoWithNestedPojo)o;
            return Objects.equals(this.inner, that.inner) && Arrays.equals(this.innerArray, that.innerArray);
        }

        public int hashCode() {
            int result = Objects.hash(this.inner);
            result = 31 * result + Arrays.hashCode(this.innerArray);
            return result;
        }
    }

    public static class PojoWithList {
        public List<List<Double>> factors;

        public PojoWithList(List<List<Double>> factors) {
            this.factors = factors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoWithList that = (PojoWithList)o;
            return Objects.equals(this.factors, that.factors);
        }

        public int hashCode() {
            return Objects.hash(this.factors);
        }
    }

    public static class GenericPojo<T> {
        public T value;

        public GenericPojo(T value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericPojo that = (GenericPojo)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

