/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.util.Arrays;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public class ExecEdge {
    private final ExecNode<?> source;
    private final ExecNode<?> target;
    private final Shuffle shuffle;
    private final StreamExchangeMode exchangeMode;
    public static final Shuffle ANY_SHUFFLE = new Shuffle(Shuffle.Type.ANY){};
    public static final Shuffle BROADCAST_SHUFFLE = new Shuffle(Shuffle.Type.BROADCAST){};
    public static final Shuffle SINGLETON_SHUFFLE = new Shuffle(Shuffle.Type.SINGLETON){};
    public static final Shuffle FORWARD_SHUFFLE = new Shuffle(Shuffle.Type.FORWARD){};

    public ExecEdge(ExecNode<?> source, ExecNode<?> target, Shuffle shuffle, StreamExchangeMode exchangeMode) {
        this.source = (ExecNode)Preconditions.checkNotNull(source);
        this.target = (ExecNode)Preconditions.checkNotNull(target);
        this.shuffle = (Shuffle)Preconditions.checkNotNull((Object)shuffle);
        this.exchangeMode = (StreamExchangeMode)Preconditions.checkNotNull((Object)exchangeMode);
        if (shuffle.getType() != Shuffle.Type.FORWARD) {
            throw new TableException("Only FORWARD shuffle is supported now.");
        }
        if (exchangeMode != StreamExchangeMode.PIPELINED) {
            throw new TableException("Only PIPELINED shuffle mode is supported now.");
        }
    }

    public ExecNode<?> getSource() {
        return this.source;
    }

    public ExecNode<?> getTarget() {
        return this.target;
    }

    public Shuffle getShuffle() {
        return this.shuffle;
    }

    public StreamExchangeMode getExchangeMode() {
        return this.exchangeMode;
    }

    public LogicalType getOutputType() {
        return this.source.getOutputType();
    }

    public String toString() {
        return "ExecEdge{source=" + this.source.getDescription() + ", target=" + this.target.getDescription() + ", shuffle=" + this.shuffle + ", exchangeMode=" + this.exchangeMode + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Shuffle hashShuffle(int[] keys) {
        return new HashShuffle(keys);
    }

    public Transformation<?> translateToPlan(Planner planner) {
        return this.source.translateToPlan(planner);
    }

    public OpFusionCodegenSpecGenerator translateToFusionCodegenSpec(Planner planner, CodeGeneratorContext parentCtx) {
        return this.source.translateToFusionCodegenSpec(planner, parentCtx);
    }

    public static abstract class Shuffle {
        private final Type type;

        protected Shuffle(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.type.name();
        }

        public static enum Type {
            ANY,
            HASH,
            BROADCAST,
            SINGLETON,
            FORWARD;

        }
    }

    public static class Builder {
        private ExecNode<?> source;
        private ExecNode<?> target;
        private Shuffle shuffle = FORWARD_SHUFFLE;
        private StreamExchangeMode exchangeMode = StreamExchangeMode.PIPELINED;

        public Builder from(ExecEdge original) {
            this.source = original.source;
            this.target = original.target;
            this.shuffle = original.shuffle;
            this.exchangeMode = original.exchangeMode;
            return this;
        }

        public Builder source(ExecNode<?> source) {
            this.source = source;
            return this;
        }

        public Builder target(ExecNode<?> target) {
            this.target = target;
            return this;
        }

        public Builder shuffle(Shuffle shuffle) {
            this.shuffle = shuffle;
            return this;
        }

        public Builder requiredDistribution(InputProperty.RequiredDistribution requiredDistribution) {
            return this.shuffle(this.fromRequiredDistribution(requiredDistribution));
        }

        public Builder exchangeMode(StreamExchangeMode exchangeMode) {
            this.exchangeMode = exchangeMode;
            return this;
        }

        public ExecEdge build() {
            return new ExecEdge(this.source, this.target, this.shuffle, this.exchangeMode);
        }

        private Shuffle fromRequiredDistribution(InputProperty.RequiredDistribution requiredDistribution) {
            switch (requiredDistribution.getType()) {
                case ANY: {
                    return ANY_SHUFFLE;
                }
                case SINGLETON: {
                    return SINGLETON_SHUFFLE;
                }
                case BROADCAST: {
                    return BROADCAST_SHUFFLE;
                }
                case HASH: {
                    InputProperty.HashDistribution hashDistribution = (InputProperty.HashDistribution)requiredDistribution;
                    return ExecEdge.hashShuffle(hashDistribution.getKeys());
                }
            }
            throw new TableException("Unsupported RequiredDistribution type: " + requiredDistribution.getType());
        }
    }

    public static class HashShuffle
    extends Shuffle {
        private final int[] keys;

        public HashShuffle(int[] keys) {
            super(Shuffle.Type.HASH);
            this.keys = (int[])Preconditions.checkNotNull((Object)keys);
            Preconditions.checkArgument((keys.length > 0 ? 1 : 0) != 0, (Object)"Hash keys must no be empty.");
        }

        public int[] getKeys() {
            return this.keys;
        }

        @Override
        public String toString() {
            return "HASH" + Arrays.toString(this.keys);
        }
    }
}

