/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.utils.SumAccumulator;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import scala.Predef$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4Qa\u0003\u0007\u0002\u0002eA\u0001b\r\u0001\u0003\u0004\u0003\u0006Y\u0001\u000e\u0005\u0006\u0001\u0002!\t!\u0011\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0011\u00199\u0005\u0001)A\u0005i!)\u0001\n\u0001C!\u0013\")!\n\u0001C\u0001\u0017\")1\u000b\u0001C!)\")a\u000b\u0001C\u0001/\")A\r\u0001C!K\")a\u000f\u0001D\u0001o\nq1+^7BO\u001e4UO\\2uS>t'BA\u0007\u000f\u0003\u0015)H/\u001b7t\u0015\ty\u0001#A\u0004qY\u0006tg.\u001a:\u000b\u0005E\u0011\u0012!\u0002;bE2,'BA\n\u0015\u0003\u00151G.\u001b8l\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\u0004\u0001U\u0011!dI\n\u0003\u0001m\u0001B\u0001H\u0010\"_5\tQD\u0003\u0002\u001f!\u0005Ia-\u001e8di&|gn]\u0005\u0003Au\u0011\u0011#Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o!\t\u00113\u0005\u0004\u0001\u0005\u000b\u0011\u0002!\u0019A\u0013\u0003\u0003Q\u000b\"A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000f9{G\u000f[5oOB\u0011q%L\u0005\u0003]!\u00121!\u00118z!\r\u0001\u0014'I\u0007\u0002\u0019%\u0011!\u0007\u0004\u0002\u000f'Vl\u0017iY2v[Vd\u0017\r^8s\u0003))g/\u001b3f]\u000e,G%\r\t\u0004ku\ncB\u0001\u001c<\u001d\t9$(D\u00019\u0015\tI\u0004$\u0001\u0004=e>|GOP\u0005\u0002S%\u0011A\bK\u0001\ba\u0006\u001c7.Y4f\u0013\tqtHA\u0004Ok6,'/[2\u000b\u0005qB\u0013A\u0002\u001fj]&$h\bF\u0001C)\t\u0019E\tE\u00021\u0001\u0005BQa\r\u0002A\u0004Q\nqA\\;nKJL7-F\u00015\u0003!qW/\\3sS\u000e\u0004\u0013!E2sK\u0006$X-Q2dk6,H.\u0019;peR\tq&\u0001\u0006bG\u000e,X.\u001e7bi\u0016$2\u0001T(R!\t9S*\u0003\u0002OQ\t!QK\\5u\u0011\u0015\u0001f\u00011\u00010\u0003-\t7mY;nk2\fGo\u001c:\t\u000bI3\u0001\u0019\u0001\u0017\u0002\u000bY\fG.^3\u0002\u0011\u001d,GOV1mk\u0016$\"!I+\t\u000bA;\u0001\u0019A\u0018\u0002\u000b5,'oZ3\u0015\u00071C&\fC\u0003Z\u0011\u0001\u0007q&A\u0002bG\u000eDQa\u0017\u0005A\u0002q\u000b1!\u001b;t!\ri&mL\u0007\u0002=*\u0011q\fY\u0001\u0005Y\u0006twMC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rt&\u0001C%uKJ\f'\r\\3\u0002!\u001d,G\u000fV=qK&sg-\u001a:f]\u000e,GC\u00014o!\t9G.D\u0001i\u0015\tI'.A\u0005j]\u001a,'/\u001a8dK*\u00111\u000eE\u0001\u0006if\u0004Xm]\u0005\u0003[\"\u0014Q\u0002V=qK&sg-\u001a:f]\u000e,\u0007\"B8\n\u0001\u0004\u0001\u0018a\u0003;za\u00164\u0015m\u0019;pef\u0004\"!\u001d;\u000e\u0003IT!a\u001d\t\u0002\u000f\r\fG/\u00197pO&\u0011QO\u001d\u0002\u0010\t\u0006$\u0018\rV=qK\u001a\u000b7\r^8ss\u0006\u0001r-\u001a;WC2,X\rR1uCRK\b/Z\u000b\u0002qB\u0011\u0011P_\u0007\u0002U&\u00111P\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0002")
public abstract class SumAggFunction<T>
extends AggregateFunction<T, SumAccumulator<T>> {
    private final Numeric<T> numeric;

    private Numeric<T> numeric() {
        return this.numeric;
    }

    public SumAccumulator<T> createAccumulator() {
        SumAccumulator acc = new SumAccumulator();
        acc.f0 = this.numeric().zero();
        acc.f1 = BoxesRunTime.boxToBoolean((boolean)false);
        return acc;
    }

    public void accumulate(SumAccumulator<T> accumulator, Object value) {
        if (value != null) {
            Object v = value;
            accumulator.f0 = this.numeric().plus(v, accumulator.f0);
            accumulator.f1 = BoxesRunTime.boxToBoolean((boolean)true);
            return;
        }
    }

    public T getValue(SumAccumulator<T> accumulator) {
        if (BoxesRunTime.unboxToBoolean((Object)accumulator.f1)) {
            return (T)accumulator.f0;
        }
        return null;
    }

    public void merge(SumAccumulator<T> acc, Iterable<SumAccumulator<T>> its) {
        for (SumAccumulator<T> a : its) {
            if (!BoxesRunTime.unboxToBoolean((Object)a.f1)) continue;
            acc.f0 = this.numeric().plus(acc.f0, a.f0);
            acc.f1 = BoxesRunTime.boxToBoolean((boolean)true);
        }
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().typedArguments(new DataType[]{this.getValueDataType()}).accumulatorTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRUCTURED(SumAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)this.getValueDataType()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())}))).outputTypeStrategy(TypeStrategies.explicit((DataType)this.getValueDataType())).build();
    }

    public abstract DataType getValueDataType();

    public SumAggFunction(Numeric<T> evidence$1) {
        this.numeric = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
    }
}

