/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.utils.TestSimpleDynamicTableSourceFactory;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.utils.CatalogManagerMocks;

public class PlannerMocks {
    private final FlinkPlannerImpl planner;
    private final ParserImpl parser;
    private final CatalogManager catalogManager;
    private final FunctionCatalog functionCatalog;
    private final TableConfig tableConfig;
    private final PlannerContext plannerContext;

    private PlannerMocks(boolean isBatchMode, TableConfig tableConfig, ResourceManager resourceManager, CatalogManager catalogManager, List<RelTraitDef> traitDefs, CalciteSchema rootSchema) {
        this.catalogManager = catalogManager;
        this.tableConfig = tableConfig;
        ModuleManager moduleManager = new ModuleManager();
        this.functionCatalog = new FunctionCatalog((ReadableConfig)tableConfig, resourceManager, catalogManager, moduleManager);
        this.plannerContext = new PlannerContext(isBatchMode, tableConfig, moduleManager, this.functionCatalog, catalogManager, rootSchema != null ? rootSchema : CalciteSchemaBuilder.asRootSchema((org.apache.calcite.schema.Schema)new CatalogManagerCalciteSchema(catalogManager, !isBatchMode)), traitDefs, PlannerMocks.class.getClassLoader());
        this.planner = this.plannerContext.createFlinkPlanner();
        this.parser = new ParserImpl(catalogManager, () -> this.planner, () -> ((FlinkPlannerImpl)this.planner).parser(), this.plannerContext.getRexFactory());
        catalogManager.initSchemaResolver(true, ExpressionResolver.resolverFor((TableConfig)tableConfig, (ClassLoader)PlannerMocks.class.getClassLoader(), name -> {
            throw new UnsupportedOperationException();
        }, (FunctionLookup)this.functionCatalog.asLookup(arg_0 -> ((ParserImpl)this.parser).parseIdentifier(arg_0)), (DataTypeFactory)catalogManager.getDataTypeFactory(), (arg_0, arg_1, arg_2) -> ((ParserImpl)this.parser).parseSqlExpression(arg_0, arg_1, arg_2), (QueryOperation[])new QueryOperation[0]), (Parser)this.parser);
    }

    public FlinkPlannerImpl getPlanner() {
        return this.planner;
    }

    public ParserImpl getParser() {
        return this.parser;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public FunctionCatalog getFunctionCatalog() {
        return this.functionCatalog;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public PlannerMocks registerTemporaryTable(String tableName, Schema tableSchema) {
        CatalogTable table = CatalogTable.newBuilder().schema(tableSchema).options(Map.of("connector", TestSimpleDynamicTableSourceFactory.IDENTIFIER())).build();
        this.getCatalogManager().createTemporaryTable((CatalogBaseTable)table, ObjectIdentifier.of((String)this.getCatalogManager().getCurrentCatalog(), (String)this.getCatalogManager().getCurrentDatabase(), (String)tableName), false);
        return this;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static PlannerMocks create() {
        return new Builder().build();
    }

    public static PlannerMocks create(boolean batchMode) {
        return new Builder().withBatchMode(batchMode).build();
    }

    public static PlannerMocks create(Configuration configuration) {
        return new Builder().withConfiguration(configuration).build();
    }

    public static class Builder {
        private boolean batchMode = false;
        private TableConfig tableConfig = TableConfig.getDefault();
        private CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        private ResourceManager resourceManager = ResourceManager.createResourceManager((URL[])new URL[0], (ClassLoader)Thread.currentThread().getContextClassLoader(), (ReadableConfig)this.tableConfig.getConfiguration());
        private List<RelTraitDef> traitDefs = Collections.emptyList();
        private CalciteSchema rootSchema;

        private Builder() {
        }

        public Builder withBatchMode(boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        public Builder withTableConfig(TableConfig tableConfig) {
            this.tableConfig = tableConfig;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.tableConfig.addConfiguration(configuration);
            return this;
        }

        public Builder withResourceManager(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
            return this;
        }

        public Builder withCatalogManager(CatalogManager catalogManager) {
            this.catalogManager = catalogManager;
            return this;
        }

        public Builder withTraitDefs(List<RelTraitDef> traitDefs) {
            this.traitDefs = traitDefs;
            return this;
        }

        public Builder withRootSchema(CalciteSchema rootSchema) {
            this.rootSchema = rootSchema;
            return this;
        }

        public PlannerMocks build() {
            return new PlannerMocks(this.batchMode, this.tableConfig, this.resourceManager, this.catalogManager, this.traitDefs, this.rootSchema);
        }
    }
}

