/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.IOException;
import org.apache.flink.FlinkVersion;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.util.jackson.JacksonMapperFactory;

public final class JsonTestUtils {
    private static final ObjectMapper OBJECT_MAPPER_INSTANCE = JacksonMapperFactory.createObjectMapper();

    private JsonTestUtils() {
    }

    public static JsonNode readFromResource(String path) throws IOException {
        return OBJECT_MAPPER_INSTANCE.readTree(JsonTestUtils.class.getResource(path));
    }

    public static JsonNode readFromString(String path) throws IOException {
        return OBJECT_MAPPER_INSTANCE.readTree(path);
    }

    public static String writeToString(JsonNode target) throws JsonProcessingException {
        return OBJECT_MAPPER_INSTANCE.writeValueAsString((Object)target);
    }

    public static JsonNode setFlinkVersion(JsonNode target, FlinkVersion flinkVersion) {
        return ((ObjectNode)target).set("flinkVersion", OBJECT_MAPPER_INSTANCE.valueToTree((Object)flinkVersion.toString()));
    }

    public static JsonNode setExecNodeConfig(JsonNode target, String type, String key, String value) {
        target.get("nodes").elements().forEachRemaining(n -> {
            if (n.get("type").asText().equals(type)) {
                ObjectNode configNode = OBJECT_MAPPER_INSTANCE.createObjectNode();
                configNode.put(key, value);
                ((ObjectNode)n).set("configuration", (JsonNode)configNode);
            }
        });
        return target;
    }

    public static JsonNode setExecNodeStateMetadata(JsonNode target, String type, int stateIndex, long stateTtl) {
        target.get("nodes").elements().forEachRemaining(n -> {
            if (n.get("type").asText().startsWith(type) && n.hasNonNull("state")) {
                ((ObjectNode)n.get("state").get(stateIndex)).put("ttl", stateTtl + " ms");
            }
        });
        return target;
    }
}

