/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class InternalConfigOptionsTest
extends TableTestBase {
    private TableEnvironment tEnv;
    private PlannerBase planner;
    @Parameter
    private String plannerMode;

    InternalConfigOptionsTest() {
    }

    @Parameters(name="plannerMode = {0}")
    private static Collection<String> parameters() {
        return Arrays.asList("STREAMING", "BATCH");
    }

    @BeforeEach
    void setUp() {
        if (this.plannerMode.equals("STREAMING")) {
            StreamTableTestUtil util = this.streamTestUtil(TableConfig.getDefault());
            this.tEnv = util.getTableEnv();
            this.planner = util.getPlanner();
        } else {
            BatchTableTestUtil util = this.batchTestUtil(TableConfig.getDefault());
            this.tEnv = util.getTableEnv();
            this.planner = util.getPlanner();
        }
    }

    @TestTemplate
    void testTranslateExecNodeGraphWithInternalTemporalConf() {
        Table table = this.tEnv.sqlQuery("SELECT LOCALTIME, LOCALTIMESTAMP, CURRENT_TIME, CURRENT_TIMESTAMP");
        RelNode relNode = this.planner.optimize(TableTestUtil.toRelNode(table));
        ExecNodeGraph execNodeGraph = this.planner.translateToExecNodeGraph(JavaScalaConversionUtil.toScala(Collections.singletonList(relNode)), false);
        List transformation = this.planner.translateToPlan(execNodeGraph);
        Assertions.assertThat((List)transformation).hasSize(1);
    }
}

