/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.utils.DecimalAvgAccumulator;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4Aa\u0003\u0007\u00013!AA\u0006\u0001B\u0001B\u0003%Q\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0003:\u0001\u0011\u0005#\bC\u0003<\u0001\u0011\u0005A\bC\u0003K\u0001\u0011\u00051\nC\u0003O\u0001\u0011\u0005s\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003]\u0001\u0011\u0005S\fC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003k\u0001\u0011\u00053NA\u000bEK\u000eLW.\u00197Bm\u001e\fum\u001a$v]\u000e$\u0018n\u001c8\u000b\u00055q\u0011!B;uS2\u001c(BA\b\u0011\u0003\u001d\u0001H.\u00198oKJT!!\u0005\n\u0002\u000bQ\f'\r\\3\u000b\u0005M!\u0012!\u00024mS:\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00015A!1D\b\u0011)\u001b\u0005a\"BA\u000f\u0011\u0003%1WO\\2uS>t7/\u0003\u0002 9\t\t\u0012iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001B7bi\"T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\tQ!)[4EK\u000eLW.\u00197\u0011\u0005%RS\"\u0001\u0007\n\u0005-b!!\u0006#fG&l\u0017\r\\!wO\u0006\u001b7-^7vY\u0006$xN]\u0001\bCJ<G+\u001f9f!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0004m_\u001eL7-\u00197\u000b\u0005I\u0002\u0012!\u0002;za\u0016\u001c\u0018B\u0001\u001b0\u0005-!UmY5nC2$\u0016\u0010]3\u0002\rqJg.\u001b;?)\t9\u0004\b\u0005\u0002*\u0001!)AF\u0001a\u0001[\u0005\t2M]3bi\u0016\f5mY;nk2\fGo\u001c:\u0015\u0003!\n!\"Y2dk6,H.\u0019;f)\ri4)\u0012\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0005+:LG\u000fC\u0003E\t\u0001\u0007\u0001&A\u0002bG\u000eDQA\u0012\u0003A\u0002\u001d\u000bQA^1mk\u0016\u0004\"A\u0010%\n\u0005%{$aA!os\u00069!/\u001a;sC\u000e$HcA\u001fM\u001b\")A)\u0002a\u0001Q!)a)\u0002a\u0001\u000f\u0006Aq-\u001a;WC2,X\r\u0006\u0002!!\")AI\u0002a\u0001Q\u0005)Q.\u001a:hKR\u0019Qh\u0015+\t\u000b\u0011;\u0001\u0019\u0001\u0015\t\u000bU;\u0001\u0019\u0001,\u0002\u0007%$8\u000fE\u0002X5\"j\u0011\u0001\u0017\u0006\u00033\u0012\nA\u0001\\1oO&\u00111\f\u0017\u0002\t\u0013R,'/\u00192mK\u0006\u0011r-\u001a;BG\u000e,X.\u001e7bi>\u0014H+\u001f9f)\u0005q\u0006cA0gQ5\t\u0001M\u0003\u0002bE\u0006AA/\u001f9fS:4wN\u0003\u0002dI\u000611m\\7n_:T!!\u001a\n\u0002\u0007\u0005\u0004\u0018.\u0003\u0002hA\nyA+\u001f9f\u0013:4wN]7bi&|g.\u0001\u0006hKR\u001cV/\u001c+za\u0016,\u0012!L\u0001\u000eO\u0016$(+Z:vYR$\u0016\u0010]3\u0015\u00031\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u0013QL\b/Z;uS2\u001c(BA9\u0011\u0003\u001d\u0011XO\u001c;j[\u0016L!a\u001d8\u0003%\tKw\rR3dS6\fG\u000eV=qK&sgm\u001c")
public class DecimalAvgAggFunction
extends AggregateFunction<BigDecimal, DecimalAvgAccumulator> {
    private final DecimalType argType;

    public DecimalAvgAccumulator createAccumulator() {
        return new DecimalAvgAccumulator();
    }

    public void accumulate(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).add(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
            return;
        }
    }

    public void retract(DecimalAvgAccumulator acc, Object value) {
        if (value != null) {
            BigDecimal v = (BigDecimal)value;
            acc.f0 = ((BigDecimal)acc.f0).subtract(v);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
            return;
        }
    }

    public BigDecimal getValue(DecimalAvgAccumulator acc) {
        if (BoxesRunTime.unboxToLong((Object)acc.f1) == 0L) {
            return null;
        }
        return ((BigDecimal)acc.f0).divide(BigDecimal.valueOf(BoxesRunTime.unboxToLong((Object)acc.f1)), MathContext.DECIMAL128);
    }

    public void merge(DecimalAvgAccumulator acc, Iterable<DecimalAvgAccumulator> its) {
        for (DecimalAvgAccumulator a : its) {
            acc.f0 = ((BigDecimal)acc.f0).add((BigDecimal)a.f0);
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
        }
    }

    public TypeInformation<DecimalAvgAccumulator> getAccumulatorType() {
        DecimalType decimalType = this.getSumType();
        return new TupleTypeInfo(DecimalAvgAccumulator.class, new TypeInformation[]{new BigDecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()), Types.LONG()});
    }

    public DecimalType getSumType() {
        return (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)this.argType);
    }

    public BigDecimalTypeInfo getResultType() {
        DecimalType t = (DecimalType)LogicalTypeMerging.findAvgAggType((LogicalType)this.argType);
        return new BigDecimalTypeInfo(t.getPrecision(), t.getScale());
    }

    public DecimalAvgAggFunction(DecimalType argType) {
        this.argType = argType;
    }
}

