/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.math.BigInteger;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.utils.BigIntegralAvgAccumulator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0003\u0006\u0002\u0002]AQ!\r\u0001\u0005\u0002IBQ\u0001\u000e\u0001\u0005BUBQA\u000e\u0001\u0005\u0002]BQa\u0010\u0001\u0005\u0002\u0001CQa\u0011\u0001\u0005B\u0011CQA\u0012\u0001\u0005\u0002\u001dCQa\u0015\u0001\u0005BQCQa\u0018\u0001\u0007\u0002\u0001\u0014\u0011DQ5h\u0013:$Xm\u001a:bY\u00063x-Q4h\rVt7\r^5p]*\u00111\u0002D\u0001\u0006kRLGn\u001d\u0006\u0003\u001b9\tq\u0001\u001d7b]:,'O\u0003\u0002\u0010!\u0005)A/\u00192mK*\u0011\u0011CE\u0001\u0006M2Lgn\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005a\t3C\u0001\u0001\u001a!\u0011QRdH\u0017\u000e\u0003mQ!\u0001\b\b\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018B\u0001\u0010\u001c\u0005E\tum\u001a:fO\u0006$XMR;oGRLwN\u001c\t\u0003A\u0005b\u0001\u0001B\u0003#\u0001\t\u00071EA\u0001U#\t!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcEA\u0004O_RD\u0017N\\4\u0011\u0005\u0015Z\u0013B\u0001\u0017'\u0005\r\te.\u001f\t\u0003]=j\u0011AC\u0005\u0003a)\u0011\u0011DQ5h\u0013:$Xm\u001a:bY\u00063x-Q2dk6,H.\u0019;pe\u00061A(\u001b8jiz\"\u0012a\r\t\u0004]\u0001y\u0012!E2sK\u0006$X-Q2dk6,H.\u0019;peR\tQ&\u0001\u0006bG\u000e,X.\u001e7bi\u0016$2\u0001O\u001e>!\t)\u0013(\u0003\u0002;M\t!QK\\5u\u0011\u0015a4\u00011\u0001.\u0003\r\t7m\u0019\u0005\u0006}\r\u0001\rAK\u0001\u0006m\u0006dW/Z\u0001\be\u0016$(/Y2u)\rA\u0014I\u0011\u0005\u0006y\u0011\u0001\r!\f\u0005\u0006}\u0011\u0001\rAK\u0001\tO\u0016$h+\u00197vKR\u0011q$\u0012\u0005\u0006y\u0015\u0001\r!L\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0004q!K\u0005\"\u0002\u001f\u0007\u0001\u0004i\u0003\"\u0002&\u0007\u0001\u0004Y\u0015aA5ugB\u0019A*U\u0017\u000e\u00035S!AT(\u0002\t1\fgn\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0003I9W\r^!dGVlW\u000f\\1u_J$\u0016\u0010]3\u0015\u0003U\u00032AV/.\u001b\u00059&B\u0001-Z\u0003!!\u0018\u0010]3j]\u001a|'B\u0001.\\\u0003\u0019\u0019w.\\7p]*\u0011A\fE\u0001\u0004CBL\u0017B\u00010X\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0017!\u0005:fgVdG\u000fV=qK\u000e{gN^3siR\u0011q$\u0019\u0005\u0006}!\u0001\rA\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K>\u000bA!\\1uQ&\u0011q\r\u001a\u0002\u000b\u0005&<\u0017J\u001c;fO\u0016\u0014\b")
public abstract class BigIntegralAvgAggFunction<T>
extends AggregateFunction<T, BigIntegralAvgAccumulator> {
    public BigIntegralAvgAccumulator createAccumulator() {
        return new BigIntegralAvgAccumulator();
    }

    public void accumulate(BigIntegralAvgAccumulator acc, Object value) {
        if (value != null) {
            long v = BoxesRunTime.unboxToLong((Object)value);
            acc.f0 = ((BigInteger)acc.f0).add(BigInteger.valueOf(v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
            return;
        }
    }

    public void retract(BigIntegralAvgAccumulator acc, Object value) {
        if (value != null) {
            long v = BoxesRunTime.unboxToLong((Object)value);
            acc.f0 = ((BigInteger)acc.f0).subtract(BigInteger.valueOf(v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
            return;
        }
    }

    public T getValue(BigIntegralAvgAccumulator acc) {
        if (BoxesRunTime.unboxToLong((Object)acc.f1) == 0L) {
            return null;
        }
        return this.resultTypeConvert(((BigInteger)acc.f0).divide(BigInteger.valueOf(BoxesRunTime.unboxToLong((Object)acc.f1))));
    }

    public void merge(BigIntegralAvgAccumulator acc, Iterable<BigIntegralAvgAccumulator> its) {
        for (BigIntegralAvgAccumulator a : its) {
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
            acc.f0 = ((BigInteger)acc.f0).add((BigInteger)a.f0);
        }
    }

    public TypeInformation<BigIntegralAvgAccumulator> getAccumulatorType() {
        return new TupleTypeInfo(BigIntegralAvgAccumulator.class, new TypeInformation[]{Types.INT(), Types.LONG()});
    }

    public abstract T resultTypeConvert(BigInteger var1);
}

