/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.planner.typeutils.SymbolUtil;
import org.apache.flink.table.utils.DateTimeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SymbolUtilTest {
    SymbolUtilTest() {
    }

    @Test
    void testCalciteToSerializable() {
        SymbolUtil.SerializableSymbol trimString = SymbolUtil.SerializableSymbol.of((String)"TRIM", (String)"LEADING");
        Assertions.assertThat((Object)SymbolUtil.calciteToSerializable((Enum)SqlTrimFunction.Flag.LEADING)).isEqualTo((Object)trimString);
        Assertions.assertThat((Comparable)((SqlTrimFunction.Flag)SymbolUtil.serializableToCalcite(SqlTrimFunction.Flag.class, (String)"LEADING"))).isEqualTo((Object)SqlTrimFunction.Flag.LEADING);
        SymbolUtil.SerializableSymbol emptyOrErrorString = SymbolUtil.SerializableSymbol.of((String)"JSON_QUERY_ON_EMPTY_OR_ERROR", (String)"EMPTY_OBJECT");
        Assertions.assertThat((Object)SymbolUtil.calciteToSerializable((Enum)SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT)).isEqualTo((Object)emptyOrErrorString);
        Assertions.assertThat((Object)SymbolUtil.serializableToCalcite((SymbolUtil.SerializableSymbol)emptyOrErrorString)).isEqualTo((Object)SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT);
    }

    @Test
    void testCommonToCalcite() {
        Assertions.assertThat((Object)SymbolUtil.commonToCalcite((Enum)TimeIntervalUnit.QUARTER)).isEqualTo((Object)TimeUnitRange.QUARTER);
        Assertions.assertThat((Object)SymbolUtil.calciteToCommon((Enum)TimeUnitRange.QUARTER, (boolean)false)).isEqualTo((Object)TimeIntervalUnit.QUARTER);
        Assertions.assertThat((Object)SymbolUtil.commonToCalcite((Enum)DateTimeUtils.TimeUnitRange.QUARTER)).isEqualTo((Object)TimeUnitRange.QUARTER);
        Assertions.assertThat((Object)SymbolUtil.calciteToCommon((Enum)TimeUnitRange.QUARTER, (boolean)true)).isEqualTo((Object)DateTimeUtils.TimeUnitRange.QUARTER);
    }
}

