/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.runtime.utils.JavaPojos;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.StringUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TestSinkUtil$ {
    public static TestSinkUtil$ MODULE$;

    static {
        new TestSinkUtil$();
    }

    public void addValuesSink(TableEnvironment tEnv, String tablePath, Table table, ChangelogMode changelogMode) {
        RelDataType rowType = TableTestUtil$.MODULE$.toRelNode(table).getRowType();
        List fieldNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala()).toList();
        List fieldTypes = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> FlinkTypeFactory$.MODULE$.toLogicalType(field.getType()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeConversions.fromLogicalToDataType((LogicalType)x$1), Buffer$.MODULE$.canBuildFrom())).toList();
        this.addValuesSink(tEnv, tablePath, (List<String>)fieldNames, (List<DataType>)fieldTypes, changelogMode, this.addValuesSink$default$6());
    }

    public void addValuesSink(TableEnvironment tEnv, String tablePath, List<String> fieldNames, List<DataType> fieldTypes, ChangelogMode changelogMode, List<String> pk) {
        Schema.Builder schemaBuilder = Schema.newBuilder();
        Object object = pk.nonEmpty() ? schemaBuilder.primaryKey((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(pk).asJava()) : BoxedUnit.UNIT;
        fieldNames.indices().foreach((Function1 & Serializable & scala.Serializable)i -> TestSinkUtil$.$anonfun$addValuesSink$3(fieldNames, pk, fieldTypes, schemaBuilder, BoxesRunTime.unboxToInt((Object)i)));
        TableDescriptor tableDesc = TableDescriptor.forConnector((String)"values").schema(schemaBuilder.build()).option("sink-insert-only", String.valueOf(changelogMode.equals((Object)ChangelogMode.insertOnly()))).option("sink-changelog-mode-enforced", ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(changelogMode.getContainedKinds()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RowKind rowKind = x0$1;
            if (RowKind.INSERT.equals(rowKind)) {
                return "I";
            }
            if (RowKind.UPDATE_BEFORE.equals(rowKind)) {
                return "UB";
            }
            if (RowKind.UPDATE_AFTER.equals(rowKind)) {
                return "UA";
            }
            if (RowKind.DELETE.equals(rowKind)) {
                return "D";
            }
            throw new MatchError((Object)rowKind);
        }, Set$.MODULE$.canBuildFrom())).mkString(",")).build();
        tEnv.createTable(tablePath, tableDesc);
    }

    public List<String> addValuesSink$default$6() {
        return Nil$.MODULE$;
    }

    public String fieldToString(Object field, TimeZone tz) {
        Object object = field;
        if (object instanceof Date ? true : (object instanceof Time ? true : object instanceof Timestamp)) {
            return this.unixDateTimeToString(field, tz);
        }
        return StringUtils.arrayAwareToString((Object)field);
    }

    public String rowToString(Row row, TimeZone tz) {
        scala.collection.mutable.StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.getArity()).foreach((Function1 & Serializable & scala.Serializable)i -> TestSinkUtil$.$anonfun$rowToString$1(sb, row, tz, BoxesRunTime.unboxToInt((Object)i)));
        return sb.toString();
    }

    public TimeZone rowToString$default$2() {
        return TimeZone.getTimeZone("UTC");
    }

    public String genericRowToString(GenericRowData row, TimeZone tz) {
        scala.collection.mutable.StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        sb.append(row.getRowKind().shortString()).append("(");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.getArity()).foreach((Function1 & Serializable & scala.Serializable)i -> TestSinkUtil$.$anonfun$genericRowToString$1(sb, row, tz, BoxesRunTime.unboxToInt((Object)i)));
        sb.append(")");
        return sb.toString();
    }

    public String pojoToString(JavaPojos.Pojo1 pojo, TimeZone tz) {
        return new StringBuilder(18).append("Pojo1{ts=").append(this.fieldToString(pojo.ts, tz)).append(", msg='").append(pojo.msg).append("'}").toString();
    }

    public String unixDateTimeToString(Object value, TimeZone tz) {
        int offset = tz.useDaylightTime() ? tz.getOffset(((java.util.Date)value).getTime()) : tz.getOffset(15L);
        Object object = value;
        if (!(object instanceof java.util.Date)) {
            throw new MatchError(object);
        }
        long origin = ((java.util.Date)value).getTime();
        long time = origin + (long)DateTimeUtils.UTC_ZONE.getOffset(origin);
        Object object2 = value;
        if (object2 instanceof Date) {
            return DateTimeUtils.unixDateToString((int)((int)(time / 86400000L) + offset));
        }
        if (object2 instanceof Time) {
            return DateTimeUtils.unixTimeToString((int)(((int)(time % 86400000L) + offset) % (int)86400000L));
        }
        if (object2 instanceof Timestamp) {
            return DateTimeUtils.unixTimestampToString((long)(time + (long)offset), (int)3);
        }
        return value.toString();
    }

    public static final /* synthetic */ Schema.Builder $anonfun$addValuesSink$3(List fieldNames$1, List pk$1, List fieldTypes$1, Schema.Builder schemaBuilder$1, int i) {
        String fieldName = (String)fieldNames$1.apply(i);
        DataType fieldType = pk$1.contains((Object)fieldName) ? (DataType)((AbstractDataType)fieldTypes$1.apply(i)).notNull() : (DataType)fieldTypes$1.apply(i);
        return schemaBuilder$1.column(fieldName, (AbstractDataType)fieldType);
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$rowToString$1(scala.collection.mutable.StringBuilder sb$1, Row row$1, TimeZone tz$1, int i) {
        Object object = i > 0 ? sb$1.append(",") : BoxedUnit.UNIT;
        return sb$1.append(MODULE$.fieldToString(row$1.getField(i), tz$1));
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$genericRowToString$1(scala.collection.mutable.StringBuilder sb$2, GenericRowData row$2, TimeZone tz$2, int i) {
        Object object = i > 0 ? sb$2.append(",") : BoxedUnit.UNIT;
        return sb$2.append(MODULE$.fieldToString(row$2.getField(i), tz$2));
    }

    private TestSinkUtil$() {
        MODULE$ = this;
    }
}

