/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.runtime.util.RowDataTestUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Sorting$;

public final class BatchTestBase$ {
    public static BatchTestBase$ MODULE$;

    static {
        new BatchTestBase$();
    }

    public Row row(Seq<Object> args) {
        Object[] values = (Object[])args.toArray(ClassTag$.MODULE$.Any());
        Row row = new Row(values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    public BinaryRowData binaryRow(LogicalType[] types, Seq<Object> fields) {
        Object object = fields.length() != types.length ? Assertions.fail((String)"Filed count inconsistent with type information") : BoxedUnit.UNIT;
        BinaryRowData row = new BinaryRowData(fields.length());
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        ((IterableLike)fields.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BatchTestBase$.$anonfun$binaryRow$1(writer, types, x0$1);
            return BoxedUnit.UNIT;
        });
        writer.complete();
        return row;
    }

    public <T> void compareResult(String[] expectedStrings, Object result, boolean sort, boolean asTuples) {
        ArrayBuffer resultStringsBuffer = new ArrayBuffer(ScalaRunTime$.MODULE$.array_length(result));
        Predef$.MODULE$.genericArrayOps(result).foreach((Function1 & Serializable & scala.Serializable)v -> {
            Object object = v;
            if (object instanceof Tuple) {
                Tuple tuple = (Tuple)object;
                if (asTuples) {
                    Object first = tuple.getField(0);
                    StringBuilder bld = new StringBuilder(first == null ? "null" : first.toString());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), tuple.getArity()).foreach((Function1 & Serializable & scala.Serializable)idx -> BatchTestBase$.$anonfun$compareResult$2(tuple, bld, resultStringsBuffer, BoxesRunTime.unboxToInt((Object)idx)));
                }
            }
            if (asTuples && !(v instanceof Tuple)) {
                throw new IllegalArgumentException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(v), " is no tuple"));
            }
            if (!asTuples) {
                return resultStringsBuffer.$plus$eq((Object)(v == null ? "null" : v.toString()));
            }
            return BoxedUnit.UNIT;
        });
        String[] resultStrings = (String[])resultStringsBuffer.toArray(ClassTag$.MODULE$.apply(String.class));
        if (sort) {
            Sorting$.MODULE$.quickSort((Object)expectedStrings, (Ordering)Ordering.String$.MODULE$);
            Sorting$.MODULE$.quickSort((Object)resultStrings, (Ordering)Ordering.String$.MODULE$);
        }
        String msg = new java.lang.StringBuilder(86).append("Different elements in arrays: expected ").append(expectedStrings.length).append(" elements ").append("and received ").append(resultStrings.length).append("\n ").append("expected: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedStrings)).mkString()).append("\n ").append("received: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resultStrings)).mkString()).toString();
        Object object = expectedStrings.length != resultStrings.length ? Assertions.fail((String)msg) : BoxedUnit.UNIT;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedStrings)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])resultStrings), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BatchTestBase$.$anonfun$compareResult$3(msg, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public <T> boolean compareResult$default$4() {
        return false;
    }

    public void configForMiniCluster(TableConfig tableConfig) {
        tableConfig.set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)3));
    }

    public void configBatchShuffleMode(TableConfig tableConfig, BatchShuffleMode shuffleMode) {
        tableConfig.set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)shuffleMode);
        BatchShuffleMode batchShuffleMode = shuffleMode;
        BatchShuffleMode batchShuffleMode2 = BatchShuffleMode.ALL_EXCHANGES_PIPELINED;
        if (!(batchShuffleMode != null ? !batchShuffleMode.equals(batchShuffleMode2) : batchShuffleMode2 != null)) {
            tableConfig.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Default);
            return;
        }
        tableConfig.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.AdaptiveBatch);
    }

    public void checkResult(String sqlQuery, Seq<Row> expectedResult, TableEnvironment tEnv, boolean isSorted) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> MODULE$.checkSame(expectedResult, (Seq<Row>)result, isSorted), tEnv);
    }

    public void check(String sqlQuery, Function1<Seq<Row>, Option<String>> checkFunc, TableEnvironment tEnv) {
        Table table = this.parseQuery(sqlQuery, tEnv);
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            String plan = MODULE$.explainLogical(table, tEnv);
            return (Nothing$)Assertions.fail((String)new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(138).append("\n                |Results do not match for query:\n                |  ").append(sqlQuery).append("\n                |").append((String)results).append("\n                |Plan:\n                |  ").append(plan).append("\n       ").toString())).stripMargin());
        });
    }

    public boolean checkResult$default$4() {
        return false;
    }

    public Table parseQuery(String sqlQuery, TableEnvironment tEnv) {
        return tEnv.sqlQuery(sqlQuery);
    }

    public Seq<Row> executeQuery(Table table) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(CollectionUtil.iteratorToList((Iterator)table.execute().collect())).asScala();
    }

    public Seq<Row> executeQuery(String sqlQuery, TableEnvironment tEnv) {
        Table table = this.parseQuery(sqlQuery, tEnv);
        return this.executeQuery(table);
    }

    public String explainLogical(Table table, TableEnvironment tEnv) {
        RelNode ast = TableTestUtil$.MODULE$.toRelNode(table);
        String logicalPlan = this.getPlan(ast, tEnv);
        return new java.lang.StringBuilder(54).append("== Abstract Syntax Tree ==").append(System.lineSeparator()).append(FlinkRelOptUtil$.MODULE$.toString(ast, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).append(System.lineSeparator()).append("== Optimized Logical Plan ==").append(System.lineSeparator()).append(logicalPlan).toString();
    }

    private String getPlan(RelNode relNode, TableEnvironment tEnv) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        RelNode optimized = planner.optimize(relNode);
        return FlinkRelOptUtil$.MODULE$.toString(optimized, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7());
    }

    public Option<String> checkSame(Seq<Row> expectedResult, Seq<Row> result, boolean isSorted) {
        if (expectedResult.size() != result.size() || !this.prepareResult(expectedResult, isSorted).equals(this.prepareResult(result, isSorted))) {
            String string = new java.lang.StringBuilder(23).append("== Correct Result - ").append(expectedResult.size()).append(" ==").toString();
            String string2 = new java.lang.StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(42).append("\n           |Results\n           |").append(this.org$apache$flink$table$planner$runtime$utils$BatchTestBase$$sideBySide((Seq<String>)((Seq)this.prepareResult(expectedResult, isSorted).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult(result, isSorted).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
            return new Some((Object)errorMessage);
        }
        return None$.MODULE$;
    }

    public boolean checkSame$default$3() {
        return false;
    }

    private Seq<String> prepareResult(Seq<Row> seq, boolean isSorted) {
        if (!isSorted) {
            return (Seq)((SeqLike)seq.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)s -> s, (Ordering)Ordering.String$.MODULE$);
        }
        return (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> org$apache$flink$table$planner$runtime$utils$BatchTestBase$$sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)left.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.length()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(right.size() - left.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        Seq rightPadded = (Seq)right.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(left.size() - right.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)leftPadded.zip((GenIterable)rightPadded, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String l = (String)tuple2._1();
                String r = (String)tuple2._2();
                String string = l;
                String string2 = r;
                return new java.lang.StringBuilder(0).append(!(string == null ? string2 != null : !string.equals(string2)) || l.startsWith("== Correct") ? " " : "!").append(l).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxLeftSize - l.length() + 3)).append(r).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$binaryRow$1(BinaryRowWriter writer$1, LogicalType[] types$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object field = tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (field == null) {
                writer$1.setNullAt(index);
                return;
            }
            RowDataTestUtil.write((BinaryWriter)writer$1, (int)index, (Object)field, (LogicalType)types$1[index]);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$compareResult$2(Tuple x2$1, StringBuilder bld$1, ArrayBuffer resultStringsBuffer$1, int idx) {
        Nothing$ next = (Nothing$)x2$1.getField(idx);
        StringBuilder stringBuilder = bld$1.append(',');
        throw next;
    }

    public static final /* synthetic */ void $anonfun$compareResult$3(String msg$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String e = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = e;
            String string2 = r;
            if (string == null ? string2 != null : !string.equals(string2)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)msg$1);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private BatchTestBase$() {
        MODULE$ = this;
    }
}

