/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ValuesITCase
extends StreamingTestBase {
    ValuesITCase() {
    }

    @Test
    void testTypeConversions() throws Exception {
        List<Row> data = Arrays.asList(Row.of((Object[])new Object[]{1, "ABC", Timestamp.valueOf("2000-12-12 12:30:57.12"), Row.of((Object[])new Object[]{1, new byte[]{1, 2}, "ABC", Arrays.asList(1, 2, 3)})}), Row.of((Object[])new Object[]{Math.PI, "ABC", LocalDateTime.parse("2000-12-12T12:30:57.123456"), Row.of((Object[])new Object[]{Math.PI, new byte[]{2, 3}, "ABC", Arrays.asList(1L, 2L, 3L)})}), Row.of((Object[])new Object[]{Float.valueOf(3.1f), "DEF", LocalDateTime.parse("2000-12-12T12:30:57.1234567"), Row.of((Object[])new Object[]{Float.valueOf(3.1f), new byte[]{3}, "DEF", Arrays.asList(1.0, 2.0, 3.0)})}), Row.of((Object[])new Object[]{99L, "DEFG", LocalDateTime.parse("2000-12-12T12:30:57.12345678"), Row.of((Object[])new Object[]{99L, new byte[]{3, 4}, "DEFG", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f))})}), Row.of((Object[])new Object[]{0.0, "D", LocalDateTime.parse("2000-12-12T12:30:57.123"), Row.of((Object[])new Object[]{0.0, new byte[]{4}, "D", Arrays.asList(1, 2, 3)})}));
        UnresolvedDataType rowType = DataTypes.ROW((DataTypes.AbstractField[])new DataTypes.AbstractField[]{DataTypes.FIELD((String)"a", (AbstractDataType)DataTypes.of((String)"DECIMAL(10, 2) NOT NULL")), DataTypes.FIELD((String)"b", (DataType)((DataType)DataTypes.CHAR((int)4).notNull())), DataTypes.FIELD((String)"c", (DataType)((DataType)DataTypes.TIMESTAMP((int)4).notNull())), DataTypes.FIELD((String)"row", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"b", (DataType)DataTypes.BINARY((int)2)), DataTypes.FIELD((String)"c", (DataType)((DataType)DataTypes.CHAR((int)5).notNull())), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)10, (int)2)))}))});
        Table t = this.tEnv().fromValues((AbstractDataType)rowType, data);
        TestCollectionTableFactory.reset();
        this.tEnv().executeSql("CREATE TABLE SinkTable(a DECIMAL(10, 2) NOT NULL, b CHAR(4) NOT NULL,c TIMESTAMP(4) NOT NULL,`row` ROW<a DECIMAL(10, 3) NOT NULL, b BINARY(2), c CHAR(5) NOT NULL, d ARRAY<DECIMAL(10, 2)>>) WITH ('connector' = 'COLLECTION')");
        t.executeInsert("SinkTable").await();
        List<Row> expected = Arrays.asList(Row.of((Object[])new Object[]{new BigDecimal("1.00"), "ABC ", LocalDateTime.parse("2000-12-12T12:30:57.120"), Row.of((Object[])new Object[]{new BigDecimal("1.000"), new byte[]{1, 2}, "ABC  ", new BigDecimal[]{new BigDecimal("1.00"), new BigDecimal("2.00"), new BigDecimal("3.00")}})}), Row.of((Object[])new Object[]{new BigDecimal("3.14"), "ABC ", LocalDateTime.parse("2000-12-12T12:30:57.123400"), Row.of((Object[])new Object[]{new BigDecimal("3.142"), new byte[]{2, 3}, "ABC  ", new BigDecimal[]{new BigDecimal("1.00"), new BigDecimal("2.00"), new BigDecimal("3.00")}})}), Row.of((Object[])new Object[]{new BigDecimal("3.10"), "DEF ", LocalDateTime.parse("2000-12-12T12:30:57.123400"), Row.of((Object[])new Object[]{new BigDecimal("3.100"), new byte[]{3, 0}, "DEF  ", new BigDecimal[]{new BigDecimal("1.00"), new BigDecimal("2.00"), new BigDecimal("3.00")}})}), Row.of((Object[])new Object[]{new BigDecimal("99.00"), "DEFG", LocalDateTime.parse("2000-12-12T12:30:57.123400"), Row.of((Object[])new Object[]{new BigDecimal("99.000"), new byte[]{3, 4}, "DEFG ", new BigDecimal[]{new BigDecimal("1.00"), new BigDecimal("2.00"), new BigDecimal("3.00")}})}), Row.of((Object[])new Object[]{new BigDecimal("0.00"), "D   ", LocalDateTime.parse("2000-12-12T12:30:57.123"), Row.of((Object[])new Object[]{new BigDecimal("0.000"), new byte[]{4, 0}, "D    ", new BigDecimal[]{new BigDecimal("1.00"), new BigDecimal("2.00"), new BigDecimal("3.00")}})}));
        List<Row> actual = TestCollectionTableFactory.getResult();
        Assertions.assertThat(actual).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    void testAllTypes() throws Exception {
        List<Row> data = Arrays.asList(ValuesITCase.rowWithNestedRow((byte)1, (short)1, 1, 1L, 1.1f, 1.1, new BigDecimal("1.1"), true, LocalTime.of(1, 1, 1), LocalDate.of(1, 1, 1), LocalDateTime.of(1, 1, 1, 1, 1, 1, 1), Instant.ofEpochMilli(1L), "1", new byte[]{1}, new BigDecimal[]{new BigDecimal("1.1")}, ValuesITCase.createMap("1", new BigDecimal("1.1"))), ValuesITCase.rowWithNestedRow((byte)2, (short)2, 2, 2L, 2.2f, 2.2, new BigDecimal("2.2"), false, LocalTime.of(2, 2, 2), LocalDate.of(2, 2, 2), LocalDateTime.of(2, 2, 2, 2, 2, 2, 2), Instant.ofEpochMilli(2L), "2", new byte[]{2}, new BigDecimal[]{new BigDecimal("2.2")}, ValuesITCase.createMap("2", new BigDecimal("2.2"))));
        Table t = this.tEnv().fromValues(data);
        TestCollectionTableFactory.reset();
        this.tEnv().executeSql("CREATE TABLE SinkTable(f0 TINYINT, f1 SMALLINT, f2 INT, f3 BIGINT, f4 FLOAT, f5 DOUBLE, f6 DECIMAL(2, 1), f7 BOOLEAN, f8 TIME(0), f9 DATE, f12 TIMESTAMP(9), f13 TIMESTAMP(3) WITH LOCAL TIME ZONE, f14 CHAR(1), f15 BINARY(1), f16 ARRAY<DECIMAL(2, 1)>, f17 MAP<CHAR(1), DECIMAL(2, 1)>, f18 ROW<   `f0` TINYINT,    `f1` SMALLINT,    `f2` INT,    `f3` BIGINT,    `f4` FLOAT,    `f5` DOUBLE,    `f6` DECIMAL(2, 1),    `f7` BOOLEAN,    `f8` TIME(0),    `f9` DATE,    `f12` TIMESTAMP(9),    `f13` TIMESTAMP(3) WITH LOCAL TIME ZONE,    `f14` CHAR(1),    `f15` BINARY(1),    `f16` ARRAY<DECIMAL(2, 1)>,    `f17` MAP<CHAR(1), DECIMAL(2, 1)>>) WITH ('connector' = 'COLLECTION')");
        t.executeInsert("SinkTable").await();
        List<Row> actual = TestCollectionTableFactory.getResult();
        Assertions.assertThat(actual).containsExactlyInAnyOrderElementsOf(data);
    }

    @Test
    void testProjectionWithValues() throws Exception {
        List<Row> data = Arrays.asList(Row.of((Object[])new Object[]{(byte)1, (short)1, 1, 1L, Float.valueOf(1.1f), 1.1, new BigDecimal("1.1"), true, LocalTime.of(1, 1, 1), LocalDate.of(1, 1, 1), LocalDateTime.of(1, 1, 1, 1, 1, 1, 1), Instant.ofEpochMilli(1L), "1", new byte[]{1}, new BigDecimal[]{new BigDecimal("1.1")}, ValuesITCase.createMap("1", new BigDecimal("1.1"))}), Row.of((Object[])new Object[]{(byte)2, (short)2, 2, 2L, Float.valueOf(2.2f), 2.2, new BigDecimal("2.2"), false, LocalTime.of(2, 2, 2), LocalDate.of(2, 2, 2), LocalDateTime.of(2, 2, 2, 2, 2, 2, 2), Instant.ofEpochMilli(2L), "2", new byte[]{2}, new BigDecimal[]{new BigDecimal("2.2")}, ValuesITCase.createMap("2", new BigDecimal("2.2"))}));
        this.tEnv().createTemporaryFunction("func", (UserDefinedFunction)new CustomScalarFunction());
        Table t = this.tEnv().fromValues(data).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{Expressions.withColumns((Object)Expressions.range((String)"f0", (String)"f15"), (Object[])new Object[0])})});
        TestCollectionTableFactory.reset();
        this.tEnv().executeSql("CREATE TABLE SinkTable(str STRING) WITH ('connector' = 'COLLECTION')");
        t.executeInsert("SinkTable").await();
        List<Row> actual = TestCollectionTableFactory.getResult();
        List<Row> expected = Arrays.asList(Row.of((Object[])new Object[]{"1,1,1,1,1.1,1.1,1.1,true,01:01:01,0001-01-01,0001-01-01T01:01:01.000000001,1970-01-01T00:00:00.001Z,1,[1],[1.1],{1=1.1}"}), Row.of((Object[])new Object[]{"2,2,2,2,2.2,2.2,2.2,false,02:02:02,0002-02-02,0002-02-02T02:02:02.000000002,1970-01-01T00:00:00.002Z,2,[2],[2.2],{2=2.2}"}));
        Assertions.assertThat(actual).containsExactlyInAnyOrderElementsOf(expected);
    }

    @ParameterizedTest(name="{index}: isTemporaryView ({0})")
    @ValueSource(booleans={true, false})
    void testRegisteringValuesWithComplexTypes(boolean isTemporaryView) {
        HashMap<Integer, Integer> mapData = new HashMap<Integer, Integer>();
        mapData.put(1, 1);
        mapData.put(2, 2);
        Row row = Row.of((Object[])new Object[]{mapData, Row.of((Object[])new Object[]{1, 2, 3}), new Integer[]{1, 2}});
        Table values = this.tEnv().fromValues(Collections.singletonList(row));
        String path = "values_t";
        if (isTemporaryView) {
            this.tEnv().createTemporaryView("values_t", values);
        } else {
            this.tEnv().createView("values_t", values);
        }
        List results = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("select * from values_t").collect());
        Assertions.assertThat((List)results).containsExactly((Object[])new Row[]{row});
    }

    private static Map<String, BigDecimal> createMap(String key, BigDecimal value) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put(key, value);
        return map;
    }

    private static Row rowWithNestedRow(byte tinyint, short smallInt, int integer, long bigint, float floating, double doublePrecision, BigDecimal decimal, boolean bool, LocalTime time, LocalDate date, LocalDateTime timestamp, Instant localZonedTimestamp, String character, byte[] binary, BigDecimal[] array, Map<String, BigDecimal> map) {
        return Row.of((Object[])new Object[]{tinyint, smallInt, integer, bigint, Float.valueOf(floating), doublePrecision, decimal, bool, time, date, timestamp, localZonedTimestamp, character, binary, array, map, Row.of((Object[])new Object[]{tinyint, smallInt, integer, bigint, Float.valueOf(floating), doublePrecision, decimal, bool, time, date, timestamp, localZonedTimestamp, character, binary, array, map})});
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"), input={@DataTypeHint(value="TINYINT"), @DataTypeHint(value="SMALLINT"), @DataTypeHint(value="INT"), @DataTypeHint(value="BIGINT"), @DataTypeHint(value="FLOAT"), @DataTypeHint(value="DOUBLE"), @DataTypeHint(value="DECIMAL(2, 1)"), @DataTypeHint(value="BOOLEAN"), @DataTypeHint(value="TIME(0)"), @DataTypeHint(value="DATE"), @DataTypeHint(value="TIMESTAMP(9)"), @DataTypeHint(value="TIMESTAMP(3) WITH LOCAL TIME ZONE"), @DataTypeHint(value="CHAR(1)"), @DataTypeHint(value="BINARY(1)"), @DataTypeHint(value="ARRAY<DECIMAL(2, 1)>"), @DataTypeHint(value="MAP<CHAR(1), DECIMAL(2, 1)>")})
    public static class CustomScalarFunction
    extends ScalarFunction {
        public String eval(Byte tinyint, Short smallInt, Integer integer, Long bigint, Float floating, Double doublePrecision, BigDecimal decimal, Boolean bool, LocalTime time, LocalDate date, LocalDateTime timestamp, Instant localZonedTimestamp, String character, byte[] binary, BigDecimal[] array, Map<String, BigDecimal> map) {
            return Stream.of(tinyint, smallInt, integer, bigint, floating, doublePrecision, decimal, bool, time, date, timestamp, localZonedTimestamp, character, Arrays.toString(binary), Arrays.toString(array), map).map(Object::toString).collect(Collectors.joining(","));
        }
    }
}

