/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableAggFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.TableAggSum;
import org.apache.flink.table.planner.utils.Top3;
import org.apache.flink.table.planner.utils.Top3Accum;
import org.apache.flink.table.planner.utils.Top3WithMapView;
import org.apache.flink.table.planner.utils.Top3WithMapViewAccum;
import org.apache.flink.table.planner.utils.Top3WithRetractInput;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\b\u0011\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006\u000b\u0002!\tE\u0012\u0005\u00061\u0002!\tA\u0012\u0005\u0006;\u0002!\tA\u0012\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006m\u0002!\tA\u0012\u0005\u0006q\u0002!\tA\u0012\u0005\u0006u\u0002!\tA\u0012\u0005\u0006y\u0002!\tA\u0012\u0005\u0006}\u0002!\tA\u0012\u0005\u0007\u0003\u0003\u0001A\u0011\u0001$\t\r\u0005\u0015\u0001\u0001\"\u0001G\u0011\u0019\tI\u0001\u0001C\u0001\r\n!B+\u00192mK\u0006;wM]3hCR,\u0017\nV\"bg\u0016T!!\u0005\n\u0002\u000bQ\f'\r\\3\u000b\u0005M!\u0012AB:ue\u0016\fWN\u0003\u0002\u0016-\u00059!/\u001e8uS6,'BA\f\u0019\u0003\u001d\u0001H.\u00198oKJT!!E\r\u000b\u0005iY\u0012!\u00024mS:\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\u0011A\u0005F\u0001\u0006kRLGn]\u0005\u0003M\r\u0012!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016\fA!\\8eKB\u0011\u0011&\u0010\b\u0003Umr!a\u000b\u001e\u000f\u00051JdBA\u00179\u001d\tqsG\u0004\u00020m9\u0011\u0001'\u000e\b\u0003cQj\u0011A\r\u0006\u0003g}\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\t\t\u0012$\u0003\u0002\u00181%\u0011QCF\u0005\u0003IQI!\u0001P\u0012\u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\n\u0005yz$\u0001E*uCR,')Y2lK:$Wj\u001c3f\u0015\ta4%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0005\u0012\u0003\"a\u0011\u0001\u000e\u0003AAQa\n\u0002A\u0002!\naAY3g_J,G#A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00079\u0003\"a\u0014,\u000e\u0003AS!!\u0015*\u0002\u0007\u0005\u0004\u0018N\u0003\u0002T)\u00069!.\u001e9ji\u0016\u0014(BA+\u001e\u0003\u0015QWO\\5u\u0013\t9\u0006K\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011\u0006^3ti\u001ac\u0017\r^!hOJ,w-\u0019;f/&$\bn\\;u\u0013:\u001c'/Z7f]R\fG.\u00169eCR,\u0007F\u0001\u0003[!\ty5,\u0003\u0002]!\naA+Z:u)\u0016l\u0007\u000f\\1uK\u00061C/Z:u\r2\fG/Q4he\u0016<\u0017\r^3XSRD\u0017J\\2sK6,g\u000e^1m+B$\u0017\r^3)\u0005\u0015Q\u0016!C2iK\u000e\\'+\u00198l)\r9\u0015m\u001b\u0005\u0006E\u001a\u0001\raY\u0001\u0005MVt7\r\u0005\u0002eQ:\u0011QM\u001a\t\u0003c%K!aZ%\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003O&CQ\u0001\u001c\u0004A\u00025\fa\"\u001a=qK\u000e$X\r\u001a*fgVdG\u000fE\u0002og\u000et!a\\9\u000f\u0005E\u0002\u0018\"\u0001&\n\u0005IL\u0015a\u00029bG.\fw-Z\u0005\u0003iV\u0014A\u0001T5ti*\u0011!/S\u0001\u0019i\u0016\u001cHo\u0012:pkB\u0014\u0015P\u00127bi\u0006;wM]3hCR,\u0007FA\u0004[\u0003e!Xm\u001d;O_:\\W-_3e\r2\fG/Q4he\u0016<\u0017\r^3)\u0005!Q\u0016\u0001\t;fgR\fum\u001a:fO\u0006$X-\u00114uKJ$\u0016M\u00197f\u0003\u001e<'/Z4bi\u0016D#!\u0003.\u0002GQ,7\u000f^$s_V\u0004()\u001f$mCR\fum\u001a:fO\u0006$XmV5uQ6\u000b\u0007OV5fo\"\u0012!BW\u0001\u0018i\u0016\u001cH/\u00138qkR<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;j_:D#a\u0003.\u00027Q,7\u000f^%oi\u0016\u0014h.\u00197BG\u000e,X.\u001e7bi>\u0014H+\u001f9fQ\ta!,A\u0016uKN$H+\u00192mK\u0006;wMR;oGRLwN\\,ji\"|W\u000f\u001e*fiJ\f7\r^5p]6+G\u000f[8eQ\ti!,A\ruKN$xJ^3sY>\fG-\u001a3BG\u000e,X.\u001e7bi>\u0014\bF\u0001\b[Q\u001d\u0001\u0011qBA\u000e\u0003;\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+\u0001\u0016!C3yi\u0016t7/[8o\u0013\u0011\tI\"a\u0005\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\r\f\u0002\u0002 \r\u0012\u0011\u0011\u0005\t\u0005\u0003G\t\u0019$\u0004\u0002\u0002&)!\u0011qEA\u0015\u00035\u0001\u0018M]1nKR,'/\u001b>fI*!\u00111FA\u0017\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0004+\u0006=\"bAA\u00193\u0005IA/Z:ukRLGn]\u0005\u0005\u0003k\t)C\u0001\u000eQCJ\fW.\u001a;fe&TX\r\u001a+fgR,\u0005\u0010^3og&|g\u000e")
public class TableAggregateITCase
extends StreamingWithStateTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.tEnv().getConfig().setIdleStateRetention(Duration.ofHours(1L));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(337).append("\n                       |CREATE TABLE myTable (\n                       |  `id` INT,\n                       |  `name` STRING,\n                       |  `price` INT\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(TestValuesTableFactory.registerData(TestData$.MODULE$.tupleData4())).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testFlatAggregateWithoutIncrementalUpdate() {
        this.tEnv().createTemporarySystemFunction("top2", (UserDefinedFunction)new JavaUserDefinedTableAggFunctions.Top2());
        this.checkRank("top2", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,6,1)", "(false,6,1)", "(true,6,1)", "(true,3,2)", "(false,6,1)", "(false,3,2)", "(true,6,1)", "(true,5,2)", "(false,6,1)", "(false,5,2)", "(true,8,1)", "(true,6,2)", "(false,8,1)", "(false,6,2)", "(true,8,1)", "(true,6,2)"})));
    }

    @TestTemplate
    public void testFlatAggregateWithIncrementalUpdate() {
        this.tEnv().createTemporarySystemFunction("incrementalTop2", (UserDefinedFunction)new JavaUserDefinedTableAggFunctions.IncrementalTop2());
        this.checkRank("incrementalTop2", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(true,6,1)", "(true,3,2)", "(false,3,2)", "(true,5,2)", "(false,6,1)", "(true,8,1)", "(false,5,2)", "(true,6,2)"})));
    }

    public void checkRank(String func, List<String> expectedResult) {
        Table resultTable = this.tEnv().from("myTable").flatAggregate((Expression)package$.MODULE$.WithOperations(package$.MODULE$.call(func, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.$("price")}))).as("top_price", new String[]{"rank"})).select(new Expression[]{package$.MODULE$.$("top_price"), package$.MODULE$.$("rank")});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Assertions.assertThat(sink.getRawResults()).isEqualTo(expectedResult);
    }

    @TestTemplate
    public void testGroupByFlatAggregate() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3Accum> clazz;
        Top3 top3 = new Top3();
        GroupedTable groupedTable = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(Map.class)), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(125).append("The field ").append(field).append(" is already contained in the ").append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").append("your class hierarchy").toString());
                    error$1.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                scala.Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String fName = (String)tuple2._1();
                    TypeInformation fTpe = (TypeInformation)tuple2._2();
                    Field field = (Field)clazzFields.apply((Object)fName);
                    if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = groupedTable.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("category", new String[]{"v1", "v2"});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1", "2,2,2", "2,3,3", "3,4,4", "3,5,5", "3,6,6", "4,10,10", "4,9,9", "4,8,8", "5,15,15", "5,14,14", "5,13,13", "6,21,21", "6,20,20", "6,19,19"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testNonkeyedFlatAggregate() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3Accum> clazz;
        Top3 top3 = new Top3();
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(Map.class)), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(125).append("The field ").append(field).append(" is already contained in the ").append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").append("your class hierarchy").toString());
                    error$2.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                scala.Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String fName = (String)tuple2._1();
                    TypeInformation fTpe = (TypeInformation)tuple2._2();
                    Field field = (Field)clazzFields.apply((Object)fName);
                    if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = source.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("v1", new String[]{"v2"});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)new .colon.colon((Object)"19,19", (List)new .colon.colon((Object)"20,20", (List)new .colon.colon((Object)"21,21", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testAggregateAfterTableAggregate() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3Accum> clazz;
        Top3 top3 = new Top3();
        GroupedTable groupedTable = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(Map.class)), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(125).append("The field ").append(field).append(" is already contained in the ").append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").append("your class hierarchy").toString());
                    error$3.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                scala.Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String fName = (String)tuple2._1();
                    TypeInformation fTpe = (TypeInformation)tuple2._2();
                    Field field = (Field)clazzFields.apply((Object)fName);
                    if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = groupedTable.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("category", new String[]{"v1", "v2"}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "category"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "category")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v1")).max()});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)new .colon.colon((Object)"1,1", (List)new .colon.colon((Object)"2,3", (List)new .colon.colon((Object)"3,6", (List)new .colon.colon((Object)"4,10", (List)new .colon.colon((Object)"5,15", (List)new .colon.colon((Object)"6,21", (List)Nil$.MODULE$)))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testGroupByFlatAggregateWithMapView() {
        GenericTypeInfo genericTypeInfo;
        Class<Top3WithMapViewAccum> clazz;
        Top3WithMapView top3 = new Top3WithMapView();
        GroupedTable groupedTable = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(MapView.class)), (List)Nil$.MODULE$)));
        scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = Top3WithMapViewAccum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(125).append("The field ").append(field).append(" is already contained in the ").append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").append("your class hierarchy").toString());
                    error$4.elem = true;
                }
                return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                scala.Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String fName = (String)tuple2._1();
                    TypeInformation fTpe = (TypeInformation)tuple2._2();
                    Field field = (Field)clazzFields.apply((Object)fName);
                    if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                }
                throw new MatchError((Object)tuple2);
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        Table resultTable = groupedTable.flatAggregate(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).as("category", new String[]{"v1", "v2"});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1", "2,2,2", "2,3,3", "3,4,4", "3,5,5", "3,6,6", "4,10,10", "4,9,9", "4,8,8", "5,15,15", "5,14,14", "5,13,13", "6,21,21", "6,20,20", "6,19,19"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testInputWithRetraction() {
        Top3WithRetractInput top3 = new Top3WithRetractInput();
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table resultTable = source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call((UserDefinedFunction)top3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "v1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "v2")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v2"))});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)new .colon.colon((Object)"111,111", (List)new .colon.colon((Object)"65,65", (List)new .colon.colon((Object)"34,34", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testInternalAccumulatorType() {
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$11 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table resultTable = source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call(TableAggSum.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "sum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "sum"))});
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(resultTable).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        List expected = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"6,111", "6,111", "5,65", "5,65", "4,34", "4,34", "3,15", "3,15", "2,5", "2,5", "1,1", "1,1"})).sorted((Ordering)Ordering.String$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testTableAggFunctionWithoutRetractionMethod() {
        Top3 top3 = new Top3();
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$13 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> {
            GenericTypeInfo genericTypeInfo;
            Class<Top3Accum> clazz;
            Table table = source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))});
            .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$));
            Class<Tuple2> clazz2 = Tuple2.class;
            TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(clazz2, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
            .colon.colon fields2 = new .colon.colon((Object)new scala.Tuple2((Object)"smallest", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"size", (Object)BasicTypeInfo.getInfoFor(Integer.class)), (List)new .colon.colon((Object)new scala.Tuple2((Object)"data", (Object)TypeExtractor.createTypeInfo(Map.class)), (List)Nil$.MODULE$)));
            scala.collection.mutable.Map clazzFields = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            BooleanRef error = BooleanRef.create((boolean)false);
            for (Class traversalClazz = clazz = Top3Accum.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                    block0: {
                        if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                        Predef$.MODULE$.println((Object)new StringBuilder(125).append("The field ").append(field).append(" is already contained in the ").append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").append("your class hierarchy").toString());
                        error$5.elem = true;
                    }
                    return (scala.collection.mutable.Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
                });
            }
            if (error.elem) {
                genericTypeInfo = new GenericTypeInfo(clazz);
            } else {
                List pojoFields = (List)fields2.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    scala.Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String fName = (String)tuple2._1();
                        TypeInformation fTpe = (TypeInformation)tuple2._2();
                        Field field = (Field)clazzFields.apply((Object)fName);
                        if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), fTpe)));
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
                genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
            }
            org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(table.flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top3, (TypeInformation)tupleTypeInfo, (TypeInformation)genericTypeInfo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "v1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "v2")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v2"))})).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
            this.env().execute();
        }).hasMessage(new StringBuilder(153).append("Could not find an implementation method 'retract' in class '").append(Top3.class.getName()).append("' ").append("for function 'Top3' that matches the following signature:\n").append("void retract(").append(Top3Accum.class.getName()).append(", java.lang.Integer)").toString()) instanceof ValidationException;
    }

    @TestTemplate
    public void testOverloadedAccumulator() {
        Table source = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.table.TableAggregateITCase$$anon$15 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        TestingRetractSink sink1 = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(source.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call(JavaUserDefinedAggFunctions.OverloadedDoubleMaxFunction.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "max"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "max"))})).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink1).setParallelism(1);
        TestingRetractSink sink2 = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(source.select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.STRING())).$plus(package$.MODULE$.string2Literal("str"))).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).flatAggregate(package$.MODULE$.WithOperations(package$.MODULE$.call(JavaUserDefinedAggFunctions.OverloadedDoubleMaxFunction.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "max"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "max"))})).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink2).setParallelism(1);
        this.env().execute();
        List expected1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1", "1,1", "2,3", "2,3", "3,6", "3,6", "4,10", "4,10", "5,15", "5,15", "6,21", "6,21"}));
        Assertions.assertThat((Object)sink1.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected1.sorted((Ordering)Ordering.String$.MODULE$));
        List expected2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1str", "1,1str", "2,3str", "2,3str", "3,6str", "3,6str", "4,9str", "4,9str", "5,15str", "5,15str", "6,21str", "6,21str"}));
        Assertions.assertThat((Object)sink2.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected2.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TableAggregateITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

