/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.expressions.utils.Func18$;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.table.planner.utils.PojoTableFunc;
import org.apache.flink.table.planner.utils.RF;
import org.apache.flink.table.planner.utils.RichTableFunc1;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.planner.utils.TableFunc3;
import org.apache.flink.table.planner.utils.TableFunc6;
import org.apache.flink.table.planner.utils.TableFunc7;
import org.apache.flink.table.planner.utils.VarArgsFunc0;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\n\u0015\u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019A\u0006\u0001)A\u0005\u0017\")a\r\u0001C\u0001O\")1\u000f\u0001C\u0001O\")Q\u000f\u0001C\u0001O\")q\u000f\u0001C\u0001O\")\u0011\u0010\u0001C\u0001O\")1\u0010\u0001C\u0001O\")Q\u0010\u0001C\u0001O\")q\u0010\u0001C\u0001O\"1\u00111\u0001\u0001\u0005\u0002\u001dDa!a\u0002\u0001\t\u00039\u0007BBA\u0006\u0001\u0011\u0005q\r\u0003\u0004\u0002\u0010\u0001!\ta\u001a\u0005\u0007\u0003'\u0001A\u0011A4\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\ty1i\u001c:sK2\fG/Z%U\u0007\u0006\u001cXM\u0003\u0002\u0016-\u0005)A/\u00192mK*\u0011q\u0003G\u0001\u0007gR\u0014X-Y7\u000b\u0005eQ\u0012a\u0002:v]RLW.\u001a\u0006\u00037q\tq\u0001\u001d7b]:,'O\u0003\u0002\u0016;)\u0011adH\u0001\u0006M2Lgn\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0019\u0003\u0015)H/\u001b7t\u0013\tQsE\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX-\u0001\u0003n_\u0012,\u0007CA\u0017B\u001d\tqsH\u0004\u00020}9\u0011\u0001'\u0010\b\u0003cqr!AM\u001e\u000f\u0005MRdB\u0001\u001b:\u001d\t)\u0004(D\u00017\u0015\t94%\u0001\u0004=e>|GOP\u0005\u0002E%\u0011\u0001%I\u0005\u0003=}I!!F\u000f\n\u0005ma\u0012BA\r\u001b\u0013\tA\u0003$\u0003\u0002AO\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK&\u0011!i\u0011\u0002\u0011'R\fG/\u001a\"bG.,g\u000eZ'pI\u0016T!\u0001Q\u0014\u0002\rqJg.\u001b;?)\t1\u0005\n\u0005\u0002H\u00015\tA\u0003C\u0003,\u0005\u0001\u0007A&A\u0001`+\u0005Y\u0005c\u0001'R'6\tQJ\u0003\u0002O\u001f\u0006IA/Z:ukRLGn\u001d\u0006\u0003!v\tAaY8sK&\u0011!+\u0014\u0002\u0014\u000b\u0006\u001c\u0007nQ1mY\n\f7m[,sCB\u0004XM\u001d\t\u0003)Zk\u0011!\u0016\u0006\u0003QqI!aV+\u0003%1+w-Y2z%><X\t\u001f;f]NLwN\\\u0001\u0003?\u0002B#\u0001\u0002.\u0011\u0005m#W\"\u0001/\u000b\u0005us\u0016!C3yi\u0016t7/[8o\u0015\ty\u0006-A\u0002ba&T!!\u00192\u0002\u000f),\b/\u001b;fe*\u00111-I\u0001\u0006UVt\u0017\u000e^\u0005\u0003Kr\u0013\u0011CU3hSN$XM]#yi\u0016t7/[8o\u00035!Xm\u001d;De>\u001c8OS8j]R\t\u0001\u000e\u0005\u0002jY6\t!NC\u0001l\u0003\u0015\u00198-\u00197b\u0013\ti'N\u0001\u0003V]&$\bFA\u0003p!\t\u0001\u0018/D\u0001_\u0013\t\u0011hL\u0001\u0007UKN$H+Z7qY\u0006$X-\u0001\u0012uKN$H*\u001a4u\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5pkR\u0004&/\u001a3jG\u0006$Xm\u001d\u0015\u0003\r=\fq\u0004^3ti2+g\r^(vi\u0016\u0014(j\\5o/&$\b\u000e\u0015:fI&\u001c\u0017\r^3tQ\t9q.\u0001\u0018uKN$Xk]3s\t\u00164\u0017N\\3e)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8XSRD7kY1mCJ4UO\\2uS>t\u0007F\u0001\u0005p\u0003%\"Xm\u001d;Vg\u0016\u0014H)\u001a4j]\u0016$G+\u00192mK\u001a+hn\u0019;j_:<\u0016\u000e\u001e5QCJ\fW.\u001a;fe\"\u0012\u0011b\\\u0001:i\u0016\u001cH/V:fe\u0012+g-\u001b8fIR\u000b'\r\\3Gk:\u001cG/[8o/&$\b.V:fe\u0012+g-\u001b8fIN\u001b\u0017\r\\1s\rVt7\r^5p]\"\u0012!b\\\u0001'i\u0016\u001cH\u000fV1cY\u00164UO\\2uS>t7i\u001c8tiJ,8\r^8s/&$\b\u000eU1sC6\u001c\bFA\u0006p\u0003\u0019\"Xm\u001d;UC\ndWMR;oGRLwN\\,ji\"4\u0016M]5bE2,\u0017I]4v[\u0016tGo\u001d\u0015\u0003\u0019=\f1\u0002^3tiJ{w\u000fV=qK\"\u0012Qb\\\u0001$i\u0016\u001cH\u000fV1cY\u00164UO\\2uS>t7i\u001c7mK\u000e$xN](qK:\u001cEn\\:fQ\tqq.\u0001\u0010uKN$H+\u00192mK\u001a+hn\u0019;j_:\u001cu\u000e\u001c7fGR|'/\u00138ji\"\u0012qb\\\u0001\fi\u0016\u001cHO\u00127bi6\u000b\u0007\u000f\u000b\u0002\u0011_\u0006\tB/Z:u\u001bVdG/\u001b9mK\u00163\u0018\r\\:)\u0005Ey\u0017\u0001\u0003;fgR$\u0015\r^1\u0015\t\u0005m\u0011q\n\t\u0007\u0003;\tI#!\f\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!\u0002Z1uCN$(/Z1n\u0015\ry\u0016Q\u0005\u0006\u0004\u0003Oi\u0012!C:ue\u0016\fW.\u001b8h\u0013\u0011\tY#a\b\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000eE\u0005j\u0003_\t\u0019$!\u000f\u0002@%\u0019\u0011\u0011\u00076\u0003\rQ+\b\u000f\\34!\rI\u0017QG\u0005\u0004\u0003oQ'aA%oiB\u0019\u0011.a\u000f\n\u0007\u0005u\"N\u0001\u0003M_:<\u0007\u0003BA!\u0003\u0013rA!a\u0011\u0002FA\u0011QG[\u0005\u0004\u0003\u000fR\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002L\u00055#AB*ue&twMC\u0002\u0002H)Dq!!\u0015\u0013\u0001\u0004\t\u0019&A\u0002f]Z\u0004B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0005\u00033\n\u0019#A\u0006f]ZL'o\u001c8nK:$\u0018\u0002BA/\u0003/\u0012!d\u0015;sK\u0006lW\t_3dkRLwN\\#om&\u0014xN\\7f]RDs\u0001AA1\u0003O\nI\u0007E\u0002\\\u0003GJ1!!\u001a]\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003W\u001a#!!\u001c\u0011\t\u0005=\u0014QP\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005i\u0001/\u0019:b[\u0016$XM]5{K\u0012TA!a\u001e\u0002z\u0005QQ\r\u001f;f]NLwN\\:\u000b\u0007\r\fYH\u0003\u0002O;%!\u0011qPA9\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0001")
public class CorrelateITCase
extends StreamingWithStateTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @TestTemplate
    public void testCrossJoin() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        PojoTableFunc pojoFunc0 = new PojoTableFunc();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)pojoFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))})).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack#22,Jack,22", "Anna#44,Anna,44"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftOuterJoinWithoutPredicates() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = t.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))});
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result, (AbstractDataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.INT()})).addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nosharp,null,null", "Jack#22,Jack,22", "John#19,John,19", "Anna#44,Anna,44"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftOuterJoinWithPredicates() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> {
            DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))})).toDataStream();
            TestingAppendSink sink = new TestingAppendSink();
            result.addSink((SinkFunction)sink);
            this.env().execute();
            String expected = "John#19,null,null\nJohn#22,null,null\nAnna44,null,null\nnosharp,null,null";
            Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(new StringOps(Predef$.MODULE$.augmentString(expected)).sorted((Ordering)Ordering.Char$.MODULE$));
        });
    }

    @TestTemplate
    public void testUserDefinedTableFunctionWithScalarFunction() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func18$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.string2Literal("J")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack#22,Jack,22", "John#19,John,19"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testUserDefinedTableFunctionWithParameter() {
        RichTableFunc1 tableFunc1 = new RichTableFunc1();
        this.tEnv().createTemporarySystemFunction("RichTableFunc1", (UserDefinedFunction)tableFunc1);
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)" ")}))));
        Table result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Hello", "3,world"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testUserDefinedTableFunctionWithUserDefinedScalarFunction() {
        RichTableFunc1 tableFunc1 = new RichTableFunc1();
        RichFunc2 richFunc2 = new RichFunc2();
        this.tEnv().createTemporarySystemFunction("RichTableFunc1", (UserDefinedFunction)tableFunc1);
        this.tEnv().createTemporarySystemFunction("RichFunc2", (UserDefinedFunction)richFunc2);
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)"#"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"test")}))));
        Table result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.ScalarFunctionCall((ScalarFunction)richFunc2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Hi", "1,test", "2,Hello", "2,test", "3,Hello world", "3,test"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testTableFunctionConstructorWithParams() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        Map config = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"value1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"value2")}));
        TableFunc3 func30 = new TableFunc3(null);
        TableFunc3 func31 = new TableFunc3("OneConf_");
        TableFunc3 func32 = new TableFunc3("TwoConf_", (Map<String, String>)config);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func30).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func31).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "f"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "g")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func32).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "h"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "i")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))})).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anna#44,Anna,OneConf_Anna,TwoConf__key=key1_value=value1_Anna,44,44,44", "Anna#44,Anna,OneConf_Anna,TwoConf__key=key2_value=value2_Anna,44,44,44", "Jack#22,Jack,OneConf_Jack,TwoConf__key=key1_value=value1_Jack,22,22,22", "Jack#22,Jack,OneConf_Jack,TwoConf__key=key2_value=value2_Jack,22,22,22", "John#19,John,OneConf_John,TwoConf__key=key1_value=value1_John,19,19,19", "John#19,John,OneConf_John,TwoConf__key=key2_value=value2_John,19,19,19"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testTableFunctionWithVariableArguments() {
        VarArgsFunc0 varArgsFunc0 = new VarArgsFunc0();
        this.tEnv().createTemporarySystemFunction("VarArgsFunc0", (UserDefinedFunction)varArgsFunc0);
        Table result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("1"), package$.MODULE$.string2Literal("2"), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anna#44,1", "Anna#44,2", "Anna#44,Anna#44", "Jack#22,1", "Jack#22,2", "Jack#22,Jack#22", "John#19,1", "John#19,2", "John#19,John#19", "nosharp,1", "nosharp,2", "nosharp,nosharp"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Table result1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("1"), package$.MODULE$.string2Literal("2")})));
        TestingAppendSink sink1 = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result1).toDataStream().addSink((SinkFunction)sink1);
        this.env().execute();
        MutableList expected1 = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anna#44,1", "Anna#44,2", "Jack#22,1", "Jack#22,2", "John#19,1", "John#19,2", "nosharp,1", "nosharp,2"}));
        Assertions.assertThat((Object)sink1.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected1.sorted((Ordering)Ordering.String$.MODULE$));
        Table result2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Nil$.MODULE$));
        TestingAppendSink sink2 = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result2).toDataStream().addSink((SinkFunction)sink2);
        this.env().execute();
        Assertions.assertThat((boolean)sink2.getAppendResults().isEmpty()).isTrue();
    }

    @TestTemplate
    public void testRowType() {
        Row row = Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToBoolean((boolean)true), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})});
        TypeInformation rowType = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.BOOLEAN(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.INT(), Types.INT()})});
        Table in = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromElements(this.env(), Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row, row}), rowType)).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc6 tableFunc = new TableFunc6();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tableFunc).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "f0"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "f1"), SymbolLiteral.bootstrap("apply", "f2")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,3,3", "1,2,3,3"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testTableFunctionCollectorOpenClose() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        FuncWithOpen func26 = new FuncWithOpen();
        this.tEnv().createTemporarySystemFunction("func26", (UserDefinedFunction)func26);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)func26).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"Jack#22,Jack,22", (List)new .colon.colon((Object)"John#19,John,19", (List)new .colon.colon((Object)"Anna#44,Anna,44", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testTableFunctionCollectorInit() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.WithOperations(package$.MODULE$.dateFormat(package$.MODULE$.currentTimestamp(), package$.MODULE$.string2Literal("yyyyMMdd"))).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((boolean)sink.getAppendResults().isEmpty()).isTrue();
    }

    @TestTemplate
    public void testFlatMap() {
        Table ds = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).flatMap(package$.MODULE$.call(TableFunc2.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).flatMap(package$.MODULE$.call(TableFunc2.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.concat(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("#")}))}))).as("f0", new String[]{"f1"}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(ds).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack,4", "22,2", "John,4", "19,2", "Anna,4", "44,2"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMultipleEvals() {
        RF rf = new RF();
        TableFunc7 tf = new TableFunc7();
        Row row = Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToBoolean((boolean)true), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})});
        TypeInformation rowType = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.BOOLEAN(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.INT(), Types.INT()})});
        Table in = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromElements(this.env(), Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row, row}), rowType)).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        Table result = in.select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)rf).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.call((UserDefinedFunction)tf, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "e"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])));
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
    }

    private DataStream<Tuple3<Object, Object, String>> testData(StreamExecutionEnvironment env) {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"));
        return StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }

    public CorrelateITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

