/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.core.execution.CheckpointingMode;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.WindowDistinctAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.FailingCollectionSource;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u00193\u0001\rC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005%\")!\u000e\u0001C\u0001W\"9\u0001\u000f\u0001b\u0001\n\u0003\t\bbBA\u0001\u0001\u0001\u0006IA\u001d\u0005\t\u0003\u0007\u0001!\u0019!C\u0001c\"9\u0011Q\u0001\u0001!\u0002\u0013\u0011\b\u0002CA\u0004\u0001\t\u0007I\u0011A9\t\u000f\u0005%\u0001\u0001)A\u0005e\"A\u00111\u0002\u0001C\u0002\u0013\u0005\u0011\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002:\t\u0011\u0005=\u0001A1A\u0005\u0002EDq!!\u0005\u0001A\u0003%!\u000f\u0003\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001r\u0011\u001d\t)\u0002\u0001Q\u0001\nID\u0001\"a\u0006\u0001\u0005\u0004%\t!\u001d\u0005\b\u00033\u0001\u0001\u0015!\u0003s\u0011!\tY\u0002\u0001b\u0001\n\u0003\t\bbBA\u000f\u0001\u0001\u0006IA\u001d\u0005\t\u0003?\u0001!\u0019!C\u0001c\"9\u0011\u0011\u0005\u0001!\u0002\u0013\u0011\b\u0002CA\u0012\u0001\t\u0007I\u0011A9\t\u000f\u0005\u0015\u0002\u0001)A\u0005e\"A\u0011q\u0005\u0001C\u0002\u0013\u0005\u0011\u000fC\u0004\u0002*\u0001\u0001\u000b\u0011\u0002:\t\u0011\u0005-\u0002A1A\u0005\u0002EDq!!\f\u0001A\u0003%!\u000fC\u0004\u00020\u0001!\t%!\r\t\u000f\u0005=\u0003\u0001\"\u0001\u00022!9\u0011\u0011\f\u0001\u0005\u0002\u0005E\u0002bBA/\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003C\u0002A\u0011AA\u0019\u0011\u001d\t)\u0007\u0001C\u0001\u0003cAq!!\u001b\u0001\t\u0003\t\t\u0004C\u0004\u0002n\u0001!\t!!\r\t\u000f\u0005E\u0004\u0001\"\u0001\u00022!9\u0011Q\u000f\u0001\u0005\u0002\u0005E\u0002bBA=\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003{\u0002A\u0011AA\u0019\u0011\u001d\t\t\t\u0001C\u0001\u0003cAq!!\"\u0001\t\u0003\t\t\u0004C\u0004\u0002\n\u0002!\t!!\r\t\u000f\u00055\u0005\u0001\"\u0001\u00022!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005EraBA`e!\u0005\u0011\u0011\u0019\u0004\u0007cIB\t!a1\t\r)tC\u0011AAf\u0011\u001d\tiM\fC\u0001\u0003\u001f\u0014QdV5oI><H)[:uS:\u001cG/Q4he\u0016<\u0017\r^3J)\u000e\u000b7/\u001a\u0006\u0003gQ\n1a]9m\u0015\t)d'\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003oa\nqA];oi&lWM\u0003\u0002:u\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u001e=\u0003\u0015!\u0018M\u00197f\u0015\tid(A\u0003gY&t7N\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001c\u0002\u000bU$\u0018\u000e\\:\n\u0005%3%AG*ue\u0016\fW.\u001b8h/&$\bn\u0015;bi\u0016$Vm\u001d;CCN,\u0017!D:qY&$H)[:uS:\u001cG\u000f\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJA\u0004C_>dW-\u00198\u0002\u000f\t\f7m[3oIB\u00111k\u001a\b\u0003)\u0016t!!\u00163\u000f\u0005Y\u001bgBA,c\u001d\tA\u0016M\u0004\u0002ZA:\u0011!l\u0018\b\u00037zk\u0011\u0001\u0018\u0006\u0003;\n\u000ba\u0001\u0010:p_Rt\u0014\"A!\n\u0005}\u0002\u0015BA\u001f?\u0013\tYD(\u0003\u0002:u%\u0011q\u0007O\u0005\u0003\u000fZJ!A\u001a$\u00025M#(/Z1nS:<w+\u001b;i'R\fG/\u001a+fgR\u0014\u0015m]3\n\u0005!L'\u0001E*uCR,')Y2lK:$Wj\u001c3f\u0015\t1g)\u0001\u0004=S:LGO\u0010\u000b\u0004Y:|\u0007CA7\u0001\u001b\u0005\u0011\u0004\"\u0002&\u0004\u0001\u0004Y\u0005\"B)\u0004\u0001\u0004\u0011\u0016\u0001\t+v[\ndWmV5oI><xI]8vaN+G/\u0012=qK\u000e$X\r\u001a#bi\u0006,\u0012A\u001d\t\u0004gZDX\"\u0001;\u000b\u0005Ul\u0015AC2pY2,7\r^5p]&\u0011q\u000f\u001e\u0002\u0004'\u0016\f\bCA=\u007f\u001b\u0005Q(BA>}\u0003\u0011a\u0017M\\4\u000b\u0003u\fAA[1wC&\u0011qP\u001f\u0002\u0007'R\u0014\u0018N\\4\u0002CQ+XN\u00197f/&tGm\\<He>,\boU3u\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\u00029Q+XN\u00197f/&tGm\\<Dk\n,W\t\u001f9fGR,G\rR1uC\u0006iB+^7cY\u0016<\u0016N\u001c3po\u000e+(-Z#ya\u0016\u001cG/\u001a3ECR\f\u0007%\u0001\u0010Uk6\u0014G.Z,j]\u0012|wOU8mYV\u0004X\t\u001f9fGR,G\rR1uC\u0006yB+^7cY\u0016<\u0016N\u001c3poJ{G\u000e\\;q\u000bb\u0004Xm\u0019;fI\u0012\u000bG/\u0019\u0011\u0002S\r\u000b7oY1eS:<G+^7cY\u0016<\u0016N\u001c3po\u001e\u0013x.\u001e9TKR,\u0005\u0010]3di\u0016$G)\u0019;b\u0003)\u001a\u0015m]2bI&tw\rV;nE2,w+\u001b8e_^<%o\\;q'\u0016$X\t\u001f9fGR,G\rR1uC\u0002\nQeQ1tG\u0006$\u0017N\\4Uk6\u0014G.Z,j]\u0012|woQ;cK\u0016C\b/Z2uK\u0012$\u0015\r^1\u0002M\r\u000b7oY1eS:<G+^7cY\u0016<\u0016N\u001c3po\u000e+(-Z#ya\u0016\u001cG/\u001a3ECR\f\u0007%A\u0014DCN\u001c\u0017\rZ5oOR+XN\u00197f/&tGm\\<S_2dW\u000f]#ya\u0016\u001cG/\u001a3ECR\f\u0017\u0001K\"bg\u000e\fG-\u001b8h)Vl'\r\\3XS:$wn\u001e*pY2,\b/\u0012=qK\u000e$X\r\u001a#bi\u0006\u0004\u0013!\b%pa^Kg\u000eZ8x\u000fJ|W\u000f]*fi\u0016C\b/Z2uK\u0012$\u0015\r^1\u0002=!{\u0007oV5oI><xI]8vaN+G/\u0012=qK\u000e$X\r\u001a#bi\u0006\u0004\u0013!\u0007%pa^Kg\u000eZ8x\u0007V\u0014W-\u0012=qK\u000e$X\r\u001a#bi\u0006\f!\u0004S8q/&tGm\\<Dk\n,W\t\u001f9fGR,G\rR1uC\u0002\n1\u0004S8q/&tGm\\<S_2dW\u000f]#ya\u0016\u001cG/\u001a3ECR\f\u0017\u0001\b%pa^Kg\u000eZ8x%>dG.\u001e9FqB,7\r^3e\t\u0006$\u0018\rI\u0001#\u0007VlW\u000f\\1uK^Kg\u000eZ8x\u000fJ|W\u000f]*fi\u0016C\b/Z2uK\u0012$\u0015\r^1\u0002G\r+X.\u001e7bi\u0016<\u0016N\u001c3po\u001e\u0013x.\u001e9TKR,\u0005\u0010]3di\u0016$G)\u0019;bA\u0005q2)^7vY\u0006$XmV5oI><8)\u001e2f\u000bb\u0004Xm\u0019;fI\u0012\u000bG/Y\u0001 \u0007VlW\u000f\\1uK^Kg\u000eZ8x\u0007V\u0014W-\u0012=qK\u000e$X\r\u001a#bi\u0006\u0004\u0013\u0001I\"v[Vd\u0017\r^3XS:$wn\u001e*pY2,\b/\u0012=qK\u000e$X\r\u001a#bi\u0006\f\u0011eQ;nk2\fG/Z,j]\u0012|wOU8mYV\u0004X\t\u001f9fGR,G\rR1uC\u0002\naAY3g_J,GCAA\u001a!\ra\u0015QG\u0005\u0004\u0003oi%\u0001B+oSRD3\u0001HA\u001e!\u0011\ti$a\u0013\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n1!\u00199j\u0015\u0011\t)%a\u0012\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\n!\u0002\u000b),h.\u001b;\n\t\u00055\u0013q\b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0005;fgR$V/\u001c2mK^Kg\u000eZ8xQ\ri\u00121\u000b\t\u0005\u0003{\t)&\u0003\u0003\u0002X\u0005}\"\u0001\u0004+fgR$V-\u001c9mCR,\u0017!\b;fgR$V/\u001c2mK^Kg\u000eZ8x?\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:)\u0007y\t\u0019&A\u000buKN$H+^7cY\u0016<\u0016N\u001c3po~\u001bUOY3)\u0007}\t\u0019&A\fuKN$H+^7cY\u0016<\u0016N\u001c3po~\u0013v\u000e\u001c7va\"\u001a\u0001%a\u0015\u00023Q,7\u000f^\"bg\u000e\fG-\u001b8h)Vl'\r\\3XS:$wn\u001e\u0015\u0004C\u0005M\u0013A\n;fgR\u001c\u0015m]2bI&tw\rV;nE2,w+\u001b8e_^|vI]8va&twmU3ug\"\u001a!%a\u0015\u0002=Q,7\u000f^\"bg\u000e\fG-\u001b8h)Vl'\r\\3XS:$wn^0Dk\n,\u0007fA\u0012\u0002T\u0005\u0001C/Z:u\u0007\u0006\u001c8-\u00193j]\u001e$V/\u001c2mK^Kg\u000eZ8x?J{G\u000e\\;qQ\r!\u00131K\u0001\u000ei\u0016\u001cH\u000fS8q/&tGm\\<)\u0007\u0015\n\u0019&\u0001\u000euKN$\bj\u001c9XS:$wn^0He>,\b/\u001b8h'\u0016$8\u000fK\u0002'\u0003'\n!\u0003^3ti\"{\u0007oV5oI><xlQ;cK\"\u001aq%a\u0015\u0002)Q,7\u000f\u001e%pa^Kg\u000eZ8x?J{G\u000e\\;qQ\rA\u00131K\u0001\u0013i\u0016\u001cHoQ;nk2\fG/Z,j]\u0012|w\u000fK\u0002*\u0003'\nq\u0004^3ti\u000e+X.\u001e7bi\u0016<\u0016N\u001c3po~;%o\\;qS:<7+\u001a;tQ\rQ\u00131K\u0001\u0018i\u0016\u001cHoQ;nk2\fG/Z,j]\u0012|woX\"vE\u0016D3aKA*\u0003e!Xm\u001d;Dk6,H.\u0019;f/&tGm\\<`%>dG.\u001e9)\u00071\n\u0019\u0006K\u0004\u0001\u0003/\u000b\u0019+!*\u0011\t\u0005e\u0015qT\u0007\u0003\u00037SA!!(\u0002@\u0005IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003C\u000bYJ\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#!a*$\u0005\u0005%\u0006\u0003BAV\u0003wk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\u000ea\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\t\u0005M\u0016QW\u0001\u000bKb$XM\\:j_:\u001c(\u0002BA%\u0003oS1!!/=\u0003%!Xm\u001d;vi&d7/\u0003\u0003\u0002>\u00065&A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017!H,j]\u0012|w\u000fR5ti&t7\r^!hOJ,w-\u0019;f\u0013R\u001b\u0015m]3\u0011\u00055t3c\u0001\u0018\u0002FB\u0019A*a2\n\u0007\u0005%WJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u0003\f!\u0002]1sC6,G/\u001a:t)\t\t\t\u000e\u0005\u0004\u0002T\u0006e\u0017Q\\\u0007\u0003\u0003+T1!a6}\u0003\u0011)H/\u001b7\n\t\u0005m\u0017Q\u001b\u0002\u000b\u0007>dG.Z2uS>t\u0007#\u0002'\u0002`\u0006\r\u0018bAAq\u001b\n)\u0011I\u001d:bsB\u0019\u00110!:\n\u0007\u0005\u001d(P\u0001\u0004PE*,7\r\u001e\u0015\ba\u0005-\u0018\u0011_Az!\u0011\tY+!<\n\t\u0005=\u0018Q\u0016\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!!>\u0002GM\u0003H.\u001b;ESN$\u0018N\\2u{m\u0004T\u0010\f\u0011Ti\u0006$XMQ1dW\u0016tG-P>2{\u0002")
public class WindowDistinctAggregateITCase
extends StreamingWithStateTestBase {
    private final boolean splitDistinct;
    private final Seq<String> TumbleWindowGroupSetExpectedData;
    private final Seq<String> TumbleWindowCubeExpectedData;
    private final Seq<String> TumbleWindowRollupExpectedData;
    private final Seq<String> CascadingTumbleWindowGroupSetExpectedData;
    private final Seq<String> CascadingTumbleWindowCubeExpectedData;
    private final Seq<String> CascadingTumbleWindowRollupExpectedData;
    private final Seq<String> HopWindowGroupSetExpectedData;
    private final Seq<String> HopWindowCubeExpectedData;
    private final Seq<String> HopWindowRollupExpectedData;
    private final Seq<String> CumulateWindowGroupSetExpectedData;
    private final Seq<String> CumulateWindowCubeExpectedData;
    private final Seq<String> CumulateWindowRollupExpectedData;

    @Parameters(name="SplitDistinct={0}, StateBackend={1}")
    public static Collection<Object[]> parameters() {
        return WindowDistinctAggregateITCase$.MODULE$.parameters();
    }

    public Seq<String> TumbleWindowGroupSetExpectedData() {
        return this.TumbleWindowGroupSetExpectedData;
    }

    public Seq<String> TumbleWindowCubeExpectedData() {
        return this.TumbleWindowCubeExpectedData;
    }

    public Seq<String> TumbleWindowRollupExpectedData() {
        return this.TumbleWindowRollupExpectedData;
    }

    public Seq<String> CascadingTumbleWindowGroupSetExpectedData() {
        return this.CascadingTumbleWindowGroupSetExpectedData;
    }

    public Seq<String> CascadingTumbleWindowCubeExpectedData() {
        return this.CascadingTumbleWindowCubeExpectedData;
    }

    public Seq<String> CascadingTumbleWindowRollupExpectedData() {
        return this.CascadingTumbleWindowRollupExpectedData;
    }

    public Seq<String> HopWindowGroupSetExpectedData() {
        return this.HopWindowGroupSetExpectedData;
    }

    public Seq<String> HopWindowCubeExpectedData() {
        return this.HopWindowCubeExpectedData;
    }

    public Seq<String> HopWindowRollupExpectedData() {
        return this.HopWindowRollupExpectedData;
    }

    public Seq<String> CumulateWindowGroupSetExpectedData() {
        return this.CumulateWindowGroupSetExpectedData;
    }

    public Seq<String> CumulateWindowCubeExpectedData() {
        return this.CumulateWindowCubeExpectedData;
    }

    public Seq<String> CumulateWindowRollupExpectedData() {
        return this.CumulateWindowRollupExpectedData;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().enableCheckpointing(100L, CheckpointingMode.EXACTLY_ONCE);
        Configuration configuration = new Configuration();
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixeddelay");
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)BoxesRunTime.boxToInteger((int)1));
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofMillis(0L));
        this.env().configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        FailingCollectionSource.reset();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(697).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | `rowtime` AS TO_TIMESTAMP(`ts`),\n                       | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("',\n                       | 'failing-source' = 'true'\n                       |)\n                       |").toString())).stripMargin());
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.splitDistinct));
    }

    @TestTemplate
    public void testTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", (List)new .colon.colon((Object)"2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3", (List)new .colon.colon((Object)"2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", (List)new .colon.colon((Object)"2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1", (List)Nil$.MODULE$))));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testTumbleWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.TumbleWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY `name`, window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`, window_start, window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"a,2020-10-10T00:00,2020-10-10T00:00:10,5,14.43,5.0,1.0,3", (List)new .colon.colon((Object)"b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", (List)new .colon.colon((Object)"b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", (List)new .colon.colon((Object)"b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", (List)new .colon.colon((Object)"null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", (List)Nil$.MODULE$)))));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow_GroupingSets() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  GROUPING_ID(`name`) as group_id,\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY GROUPING SETS((`name`),()), window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  group_id,\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY group_id, `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CascadingTumbleWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow_Cube() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  GROUPING_ID(`name`) as group_id,\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY CUBE(`name`), window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  group_id,\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY group_id, `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CascadingTumbleWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCascadingTumbleWindow_Rollup() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE VIEW V1 AS\n                      |SELECT\n                      |  GROUPING_ID(`name`) as group_id,\n                      |  `name`,\n                      |  window_time as rowtime,\n                      |  COUNT(*) as cnt,\n                      |  SUM(`bigdec`) as sum_bigdec,\n                      |  MAX(`double`) as max_double,\n                      |  MIN(`float`) as min_float,\n                      |  COUNT(DISTINCT `string`) as uv\n                      |FROM TABLE(\n                      |   TUMBLE(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND))\n                      |GROUP BY ROLLUP(`name`), window_start, window_end, window_time\n                      |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  group_id,\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  SUM(cnt),\n        |  SUM(sum_bigdec),\n        |  MAX(max_double),\n        |  MIN(min_float),\n        |  SUM(uv)\n        |FROM TABLE(\n        |   TUMBLE(TABLE V1, DESCRIPTOR(rowtime), INTERVAL '10' SECOND))\n        |GROUP BY group_id, `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CascadingTumbleWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY CUBE(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testHopWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   HOP(TABLE T1, DESCRIPTOR(rowtime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.HopWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY `name`, window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3", "b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1", "null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0"}));
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow_GroupingSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY GROUPING SETS((`name`),()), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowGroupSetExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow_Cube() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY Cube(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowCubeExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testCumulateWindow_Rollup() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  GROUPING_ID(`name`),\n        |  `name`,\n        |  window_start,\n        |  window_end,\n        |  COUNT(*),\n        |  SUM(`bigdec`),\n        |  MAX(`double`),\n        |  MIN(`float`),\n        |  COUNT(DISTINCT `string`)\n        |FROM TABLE(\n        |   CUMULATE(\n        |     TABLE T1,\n        |     DESCRIPTOR(rowtime),\n        |     INTERVAL '5' SECOND,\n        |     INTERVAL '15' SECOND))\n        |GROUP BY ROLLUP(`name`), window_start, window_end\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((String)((TraversableOnce)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)this.CumulateWindowRollupExpectedData().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    public WindowDistinctAggregateITCase(boolean splitDistinct, StreamingWithStateTestBase.StateBackendMode backend) {
        this.splitDistinct = splitDistinct;
        super(backend);
        this.TumbleWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:10,1,3.33,null,3.0,1", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:10,3,9.99,6.0,3.0,3", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1"}));
        this.TumbleWindowCubeExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.TumbleWindowRollupExpectedData = this.TumbleWindowGroupSetExpectedData();
        this.CascadingTumbleWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:10,5,14.43,5.0,1.0,3", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,7,21.09,6.0,1.0,5", "1,null,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1"}));
        this.CascadingTumbleWindowCubeExpectedData = this.CascadingTumbleWindowGroupSetExpectedData();
        this.CascadingTumbleWindowRollupExpectedData = this.CascadingTumbleWindowGroupSetExpectedData();
        this.HopWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "0,a,2020-10-10T00:00:05,2020-10-10T00:00:15,1,3.33,null,3.0,1", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:05,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:25,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:25,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "1,null,2020-10-09T23:59:55,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4", "1,null,2020-10-10T00:00:05,2020-10-10T00:00:15,3,9.99,6.0,3.0,3", "1,null,2020-10-10T00:00:10,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:25,2020-10-10T00:00:35,2,11.10,7.0,3.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1"}));
        this.HopWindowCubeExpectedData = this.HopWindowGroupSetExpectedData();
        this.HopWindowRollupExpectedData = this.HopWindowGroupSetExpectedData();
        this.CumulateWindowGroupSetExpectedData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,a,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "0,a,2020-10-10T00:00,2020-10-10T00:00:10,6,19.98,5.0,1.0,3", "0,a,2020-10-10T00:00,2020-10-10T00:00:15,6,19.98,5.0,1.0,3", "0,b,2020-10-10T00:00,2020-10-10T00:00:10,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00,2020-10-10T00:00:15,2,6.66,6.0,3.0,2", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:35,1,3.33,3.0,3.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:40,1,3.33,3.0,3.0,1", "0,b,2020-10-10T00:00:30,2020-10-10T00:00:45,1,3.33,3.0,3.0,1", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:35,1,7.77,7.0,7.0,0", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:40,1,7.77,7.0,7.0,0", "0,null,2020-10-10T00:00:30,2020-10-10T00:00:45,1,7.77,7.0,7.0,0", "1,null,2020-10-10T00:00,2020-10-10T00:00:05,4,11.10,5.0,1.0,2", "1,null,2020-10-10T00:00,2020-10-10T00:00:10,8,26.64,6.0,1.0,4", "1,null,2020-10-10T00:00,2020-10-10T00:00:15,8,26.64,6.0,1.0,4", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:20,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:25,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:15,2020-10-10T00:00:30,1,4.44,4.0,4.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:35,2,11.10,7.0,3.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:40,2,11.10,7.0,3.0,1", "1,null,2020-10-10T00:00:30,2020-10-10T00:00:45,2,11.10,7.0,3.0,1"}));
        this.CumulateWindowCubeExpectedData = this.CumulateWindowGroupSetExpectedData();
        this.CumulateWindowRollupExpectedData = this.CumulateWindowGroupSetExpectedData();
    }
}

