/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithAggTestBase;
import org.apache.flink.table.planner.runtime.utils.StreamingWithMiniBatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001\u0002\u001b6\u0001\u0019C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u000b\u0003c\u0004!\u0011!Q\u0001\n\u0005M\bB\u0003B\u0003\u0001\t\u0005\t\u0015!\u0003\u0003\b!1Q\u000e\u0001C\u0001\u0005+AqAa\b\u0001\t\u0003\u0012\t\u0003C\u0004\u0003>\u0001!\tA!\t\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003\"!9!1\n\u0001\u0005\u0002\t\u0005\u0002b\u0002B(\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005'\u0002A\u0011\u0001B\u0011\u0011\u001d\u00119\u0006\u0001C\u0001\u0005CAqAa\u0017\u0001\t\u0003\u0011\t\u0003C\u0004\u0003`\u0001!\tA!\t\t\u000f\t\r\u0004\u0001\"\u0001\u0003\"!9!q\r\u0001\u0005\u0002\t\u0005\u0002b\u0002B6\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005_\u0002A\u0011\u0001B\u0011\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005CAqAa\u001e\u0001\t\u0003\u0011\t\u0003C\u0004\u0003|\u0001!\tA!\t\t\u000f\t}\u0004\u0001\"\u0001\u0003\"!9!1\u0011\u0001\u0005\u0002\t\u0005r!B26\u0011\u0003!g!\u0002\u001b6\u0011\u00031\u0007\"B7\u0019\t\u0003qg\u0001B8\u0019\u0001BD\u0001b\u001e\u000e\u0003\u0016\u0004%\t\u0001\u001f\u0005\tyj\u0011\t\u0012)A\u0005s\")QN\u0007C\u0001{\"9\u00111\u0001\u000e\u0005B\u0005\u0015\u0001\"CA\f5\u0005\u0005I\u0011AA\r\u0011%\tiBGI\u0001\n\u0003\ty\u0002C\u0005\u00026i\t\t\u0011\"\u0011\u00028!I\u0011q\t\u000e\u0002\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003#R\u0012\u0011!C\u0001\u0003'B\u0011\"a\u0018\u001b\u0003\u0003%\t%!\u0019\t\u0013\u0005=$$!A\u0005\u0002\u0005E\u0004\"CA;5\u0005\u0005I\u0011IA<\u0011%\tIHGA\u0001\n\u0003\nYhB\u0005\u0002\u0000a\t\t\u0011#\u0001\u0002\u0002\u001aAq\u000eGA\u0001\u0012\u0003\t\u0019\t\u0003\u0004nS\u0011\u0005\u0011q\u0012\u0005\n\u0003\u0007I\u0013\u0011!C#\u0003#C\u0011\"a%*\u0003\u0003%\t)!&\t\u0013\u0005e\u0015&!A\u0005\u0002\u0006m\u0005\"CATS\u0005\u0005I\u0011BAU\u0011%\t\t\f\u0007b\u0001\n\u0003\t\u0019\fC\u0004\u00026b\u0001\u000b\u0011\u0002@\t\u0013\u0005]\u0006D1A\u0005\u0002\u0005M\u0006bBA]1\u0001\u0006IA \u0005\b\u0003wCB\u0011AA_\u0005Q\u0019\u0006\u000f\\5u\u0003\u001e<'/Z4bi\u0016LEkQ1tK*\u0011agN\u0001\u0004gFd'B\u0001\u001d:\u0003\u0019\u0019HO]3b[*\u0011!hO\u0001\beVtG/[7f\u0015\taT(A\u0004qY\u0006tg.\u001a:\u000b\u0005yz\u0014!\u0002;bE2,'B\u0001!B\u0003\u00151G.\u001b8l\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\u0004\u0001M\u0011\u0001a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015f\nQ!\u001e;jYNL!\u0001T%\u00031M#(/Z1nS:<w+\u001b;i\u0003\u001e<G+Z:u\u0005\u0006\u001cX-\u0001\bqCJ$\u0018.\u00197BO\u001elu\u000eZ3\u0011\u0005=SbB\u0001)\u0018\u001d\t\t&M\u0004\u0002SC:\u00111\u000b\u0019\b\u0003)~s!!\u00160\u000f\u0005YkfBA,]\u001d\tA6,D\u0001Z\u0015\tQV)\u0001\u0004=e>|GOP\u0005\u0002\t&\u0011!iQ\u0005\u0003\u0001\u0006K!AP \n\u0005qj\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u00027o\u0005!2\u000b\u001d7ji\u0006;wM]3hCR,\u0017\nV\"bg\u0016\u0004\"!\u001a\r\u000e\u0003U\u001a\"\u0001G4\u0011\u0005!\\W\"A5\u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tAM\u0001\bQCJ$\u0018.\u00197BO\u001elu\u000eZ3\u0014\ti9\u0017\u000f\u001e\t\u0003QJL!a]5\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001.^\u0005\u0003m&\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f1#[:QCJ$\u0018.\u00197BO\u001e,e.\u00192mK\u0012,\u0012!\u001f\t\u0003QjL!a_5\u0003\u000f\t{w\u000e\\3b]\u0006!\u0012n\u001d)beRL\u0017\r\\!hO\u0016s\u0017M\u00197fI\u0002\"2A`A\u0001!\ty($D\u0001\u0019\u0011\u00159X\u00041\u0001z\u0003!!xn\u0015;sS:<GCAA\u0004!\u0011\tI!!\u0005\u000f\t\u0005-\u0011Q\u0002\t\u00031&L1!a\u0004j\u0003\u0019\u0001&/\u001a3fM&!\u00111CA\u000b\u0005\u0019\u0019FO]5oO*\u0019\u0011qB5\u0002\t\r|\u0007/\u001f\u000b\u0004}\u0006m\u0001bB< !\u0003\u0005\r!_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tCK\u0002z\u0003GY#!!\n\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_I\u0017AC1o]>$\u0018\r^5p]&!\u00111GA\u0015\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0005Y\u0006twM\u0003\u0002\u0002D\u0005!!.\u0019<b\u0013\u0011\t\u0019\"!\u0010\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0003c\u00015\u0002N%\u0019\u0011qJ5\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00131\f\t\u0004Q\u0006]\u0013bAA-S\n\u0019\u0011I\\=\t\u0013\u0005u3%!AA\u0002\u0005-\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002dA1\u0011QMA6\u0003+j!!a\u001a\u000b\u0007\u0005%\u0014.\u0001\u0006d_2dWm\u0019;j_:LA!!\u001c\u0002h\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rI\u00181\u000f\u0005\n\u0003;*\u0013\u0011!a\u0001\u0003+\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0017\na!Z9vC2\u001cHcA=\u0002~!I\u0011QL\u0014\u0002\u0002\u0003\u0007\u0011QK\u0001\u000f!\u0006\u0014H/[1m\u0003\u001e<Wj\u001c3f!\ty\u0018f\u0005\u0003*\u0003\u000b#\bCBAD\u0003\u0017Kh0\u0004\u0002\u0002\n*\u0011!([\u0005\u0005\u0003\u001b\u000bIIA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!!\u0015\u0005\u0005e\u0012!B1qa2LHc\u0001@\u0002\u0018\")q\u000f\fa\u0001s\u00069QO\\1qa2LH\u0003BAO\u0003G\u0003B\u0001[APs&\u0019\u0011\u0011U5\u0003\r=\u0003H/[8o\u0011!\t)+LA\u0001\u0002\u0004q\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u000b\u0005\u0003\u0002<\u00055\u0016\u0002BAX\u0003{\u0011aa\u00142kK\u000e$\u0018\u0001\u0004)beRL\u0017\r\\!hO>sW#\u0001@\u0002\u001bA\u000b'\u000f^5bY\u0006;wm\u00148!\u00035\u0001\u0016M\u001d;jC2\fumZ(gM\u0006q\u0001+\u0019:uS\u0006d\u0017iZ4PM\u001a\u0004\u0013A\u00039be\u0006lW\r^3sgR\u0011\u0011q\u0018\t\u0007\u0003\u0003\f9-a3\u000e\u0005\u0005\r'\u0002BAc\u0003\u0003\nA!\u001e;jY&!\u0011\u0011ZAb\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006Q\u00065\u00171V\u0005\u0004\u0003\u001fL'!B!se\u0006L\bfB\u001a\u0002T\u0006-\u0018Q\u001e\t\u0005\u0003+\f9/\u0004\u0002\u0002X*!\u0011\u0011\\An\u00035\u0001\u0018M]1nKR,'/\u001b>fI*!\u0011Q\\Ap\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0005\u0003C\f\u0019/A\u0003kk:LGOC\u0002\u0002f~\n\u0011\u0002^3tiV$\u0018\u000e\\:\n\t\u0005%\u0018q\u001b\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#!a<\u0002cA\u000b'\u000f^5bY\u0006;w-P>1{2\u0002Cj\\2bY\u001ecwNY1m{m\fT\u0010\f\u0011Ti\u0006$XMQ1dW\u0016tG-P>3{\u00069\u0011mZ4N_\u0012,\u0007\u0003BA{\u0003\u007ftA!a>\u0002|:\u0019!+!?\n\u0005)K\u0014bAA\u007f\u0013\u0006A2\u000b\u001e:fC6LgnZ,ji\"\fum\u001a+fgR\u0014\u0015m]3\n\t\t\u0005!1\u0001\u0002\b\u0003\u001e<Wj\u001c3f\u0015\r\ti0S\u0001\bE\u0006\u001c7.\u001a8e!\u0011\u0011IAa\u0004\u000f\t\u0005](1B\u0005\u0004\u0005\u001bI\u0015AG*ue\u0016\fW.\u001b8h/&$\bn\u0015;bi\u0016$Vm\u001d;CCN,\u0017\u0002\u0002B\t\u0005'\u0011\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u0007\t5\u0011\n\u0006\u0005\u0003\u0018\te!1\u0004B\u000f!\t)\u0007\u0001C\u0003N\t\u0001\u0007a\nC\u0004\u0002r\u0012\u0001\r!a=\t\u000f\t\u0015A\u00011\u0001\u0003\b\u00051!-\u001a4pe\u0016$\"Aa\t\u0011\u0007!\u0014)#C\u0002\u0003(%\u0014A!\u00168ji\"\u001aQAa\u000b\u0011\t\t5\"\u0011H\u0007\u0003\u0005_QAA!\r\u00034\u0005\u0019\u0011\r]5\u000b\t\tU\"qG\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\toQ\u0005\u0005\u0005w\u0011yC\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011\u0003^3ti\u000e{WO\u001c;ESN$\u0018N\\2uQ\r1!\u0011\t\t\u0005\u0005[\u0011\u0019%\u0003\u0003\u0003F\t=\"\u0001\u0004+fgR$V-\u001c9mCR,\u0017!\u0006;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fum\u001a\u0015\u0004\u000f\t\u0005\u0013!\u0007;fgRlU\u000f\u001c;j\u0007>,h\u000e\u001e#jgRLgn\u0019;BO\u001eD3\u0001\u0003B!\u0003A\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e\fe\u000eZ(oK>\u0013X*\u001e7uS:{g\u000eR5ti&t7\r^!hO\"\u001a\u0011B!\u0011\u0002AQ,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO^KG\u000f[$s_V\u0004()\u001f\u0015\u0004\u0015\t\u0005\u0013A\u000e;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fumZ,ji\"\fe\u000e\u001a(p]\u0012K7\u000f^5oGR\fumZ(o'\u0006lWmQ8mk6t\u0007fA\u0006\u0003B\u0005QC/Z:u'>lWmQ8mk6t7OQ8uQ&sG)[:uS:\u001cG/Q4h\u0003:$wI]8va\nK\bf\u0001\u0007\u0003B\u00059B/Z:u\u0003\u001e<w+\u001b;i\r&dG/\u001a:DY\u0006,8/\u001a\u0015\u0004\u001b\t\u0005\u0013\u0001\u0007;fgRl\u0015N\\'bq^KG\u000f\u001b*fiJ\f7\r^5p]\"\u001aaB!\u0011\u0002QQ,7\u000f^\"pk:$x+\u001b;i'&tw\r\\3ESN$\u0018N\\2u\u0003:$'+\u001a;sC\u000e$\u0018n\u001c8)\u0007=\u0011\t%A\u0016uKN$8+^7D_VtGoV5uQNKgn\u001a7f\t&\u001cH/\u001b8di\u0006sGMU3ue\u0006\u001cG/[8oQ\r\u0001\"\u0011I\u0001\u0010i\u0016\u001cH/Q4h/&$\bNS8j]\"\u001a\u0011C!\u0011\u0002)Q,7\u000f^+w/&$\bNU3ue\u0006\u001cG/[8oQ\r\u0011\"\u0011I\u0001%i\u0016\u001cHoQ8v]R$\u0015n\u001d;j]\u000e$x+\u001b;i\u0005&t\u0017M]=S_^\u001cv.\u001e:dK\"\u001a1C!\u0011\u0002GQ,7\u000f^'vYRL\u0007\u000f\\3ESN$\u0018N\\2u\u0003\u001e<wJ\\*b[\u0016\u001cu\u000e\\;n]\"\u001aAC!\u0011\u0002MQ,7\u000f^!hO\u001aKG\u000e^3s\u00072\fWo]3C_RDw+\u001b;i\u0003Z<\u0017I\u001c3D_VtG\u000fK\u0002\u0016\u0005\u0003\n\u0001\u0005^3ti2K7\u000f^!hO^KG\u000f\u001b#jgRLgn\u0019;Nk2$\u0018.\u0011:hg\"\u001aaC!\u0011)\u000f\u0001\u0011II!&\u0003\u0018B!!1\u0012BI\u001b\t\u0011iI\u0003\u0003\u0003\u0010\n=\u0012!C3yi\u0016t7/[8o\u0013\u0011\u0011\u0019J!$\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\r\f\u0002\u0003\u001a\u000e\u0012!1\u0014\t\u0005\u0003+\u0014i*\u0003\u0003\u0003 \u0006]'A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0007")
public class SplitAggregateITCase
extends StreamingWithAggTestBase {
    private final PartialAggMode partialAggMode;

    @Parameters(name="PartialAgg={0}, LocalGlobal={1}, StateBackend={2}")
    public static Collection<Object[]> parameters() {
        return SplitAggregateITCase$.MODULE$.parameters();
    }

    public static PartialAggMode PartialAggOff() {
        return SplitAggregateITCase$.MODULE$.PartialAggOff();
    }

    public static PartialAggMode PartialAggOn() {
        return SplitAggregateITCase$.MODULE$.PartialAggOn();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        TableConfig tableConfig = this.partialAggMode.isPartialAggEnabled() ? this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 1"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello 2"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), null), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 4"), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 2"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), null), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"Hello 3"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello 0"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)6), (Object)"Hello 1")}));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("T", t);
    }

    @TestTemplate
    public void testCountDistinct() {
        List ids = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5}));
        List dateTimes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01 00:00:01", "1970-01-01 00:00:02", null, "1970-01-01 00:00:04", "1970-01-01 00:00:05", "1970-01-01 00:00:06", "1970-01-01 00:00:07", null, null, "1970-01-01 00:00:10", "1970-01-01 00:00:11", "1970-01-01 00:00:11", "1970-01-01 00:00:13", "1970-01-01 00:00:14", "1970-01-01 00:00:15"}));
        List dates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1970-01-01", "1970-01-02", null, "1970-01-04", "1970-01-05", "1970-01-06", "1970-01-07", null, null, "1970-01-10", "1970-01-11", "1970-01-11", "1970-01-13", "1970-01-14", "1970-01-15"}));
        List times = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"00:00:01", "00:00:02", null, "00:00:04", "00:00:05", "00:00:06", "00:00:07", null, null, "00:00:10", "00:00:11", "00:00:11", "00:00:13", "00:00:14", "00:00:15"}));
        List integers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", null, "4", "5", "6", "7", null, null, "10", "11", "11", "13", "14", "15"}));
        List chars = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", null, "D", "E", "F", "H", null, null, "K", "L", "L", "N", "O", "P"}));
        MutableList data = new MutableList();
        ids.indices().foreach((Function1 & Serializable & scala.Serializable)i -> SplitAggregateITCase.$anonfun$testCountDistinct$1(integers, data, ids, dateTimes, dates, times, chars, BoxesRunTime.unboxToInt((Object)i)));
        MutableList inputs = (MutableList)Random$.MODULE$.shuffle((TraversableOnce)data, MutableList$.MODULE$.canBuildFrom());
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{Types.INT(), Types.LOCAL_DATE_TIME(), Types.LOCAL_DATE(), Types.LOCAL_TIME(), Types.DECIMAL(), Types.INT(), Types.LONG(), Types.STRING()});
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(inputs, rowType)).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              | id,\n                              | count(distinct a),\n                              | count(distinct b),\n                              | count(distinct c),\n                              | count(distinct d),\n                              | count(distinct e),\n                              | count(distinct f),\n                              | count(distinct g)\n                              |FROM MyTable\n                              |GROUP BY id\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,1,1,1,1,1,1", (List)new .colon.colon((Object)"2,1,1,1,1,1,1,1", (List)new .colon.colon((Object)"3,3,3,3,3,3,3,3", (List)new .colon.colon((Object)"4,2,2,2,2,2,2,2", (List)new .colon.colon((Object)"5,4,4,4,4,4,4,4", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT COUNT(DISTINCT c) FROM T");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"5", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMultiCountDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT COUNT(DISTINCT b), COUNT(DISTINCT c) FROM T");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"6,5", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAggAndOneOrMultiNonDistinctAgg() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, SUM(b), COUNT(DISTINCT c), avg(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,3,2,1", (List)new .colon.colon((Object)"2,29,5,3", (List)new .colon.colon((Object)"3,10,2,5", (List)new .colon.colon((Object)"4,21,3,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAggWithGroupBy() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT c) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,2", (List)new .colon.colon((Object)"2,5", (List)new .colon.colon((Object)"3,2", (List)new .colon.colon((Object)"4,3", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT b), MAX(b), MIN(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,2,2,1", (List)new .colon.colon((Object)"2,4,5,2", (List)new .colon.colon((Object)"3,1,5,5", (List)new .colon.colon((Object)"4,2,6,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        Table t1 = this.tEnv().sqlQuery("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM T GROUP BY a");
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,2", (List)new .colon.colon((Object)"2,1,8", (List)new .colon.colon((Object)"3,1,2", (List)new .colon.colon((Object)"4,1,4", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggWithFilterClause() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  COUNT(DISTINCT b) filter (where not b = 2),\n                              |  MAX(b) filter (where not b = 5),\n                              |  MIN(b) filter (where not b = 2)\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,2,1", (List)new .colon.colon((Object)"2,3,4,3", (List)new .colon.colon((Object)"3,1,null,5", (List)new .colon.colon((Object)"4,2,6,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMinMaxWithRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  c, MIN(b), MAX(b), COUNT(DISTINCT a)\n                              |FROM(\n                              |  SELECT\n                              |    a, COUNT(DISTINCT b) as b, MAX(b) as c\n                              |  FROM T\n                              |  GROUP BY a\n                              |) GROUP BY c\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,2,1", (List)new .colon.colon((Object)"5,1,4,2", (List)new .colon.colon((Object)"6,2,2,1", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCountWithSingleDistinctAndRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  b, COUNT(DISTINCT b1), COUNT(1)\n                              |FROM(\n                              |   SELECT\n                              |     a, COUNT(b) as b, MAX(b) as b1\n                              |   FROM T\n                              |   GROUP BY a\n                              |) GROUP BY b\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,2", (List)new .colon.colon((Object)"4,1,1", (List)new .colon.colon((Object)"8,1,1", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSumCountWithSingleDistinctAndRetraction() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  b, SUM(b1), COUNT(DISTINCT b1), COUNT(1)\n                              |FROM(\n                              |   SELECT\n                              |     a, COUNT(b) as b, MAX(b) as b1\n                              |   FROM T\n                              |   GROUP BY a\n                              |) GROUP BY b\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,7,2,2", (List)new .colon.colon((Object)"4,6,1,1", (List)new .colon.colon((Object)"8,5,1,1", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggWithJoin() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT *\n                              |FROM(\n                              |  SELECT\n                              |    c, MIN(b) as b, MAX(b) as d, COUNT(DISTINCT a) as a\n                              |  FROM(\n                              |    SELECT\n                              |      a, COUNT(DISTINCT b) as b, MAX(b) as c\n                              |    FROM T\n                              |    GROUP BY a\n                              |  ) GROUP BY c\n                              |) as T1 JOIN T ON T1.b + 2 = T.a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,2,2,1,4,5,Hello 2", "2,2,2,1,4,5,Hello 3", "2,2,2,1,4,5,null", "2,2,2,1,4,6,Hello 1", "5,1,4,2,3,5,Hello 0", "5,1,4,2,3,5,Hello 1", "6,2,2,1,4,5,Hello 2", "6,2,2,1,4,5,Hello 3", "6,2,2,1,4,5,null", "6,2,2,1,4,6,Hello 1"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testUvWithRetraction() {
        List data = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)i -> SplitAggregateITCase.$anonfun$testUvWithRetraction$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(data, new CaseClassTypeInfo<Tuple3<String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, String, String>>(this, fieldSerializers){

                    public Tuple3<String, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("src", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(distinct b) as uv\n         |FROM (\n         |  SELECT a, b, last_value(c)\n         |  FROM src\n         |  GROUP BY a, b\n         |) t\n         |GROUP BY a\n     ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,10", "1,10", "2,10", "3,10", "4,10", "5,10", "6,10", "7,10", "8,10", "9,10"}));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCountDistinctWithBinaryRowSource() {
        List data = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)i -> SplitAggregateITCase.$anonfun$testCountDistinctWithBinaryRowSource$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingBinaryRowSource(data, new CaseClassTypeInfo<Tuple4<String, String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, String, String, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, String, String, String>>(this, fieldSerializers){

                    public Tuple4<String, String, String, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.sql.SplitAggregateITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}));
        this.tEnv().createTemporaryView("src", t);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  b,\n         |  COUNT(distinct c) as uv\n         |FROM (\n         |  SELECT\n         |    a, b, c, d\n         |  FROM\n         |    src where b <> ''\n         |  UNION ALL\n         |  SELECT\n         |    a, 'ALL' as b, c, d\n         |  FROM\n         |    src where b <> ''\n         |) t\n         |GROUP BY\n         |  a, b\n     ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,50", (List)new .colon.colon((Object)"1,ALL,50", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMultipleDistinctAggOnSameColumn() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  COUNT(DISTINCT b),\n                              |  COUNT(DISTINCT b) filter (where not b = 2),\n                              |  MAX(b) filter (where not b = 5),\n                              |  MIN(b) filter (where not b = 2)\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,2,1,2,1", (List)new .colon.colon((Object)"2,4,3,4,3", (List)new .colon.colon((Object)"3,1,1,null,5", (List)new .colon.colon((Object)"4,2,2,6,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggFilterClauseBothWithAvgAndCount() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n                              |  SUM(b) FILTER (WHERE NOT b = 5),\n                              |  COUNT(b),\n                              |  SUM(b),\n                              |  AVG(b)\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,3,2,3,1", (List)new .colon.colon((Object)"2,3,24,8,29,3", (List)new .colon.colon((Object)"3,1,null,2,10,5", (List)new .colon.colon((Object)"4,2,6,4,21,5", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testListAggWithDistinctMultiArgs() {
        Table t1 = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                              |SELECT\n                              |  a,\n                              |  LISTAGG(DISTINCT c, '#')\n                              |FROM T\n                              |GROUP BY a\n       ")).stripMargin());
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t1).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)new .colon.colon((Object)"Hello 0", (List)new .colon.colon((Object)"Hello 1", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2"), (Object)new .colon.colon((Object)"Hello 0", (List)new .colon.colon((Object)"Hello 1", (List)new .colon.colon((Object)"Hello 2", (List)new .colon.colon((Object)"Hello 3", (List)new .colon.colon((Object)"Hello 4", (List)Nil$.MODULE$)))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"3"), (Object)new .colon.colon((Object)"Hello 0", (List)new .colon.colon((Object)"Hello 1", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"4"), (Object)new .colon.colon((Object)"Hello 1", (List)new .colon.colon((Object)"Hello 2", (List)new .colon.colon((Object)"Hello 3", (List)Nil$.MODULE$))))}));
        List actualData = (List)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$);
        Map actualMap = ((TraversableOnce)actualData.map((Function1 & Serializable & scala.Serializable)str -> {
            String[] list = str.split(",");
            List values = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list[1].split("#"))).toList().sorted((Ordering)Ordering.String$.MODULE$);
            return new Tuple2((Object)list[0], (Object)values);
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.assertMapStrEquals(expected.toString(), actualMap.toString());
    }

    public static final /* synthetic */ MutableList $anonfun$testCountDistinct$1(List integers$1, MutableList data$1, List ids$1, List dateTimes$1, List dates$1, List times$1, List chars$1, int i) {
        String v = (String)integers$1.apply(i);
        BigDecimal decimal = v == null ? null : new BigDecimal(v);
        Integer n = v == null ? null : Integer.valueOf(v);
        Long l = v == null ? null : Long.valueOf(v);
        return data$1.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)ids$1.apply(i))), DateTimeTestUtil$.MODULE$.localDateTime((String)dateTimes$1.apply(i)), DateTimeTestUtil$.MODULE$.localDate((String)dates$1.apply(i)), DateTimeTestUtil$.MODULE$.localTime((String)times$1.apply(i)), decimal, n, l, chars$1.apply(i)}));
    }

    public static final /* synthetic */ Tuple3 $anonfun$testUvWithRetraction$1(int i) {
        return new Tuple3((Object)String.valueOf(BoxesRunTime.boxToInteger((int)(i % 10))), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)(i % 100))), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)));
    }

    public static final /* synthetic */ Tuple4 $anonfun$testCountDistinctWithBinaryRowSource$1(int i) {
        return new Tuple4((Object)"1", (Object)"1", (Object)String.valueOf(BoxesRunTime.boxToInteger((int)(i % 50))), (Object)"1");
    }

    public SplitAggregateITCase(PartialAggMode partialAggMode, StreamingWithAggTestBase.AggMode aggMode, StreamingWithStateTestBase.StateBackendMode backend) {
        this.partialAggMode = partialAggMode;
        super(aggMode, StreamingWithMiniBatchTestBase$.MODULE$.MiniBatchOn(), backend);
    }

    public static class PartialAggMode
    implements Product,
    scala.Serializable {
        private final boolean isPartialAggEnabled;

        public boolean isPartialAggEnabled() {
            return this.isPartialAggEnabled;
        }

        public String toString() {
            if (this.isPartialAggEnabled()) {
                return "ON";
            }
            return "OFF";
        }

        public PartialAggMode copy(boolean isPartialAggEnabled) {
            return new PartialAggMode(isPartialAggEnabled);
        }

        public boolean copy$default$1() {
            return this.isPartialAggEnabled();
        }

        public String productPrefix() {
            return "PartialAggMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isPartialAggEnabled());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartialAggMode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)(this.isPartialAggEnabled() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartialAggMode)) return false;
            boolean bl = true;
            if (!bl) return false;
            PartialAggMode partialAggMode = (PartialAggMode)x$1;
            if (this.isPartialAggEnabled() != partialAggMode.isPartialAggEnabled()) return false;
            if (!partialAggMode.canEqual(this)) return false;
            return true;
        }

        public PartialAggMode(boolean isPartialAggEnabled) {
            this.isPartialAggEnabled = isPartialAggEnabled;
            Product.$init$((Product)this);
        }
    }
}

