/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0003\u0006\u00017!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u001b\u0001A\u0003%\u0001\u0006C\u0003D\u0001\u0011\u0005A\tC\u0003Q\u0001\u0011\u0005A\tC\u0003S\u0001\u0011\u0005A\tC\u0003U\u0001\u0011\u0005A\tC\u0003W\u0001\u0011\u0005AIA\u000bT_V\u00148-Z,bi\u0016\u0014X.\u0019:l\u0013R\u001b\u0015m]3\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u0007gR\u0014X-Y7\u000b\u0005=\u0001\u0012a\u0002:v]RLW.\u001a\u0006\u0003#I\tq\u0001\u001d7b]:,'O\u0003\u0002\u0014)\u0005)A/\u00192mK*\u0011QCF\u0001\u0006M2Lgn\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"BA\u0010\u000f\u0003\u0015)H/\u001b7t\u0013\t\tcDA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0006\u0002\u0003}+\u0012\u0001\u000b\t\u0004S9\u0002T\"\u0001\u0016\u000b\u0005-b\u0013!\u0003;fgR,H/\u001b7t\u0015\tiC#\u0001\u0003d_J,\u0017BA\u0018+\u0005M)\u0015m\u00195DC2d'-Y2l/J\f\u0007\u000f]3s!\t\t4'D\u00013\u0015\ty\"#\u0003\u00025e\t\u0011B*Z4bGf\u0014vn^#yi\u0016t7/[8o\u0003\ty\u0006\u0005\u000b\u0002\u0004oA\u0011\u0001(Q\u0007\u0002s)\u0011!hO\u0001\nKb$XM\\:j_:T!\u0001P\u001f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002?\u007f\u00059!.\u001e9ji\u0016\u0014(B\u0001!\u0019\u0003\u0015QWO\\5u\u0013\t\u0011\u0015HA\tSK\u001eL7\u000f^3s\u000bb$XM\\:j_:\f1\u0004^3tiNKW\u000e\u001d7f/\u0006$XM]7be.\u0004Vo\u001d5E_^tG#A#\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t1\u0003\"!\u0014(\u000e\u0003mJ!aT\u001e\u0003\tQ+7\u000f^\u0001*i\u0016\u001cHoU5na2,w+\u0019;fe6\f'o[(o)&lWm\u001d;b[BdEO\u001f)vg\"$un\u001e8)\u0005\u0015a\u0015A\u0007;fgR<\u0016\r^3s[\u0006\u00148nV5uQ:+7\u000f^3e%><\bF\u0001\u0004M\u0003y!Xm\u001d;XCR,'/\\1sW^KG\u000f['vYRL\u0017J\u001c9viV#g\r\u000b\u0002\b\u0019\u0006IB/Z:u/\u0006$XM]7be.<\u0016\u000e\u001e5NKR\fG-\u0019;bQ\tAA\n")
public class SourceWatermarkITCase
extends StreamingTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testSimpleWatermarkPushDown() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(445).append("\n         | CREATE Table VirtualTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   d as c - INTERVAL '5' second,\n         |   WATERMARK FOR d as d + INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)new .colon.colon((Object)"2020-11-21T19:00:05.230", (List)new .colon.colon((Object)"2020-11-21T21:00:05.230", (List)Nil$.MODULE$));
        Seq expectedData = (Seq)new .colon.colon((Object)"1,2,2020-11-21T19:00:05.230", (List)new .colon.colon((Object)"2,3,2020-11-21T21:00:05.230", (List)Nil$.MODULE$));
        String query = "SELECT a, b, c FROM VirtualTable";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("VirtualTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleWatermarkOnTimestampLtzPushDown() {
        ZoneId zoneId = ZoneId.of("Asia/Shanghai");
        this.tEnv().getConfig().setLocalTimeZone(zoneId);
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23").atZone(zoneId).toInstant()})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23").atZone(zoneId).toInstant()})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(450).append("\n         | CREATE Table VirtualTable1 (\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP_LTZ(3),\n         |   d as c - INTERVAL '5' second,\n         |   WATERMARK FOR d as d + INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)new .colon.colon((Object)"2020-11-21T19:00:05.230", (List)new .colon.colon((Object)"2020-11-21T21:00:05.230", (List)Nil$.MODULE$));
        Seq expectedData = (Seq)new .colon.colon((Object)"1,2,2020-11-21T11:00:05.230Z", (List)new .colon.colon((Object)"2,3,2020-11-21T13:00:05.230Z", (List)Nil$.MODULE$));
        String query = "SELECT a, b, c FROM VirtualTable1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("VirtualTable1")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> LocalDateTime.ofInstant(Instant.ofEpochMilli(x.getTimestamp()), zoneId).toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithNestedRow() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)0L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"h1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"h2", null}))}))})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i2", LocalDateTime.parse("2020-11-21T19:00:05.23")}))}))})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"j1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"j2", LocalDateTime.parse("2020-11-21T21:00:05.23")}))}))})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)4L), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"k1", BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"k2", null}))}))})), (List)Nil$.MODULE$))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n         | CREATE Table NestedTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c ROW<name STRING, d ROW<e STRING, f TIMESTAMP(3)>>,\n         |   g as c.d.f,\n         |   WATERMARK FOR g as g - INTERVAL '5' second\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)new .colon.colon((Object)TimestampData.fromEpochMillis((long)Long.MIN_VALUE).toString(), (List)new .colon.colon((Object)"2020-11-21T19:00:00.230", (List)new .colon.colon((Object)"2020-11-21T21:00:00.230", (List)new .colon.colon((Object)"2020-11-21T21:00:00.230", (List)Nil$.MODULE$))));
        Seq expectedData = (Seq)new .colon.colon((Object)"0,0,h2,null", (List)new .colon.colon((Object)"1,2,i2,2020-11-21T19:00:05.230", (List)new .colon.colon((Object)"2,3,j2,2020-11-21T21:00:05.230", (List)new .colon.colon((Object)"3,4,k2,null", (List)Nil$.MODULE$))));
        String query = "SELECT a, b, c.d FROM NestedTable";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("NestedTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithMultiInputUdf() {
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2000), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(424).append("\n         | CREATE Table UdfTable (\n         |   a INT,\n         |   b BIGINT,\n         |   c timestamp(3),\n         |   d as func(c, a),\n         |   WATERMARK FOR c as func(func(d, a), a)\n         | ) with (\n         |   'connector' = 'values',\n         |   'bounded' = 'false',\n         |   'enable-watermark-push-down' = 'true',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        Seq expectedWatermarkOutput = (Seq)new .colon.colon((Object)"2020-11-21T19:00:02.230", (List)new .colon.colon((Object)"2020-11-21T20:59:59.230", (List)Nil$.MODULE$));
        Seq expectedData = (Seq)new .colon.colon((Object)"2000,3,2020-11-21T21:00:03.230", (List)Nil$.MODULE$);
        String query = "SELECT a, b, d FROM UdfTable WHERE b > 2";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("UdfTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWatermarkWithMetadata() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)Timestamp.valueOf("2020-11-21 19:00:05.23").toInstant().toEpochMilli())})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)Timestamp.valueOf("2020-11-21 21:00:05.23").toInstant().toEpochMilli())})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(553).append("\n         | CREATE TABLE MetadataTable(\n         |   a INT,\n         |   b BIGINT,\n         |   originTime BIGINT METADATA,\n         |   rowtime AS TO_TIMESTAMP(FROM_UNIXTIME(originTime/1000), 'yyyy-MM-dd HH:mm:ss'),\n         |   WATERMARK FOR rowtime AS rowtime\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'readable-metadata' = 'originTime:BIGINT',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        .colon.colon expectedWatermarkOutput = new .colon.colon((Object)"2020-11-21T19:00:05", (List)new .colon.colon((Object)"2020-11-21T21:00:05", (List)Nil$.MODULE$));
        Seq expectedData = (Seq)new .colon.colon((Object)"1", (List)Nil$.MODULE$);
        String query = "SELECT a FROM MetadataTable WHERE b > 2";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List actualWatermark = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(TestValuesTableFactory.getWatermarkOutput("MetadataTable")).asScala()).map((Function1 & Serializable & scala.Serializable)x -> TimestampData.fromEpochMillis((long)x.getTimestamp()).toLocalDateTime().toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertThat((Object)actualWatermark).isEqualTo((Object)expectedWatermarkOutput);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

