/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\t\u0012\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001BC\u0002\u0013\u0005!\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015Q\u0004\u0001\"\u0011<\u0011\u0015Q\u0005\u0001\"\u0001<\u0011\u0015y\u0005\u0001\"\u0001<\u0011\u0015\t\u0006\u0001\"\u0001<\u0011\u0015\u0019\u0006\u0001\"\u0001<\u0011\u0015)\u0006\u0001\"\u0001<\u000f\u0015a\u0017\u0003#\u0001n\r\u0015\u0001\u0012\u0003#\u0001o\u0011\u0015!T\u0002\"\u0001s\u0011\u0015\u0019X\u0002\"\u0001u\u0005e\u0001\u0016M\u001d;ji&|g.\u00192mKN{WO]2f\u0013R\u001b\u0015m]3\u000b\u0005I\u0019\u0012aA:rY*\u0011A#F\u0001\u0007gR\u0014X-Y7\u000b\u0005Y9\u0012a\u0002:v]RLW.\u001a\u0006\u00031e\tq\u0001\u001d7b]:,'O\u0003\u0002\u001b7\u0005)A/\u00192mK*\u0011A$H\u0001\u0006M2Lgn\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0016\u0003\u0015)H/\u001b7t\u0013\tASEA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016\fQc]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7/F\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u001d\u0011un\u001c7fC:\fac]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7\u000fI\u0001\u0011kN,7)\u0019;bY><g)\u001b7uKJ\f\u0011#^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0019a\u0007O\u001d\u0011\u0005]\u0002Q\"A\t\t\u000b%*\u0001\u0019A\u0016\t\u000bI*\u0001\u0019A\u0016\u0002\r\t,gm\u001c:f)\u0005a\u0004C\u0001\u0017>\u0013\tqTF\u0001\u0003V]&$\bF\u0001\u0004A!\t\t\u0005*D\u0001C\u0015\t\u0019E)A\u0002ba&T!!\u0012$\u0002\u000f),\b/\u001b;fe*\u0011qiH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0013\n\u0013!BQ3g_J,W)Y2i\u0003\t\"Xm\u001d;TS6\u0004H.\u001a)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;fc!\u0012q\u0001\u0014\t\u0003\u00036K!A\u0014\"\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\u0002UQ,7\u000f\u001e)beRL\u0017\r\u001c)beRLG/[8o\r&,G\u000e\u001a)sK\u0012L7-\u0019;f!V\u001c\b\u000eR8x]\"\u0012\u0001\u0002T\u0001\u001ai\u0016\u001cH/\u00168d_:4XM\u001d;fI\u0016C\bO]3tg&|g\u000e\u000b\u0002\n\u0019\u0006\u0019D/Z:u!V\u001c\b\u000eR8x]B\u000b'\u000f^5uS>t\u0017I\u001c3GS2$XM]:D_:$\u0018-\u001b8QCJ$\u0018\u000e^5p].+\u0017p\u001d\u0015\u0003\u00151\u000bq\t^3tiB+8\u000f\u001b#po:\u0004\u0016M\u001d;ji&|g.\u00118e\r&dG/\u001a:t\u0007>tG/Y5o!\u0006\u0014H/\u001b;j_:\\U-_:XSRD7+\u001b8hY\u0016\u0004&o\u001c6fGRLwN\u001c\u0015\u0003\u00171CC\u0001\u0001-_?B\u0011\u0011\fX\u0007\u00025*\u00111LQ\u0001\nKb$XM\\:j_:L!!\u0018.\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\rL\u0001aG\u0005\t\u0007C\u00012k\u001b\u0005\u0019'B\u00013f\u00035\u0001\u0018M]1nKR,'/\u001b>fI*\u0011amZ\u0001\u000bKb$XM\\:j_:\u001c(BA$i\u0015\tI7$A\u0005uKN$X\u000f^5mg&\u00111n\u0019\u0002\u001b!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$X\t\u001f;f]NLwN\\\u0001\u001a!\u0006\u0014H/\u001b;j_:\f'\r\\3T_V\u00148-Z%U\u0007\u0006\u001cX\r\u0005\u00028\u001bM\u0011Qb\u001c\t\u0003YAL!!]\u0017\u0003\r\u0005s\u0017PU3g)\u0005i\u0017A\u00039be\u0006lW\r^3sgR\tQ\u000fE\u0002wwvl\u0011a\u001e\u0006\u0003qf\fA!\u001e;jY*\t!0\u0001\u0003kCZ\f\u0017B\u0001?x\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0005Yy\f\t!\u0003\u0002\u0000[\t)\u0011I\u001d:bsB\u0019A&a\u0001\n\u0007\u0005\u0015QFA\u0002B]fDsaDA\u0005\u0003\u001f\t\t\u0002E\u0002c\u0003\u0017I1!!\u0004d\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002\u0014\u0005y3o\\;sG\u00164U\r^2i!\u0006\u0014H/\u001b;j_:\u001cXh\u001f\u0019~Y\u0001*8/Z\"bi\u0006dwn\u001a$jYR,'/P>2{\u0002")
public class PartitionableSourceITCase
extends StreamingTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;

    @Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)))));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n         |CREATE TABLE PartitionableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s'\n         |)\n         |").toString())).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n         |CREATE TABLE PartitionableAndFilterableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s',\n         |    'filterable-fields' = 'id;part1;part2'\n         |)\n         |").toString())).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(partitionableTable, partitions));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
            return;
        }
        TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
        this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
        this.tEnv().useCatalog("test_catalog");
        this.tEnv().executeSql(String.format(partitionableTable, ""));
        this.tEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
        ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
        ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
        Seq partitions = (Seq)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")}))), (List)new .colon.colon((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))), (List)Nil$.MODULE$))));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionableSourceITCase.$anonfun$before$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testSimplePartitionFieldPredicate1() {
        String query = "SELECT * FROM PartitionableTable WHERE part1 = 'A'";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,ZhangSan,A,1,2", (List)new .colon.colon((Object)"2,LiSi,A,1,2", (List)new .colon.colon((Object)"3,Jack,A,2,3", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testPartialPartitionFieldPredicatePushDown() {
        String query = "SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,Jack,A,2,3", (List)new .colon.colon((Object)"4,Tom,B,3,4", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testUnconvertedExpression() {
        String query = "select * from PartitionableTable where trim(part1) = 'A' and part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,Jack,A,2,3", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        String query = "SELECT * FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"2,LiSi,A,1,2", (List)new .colon.colon((Object)"3,Jack,A,2,3", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        String query = "SELECT name FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"LiSi", (List)new .colon.colon((Object)"Jack", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$before$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceITCase(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
    }
}

