/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.flink.api.common.eventtime.AscendingTimestampsWatermarks;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkAlignmentParams;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$;
import org.apache.flink.table.planner.runtime.stream.sql.PrefixingScalarFunc;
import org.apache.flink.table.planner.runtime.stream.sql.RichAggFunc;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TimeTestUtil;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\n\u0014\u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006\u0013\u0002!\tA\u0013\u0005\u00069\u0002!\tA\u0013\u0005\u0006=\u0002!\tA\u0013\u0005\u0006A\u0002!\tA\u0013\u0005\u0006E\u0002!\tA\u0013\u0005\u0006I\u0002!\tA\u0013\u0005\u0006M\u0002!\tA\u0013\u0005\u0006Q\u0002!\tA\u0013\u0005\u0006U\u0002!\tA\u0013\u0005\u0006Y\u0002!\tA\u0013\u0005\u0006]\u0002!\tA\u0013\u0005\u0006a\u0002!\tA\u0013\u0005\u0006e\u0002!\tA\u0013\u0005\u0006i\u0002!\tA\u0013\u0005\u0006m\u0002!\tA\u0013\u0002\u0015\u001b\u0006$8\r\u001b*fG><g.\u001b>f\u0013R\u001b\u0015m]3\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0007gR\u0014X-Y7\u000b\u0005aI\u0012a\u0002:v]RLW.\u001a\u0006\u00035m\tq\u0001\u001d7b]:,'O\u0003\u0002\u001d;\u0005)A/\u00192mK*\u0011adH\u0001\u0006M2Lgn\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0018\u0003\u0015)H/\u001b7t\u0013\tQsE\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX-A\u0004cC\u000e\\WM\u001c3\u0011\u00055\neB\u0001\u0018@\u001d\tycH\u0004\u00021{9\u0011\u0011\u0007\u0010\b\u0003emr!a\r\u001e\u000f\u0005QJdBA\u001b9\u001b\u00051$BA\u001c$\u0003\u0019a$o\\8u}%\t!%\u0003\u0002!C%\u0011adH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012B\u0001\u0015\u0018\u0013\t\u0001u%\u0001\u000eTiJ,\u0017-\\5oO^KG\u000f[*uCR,G+Z:u\u0005\u0006\u001cX-\u0003\u0002C\u0007\n\u00012\u000b^1uK\n\u000b7m[3oI6{G-\u001a\u0006\u0003\u0001\u001e\na\u0001P5oSRtDC\u0001$I!\t9\u0005!D\u0001\u0014\u0011\u0015Y#\u00011\u0001-\u0003E!Xm\u001d;TS6\u0004H.\u001a)biR,'O\u001c\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\ta*A\u0003tG\u0006d\u0017-\u0003\u0002Q\u001b\n!QK\\5uQ\t\u0019!\u000b\u0005\u0002T56\tAK\u0003\u0002V-\u0006\u0019\u0011\r]5\u000b\u0005]C\u0016a\u00026va&$XM\u001d\u0006\u00033\u0006\nQA[;oSRL!a\u0017+\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\u00025Q,7\u000f^*j[BdW\rU1ui\u0016\u0014hnV5uQ:+H\u000e\\:)\u0005\u0011\u0011\u0016A\t;fgR\u001cu\u000eZ3Ta2LGo]!sKB\u0013x\u000e]3sYf<UM\\3sCR,G\r\u000b\u0002\u0006%\u0006aB/Z:u\u000bZ,g\u000e^:Be\u0016\u0004&o\u001c9fe2LxJ\u001d3fe\u0016$\u0007F\u0001\u0004S\u0003-\"Xm\u001d;NCR\u001c\u0007NU3d_\u001et\u0017N_3BaBd\u0017.\u001a3U_^Kg\u000eZ8xK\u0012<%o\\;qS:<\u0007FA\u0004S\u0003-\"Xm\u001d;XS:$wn^3e\u000fJ|W\u000f]5oO\u0006\u0003\b\u000f\\5fIR{W*\u0019;dQJ+7m\\4oSj,\u0007F\u0001\u0005S\u0003]\"Xm\u001d;XS:$wn^3e\u000fJ|W\u000f]5oO\u0006\u0003\b\u000f\\5fIR{W*\u0019;dQJ+7m\\4oSj,wJ\u001c'uuJ{w\u000f^5nK\"\u0012\u0011BU\u0001\u0013i\u0016\u001cH\u000fT8hS\u000e\fGn\u00144gg\u0016$8\u000f\u000b\u0002\u000b%\u0006\tC/Z:u!\u0006\u0014H/\u001b;j_:\u0014\u0015pV5uQB\u000b'/\u00197mK2\u001cv.\u001e:dK\"\u00121BU\u0001#i\u0016\u001cH\u000fT8hS\u000e\fGn\u00144gg\u0016$8oV5uQN#\u0018M\u001d,be&\f'\r\\3)\u00051\u0011\u0016!\u000b;fgRdunZ5dC2|eMZ:fi>+Ho]5eK>3'+\u00198hK&sW*Z1tkJ,7\u000f\u000b\u0002\u000e%\u0006qA/Z:u\u0003\u001e<'/Z4bi\u0016\u001c\bF\u0001\bS\u0003q!Xm\u001d;BO\u001e\u0014XmZ1uKN<\u0016\u000e\u001e5Ok2d\u0017J\u001c9viND#a\u0004*\u00021Q,7\u000f^!dG\u0016\u001c8/\u001b8h\u0007V\u0014(/\u001a8u)&lW\r\u000b\u0002\u0011%\u0006AB/Z:u+N,'\u000fR3gS:,GMR;oGRLwN\\:)\u0005E\u0011\u0006&\u0002\u0001z\u007f\u0006\u0005\u0001C\u0001>~\u001b\u0005Y(B\u0001?U\u0003%)\u0007\u0010^3og&|g.\u0003\u0002\u007fw\nQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005\r1EAA\u0003!\u0011\t9!a\u0006\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\tQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA\b\u0003#\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\rI\u00161\u0003\u0006\u0004\u0003+i\u0012!\u0003;fgR,H/\u001b7t\u0013\u0011\tI\"!\u0003\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8")
public class MatchRecognizeITCase
extends StreamingWithStateTestBase {
    @TestTemplate
    public void testSimplePattern() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"z"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"b"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)"c"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)"d"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)6), (Object)"a"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)7), (Object)"b"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Object)"c"));
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)9), (Object)"h"));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid, T.bid, T.cid\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    `A\"`.id AS aid,\n         |    l.id AS bid,\n         |    C.id AS cid\n         |  PATTERN (`A\"` l C)\n         |  DEFINE\n         |    `A\"` AS name = 'a',\n         |    l AS name = 'b',\n         |    C AS name = 'c'\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"6,7,8"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testSimplePatternWithNulls() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), null, null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"a", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)7), (Object)"b", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)8), (Object)"c", null));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), null, null));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple3<Object, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, String>>(this, fieldSerializers){

                    public Tuple3<Object, String, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nullField")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid, T.bNull, T.cid, T.aNull\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.id AS aid,\n         |    A.nullField AS aNull,\n         |    LAST(B.nullField) AS bNull,\n         |    C.id AS cid\n         |  PATTERN (A B C)\n         |  DEFINE\n         |    A AS name = 'a' AND nullField IS NULL,\n         |    B AS name = 'b' AND LAST(A.nullField) IS NULL,\n         |    C AS name = 'c'\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,null,3,null", "6,null,8,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCodeSplitsAreProperlyGenerated() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        tEnv.getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)"key1", (Object)"second_key3"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)"key1", (Object)"second_key3"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)"key1", (Object)"second_key3"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)"d", (Object)"key", (Object)"second_key"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)"e", (Object)"key", (Object)"second_key"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)"a", (Object)"key2", (Object)"second_key4"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)7), (Object)"b", (Object)"key2", (Object)"second_key4"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)8), (Object)"c", (Object)"key2", (Object)"second_key4"));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)9), (Object)"f", (Object)"key", (Object)"second_key"));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple4<Object, String, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, String, String>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, String, String>>(this, fieldSerializers){

                    public Tuple4<Object, String, String, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key2")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY key1, key2\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.id AS aid,\n         |    A.key1 AS akey1,\n         |    LAST(B.id) AS bid,\n         |    C.id AS cid,\n         |    C.key2 AS ckey2\n         |  PATTERN (A B C)\n         |  DEFINE\n         |    A AS name = 'a' AND key1 LIKE '%key%' AND id > 0,\n         |    B AS name = 'b' AND LAST(A.name, 2) IS NULL,\n         |    C AS name = 'c' AND LAST(A.name) = 'a'\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1,second_key3,1,key1,2,3,second_key3", "key2,second_key4,6,key2,7,8,second_key4"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventsAreProperlyOrdered() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)3)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)3L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)4L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)5), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)5)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)5L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToInteger((int)6), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)6)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)5L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)8), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)7)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)6L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)7), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)8)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)8L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)9), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)9)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)8L)), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)9L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)10), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)10)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)10L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)11), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)11)))), package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)11L), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)12), (Object)"c", (Object)BoxesRunTime.boxToInteger((int)12)))), package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)11L))}));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)env.addSource(new TimeTestUtil.EventTimeSourceFunction(data), (TypeInformation)Predef$.MODULE$.implicitly((Object)new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }))).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "secondaryOrder")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ternaryOrder")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        tEnv.createTemporaryView("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid, T.bid, T.cid\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY rowtime, secondaryOrder DESC, ternaryOrder ASC\n         |  MEASURES\n         |    A.id AS aid,\n         |    B.id AS bid,\n         |    C.id AS cid\n         |  PATTERN (A B C)\n         |  DEFINE\n         |    A AS name = 'a',\n         |    B AS name = 'b',\n         |    C AS name = 'c'\n         |) AS T\n         |")).stripMargin();
        Table table = tEnv.sqlQuery(sqlQuery);
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(table).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10,11,12"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMatchRecognizeAppliedToWindowedGrouping() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(1L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(2L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(4L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(5L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(7L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(8L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(1L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(1L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)24), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(1L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME1", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(1L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)8)));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks((WatermarkStrategy)new WatermarkStrategy<Tuple4<String, Object, Object, Object>>(null){

            public WatermarkAlignmentParams getAlignmentParameters() {
                return super.getAlignmentParameters();
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withTimestampAssigner(TimestampAssignerSupplier<Tuple4<String, Object, Object, Object>> x$1) {
                return super.withTimestampAssigner(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withTimestampAssigner(SerializableTimestampAssigner<Tuple4<String, Object, Object, Object>> x$1) {
                return super.withTimestampAssigner(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withIdleness(Duration x$1) {
                return super.withIdleness(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withWatermarkAlignment(String x$1, Duration x$2) {
                return super.withWatermarkAlignment(x$1, x$2);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withWatermarkAlignment(String x$1, Duration x$2, Duration x$3) {
                return super.withWatermarkAlignment(x$1, x$2, x$3);
            }

            public WatermarkGenerator<Tuple4<String, Object, Object, Object>> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
                return new AscendingTimestampsWatermarks();
            }

            public TimestampAssigner<Tuple4<String, Object, Object, Object>> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
                return (e, x$1) -> BoxesRunTime.unboxToLong((Object)e._2());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax"))}));
        tEnv.createTemporaryView("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (\n         |   SELECT\n         |      symbol,\n         |      SUM(price) as price,\n         |      TUMBLE_ROWTIME(rowtime, interval '3' second) as rowTime,\n         |      TUMBLE_START(rowtime, interval '3' second) as startTime\n         |   FROM Ticker\n         |   GROUP BY symbol, TUMBLE(rowtime, interval '3' second)\n         |)\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY rowTime\n         |  MEASURES\n         |    B.price as dPrice,\n         |    B.startTime as dTime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A B)\n         |  DEFINE\n         |    B AS B.price < A.price\n         |)\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"ACME,2,1970-01-01T00:00:03", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testWindowedGroupingAppliedToMatchRecognize() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(1L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(2L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(4L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(5L).toMillis()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)3)));
        Table tickerEvents = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$12 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks((WatermarkStrategy)new WatermarkStrategy<Tuple4<String, Object, Object, Object>>(null){

            public WatermarkAlignmentParams getAlignmentParameters() {
                return super.getAlignmentParameters();
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withTimestampAssigner(TimestampAssignerSupplier<Tuple4<String, Object, Object, Object>> x$1) {
                return super.withTimestampAssigner(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withTimestampAssigner(SerializableTimestampAssigner<Tuple4<String, Object, Object, Object>> x$1) {
                return super.withTimestampAssigner(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withIdleness(Duration x$1) {
                return super.withIdleness(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withWatermarkAlignment(String x$1, Duration x$2) {
                return super.withWatermarkAlignment(x$1, x$2);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withWatermarkAlignment(String x$1, Duration x$2, Duration x$3) {
                return super.withWatermarkAlignment(x$1, x$2, x$3);
            }

            public WatermarkGenerator<Tuple4<String, Object, Object, Object>> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
                return new AscendingTimestampsWatermarks();
            }

            public TimestampAssigner<Tuple4<String, Object, Object, Object>> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
                return (e, x$2) -> BoxesRunTime.unboxToLong((Object)e._2());
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax"))}));
        tEnv.createTemporaryView("Ticker", tickerEvents);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY rowtime\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME() as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"ACME,3,1970-01-01T00:00:02.999,1970-01-01T00:00", (List)new .colon.colon((Object)"ACME,2,1970-01-01T00:00:05.999,1970-01-01T00:00:03", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testWindowedGroupingAppliedToMatchRecognizeOnLtzRowtime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Seq data = (Seq)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ACME", Instant.ofEpochSecond(1L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ACME", Instant.ofEpochSecond(2L), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ACME", Instant.ofEpochSecond(3L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ACME", Instant.ofEpochSecond(4L), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))));
        tEnv.getConfig().setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(469).append("\n                       |CREATE TABLE Ticker (\n                       | `symbol` STRING,\n                       | `ts_ltz` TIMESTAMP_LTZ(3),\n                       | `price` INT,\n                       | `tax` INT,\n                       | WATERMARK FOR `ts_ltz` AS `ts_ltz` - INTERVAL '1' SECOND\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  symbol,\n         |  SUM(price) as price,\n         |  TUMBLE_ROWTIME(matchRowtime, interval '3' second) as rowTime,\n         |  TUMBLE_START(matchRowtime, interval '3' second) as startTime\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY ts_ltz\n         |  MEASURES\n         |    A.price as price,\n         |    A.tax as tax,\n         |    MATCH_ROWTIME(ts_ltz) as matchRowtime\n         |  ONE ROW PER MATCH\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS A.price > 0\n         |) AS T\n         |GROUP BY symbol, TUMBLE(matchRowtime, interval '3' second)\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"ACME,3,1970-01-01T00:00:02.999Z,1970-01-01T08:00", (List)new .colon.colon((Object)"ACME,2,1970-01-01T00:00:05.999Z,1970-01-01T08:00:03", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLogicalOffsets() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)17), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)4)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)5)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToInteger((int)26), (Object)BoxesRunTime.boxToInteger((int)6)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)7)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)8)));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$15 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(DOWN.tstamp) AS start_tstamp,\n         |    LAST(DOWN.tstamp) AS bottom_tstamp,\n         |    UP.tstamp AS end_tstamp,\n         |    FIRST(DOWN.price + DOWN.tax + 1) AS bottom_total,\n         |    UP.price + UP.tax AS end_total\n         |  ONE ROW PER MATCH\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (DOWN{2,} UP)\n         |  DEFINE\n         |    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n         |    UP AS price < FIRST(DOWN.price)\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"6,7,8,33,33", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testPartitionByWithParallelSource() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)17), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)4)));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$17 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks((WatermarkStrategy)new WatermarkStrategy<Tuple4<String, Object, Object, Object>>(null){

            public WatermarkAlignmentParams getAlignmentParameters() {
                return super.getAlignmentParameters();
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withTimestampAssigner(TimestampAssignerSupplier<Tuple4<String, Object, Object, Object>> x$1) {
                return super.withTimestampAssigner(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withTimestampAssigner(SerializableTimestampAssigner<Tuple4<String, Object, Object, Object>> x$1) {
                return super.withTimestampAssigner(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withIdleness(Duration x$1) {
                return super.withIdleness(x$1);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withWatermarkAlignment(String x$1, Duration x$2) {
                return super.withWatermarkAlignment(x$1, x$2);
            }

            public WatermarkStrategy<Tuple4<String, Object, Object, Object>> withWatermarkAlignment(String x$1, Duration x$2, Duration x$3) {
                return super.withWatermarkAlignment(x$1, x$2, x$3);
            }

            public WatermarkGenerator<Tuple4<String, Object, Object, Object>> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
                return new AscendingTimestampsWatermarks();
            }

            public TimestampAssigner<Tuple4<String, Object, Object, Object>> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
                return (e, x$3) -> BoxesRunTime.unboxToLong((Object)e._2());
            }
        }).setParallelism(env.getParallelism())).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax"))}));
        tEnv.createTemporaryView("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol\n         |  ORDER BY rowtime\n         |  MEASURES\n         |    DOWN.tax AS bottom_tax,\n         |    UP.tax AS end_tax\n         |  ONE ROW PER MATCH\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (DOWN UP)\n         |  DEFINE\n         |    DOWN AS DOWN.price = 13,\n         |    UP AS UP.price = 20\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"ACME,3,4", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLogicalOffsetsWithStarVariable() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)20)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)19)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)18)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)17)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToInteger((int)16)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToInteger((int)15)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)7), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToInteger((int)14)));
        data.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)8), (Object)"ACME", (Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)20)));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple4<Object, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, String, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, String, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$20 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(id, 0) as id0,\n         |    FIRST(id, 1) as id1,\n         |    FIRST(id, 2) as id2,\n         |    FIRST(id, 3) as id3,\n         |    FIRST(id, 4) as id4,\n         |    FIRST(id, 5) as id5,\n         |    FIRST(id, 6) as id6,\n         |    FIRST(id, 7) as id7,\n         |    LAST(id, 0) as id8,\n         |    LAST(id, 1) as id9,\n         |    LAST(id, 2) as id10,\n         |    LAST(id, 3) as id11,\n         |    LAST(id, 4) as id12,\n         |    LAST(id, 5) as id13,\n         |    LAST(id, 6) as id14,\n         |    LAST(id, 7) as id15\n         |  ONE ROW PER MATCH\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (`DOWN\"`{2,} UP)\n         |  DEFINE\n         |    `DOWN\"` AS price < LAST(price, 1) OR LAST(price, 1) IS NULL,\n         |    UP AS price = FIRST(price) AND price > FIRST(price, 3) AND price = LAST(price, 7)\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1,2,3,4,5,6,7,8,8,7,6,5,4,3,2,1", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLogicalOffsetOutsideOfRangeInMeasures() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)17), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple4((Object)"ACME", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)4)));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$22 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("Ticker", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(DOWN.price) as first,\n         |    LAST(DOWN.price) as last,\n         |    FIRST(DOWN.price, 5) as nullPrice\n         |  ONE ROW PER MATCH\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (DOWN{2,} UP)\n         |  DEFINE\n         |    DOWN AS price < LAST(DOWN.price, 1) OR LAST(DOWN.price, 1) IS NULL,\n         |    UP AS price > LAST(DOWN.price)\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"19,13,null", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggregates() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        tEnv.getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)1)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"z", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)3), (Object)"b", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)4), (Object)"c", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)5)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)5), (Object)"d", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToInteger((int)5)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)6), (Object)"a", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.5), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)7), (Object)"b", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)8), (Object)"c", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)2)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)9), (Object)"h", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)10), (Object)"h", (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)11), (Object)"h", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)3)));
        data.$plus$eq((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)12), (Object)"h", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToInteger((int)3)));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple5<Object, String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, String, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple5<Object, String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Object, String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[3])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$24 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "weight")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("MyTable", t);
        tEnv.createTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvg.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(id) as startId,\n         |    SUM(A.price) AS sumA,\n         |    COUNT(D.price) AS countD,\n         |    SUM(D.price) as sumD,\n         |    weightedAvg(price, weight) as wAvg,\n         |    AVG(B.price) AS avgB,\n         |    SUM(B.price * B.rate) as sumExprB,\n         |    LAST(id) as endId\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (A+ B+ C D? E )\n         |  DEFINE\n         |    A AS SUM(A.price) < 6,\n         |    B AS SUM(B.price * B.rate) < SUM(A.price) AND\n         |         SUM(B.price * B.rate) > 0.2 AND\n         |         SUM(B.price) >= 1 AND\n         |         AVG(B.price) >= 1 AND\n         |         weightedAvg(price, weight) > 1\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,5,0,null,2,3,3.4,8", "9,4,0,null,3,4,3.2,12"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggregatesWithNullInputs() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        tEnv.getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        MutableList data = new MutableList();
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)10)}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)2), "z", BoxesRunTime.boxToInteger((int)10)}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)3), "b", null}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)4), "c", null}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)5), "d", BoxesRunTime.boxToInteger((int)3)}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)6), "c", BoxesRunTime.boxToInteger((int)3)}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)7), "c", BoxesRunTime.boxToInteger((int)3)}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)8), "c", BoxesRunTime.boxToInteger((int)3)}));
        data.$plus$eq((Object)Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)9), "c", BoxesRunTime.boxToInteger((int)2)}));
        TypeInformation tpe = Types.ROW((TypeInformation[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, tpe)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("MyTable", t);
        tEnv.createTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvg.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    SUM(A.price) as sumA,\n         |    COUNT(A.id) as countAId,\n         |    COUNT(A.price) as countAPrice,\n         |    COUNT(*) as countAll,\n         |    COUNT(price) as countAllPrice,\n         |    LAST(id) as endId\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (A+ C)\n         |  DEFINE\n         |    A AS SUM(A.price) < 30,\n         |    C AS C.name = 'c'\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"29,7,5,8,6,8"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAccessingCurrentTime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$26 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("MyTable", t);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT T.aid\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.id AS aid,\n         |    A.proctime AS aProctime,\n         |    LAST(A.proctime + INTERVAL '1' second) as calculatedField\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS proctime >= (CURRENT_TIMESTAMP - INTERVAL '1' day)\n         |) AS T\n         |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        .colon.colon expected = new .colon.colon((Object)"1", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testUserDefinedFunctions() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        tEnv.getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)"b", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)7), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)8), (Object)"a", (Object)BoxesRunTime.boxToLong((long)1L)));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)9), (Object)"f", (Object)BoxesRunTime.boxToLong((long)1L)));
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(env, data, new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$28 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.planner.runtime.stream.sql.MatchRecognizeITCase$$anon$28 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), (Expression)org.apache.flink.table.api.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        tEnv.createTemporaryView("MyTable", t);
        tEnv.createTemporarySystemFunction("prefix", PrefixingScalarFunc.class);
        tEnv.createTemporarySystemFunction("countFrom", RichAggFunc.class);
        String prefix = "PREF";
        int startFrom = 4;
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(env, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefix"), (Object)prefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"start"), (Object)Integer.toString(startFrom))}))));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(470).append("\n         |SELECT *\n         |FROM MyTable\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    FIRST(id) as firstId,\n         |    prefix(A.name) as prefixedNameA,\n         |    countFrom(A.price) as countFromA,\n         |    LAST(id) as lastId\n         |  AFTER MATCH SKIP PAST LAST ROW\n         |  PATTERN (A+ C)\n         |  DEFINE\n         |    A AS prefix(A.name) = '").append(prefix).append(":a' AND countFrom(A.price) <= ").append(startFrom + 4).append("\n         |) AS T\n         |").toString())).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(tEnv.sqlQuery(sqlQuery)).toDataStream();
        result.addSink((SinkFunction)sink);
        env.execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,PREF:a,8,5", "7,PREF:a,6,9"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public MatchRecognizeITCase(StreamingWithStateTestBase.StateBackendMode backend) {
        super(backend);
    }
}

