/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.utils.SingleSubTaskBoundTableFunction;
import org.apache.flink.table.planner.runtime.stream.sql.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestAddWithOpen$;
import org.apache.flink.table.runtime.functions.table.fullcache.inputformat.FullCacheTestInputFormat;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\r%b\u0001\u0002$H\u0001aC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006}\u0002!\ta \u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"a\u000b\u0001A\u0003%\u00111\u0002\u0005\n\u0003[\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"a\f\u0001A\u0003%\u00111\u0002\u0005\n\u0003c\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"a\r\u0001A\u0003%\u00111\u0002\u0005\n\u0003k\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"a\u000e\u0001A\u0003%\u00111\u0002\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\tY\u0006\u0001C!\u0003wAq!!\u001a\u0001\t\u0013\t9\u0007C\u0005\u00020\u0002\t\n\u0011\"\u0003\u00022\"I\u0011q\u0019\u0001\u0012\u0002\u0013%\u0011\u0011\u001a\u0005\n\u0003\u001b\u0004\u0011\u0013!C\u0005\u0003\u0013D\u0011\"a4\u0001#\u0003%I!!3\t\u0013\u0005E\u0007!%A\u0005\n\u0005%\u0007bBAj\u0001\u0011%\u0011Q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!a:\u0001\t\u0003\tY\u0004C\u0004\u0002r\u0002!\t!a\u000f\t\u000f\u0005U\b\u0001\"\u0001\u0002<!9\u0011\u0011 \u0001\u0005\u0002\u0005m\u0002bBA\u007f\u0001\u0011\u0005\u00111\b\u0005\b\u0005\u0003\u0001A\u0011AA\u001e\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003wAqA!\u0003\u0001\t\u0003\tY\u0004C\u0004\u0003\u000e\u0001!\t!a\u000f\t\u000f\tE\u0001\u0001\"\u0001\u0002<!9!Q\u0003\u0001\u0005\u0002\u0005m\u0002b\u0002B\r\u0001\u0011\u0005\u00111\b\u0005\b\u0005;\u0001A\u0011AA\u001e\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003wAqA!\n\u0001\t\u0003\tY\u0004C\u0004\u0003*\u0001!\t!a\u000f\t\u000f\t5\u0002\u0001\"\u0001\u0002<!9!\u0011\u0007\u0001\u0005\u0002\u0005m\u0002b\u0002B\u001b\u0001\u0011\u0005\u00111\b\u0005\b\u0005s\u0001A\u0011AA\u001e\u0011\u001d\u0011i\u0004\u0001C\u0001\u0003wAqA!\u0011\u0001\t\u0003\tY\u0004C\u0004\u0003F\u0001!\t!a\u000f\t\u000f\t%\u0003\u0001\"\u0001\u0002<!9!Q\n\u0001\u0005\u0002\u0005m\u0002b\u0002B)\u0001\u0011\u0005\u00111\b\u0005\b\u0005+\u0002A\u0011AA\u001e\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057BqA!\u001d\u0001\t\u0003\u0011\u0019\bC\u0004\u0003\u0004\u0002!\t!a\u000f\t\u000f\t\u001d\u0005\u0001\"\u0001\u0002<!9!1\u0012\u0001\u0005\u0002\u0005m\u0002b\u0002BH\u0001\u0011%!\u0011\u0013\u0005\b\u00057\u0003A\u0011AA\u001e\u0011\u001d\u0011y\n\u0001C\u0001\u0003wAqAa)\u0001\t\u0003\tY\u0004C\u0004\u0003(\u0002!\t!a\u000f\t\u000f\t-\u0006\u0001\"\u0001\u0002<!9!q\u0016\u0001\u0005\u0002\u0005m\u0002b\u0002BZ\u0001\u0011\u0005\u00111\b\u0005\b\u0005o\u0003A\u0011AA\u001e\u0011\u001d\u0011Y\f\u0001C\u0001\u0003wAqAa0\u0001\t\u0003\tY\u0004C\u0004\u0003D\u0002!\t!a\u000f\b\u000f\tEx\t#\u0001\u0003t\u001a1ai\u0012E\u0001\u0005kDaA`\"\u0005\u0002\tu\bb\u0002B\u0000\u0007\u0012\u00051\u0011\u0001\u0002\u0011\u0019>|7.\u001e9K_&t\u0017\nV\"bg\u0016T!\u0001S%\u0002\u0007M\fHN\u0003\u0002K\u0017\u000611\u000f\u001e:fC6T!\u0001T'\u0002\u000fI,h\u000e^5nK*\u0011ajT\u0001\ba2\fgN\\3s\u0015\t\u0001\u0016+A\u0003uC\ndWM\u0003\u0002S'\u0006)a\r\\5oW*\u0011A+V\u0001\u0007CB\f7\r[3\u000b\u0003Y\u000b1a\u001c:h\u0007\u0001\u0019\"\u0001A-\u0011\u0005ikV\"A.\u000b\u0005q[\u0015!B;uS2\u001c\u0018B\u00010\\\u0005E\u0019FO]3b[&tw\rV3ti\n\u000b7/Z\u0001\nG\u0006\u001c\u0007.\u001a+za\u0016\u0004\"!Y>\u000f\u0005\tDhBA2v\u001d\t!'O\u0004\u0002fa:\u0011am\u001c\b\u0003O:t!\u0001[7\u000f\u0005%dW\"\u00016\u000b\u0005-<\u0016A\u0002\u001fs_>$h(C\u0001W\u0013\t!V+\u0003\u0002S'&\u0011\u0001+U\u0005\u0003c>\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005M$\u0018AB:pkJ\u001cWM\u0003\u0002r\u001f&\u0011ao^\u0001\u0007Y>|7.\u001e9\u000b\u0005M$\u0018BA={\u00035aun\\6va>\u0003H/[8og*\u0011ao^\u0005\u0003yv\u0014q\u0002T8pWV\u00048)Y2iKRK\b/\u001a\u0006\u0003sj\fa\u0001P5oSRtD\u0003BA\u0001\u0003\u000b\u00012!a\u0001\u0001\u001b\u00059\u0005\"B0\u0003\u0001\u0004\u0001\u0017\u0001\u00023bi\u0006,\"!a\u0003\u0011\r\u00055\u00111DA\u0010\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C5n[V$\u0018M\u00197f\u0015\u0011\t)\"a\u0006\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002\u0002\u001a\u0005)1oY1mC&!\u0011QDA\b\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nR\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI#a\t\u0003\u0007I{w/A\u0003eCR\f\u0007%\u0001\u0007eCR\fw+\u001b;i\u001dVdG.A\u0007eCR\fw+\u001b;i\u001dVdG\u000eI\u0001\tkN,'\u000fR1uC\u0006IQo]3s\t\u0006$\u0018\rI\u0001\u0011kN,'\u000fR1uC^KG\u000f\u001b(vY2\f\u0011#^:fe\u0012\u000bG/Y,ji\"tU\u000f\u001c7!\u0003\u0019\u0011WMZ8sKR\u0011\u0011Q\b\t\u0005\u0003\u007f\t\t%\u0004\u0002\u0002\u0018%!\u00111IA\f\u0005\u0011)f.\u001b;)\u0007-\t9\u0005\u0005\u0003\u0002J\u0005]SBAA&\u0015\u0011\ti%a\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002R\u0005M\u0013a\u00026va&$XM\u001d\u0006\u0004\u0003+*\u0016!\u00026v]&$\u0018\u0002BA-\u0003\u0017\u0012!BQ3g_J,W)Y2i\u0003\u0015\tg\r^3sQ\ra\u0011q\f\t\u0005\u0003\u0013\n\t'\u0003\u0003\u0002d\u0005-#!C!gi\u0016\u0014X)Y2i\u0003E\u0019'/Z1uK2{wn[;q)\u0006\u0014G.\u001a\u000b\u0011\u0003{\tI'! \u0002\u0010\u0006e\u00151UAT\u0003WCq!a\u001b\u000e\u0001\u0004\ti'A\u0005uC\ndWMT1nKB!\u0011qNA<\u001d\u0011\t\t(a\u001d\u0011\u0007%\f9\"\u0003\u0003\u0002v\u0005]\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$AB*ue&twM\u0003\u0003\u0002v\u0005]\u0001bBA\u0004\u001b\u0001\u0007\u0011q\u0010\t\u0007\u0003\u0003\u000bY)a\b\u000f\t\u0005\r\u0015q\u0011\b\u0004S\u0006\u0015\u0015BAA\r\u0013\u0011\tI)a\u0006\u0002\u000fA\f7m[1hK&!\u0011QDAG\u0015\u0011\tI)a\u0006\t\u0013\u0005EU\u0002%AA\u0002\u0005M\u0015a\u00047p_.,\b\u000f\u00165sKNDw\u000e\u001c3\u0011\t\u0005}\u0012QS\u0005\u0005\u0003/\u000b9BA\u0002J]RD\u0011\"a'\u000e!\u0003\u0005\r!!(\u0002'\u0015t\u0017M\u00197f\u0007V\u001cHo\\7TQV4g\r\\3\u0011\t\u0005}\u0012qT\u0005\u0005\u0003C\u000b9BA\u0004C_>dW-\u00198\t\u0013\u0005\u0015V\u0002%AA\u0002\u0005u\u0015AG2vgR|Wn\u00155vM\u001adW\rR3uKJl\u0017N\\5ti&\u001c\u0007\"CAU\u001bA\u0005\t\u0019AAO\u0003Q\u0019Wo\u001d;p[NCWO\u001a4mK^KG\u000f[+E\r\"I\u0011QV\u0007\u0011\u0002\u0003\u0007\u0011QT\u0001\u001eGV\u001cHo\\7TQV4g\r\\3F[B$\u0018\u0010U1si&$\u0018n\u001c8fe\u0006Y2M]3bi\u0016dun\\6vaR\u000b'\r\\3%I\u00164\u0017-\u001e7uIM*\"!a-+\t\u0005M\u0015QW\u0016\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*!\u0011\u0011YA\f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\fYLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1d\u0019:fCR,Gj\\8lkB$\u0016M\u00197fI\u0011,g-Y;mi\u0012\"TCAAfU\u0011\ti*!.\u00027\r\u0014X-\u0019;f\u0019>|7.\u001e9UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003m\u0019'/Z1uK2{wn[;q)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005Y2M]3bi\u0016dun\\6vaR\u000b'\r\\3%I\u00164\u0017-\u001e7uI]\n1e\u0019:fCR,Gj\\8lkB$\u0016M\u00197f/&$\bnQ8naV$X\rZ\"pYVlg\u000e\u0006\u0004\u0002>\u0005]\u0017\u0011\u001c\u0005\b\u0003W\u001a\u0002\u0019AA7\u0011\u001d\t9a\u0005a\u0001\u0003\u007f\nqbZ3u\u0007\u0006\u001c\u0007.Z(qi&|gn\u001d\u000b\u0003\u0003[\nqb\u0019:fCR,7kY1o)\u0006\u0014G.\u001a\u000b\u0007\u0003{\t\u0019/!:\t\u000f\u0005-T\u00031\u0001\u0002n!9\u0011qA\u000bA\u0002\u0005}\u0014!\u0006;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0004-\u0005-\b\u0003BA%\u0003[LA!a<\u0002L\taA+Z:u)\u0016l\u0007\u000f\\1uK\u0006\u0011C/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,w+\u001b;i+\u00124g)\u001b7uKJD3aFAv\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5VI\u001a,\u0015/^1m\r&dG/\u001a:)\u0007a\tY/\u0001\u0012uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]\u000e{gn\u001d;b]R\\U-\u001f\u0015\u00043\u0005-\u0018A\t;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001dVdG.\u00192mK.+\u0017\u0010K\u0002\u001b\u0003W\f\u0011\u0005^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQB+8\u000f\u001b#po:D3aGAv\u0003\u001d\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5O_:,\u0015/^1m\r&dG/\u001a:)\u0007q\tY/\u0001\u0012uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5GS\u0016dGm\u001d\u0015\u0004;\u0005-\u0018!\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3tQ\rq\u00121^\u0001'i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\u0017\u0016Lh)[3mIN\u0014\u0004fA\u0010\u0002l\u0006!D/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm],ji\"\u001cuN\\:uC:$8*Z=)\u0007\u0001\nY/\u0001\u001euKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5LKf4\u0015.\u001a7eg^KG\u000f[*ue&twmQ8ogR\fg\u000e^&fs\"\u001a\u0011%a;\u0002OQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0004E\u0005-\u0018!\u0007;fgRdUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016D3aIAv\u0003\u0019\"Xm\u001d;MK\u001a$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRD\u0007K]3GS2$XM\u001d\u0015\u0004I\u0005-\u0018!\u000b;fgRdUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5VI\u001a\u0004&/\u001a$jYR,'\u000fK\u0002&\u0003W\fa\u0005^3ti2+g\r\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sg*\u001e7mC\ndWmS3zQ\r1\u00131^\u0001)i\u0016\u001cH\u000fT3gi*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$8*Z=GS\u0016dGm\u001d\u0015\u0004O\u0005-\u0018!\r;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\bNT;mY\u0012\u000bG/\u0019\u0015\u0004Q\u0005-\u0018!\u000e;fgRdUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016|e.T;mi&\\U-\u001f$jK2$7oV5uQ:+H\u000e\u001c#bi\u0006D3!KAv\u0003\u0019\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016|eNT;mY\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0004U\u0005-\u0018\u0001\u000f;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\bNT;mY\u000e{gn\u001d;b]R\\U-\u001f\u0015\u0004W\u0005-\u0018\u0001\f;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001bVdG/[&fs\u001aKW\r\u001c3t/&$\b.\u0016#GQ\ra\u00131^\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bnQ8naV$X\rZ\"pYVlg\u000eK\u0002.\u0003W\f!\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\u0006sG\rU;tQ\u0012{wO\u001c\u0015\u0004]\u0005-\u0018A\b;fgR\u001cUO\u001d:f]R$\u0015\r^3J]*{\u0017N\\\"p]\u0012LG/[8oQ\ry\u00131^\u0001%i\u0016\u001cH\u000fT8pWV\u00048)Y2iKNC\u0017M]5oO\u0006\u001b'o\\:t'V\u0014G/Y:lg\"\u001a\u0001'a;\u0002\u0005)LG\u0003\u0002B/\u0005[\u0002BAa\u0018\u0003j5\u0011!\u0011\r\u0006\u0005\u0005G\u0012)'\u0001\u0003mC:<'B\u0001B4\u0003\u0011Q\u0017M^1\n\t\t-$\u0011\r\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011y'\ra\u0001\u0003'\u000b\u0011![\u0001\u0003U2$BA!\u001e\u0003|A!!q\fB<\u0013\u0011\u0011IH!\u0019\u0003\t1{gn\u001a\u0005\b\u0005{\u0012\u0004\u0019\u0001B@\u0003\u0005a\u0007\u0003BA \u0005\u0003KAA!\u001f\u0002\u0018\u0005!C/Z:u\u0003\u001e<\u0017I\u001c3MK\u001a$(j\\5o/&$\b\u000e\u0016:z%\u0016\u001cx\u000e\u001c<f\u001b>$W\rK\u00024\u0003W\f!\u0007^3ti\u0006;w-\u00118e\u0019\u00164GOS8j]\u0006cGnQ8ogR\fg\u000e^&fs^KG\u000f\u001b+ssJ+7o\u001c7wK6{G-\u001a\u0015\u0004i\u0005-\u0018A\f;fgR\fumZ!oI*{\u0017N\\!mY\u000e{gn\u001d;b]R\\U-_,ji\"$&/\u001f*fg>dg/Z'pI\u0016D3!NAv\u0003I9W\r\u001e*fiJLHj\\8lkBD\u0015N\u001c;\u0015\r\u00055$1\u0013BL\u0011\u001d\u0011)J\u000ea\u0001\u0003[\n1\u0002\\8pWV\u0004H+\u00192mK\"9!\u0011\u0014\u001cA\u0002\u0005M\u0015aC7bq\u0006#H/Z7qiN\fa\u0004^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQJ+GO]=)\u0007]\nY/A\u001fuKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDGj\\8lkB$\u0006N]3tQ>dGmV5uQ&s7/\u001e4gS\u000eLWM\u001c;SKR\u0014\u0018\u0010K\u00029\u0003W\f1\b^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ2{wn[;q)\"\u0014Xm\u001d5pY\u0012<\u0016\u000e\u001e5Tk\u001a4\u0017nY5f]R\u0014V\r\u001e:zQ\rI\u00141^\u00018i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eT8pWV\u0004H\u000b\u001b:fg\"|G\u000eZ,ji\"d\u0015M]4feJ+GO]=)\u0007i\nY/\u0001\u0019uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDGj\\8lkBD\u0015N\u001c;F]\u0006\u0014G.Z*ik\u001a4G.\u001a\u0015\u0004w\u0005-\u0018A\u0010;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"dun\\6va\"Kg\u000e^#oC\ndWm\u00155vM\u001adWm\u00148O_Jl\u0017\r\\*pkJ\u001cW\rK\u0002=\u0003W\f\u0001\t^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ2{wn[;q\u0011&tG/\u00128bE2,gj\u001c8EKR,'/\\5oSN$\u0018nY*ik\u001a4G.\u001a\u0015\u0004{\u0005-\u0018a\u0012;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"dun\\6va\"Kg\u000e^#oC\ndWm\u00155vM\u001adWm\u00148BY2\u001cuN\\:uC:$Hj\\8lkB\\U-_:)\u0007y\nY/\u0001!uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDGj\\8lkBD\u0015N\u001c;F]\u0006\u0014G.Z*ik\u001a4G.Z#naRL\b+\u0019:uSRLwN\\3sQ\ry\u00141^\u0001;i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eT8pWV\u0004\b*\u001b8u\u000b:\f'\r\\3TQV4g\r\\3XSRDw.\u001e;V\t\u001aC3\u0001QAv\u0003\r\"Xm\u001d;K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5MCR,7\u000f\u001e#bi\u0006D3!QAvQ\u001d\u0001!\u0011\u001aBk\u0005/\u0004BAa3\u0003R6\u0011!Q\u001a\u0006\u0005\u0005\u001f\fY%A\u0005fqR,gn]5p]&!!1\u001bBg\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u00053\u001c#Aa7\u0011\t\tu'Q^\u0007\u0003\u0005?TAA!9\u0003d\u0006i\u0001/\u0019:b[\u0016$XM]5{K\u0012TAA!:\u0003h\u0006QQ\r\u001f;f]NLwN\\:\u000b\t\u0005U#\u0011\u001e\u0006\u0004\u0005W\f\u0016!\u0003;fgR,H/\u001b7t\u0013\u0011\u0011yOa8\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\u0002!1{wn[;q\u0015>Lg.\u0013+DCN,\u0007cAA\u0002\u0007N\u00191Ia>\u0011\t\u0005}\"\u0011`\u0005\u0005\u0005w\f9B\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005g\f!\u0002]1sC6,G/\u001a:t)\t\u0019\u0019\u0001\u0005\u0004\u0004\u0006\r-1qB\u0007\u0003\u0007\u000fQAa!\u0003\u0003f\u0005!Q\u000f^5m\u0013\u0011\u0019iaa\u0002\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0004\u0002@\rE1QC\u0005\u0005\u0007'\t9BA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0003`\r]\u0011\u0002BB\r\u0005C\u0012aa\u00142kK\u000e$\bfB#\u0004\u001e\r\r2Q\u0005\t\u0005\u0005;\u001cy\"\u0003\u0003\u0004\"\t}'A\u0003)be\u0006lW\r^3sg\u0006!a.Y7fC\t\u00199#A\u0007DC\u000eDW\rV=qKvZ\b' ")
public class LookupJoinITCase
extends StreamingTestBase {
    private final LookupOptions.LookupCacheType cacheType;
    private final List<Row> data;
    private final List<Row> dataWithNull;
    private final List<Row> userData;
    private final List<Row> userDataWithNull;

    @Parameters(name="CacheType={0}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        TestValuesTableFactory.RESOURCE_COUNTER.set(0);
        FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.set(0);
        this.createScanTable("src", this.data());
        this.createScanTable("nullable_src", this.dataWithNull());
        this.createLookupTable("user_table", this.userData(), this.createLookupTable$default$3(), this.createLookupTable$default$4(), this.createLookupTable$default$5(), this.createLookupTable$default$6(), this.createLookupTable$default$7());
        String x$1 = "user_table_custom_shuffle";
        List<Row> x$2 = this.userData();
        boolean x$3 = true;
        int x$4 = this.createLookupTable$default$3();
        boolean x$5 = this.createLookupTable$default$5();
        boolean x$6 = this.createLookupTable$default$6();
        boolean x$7 = this.createLookupTable$default$7();
        this.createLookupTable(x$1, x$2, x$4, x$3, x$5, x$6, x$7);
        String x$8 = "user_table_custom_shuffle_non_deterministic";
        List<Row> x$9 = this.userData();
        boolean x$10 = true;
        boolean x$11 = false;
        int x$12 = this.createLookupTable$default$3();
        boolean x$13 = this.createLookupTable$default$6();
        boolean x$14 = this.createLookupTable$default$7();
        this.createLookupTable(x$8, x$9, x$12, x$10, x$11, x$13, x$14);
        String x$15 = "user_table_custom_shuffle_empty_partitioner";
        List<Row> x$16 = this.userData();
        boolean x$17 = true;
        boolean x$18 = true;
        int x$19 = this.createLookupTable$default$3();
        boolean x$20 = this.createLookupTable$default$5();
        boolean x$21 = this.createLookupTable$default$6();
        this.createLookupTable(x$15, x$16, x$19, x$17, x$20, x$21, x$18);
        String x$22 = "user_table_custom_shuffle_without_udf";
        List<Row> x$23 = this.userData();
        boolean x$24 = true;
        boolean x$25 = false;
        int x$26 = this.createLookupTable$default$3();
        boolean x$27 = this.createLookupTable$default$5();
        boolean x$28 = this.createLookupTable$default$7();
        this.createLookupTable(x$22, x$23, x$26, x$24, x$27, x$25, x$28);
        this.createLookupTable("nullable_user_table", this.userDataWithNull(), this.createLookupTable$default$3(), this.createLookupTable$default$4(), this.createLookupTable$default$5(), this.createLookupTable$default$6(), this.createLookupTable$default$7());
        this.createLookupTable("user_table_with_lookup_threshold2", this.userData(), 2, this.createLookupTable$default$4(), this.createLookupTable$default$5(), this.createLookupTable$default$6(), this.createLookupTable$default$7());
        this.createLookupTable("user_table_with_lookup_threshold3", this.userData(), 3, this.createLookupTable$default$4(), this.createLookupTable$default$5(), this.createLookupTable$default$6(), this.createLookupTable$default$7());
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
    }

    @Override
    @AfterEach
    public void after() {
        Assertions.assertThat((int)TestValuesTableFactory.RESOURCE_COUNTER.get()).isZero();
        Assertions.assertThat((int)FullCacheTestInputFormat.OPEN_CLOSED_COUNTER.get()).isZero();
    }

    private void createLookupTable(String tableName, List<Row> data, int lookupThreshold, boolean enableCustomShuffle, boolean customShuffleDeterministic, boolean customShuffleWithUDF, boolean customShuffleEmptyPartitioner) {
        String lookupThresholdOption;
        String dataId = TestValuesTableFactory.registerData(data);
        String cacheOptions = this.getCacheOptions();
        String string = lookupThresholdOption = lookupThreshold > 0 ? new StringBuilder(28).append("'start-lookup-threshold'='").append(lookupThreshold).append("',").toString() : "";
        if (!enableCustomShuffle) {
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(407).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  ").append(lookupThresholdOption).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("'\n                         |)\n                         |").toString())).stripMargin());
            return;
        }
        if (customShuffleEmptyPartitioner || !customShuffleWithUDF) {
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(564).append("\n                           |CREATE TABLE ").append(tableName).append(" (\n                           |  `age` INT,\n                           |  `id` BIGINT,\n                           |  `name` STRING\n                           |) WITH (\n                           |  ").append(cacheOptions).append("\n                           |  ").append(lookupThresholdOption).append("\n                           |  'connector' = 'values',\n                           |  'data-id' = '").append(dataId).append("',\n                           |  'enable-custom-shuffle' = 'true',\n                           |  'custom-shuffle-empty-partitioner' = '").append(customShuffleEmptyPartitioner).append("'\n                           |)\n                           |").toString())).stripMargin());
            return;
        }
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(424).append("\n             |CREATE TABLE ").append(tableName).append(" (\n             |  `age` INT,\n             |  `id` BIGINT,\n             |  `name` STRING\n             |) WITH (\n             |  ").append(cacheOptions).append("\n             |  ").append(lookupThresholdOption).append("\n             |  'connector' = 'values',\n             |  'data-id' = '").append(dataId).append("',\n             |  'enable-custom-shuffle' = 'true',\n             |  'lookup-function-class' = '").append(new SingleSubTaskBoundTableFunction().getClass().getName()).append("',\n             |  'custom-shuffle-deterministic' = '").append(customShuffleDeterministic).append("'\n             |)\n             |").toString())).stripMargin());
    }

    private int createLookupTable$default$3() {
        return -1;
    }

    private boolean createLookupTable$default$4() {
        return false;
    }

    private boolean createLookupTable$default$5() {
        return true;
    }

    private boolean createLookupTable$default$6() {
        return true;
    }

    private boolean createLookupTable$default$7() {
        return false;
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        String cacheOptions = this.getCacheOptions();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(410).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `age` INT,\n                       |  `id` BIGINT,\n                       |  `name` STRING,\n                       |  `nominal_age` as age + 1\n                       |) WITH (\n                       |  ").append(cacheOptions).append("\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    private String getCacheOptions() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.PARTIAL;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(53).append("\n         |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n         |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n         |").toString())).stripMargin();
        }
        LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
        LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.FULL;
        if (!(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n         |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.FULL).append("',\n         |  '").append(LookupOptions.FULL_CACHE_RELOAD_STRATEGY.key()).append("' = '").append(LookupOptions.ReloadStrategy.PERIODIC).append("',\n         |  '").append(LookupOptions.FULL_CACHE_PERIODIC_RELOAD_INTERVAL.key()).append("' = '").append(Long.MAX_VALUE).append("',\n         |").toString())).stripMargin();
        }
        return "";
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(443).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` INT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'runtime-source' ='NewSource',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @TestTemplate
    public void testJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,Julian", (List)new .colon.colon((Object)"2,15,Hello,Jark", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithUdfFilter() {
        this.tEnv().createTemporarySystemFunction("add", (UserDefinedFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE add(T.id, D.id) > 3 AND add(T.id, 2) > 3 AND add (D.id, 2) > 3";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"2,15,Hello,Jark", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertThat((int)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter().get()).isZero();
    }

    @TestTemplate
    public void testJoinTemporalTableWithUdfEqualFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  T.id, T.len, T.content, D.name\n        |FROM\n        |  src AS T JOIN user_table for system_time as of T.proctime AS D\n        |ON T.id = D.id\n        |WHERE CONCAT('Hello-', D.name) = 'Hello-Jark'\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"2,15,Hello,Jark", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnConstantKey() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.id = 1";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,Julian", (List)new .colon.colon((Object)"2,15,Hello,Julian", (List)new .colon.colon((Object)"3,15,Fabian,Julian", (List)new .colon.colon((Object)"8,11,Hello world,Julian", (List)new .colon.colon((Object)"9,12,Hello world!,Julian", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,15,Fabian", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithPushDown() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"2,15,Hello,Jark", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"2,15,Hello,Jark,22", (List)new .colon.colon((Object)"3,15,Fabian,Fabian,33", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian", (List)new .colon.colon((Object)"3,15,Fabian", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian", (List)new .colon.colon((Object)"3,15,Fabian", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFields2() {
        String sql = "SELECT t1.id, t1.len, D.name FROM (select proctime, content, id, len FROM src) t1 JOIN user_table for system_time as of t1.proctime AS D ON t1.content = D.name AND t1.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian", (List)new .colon.colon((Object)"3,15,Fabian", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,15,Fabian", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithStringConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,15,Fabian", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON D.name = 'Fabian' AND 3 = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Fabian", (List)new .colon.colon((Object)"2,15,Fabian", (List)new .colon.colon((Object)"3,15,Fabian", (List)new .colon.colon((Object)"8,11,Fabian", (List)new .colon.colon((Object)"9,12,Fabian", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,11", (List)new .colon.colon((Object)"2,15,Jark,22", (List)new .colon.colon((Object)"3,15,Fabian,33", (List)new .colon.colon((Object)"8,11,null,null", (List)new .colon.colon((Object)"9,12,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableWithPreFilter() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.len < 15";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,11", (List)new .colon.colon((Object)"2,15,null,null", (List)new .colon.colon((Object)"3,15,null,null", (List)new .colon.colon((Object)"8,11,null,null", (List)new .colon.colon((Object)"9,12,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableWithUdfPreFilter() {
        this.tEnv().createTemporarySystemFunction("add", (UserDefinedFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND add(T.id, 2) > 4";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,null", (List)new .colon.colon((Object)"2,15,Hello,null", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)new .colon.colon((Object)"8,11,Hello world,null", (List)new .colon.colon((Object)"9,12,Hello world!,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        Assertions.assertThat((AtomicInteger)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter()).hasValue(0);
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnNullableKey() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T LEFT OUTER JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"null,15,null", (List)new .colon.colon((Object)"3,15,Fabian", (List)new .colon.colon((Object)"null,11,null", (List)new .colon.colon((Object)"9,12,null", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnMultKeyFields() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id and T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,11", (List)new .colon.colon((Object)"2,15,null,null", (List)new .colon.colon((Object)"3,15,Fabian,33", (List)new .colon.colon((Object)"8,11,null,null", (List)new .colon.colon((Object)"9,12,null,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT T.id, T.len, D.name FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,15,Fabian", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = "SELECT D.id, T.len, D.name FROM nullable_src AS T LEFT JOIN nullable_user_table for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"null,15,null", (List)new .colon.colon((Object)"3,15,Fabian", (List)new .colon.colon((Object)"null,11,null", (List)new .colon.colon((Object)"null,12,null", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = "SELECT T.id, T.len, T.content FROM nullable_src AS T JOIN nullable_user_table for system_time as of T.proctime AS D ON D.id = null";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((boolean)sink.getAppendResults().isEmpty()).isTrue();
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((boolean)sink.getAppendResults().isEmpty()).isTrue();
    }

    @TestTemplate
    public void testJoinTemporalTableOnMultiKeyFieldsWithUDF() {
        String sql = "SELECT T.id, T.content, D.age, D.id FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id + 4 AND T.content = concat(D.name, '!') AND D.age = 11";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"9,Hello world!,11,5", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumn() {
        String sql = new StringBuilder(159).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM src AS T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,Julian,11,12", (List)new .colon.colon((Object)"2,15,Hello,Jark,22,23", (List)new .colon.colon((Object)"3,15,Fabian,Fabian,33,34", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        String sql = new StringBuilder(182).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM src AS T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"2,15,Hello,Jark,22,23", (List)new .colon.colon((Object)"3,15,Fabian,Fabian,33,34", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCurrentDateInJoinCondition() {
        String id1 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 1, 0, 0)}), (List)Nil$.MODULE$)));
        String ddl1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         |CREATE TABLE Ta (\n         |  id VARCHAR,\n         |  ts TIMESTAMP,\n         |  proc AS PROCTIME()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(id1).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl1);
        String id2 = TestValuesTableFactory.registerData((Seq<Row>)((Seq)new .colon.colon((Object)Row.of((Object[])new Object[]{"abc", LocalDateTime.of(2000, 1, 2, 0, 0)}), (List)Nil$.MODULE$)));
        String ddl2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n         |CREATE TABLE Tb (\n         |  id VARCHAR,\n         |  ts TIMESTAMP\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(id2).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl2);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM Ta AS t1\n        |INNER JOIN Tb FOR SYSTEM_TIME AS OF t1.proc AS t2\n        |ON t1.id = t2.id\n        |WHERE\n        |  CAST(coalesce(t1.ts, t2.ts) AS VARCHAR)\n        |  >=\n        |  CONCAT(CAST(CURRENT_DATE AS VARCHAR), ' 00:00:00')\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat(sink.getAppendResults()).isEqualTo((Object)Nil$.MODULE$);
    }

    @TestTemplate
    public void testLookupCacheSharingAcrossSubtasks() {
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.NONE;
        if (!(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null)) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE T (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM T \n          |LEFT JOIN user_table FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            TestingAppendSink sink = new TestingAppendSink();
            package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
            this.env().execute();
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupOptions.LookupCacheType lookupCacheType3 = this.cacheType;
            LookupOptions.LookupCacheType lookupCacheType4 = LookupOptions.LookupCacheType.PARTIAL;
            int numEntries = !(lookupCacheType3 != null ? !lookupCacheType3.equals(lookupCacheType4) : lookupCacheType4 != null) ? 6 : this.userData().size();
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo((long)numEntries);
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(4L), BinaryStringData.fromString((String)"Hello world")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(5L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(5L), BinaryStringData.fromString((String)"Hello world")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(6L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    @TestTemplate
    public void testAggAndLeftJoinWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,Fabian,33", (List)new .colon.colon((Object)"8,null,null", (List)new .colon.colon((Object)"9,null,null", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggAndLeftJoinAllConstantKeyWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON D.id = 3";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,Fabian,33", (List)new .colon.colon((Object)"8,Fabian,33", (List)new .colon.colon((Object)"9,Fabian,33", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testAggAndJoinAllConstantKeyWithTryResolveMode() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().createTemporaryView("t1", table1);
        String sql2 = "SELECT t1.id FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON D.id = 3";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"8", (List)new .colon.colon((Object)"9", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private String getRetryLookupHint(String lookupTable, int maxAttempts) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("\n       |/*+ LOOKUP('table'='").append(lookupTable).append("', 'retry-predicate'='lookup_miss',\n       | 'retry-strategy'='fixed_delay',\n       |  'fixed-delay'='5 ms',\n       |   'max-attempts'='").append(maxAttempts).append("')\n       |*/").toString())).stripMargin();
    }

    @TestTemplate
    public void testJoinTemporalTableWithRetry() {
        String maxRetryTwiceHint = this.getRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,Julian", (List)new .colon.colon((Object)"2,15,Hello,Jark", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupThresholdWithInsufficientRetry() {
        String maxRetryOnceHint = this.getRetryLookupHint("D", 1);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryOnceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold3 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        LookupOptions.LookupCacheType lookupCacheType = this.cacheType;
        LookupOptions.LookupCacheType lookupCacheType2 = LookupOptions.LookupCacheType.FULL;
        Seq expected = !(lookupCacheType != null ? !lookupCacheType.equals(lookupCacheType2) : lookupCacheType2 != null) ? (Seq)new .colon.colon((Object)"1,12,Julian,Julian", (List)new .colon.colon((Object)"2,15,Hello,Jark", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)Nil$.MODULE$))) : (Seq)Nil$.MODULE$;
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupThresholdWithSufficientRetry() {
        String maxRetryTwiceHint = this.getRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,Julian", (List)new .colon.colon((Object)"2,15,Hello,Jark", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupThresholdWithLargerRetry() {
        String largerRetryHint = this.getRetryLookupHint("D", 10);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(largerRetryHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,12,Julian,Julian", (List)new .colon.colon((Object)"2,15,Hello,Jark", (List)new .colon.colon((Object)"3,15,Fabian,Fabian", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffle() {
        String sql = new StringBuilder(198).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM src ").append("AS T JOIN user_table_custom_shuffle ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Hello' AND D.age = 33").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,Hello", (List)new .colon.colon((Object)"2,Hello", (List)new .colon.colon((Object)"3,Hello", (List)new .colon.colon((Object)"8,Hello", (List)new .colon.colon((Object)"9,Hello", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleOnNormalSource() {
        String sql = new StringBuilder(147).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM src ").append("AS T JOIN user_table ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,Julian", (List)new .colon.colon((Object)"2,Jark", (List)new .colon.colon((Object)"3,Fabian", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableNonDeterministicShuffle() {
        String sql = new StringBuilder(216).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM src ").append("AS T JOIN user_table_custom_shuffle_non_deterministic ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Hello' AND D.age = 33").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,Hello", (List)new .colon.colon((Object)"2,Hello", (List)new .colon.colon((Object)"3,Hello", (List)new .colon.colon((Object)"8,Hello", (List)new .colon.colon((Object)"9,Hello", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleOnAllConstantLookupKeys() {
        String sql = new StringBuilder(196).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM src ").append("AS T JOIN user_table_custom_shuffle ").append("for system_time as of T.proctime AS D ON D.id = 1 AND D.name = 'Fabian' AND D.age = 33").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1,Fabian", (List)new .colon.colon((Object)"2,Fabian", (List)new .colon.colon((Object)"3,Fabian", (List)new .colon.colon((Object)"8,Fabian", (List)new .colon.colon((Object)"9,Fabian", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleEmptyPartitioner() {
        String sql = new StringBuilder(217).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM src ").append("AS T JOIN user_table_custom_shuffle_empty_partitioner ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Fabian' AND D.age = 33").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,Fabian", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLookupHintEnableShuffleWithoutUDF() {
        String sql = new StringBuilder(211).append("SELECT /*+ LOOKUP('table'='D', 'shuffle'='true') */ T.id, D.name FROM src ").append("AS T JOIN user_table_custom_shuffle_without_udf ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.name = 'Fabian' AND D.age = 33").toString();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"3,Fabian", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testJoinTemporalTableWithLatestData() {
        Assumptions.assumeThat((boolean)this.cacheType.equals((Object)LookupOptions.LookupCacheType.NONE)).isTrue();
        .colon.colon dimData = new .colon.colon((Object)TestValuesTableFactory.changelogRow("+I", BoxesRunTime.boxToInteger((int)12), "DimJulia"), (List)new .colon.colon((Object)TestValuesTableFactory.changelogRow("+I", BoxesRunTime.boxToInteger((int)15), "DimHello"), (List)new .colon.colon((Object)TestValuesTableFactory.changelogRow("+U", BoxesRunTime.boxToInteger((int)15), "DimFabian"), (List)new .colon.colon((Object)TestValuesTableFactory.changelogRow("-D", BoxesRunTime.boxToInteger((int)15), "DimFabian"), (List)new .colon.colon((Object)TestValuesTableFactory.changelogRow("+I", BoxesRunTime.boxToInteger((int)11), "DimHelloWorld1"), (List)new .colon.colon((Object)TestValuesTableFactory.changelogRow("+U", BoxesRunTime.boxToInteger((int)11), "DimHelloWorld2"), (List)Nil$.MODULE$))))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(331).append("\n                       |CREATE TABLE dim_with_pk (\n                       |  `len` INT PRIMARY KEY NOT ENFORCED,\n                       |  `comment` STRING\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(TestValuesTableFactory.registerData((Seq<Row>)dimData)).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT dim_with_pk.* FROM src JOIN dim_with_pk\n        |FOR SYSTEM_TIME AS OF src.proctime ON src.len = dim_with_pk.len\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"12,DimJulia", (List)new .colon.colon((Object)"11,DimHelloWorld2", (List)new .colon.colon((Object)"12,DimJulia", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public LookupJoinITCase(LookupOptions.LookupCacheType cacheType) {
        this.cacheType = cacheType;
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.dataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)4L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)5L), "Hello world"})), (List)Nil$.MODULE$)))));
        this.userDataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"})), (List)Nil$.MODULE$))));
    }
}

