/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000153Aa\u0002\u0005\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0003)\u0003B\u0002\u001b\u0001A\u0003%a\u0005C\u00036\u0001\u0011\u0005a\u0007C\u0003G\u0001\u0011\u0005a\u0007C\u0003L\u0001\u0011\u0005aGA\u000bMS6LG/\u00192mKN{WO]2f\u0013R\u001b\u0015m]3\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0007gR\u0014X-Y7\u000b\u00055q\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u001fA\tq\u0001\u001d7b]:,'O\u0003\u0002\u0012%\u0005)A/\u00192mK*\u00111\u0003F\u0001\u0006M2Lgn\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"BA\u000f\r\u0003\u0015)H/\u001b7t\u0013\tyBDA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u0005\u0002\t\u0011\fG/Y\u000b\u0002MA\u0019q\u0005\f\u0018\u000e\u0003!R!!\u000b\u0016\u0002\u0015\r|G\u000e\\3di&|gNC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti\u0003FA\u0002TKF\u0004\"a\f\u001a\u000e\u0003AR!!\r\n\u0002\u000bQL\b/Z:\n\u0005M\u0002$a\u0001*po\u0006)A-\u0019;bA\u0005)1/\u001a;vaR\tq\u0007\u0005\u00029s5\t!&\u0003\u0002;U\t!QK\\5uQ\t!A\b\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006\u0019\u0011\r]5\u000b\u0005\u0005\u0013\u0015a\u00026va&$XM\u001d\u0006\u0003\u0007Z\tQA[;oSRL!!\u0012 \u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0005uKN$H*[7ji\"\u0012Q\u0001\u0013\t\u0003{%K!A\u0013 \u0003\tQ+7\u000f^\u0001\u0013i\u0016\u001cHo\u00144gg\u0016$\u0018I\u001c3GKR\u001c\u0007\u000e\u000b\u0002\u0007\u0011\u0002")
public class LimitableSourceITCase
extends StreamingTestBase {
    private final Seq<Row> data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)19)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)11)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)33)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)44)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)22)})), (List)Nil$.MODULE$))))));

    public Seq<Row> data() {
        return this.data;
    }

    @BeforeEach
    public void setup() {
        String dataId = TestValuesTableFactory.registerData(this.data());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(243).append("\n         |CREATE TABLE Source (\n         |  category STRING,\n         |  shopId INT,\n         |  num INT\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'false'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
    }

    @Test
    public void testLimit() {
        String sql = "SELECT * FROM Source LIMIT 4";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"book,1,12", (List)new .colon.colon((Object)"book,2,19", (List)new .colon.colon((Object)"book,4,11", (List)new .colon.colon((Object)"fruit,4,33", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testOffsetAndFetch() {
        String sql = "SELECT * FROM Source LIMIT 4 OFFSET 2";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"book,4,11", (List)new .colon.colon((Object)"fruit,4,33", (List)new .colon.colon((Object)"fruit,3,44", (List)new .colon.colon((Object)"fruit,5,22", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

