/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.planner.runtime.stream.sql.GroupWindowITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.TimeTestUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u000e\u001d\u00015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\")A\u000b\u0001C\u0001+\"9!\f\u0001b\u0001\n\u0003Y\u0006B\u00023\u0001A\u0003%A\fC\u0004f\u0001\t\u0007I\u0011\u00014\t\rU\u0004\u0001\u0015!\u0003h\u0011\u00151\b\u0001\"\u0011x\u0011\u0019\ti\u0001\u0001C\u0001o\"1\u0011q\u0003\u0001\u0005\u0002]Da!a\u0007\u0001\t\u00039\bBBA\u0010\u0001\u0011\u0005q\u000fC\u0004\u0002$\u0001!\t!!\n\t\r\u0005%\u0002\u0001\"\u0001x\u0011\u0019\ti\u0003\u0001C\u0001o\"1\u0011\u0011\u0007\u0001\u0005\u0002]Da!!\u000e\u0001\t\u00039\bBBA\u001d\u0001\u0011\u0005q\u000f\u0003\u0004\u0002>\u0001!\ta\u001e\u0005\u0007\u0003\u0003\u0002A\u0011A<\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011\u0011\r\u0001\u0005\n\u0005\rtaBAP9!\u0005\u0011\u0011\u0015\u0004\u00077qA\t!a)\t\rQCB\u0011AAV\u0011\u001d\ti\u000b\u0007C\u0001\u0003_\u0013\u0011c\u0012:pkB<\u0016N\u001c3po&#6)Y:f\u0015\tib$A\u0002tc2T!a\b\u0011\u0002\rM$(/Z1n\u0015\t\t#%A\u0004sk:$\u0018.\\3\u000b\u0005\r\"\u0013a\u00029mC:tWM\u001d\u0006\u0003K\u0019\nQ\u0001^1cY\u0016T!a\n\u0015\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001G\u0003\u00022A\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/Z\u0001\u0005[>$W\r\u0005\u00027\u0015:\u0011q\u0007\u0013\b\u0003q\u001ds!!\u000f$\u000f\u0005i*eBA\u001eE\u001d\ta4I\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tL\u0001\u0007yI|w\u000e\u001e \n\u0003-J!!\u000b\u0016\n\u0005\u001dB\u0013BA\u0013'\u0013\t\u0019C%\u0003\u0002\"E%\u0011\u0011\u0007I\u0005\u0003\u0013B\n!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016L!a\u0013'\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'BA%1\u0003=)8/\u001a+j[\u0016\u001cH/Y7q\u0019RT\bCA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007YC\u0016\f\u0005\u0002X\u00015\tA\u0004C\u00035\u0007\u0001\u0007Q\u0007C\u0003N\u0007\u0001\u0007a*A\u0007T\u0011\u0006su\tS!J?j{e*R\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0005i&lWMC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rt&A\u0002.p]\u0016LE-\u0001\bT\u0011\u0006su\tS!J?j{e*\u0012\u0011\u00021U\u00048/\u001a:u'>,(oY3DkJ\u0014XM\\2z\t\u0006$\u0018-F\u0001h!\rAWn\\\u0007\u0002S*\u0011!n[\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u001c)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002oS\n!A*[:u!\t\u00018/D\u0001r\u0015\t\u0011h%A\u0003usB,7/\u0003\u0002uc\n\u0019!k\\<\u00023U\u00048/\u001a:u'>,(oY3DkJ\u0014XM\\2z\t\u0006$\u0018\rI\u0001\u0007E\u00164wN]3\u0015\u0003a\u0004\"aT=\n\u0005i\u0004&\u0001B+oSRD#\u0001\u0003?\u0011\u0007u\fI!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0004CBL'\u0002BA\u0002\u0003\u000b\tqA[;qSR,'OC\u0002\u0002\b)\nQA[;oSRL1!a\u0003\u007f\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001bi\u0016\u001cH/\u0012<f]R$\u0016.\\3TY&$\u0017N\\4XS:$wn\u001e\u0015\u0004\u0013\u0005E\u0001cA?\u0002\u0014%\u0019\u0011Q\u0003@\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\u00023Q,7\u000f^\"bg\u000e\fG-\u001b8h)Vl'\r\\3XS:$wn\u001e\u0015\u0004\u0015\u0005E\u0011\u0001\b;fgRl\u0015N\\'bq^KG\u000f\u001b+v[\nd\u0017N\\4XS:$wn\u001e\u0015\u0004\u0017\u0005E\u0011A\t;fgR<\u0016N\u001c3po\u0006;wM]3hCR,wJ\\\"p]N$\u0018M\u001c;WC2,X\rK\u0002\r\u0003#\tA\u0004^3tiB\u0013xn\u0019;j[\u0016\u001c\u0015m]2bI\u0016<\u0016N\u001c3po\u0006;w-F\u0001yQ\ri\u0011\u0011C\u0001\u001bi\u0016\u001cH/\u0012<f]R$\u0016.\\3TKN\u001c\u0018n\u001c8XS:$wn\u001e\u0015\u0004\u001d\u0005E\u0011\u0001\f;fgR,e/\u001a8u)&lW\rV;nE2LgnZ,j]\u0012|woV5uQ\u0006cGn\\<MCR,g.Z:tQ\ry\u0011\u0011C\u0001\"i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z(o+B\u001cXM\u001d;T_V\u00148-\u001a\u0015\u0004!\u0005E\u0011A\r;fgR<\u0016N\u001c3po\u0006;wM]3hCR,wJ\\+qg\u0016\u0014HoU8ve\u000e,w+\u001b;i\u00032dwn\u001e'bi\u0016tWm]:)\u0007E\t\t\"\u0001\u001auKN$x+\u001b8e_^\fum\u001a:fO\u0006$Xm\u00148VaN,'\u000f^*pkJ\u001cW\rU;tQ\u0012|wO\\,bi\u0016\u0014X.\u0019:lQ\r\u0011\u0012\u0011C\u0001#i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z(o%\u0016$(/Y2u'R\u0014X-Y7)\u0007M\t\t\"A\u001buKN$H)[:uS:\u001cG/Q4h/&$\b.T3sO\u0016|e.\u0012<f]R$\u0016.\\3TKN\u001c\u0018n\u001c8He>,\boV5oI><\bf\u0001\u000b\u0002\u0012\u0005\tr/\u001b;i\u0019\u0006$XMR5sK\u0012+G.Y=\u0015\u000ba\fI%a\u0016\t\u000f\u0005-S\u00031\u0001\u0002N\u0005YA/\u00192mK\u000e{gNZ5h!\u0011\ty%a\u0015\u000e\u0005\u0005E#BA@%\u0013\u0011\t)&!\u0015\u0003\u0017Q\u000b'\r\\3D_:4\u0017n\u001a\u0005\b\u00033*\u0002\u0019AA.\u0003!Ig\u000e^3sm\u0006d\u0007cA/\u0002^%\u0019\u0011q\f0\u0003\u0011\u0011+(/\u0019;j_:\fQ\u0002\\8dC2$\u0015\r^3US6,G\u0003BA3\u0003W\u00022!XA4\u0013\r\tIG\u0018\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u00055d\u00031\u0001\u0002p\u0005YQ\r]8dQN+7m\u001c8e!\ry\u0015\u0011O\u0005\u0004\u0003g\u0002&\u0001\u0002'p]\u001eDs\u0001AA<\u0003\u0007\u000b)\t\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiH`\u0001\nKb$XM\\:j_:LA!!!\u0002|\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005\u001d5EAAE!\u0011\tY)a'\u000e\u0005\u00055%\u0002BAH\u0003#\u000bQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BAJ\u0003+\u000b!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\u0011\t9!a&\u000b\u0007\u0005ee%A\u0005uKN$X\u000f^5mg&!\u0011QTAG\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0003E9%o\\;q/&tGm\\<J)\u000e\u000b7/\u001a\t\u0003/b\u00192\u0001GAS!\ry\u0015qU\u0005\u0004\u0003S\u0003&AB!osJ+g\r\u0006\u0002\u0002\"\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005E\u0006CBAZ\u0003s\u000bi,\u0004\u0002\u00026*\u0019\u0011q\u00171\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003w\u000b)L\u0001\u0006D_2dWm\u0019;j_:\u0004RaTA`\u0003\u0007L1!!1Q\u0005\u0015\t%O]1z!\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAeA\u0006!A.\u00198h\u0013\u0011\ti-a2\u0003\r=\u0013'.Z2uQ\u001dQ\u0012\u0011[Al\u00033\u0004B!a#\u0002T&!\u0011Q[AG\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0005]\u0006lW-\t\u0002\u0002\\\u000693\u000b^1uK\n\u000b7m[3oIvZ\b' \u0017!+N,G+[7fgR\fW\u000e\u001d'uu\u0002j\u0004e_\u0019~\u0001")
public class GroupWindowITCase
extends StreamingWithStateTestBase {
    private final boolean useTimestampLtz;
    private final ZoneId SHANGHAI_ZONE;
    private final List<Row> upsertSourceCurrencyData;

    @Parameters(name="StateBackend={0}, UseTimestampLtz = {1}")
    public static Collection<Object[]> parameters() {
        return GroupWindowITCase$.MODULE$.parameters();
    }

    public ZoneId SHANGHAI_ZONE() {
        return this.SHANGHAI_ZONE;
    }

    public List<Row> upsertSourceCurrencyData() {
        return this.upsertSourceCurrencyData;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        String timestampDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.timestampData());
        String timestampLtzDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.timestampLtzData());
        this.tEnv().getConfig().setLocalTimeZone(this.SHANGHAI_ZONE());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(505).append("\n         |CREATE TABLE testTable (\n         | `ts` ").append((Object)(this.useTimestampLtz ? "BIGINT" : "STRING")).append(",\n         | `int` INT,\n         | `double` DOUBLE,\n         | `float` FLOAT,\n         | `bigdec` DECIMAL(10, 2),\n         | `string` STRING,\n         | `name` STRING,\n         | `rowtime` AS\n         | ").append((Object)(this.useTimestampLtz ? "TO_TIMESTAMP_LTZ(`ts`, 3)" : "TO_TIMESTAMP(`ts`)")).append(",\n         | proctime as PROCTIME(),\n         | WATERMARK for `rowtime` AS `rowtime` - INTERVAL '0.01' SECOND\n         |) WITH (\n         | 'connector' = 'values',\n         | 'data-id' = '").append((Object)(this.useTimestampLtz ? timestampLtzDataId : timestampDataId)).append("',\n         | 'failing-source' = 'true'\n         |)\n         |").toString())).stripMargin());
    }

    @TestTemplate
    public void testEventTimeSlidingWindow() {
        this.tEnv().createTemporarySystemFunction("concat_distinct_agg", JavaUserDefinedAggFunctions.ConcatDistinctAggFunction.class);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `string`,\n        |  HOP_START(rowtime, INTERVAL '0.004' SECOND, INTERVAL '0.005' SECOND),\n        |  HOP_ROWTIME(rowtime, INTERVAL '0.004' SECOND, INTERVAL '0.005' SECOND),\n        |  COUNT(1),\n        |  SUM(1),\n        |  COUNT(`int`),\n        |  COUNT(DISTINCT `float`),\n        |  concat_distinct_agg(name)\n        |FROM testTable\n        |GROUP BY `string`, HOP(rowtime, INTERVAL '0.004' SECOND, INTERVAL '0.005' SECOND)\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = this.useTimestampLtz ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hallo,1970-01-01T00:00,1969-12-31T16:00:00.004Z,1,1,1,1,a", "Hello world,1970-01-01T00:00:00.004,1969-12-31T16:00:00.008Z,1,1,1,1,a", "Hello world,1970-01-01T00:00:00.008,1969-12-31T16:00:00.012Z,1,1,1,1,a", "Hello world,1970-01-01T00:00:00.012,1969-12-31T16:00:00.016Z,1,1,1,1,b", "Hello world,1970-01-01T00:00:00.016,1969-12-31T16:00:00.020Z,1,1,1,1,b", "Hello,1970-01-01T00:00,1969-12-31T16:00:00.004Z,2,2,2,2,a", "Hello,1970-01-01T00:00:00.004,1969-12-31T16:00:00.008Z,3,3,3,2,a|b", "Hi,1970-01-01T00:00,1969-12-31T16:00:00.004Z,1,1,1,1,a", "null,1970-01-01T00:00:00.028,1969-12-31T16:00:00.032Z,1,1,1,1,null", "null,1970-01-01T00:00:00.032,1969-12-31T16:00:00.036Z,1,1,1,1,null"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hallo,1970-01-01T00:00,1970-01-01T00:00:00.004,1,1,1,1,a", "Hello world,1970-01-01T00:00:00.004,1970-01-01T00:00:00.008,1,1,1,1,a", "Hello world,1970-01-01T00:00:00.008,1970-01-01T00:00:00.012,1,1,1,1,a", "Hello world,1970-01-01T00:00:00.012,1970-01-01T00:00:00.016,1,1,1,1,b", "Hello world,1970-01-01T00:00:00.016,1970-01-01T00:00:00.020,1,1,1,1,b", "Hello,1970-01-01T00:00,1970-01-01T00:00:00.004,2,2,2,2,a", "Hello,1970-01-01T00:00:00.004,1970-01-01T00:00:00.008,3,3,3,2,a|b", "Hi,1970-01-01T00:00,1970-01-01T00:00:00.004,1,1,1,1,a", "null,1970-01-01T00:00:00.028,1970-01-01T00:00:00.032,1,1,1,1,null", "null,1970-01-01T00:00:00.032,1970-01-01T00:00:00.036,1,1,1,1,null"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testCascadingTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUM(cnt)\n        |FROM (\n        |  SELECT COUNT(1) AS cnt, TUMBLE_ROWTIME(rowtime, INTERVAL '10' SECOND) AS ts\n        |  FROM testTable\n        |  GROUP BY `int`, `string`, TUMBLE(rowtime, INTERVAL '10' SECOND)\n        |)\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND)\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"9", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testMinMaxWithTumblingWindow() {
        this.tEnv().getConfig().set("table.exec.emit.early-fire.enabled", "true");
        this.tEnv().getConfig().set("table.exec.emit.early-fire.delay", "1000 ms");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        | MAX(max_ts),\n        | MIN(min_ts),\n        | `string`\n        |FROM(\n        | SELECT\n        | `string`,\n        | `int`,\n        | MAX(rowtime) as max_ts,\n        | MIN(rowtime) as min_ts\n        | FROM testTable\n        | GROUP BY `string`, `int`, TUMBLE(rowtime, INTERVAL '10' SECOND))\n        |GROUP BY `string`\n      ")).stripMargin();
        TestingRetractSink sink = new TestingRetractSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = this.useTimestampLtz ? (Seq)new .colon.colon((Object)"1969-12-31T16:00:00.001Z,1969-12-31T16:00:00.001Z,Hi", (List)new .colon.colon((Object)"1969-12-31T16:00:00.002Z,1969-12-31T16:00:00.002Z,Hallo", (List)new .colon.colon((Object)"1969-12-31T16:00:00.007Z,1969-12-31T16:00:00.003Z,Hello", (List)new .colon.colon((Object)"1969-12-31T16:00:00.016Z,1969-12-31T16:00:00.008Z,Hello world", (List)new .colon.colon((Object)"1969-12-31T16:00:00.032Z,1969-12-31T16:00:00.032Z,null", (List)Nil$.MODULE$))))) : (Seq)new .colon.colon((Object)"1970-01-01T00:00:00.001,1970-01-01T00:00:00.001,Hi", (List)new .colon.colon((Object)"1970-01-01T00:00:00.002,1970-01-01T00:00:00.002,Hallo", (List)new .colon.colon((Object)"1970-01-01T00:00:00.007,1970-01-01T00:00:00.003,Hello", (List)new .colon.colon((Object)"1970-01-01T00:00:00.016,1970-01-01T00:00:00.008,Hello world", (List)new .colon.colon((Object)"1970-01-01T00:00:00.032,1970-01-01T00:00:00.032,null", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testWindowAggregateOnConstantValue() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_END(rowtime, INTERVAL '0.003' SECOND), COUNT(name)\n        |FROM testTable\n        | GROUP BY 'a', TUMBLE(rowtime, INTERVAL '0.003' SECOND)\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1970-01-01T00:00:00.003,2", (List)new .colon.colon((Object)"1970-01-01T00:00:00.006,2", (List)new .colon.colon((Object)"1970-01-01T00:00:00.009,3", (List)new .colon.colon((Object)"1970-01-01T00:00:00.018,1", (List)new .colon.colon((Object)"1970-01-01T00:00:00.033,0", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testProctimeCascadeWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT\n        |  cnt AS key,\n        |  TUMBLE_START(pt1, INTERVAL '0.01' SECOND) AS window_start,\n        |  TUMBLE_END(pt1, INTERVAL '0.01' SECOND) AS window_start,\n        |  TUMBLE_PROCTIME(pt1, INTERVAL '0.01' SECOND) as window_proctime,\n        |  MAX(s1) AS v1,\n        |  MAX(e1) AS v2\n        | FROM\n        | (SELECT\n        |   TUMBLE_START(proctime, INTERVAL '0.005' SECOND) as s1,\n        |   TUMBLE_END(proctime, INTERVAL '0.005' SECOND) e1,\n        |   TUMBLE_PROCTIME(proctime, INTERVAL '0.005' SECOND) as pt1,\n        |   COUNT(name) as cnt\n        |  FROM testTable\n        |  GROUP BY 'a', TUMBLE(proctime, INTERVAL '0.005' SECOND)\n        |  ) as T\n        | GROUP BY cnt, TUMBLE(pt1, INTERVAL '0.01' SECOND)\n      ")).stripMargin();
        ResolvedSchema resolvedSchema = this.tEnv().sqlQuery(sql).getResolvedSchema();
        Assertions.assertThat((String)resolvedSchema.toString()).isEqualTo(new StringOps(Predef$.MODULE$.augmentString("\n           |(\n           |  `key` BIGINT NOT NULL,\n           |  `window_start` TIMESTAMP(3) NOT NULL,\n           |  `window_start0` TIMESTAMP(3) NOT NULL,\n           |  `window_proctime` TIMESTAMP_LTZ(3) NOT NULL *PROCTIME*,\n           |  `v1` TIMESTAMP(3) NOT NULL,\n           |  `v2` TIMESTAMP(3) NOT NULL\n           |)\n         ")).stripMargin().trim());
    }

    @TestTemplate
    public void testEventTimeSessionWindow() {
        if (this.useTimestampLtz) {
            return;
        }
        .colon.colon sessionData = new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hello", (Object)"a"), (List)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello", (Object)"b"), (List)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)8), (Object)"Hello", (Object)"a"), (List)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)9), (Object)"Hello World", (Object)"b"), (List)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello", (Object)"c"), (List)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)16L), (Object)BoxesRunTime.boxToInteger((int)16), (Object)"Hello", (Object)"d"), (List)Nil$.MODULE$))))));
        SingleOutputStreamOperator stream = this.failingDataSource(sessionData, new CaseClassTypeInfo<Tuple4<Object, Object, String, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, String>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, String>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.GroupWindowITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimeTestUtil.TimestampAndWatermarkWithOffset(10L));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)stream).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "string")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}));
        this.tEnv().createTemporaryView("T1", table);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `string`,\n        |  SESSION_START(rowtime, INTERVAL '0.005' SECOND),\n        |  SESSION_ROWTIME(rowtime, INTERVAL '0.005' SECOND),\n        |  COUNT(1),\n        |  SUM(1),\n        |  COUNT(`int`),\n        |  SUM(`int`),\n        |  COUNT(DISTINCT name)\n        |FROM T1\n        |GROUP BY `string`, SESSION(rowtime, INTERVAL '0.005' SECOND)\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"Hello World,1970-01-01T00:00:00.009,1970-01-01T00:00:00.013,1,1,1,9,1", (List)new .colon.colon((Object)"Hello,1970-01-01T00:00:00.016,1970-01-01T00:00:00.020,1,1,1,16,1", (List)new .colon.colon((Object)"Hello,1970-01-01T00:00:00.001,1970-01-01T00:00:00.012,4,4,4,15,3", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testEventTimeTumblingWindowWithAllowLateness() {
        if (this.useTimestampLtz) {
            return;
        }
        this.tEnv().getConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofMillis(10L));
        this.withLateFireDelay(this.tEnv().getConfig(), Duration.ofMillis(0L));
        List data = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hi"), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), new Tuple3((Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello world"), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello"), new Tuple3((Object)BoxesRunTime.boxToLong((long)16L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello world"), new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)4), (Object)"Hello world"), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hi")}));
        SingleOutputStreamOperator stream = this.failingDataSource(data, new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.GroupWindowITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimeTestUtil.TimestampAndWatermarkWithOffset(0L));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)stream).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "long")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "string")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        this.tEnv().createTemporaryView("T1", table);
        this.tEnv().createTemporarySystemFunction("weightAvgFun", JavaUserDefinedAggFunctions.WeightedAvg.class);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  `string`,\n        |  TUMBLE_START(rowtime, INTERVAL '0.005' SECOND) as w_start,\n        |  TUMBLE_END(rowtime, INTERVAL '0.005' SECOND),\n        |  COUNT(DISTINCT `long`),\n        |  COUNT(`int`),\n        |  CAST(AVG(`int`) AS INT),\n        |  weightAvgFun(`long`, `int`),\n        |  MIN(`int`),\n        |  MAX(`int`),\n        |  SUM(`int`)\n        |FROM T1\n        |GROUP BY `string`, TUMBLE(rowtime, INTERVAL '0.005' SECOND)\n      ")).stripMargin();
        Table result = this.tEnv().sqlQuery(sql);
        List fieldTypes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{DataTypes.STRING(), (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class), (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class), DataTypes.BIGINT(), DataTypes.BIGINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.INT(), DataTypes.INT(), DataTypes.INT()}));
        List fieldNames = ((TraversableOnce)fieldTypes.indices().map((Function1 & Serializable & scala.Serializable)x$1 -> GroupWindowITCase.$anonfun$testEventTimeTumblingWindowWithAllowLateness$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), "MySink", (List<String>)fieldNames, (List<DataType>)fieldTypes, ChangelogMode.upsert(), (List<String>)fieldNames.take(2));
        result.executeInsert("MySink").await();
        Seq expected = (Seq)new .colon.colon((Object)"+I[Hi, 1970-01-01T00:00, 1970-01-01T00:00:00.005, 1, 1, 1, 1, 1, 1, 1]", (List)new .colon.colon((Object)"+I[Hello, 1970-01-01T00:00, 1970-01-01T00:00:00.005, 2, 3, 2, 3, 2, 3, 7]", (List)new .colon.colon((Object)"+I[Hello world, 1970-01-01T00:00:00.015, 1970-01-01T00:00:00.020, 1, 1, 3, 16, 3, 3, 3]", (List)new .colon.colon((Object)"+I[Hello world, 1970-01-01T00:00:00.005, 1970-01-01T00:00:00.010, 2, 2, 3, 8, 3, 4, 7]", (List)Nil$.MODULE$))));
        Assertions.assertThat((String)((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("MySink")).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).isEqualTo(((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    @TestTemplate
    public void testWindowAggregateOnUpsertSource() {
        this.env().setParallelism(1);
        String upsertSourceDataId = TestValuesTableFactory.registerData(this.upsertSourceCurrencyData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(621).append("\n                       |CREATE TABLE upsert_currency (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '5' SECOND,\n                       |  PRIMARY KEY(currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'data-id' = '").append(upsertSourceDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |currency,\n        |COUNT(1) AS cnt,\n        |MAX(rate),\n        |TUMBLE_START(currency_time, INTERVAL '5' SECOND) as w_start,\n        |TUMBLE_END(currency_time, INTERVAL '5' SECOND) as w_end\n        |FROM upsert_currency\n        |GROUP BY currency, TUMBLE(currency_time, INTERVAL '5' SECOND)\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"US Dollar,1,102,1970-01-01T00:00,1970-01-01T00:00:05", (List)new .colon.colon((Object)"Yen,1,1,1970-01-01T00:00,1970-01-01T00:00:05", (List)new .colon.colon((Object)"Euro,1,118,1970-01-01T00:00:15,1970-01-01T00:00:20", (List)new .colon.colon((Object)"RMB,1,702,1970-01-01T00:00,1970-01-01T00:00:05", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testWindowAggregateOnUpsertSourceWithAllowLateness() {
        this.tEnv().getConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofSeconds(15L));
        this.withLateFireDelay(this.tEnv().getConfig(), Duration.ofMillis(0L));
        String upsertSourceDataId = TestValuesTableFactory.registerData(this.upsertSourceCurrencyData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(621).append("\n                       |CREATE TABLE upsert_currency (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '5' SECOND,\n                       |  PRIMARY KEY(currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'data-id' = '").append(upsertSourceDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |currency,\n        |COUNT(1) AS cnt,\n        |MAX(rate),\n        |TUMBLE_START(currency_time, INTERVAL '5' SECOND) as w_start,\n        |TUMBLE_END(currency_time, INTERVAL '5' SECOND) as w_end\n        |FROM upsert_currency\n        |GROUP BY currency, TUMBLE(currency_time, INTERVAL '5' SECOND)\n        |")).stripMargin();
        Table table = this.tEnv().sqlQuery(sql);
        TableSchema schema = table.getSchema();
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), "MySink1", (List<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(Arrays.asList((Object[])schema.getFieldNames())).toList(), (List<DataType>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.getFieldDataTypes())).map((Function1 & Serializable & scala.Serializable)x$2 -> (DataType)x$2.nullable(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))).toList(), ChangelogMode.all(), TestSinkUtil$.MODULE$.addValuesSink$default$6());
        table.executeInsert("MySink1").await();
        Seq expected = (Seq)new .colon.colon((Object)"+I[US Dollar, 1, 104, 1970-01-01T00:00, 1970-01-01T00:00:05]", (List)new .colon.colon((Object)"+I[Yen, 1, 1, 1970-01-01T00:00, 1970-01-01T00:00:05]", (List)new .colon.colon((Object)"+I[Euro, 1, 118, 1970-01-01T00:00:15, 1970-01-01T00:00:20]", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("MySink1")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testWindowAggregateOnUpsertSourcePushdownWatermark() {
        this.env().setParallelism(1);
        String upsertSourceDataId = TestValuesTableFactory.registerData(this.upsertSourceCurrencyData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(621).append("\n                       |CREATE TABLE upsert_currency (\n                       |  currency STRING,\n                       |  currency_no STRING,\n                       |  rate  BIGINT,\n                       |  currency_time TIMESTAMP(3),\n                       |  WATERMARK FOR currency_time AS currency_time - interval '5' SECOND,\n                       |  PRIMARY KEY(currency) NOT ENFORCED\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'changelog-mode' = 'UA,D',\n                       |  'data-id' = '").append(upsertSourceDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |TUMBLE_START(currency_time, INTERVAL '5' SECOND) as w_start,\n        |TUMBLE_END(currency_time, INTERVAL '5' SECOND) as w_end,\n        |MAX(rate) AS max_rate\n        |FROM upsert_currency\n        |GROUP BY TUMBLE(currency_time, INTERVAL '5' SECOND)\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"1970-01-01T00:00,1970-01-01T00:00:05,702", (List)new .colon.colon((Object)"1970-01-01T00:00:15,1970-01-01T00:00:20,118", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testWindowAggregateOnRetractStream() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |`string`,\n        |TUMBLE_START(rowtime, INTERVAL '0.005' SECOND) as w_start,\n        |TUMBLE_END(rowtime, INTERVAL '0.005' SECOND) as w_end,\n        |COUNT(1) AS cnt\n        |FROM\n        | (\n        | SELECT `string`, rowtime\n        | FROM (\n        |  SELECT *,\n        |  ROW_NUMBER() OVER (PARTITION BY `string` ORDER BY rowtime DESC) as rowNum\n        |   FROM testTable\n        | )\n        | WHERE rowNum = 1\n        |)\n        |GROUP BY `string`, TUMBLE(rowtime, INTERVAL '0.005' SECOND)\n        |")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"Hi,1970-01-01T00:00,1970-01-01T00:00:00.005,1", (List)new .colon.colon((Object)"Hallo,1970-01-01T00:00,1970-01-01T00:00:00.005,1", (List)new .colon.colon((Object)"Hello,1970-01-01T00:00:00.005,1970-01-01T00:00:00.010,1", (List)new .colon.colon((Object)"Hello world,1970-01-01T00:00:00.015,1970-01-01T00:00:00.020,1", (List)new .colon.colon((Object)"null,1970-01-01T00:00:00.030,1970-01-01T00:00:00.035,1", (List)Nil$.MODULE$)))));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @TestTemplate
    public void testDistinctAggWithMergeOnEventTimeSessionGroupWindow() {
        if (this.useTimestampLtz) {
            return;
        }
        .colon.colon sessionWindowTestData = new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToInteger((int)2), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)3), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)9), (Object)"Hello World"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToInteger((int)1), (Object)"Hello"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)16L), (Object)BoxesRunTime.boxToInteger((int)16), (Object)"Hello"), (List)Nil$.MODULE$)))))));
        SingleOutputStreamOperator stream = this.failingDataSource(sessionWindowTestData, new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.sql.GroupWindowITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(new TimeTestUtil.TimestampAndWatermarkWithOffset(10L));
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions((DataStream)stream).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}));
        this.tEnv().createTemporaryView("MyTable", table);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c,\n        |   COUNT(DISTINCT b),\n        |   SESSION_END(rowtime, INTERVAL '0.005' SECOND)\n        |FROM MyTable\n        |GROUP BY c, SESSION(rowtime, INTERVAL '0.005' SECOND)\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream().addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)new .colon.colon((Object)"Hello World,1,1970-01-01T00:00:00.014", (List)new .colon.colon((Object)"Hello,1,1970-01-01T00:00:00.021", (List)new .colon.colon((Object)"Hello,3,1970-01-01T00:00:00.015", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void withLateFireDelay(TableConfig tableConfig, Duration interval) {
        long intervalInMillis = interval.toMillis();
        Duration lateFireDelay = tableConfig.getOptional(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY()).orElse(null);
        if (lateFireDelay != null && lateFireDelay.toMillis() != intervalInMillis) {
            throw new RuntimeException("Currently not support different lateFireInterval configs in one job");
        }
        tableConfig.set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        tableConfig.set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofMillis(intervalInMillis));
    }

    private LocalDateTime localDateTime(long epochSecond) {
        return LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC);
    }

    public static final /* synthetic */ String $anonfun$testEventTimeTumblingWindowWithAllowLateness$1(int x$1) {
        return new StringBuilder(1).append("f").append(x$1).toString();
    }

    public GroupWindowITCase(StreamingWithStateTestBase.StateBackendMode mode, boolean useTimestampLtz) {
        this.useTimestampLtz = useTimestampLtz;
        super(mode);
        this.SHANGHAI_ZONE = ZoneId.of("Asia/Shanghai");
        this.upsertSourceCurrencyData = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{TestValuesTableFactory.changelogRow("+U", "Euro", "no1", 114L, this.localDateTime(1L)), TestValuesTableFactory.changelogRow("+U", "US Dollar", "no1", 100L, this.localDateTime(1L)), TestValuesTableFactory.changelogRow("+U", "US Dollar", "no1", 102L, this.localDateTime(2L)), TestValuesTableFactory.changelogRow("+U", "Yen", "no1", 1L, this.localDateTime(3L)), TestValuesTableFactory.changelogRow("+U", "RMB", "no1", 702L, this.localDateTime(4L)), TestValuesTableFactory.changelogRow("+U", "Euro", "no1", 118L, this.localDateTime(18L)), TestValuesTableFactory.changelogRow("+U", "US Dollar", "no1", 104L, this.localDateTime(4L)), TestValuesTableFactory.changelogRow("-D", "RMB", "no1", 702L, this.localDateTime(4L))}));
    }
}

