/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.time.LocalDateTime;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I3Aa\u0002\u0005\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003BB\u001a\u0001A\u0003%a\u0005C\u0003B\u0001\u0011\u0005!\tC\u0003O\u0001\u0011\u0005!\tC\u0003Q\u0001\u0011\u0005!I\u0001\fGS2$XM]1cY\u0016\u001cv.\u001e:dK&#6)Y:f\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\rM$(/Z1n\u0015\tia\"A\u0004sk:$\u0018.\\3\u000b\u0005=\u0001\u0012a\u00029mC:tWM\u001d\u0006\u0003#I\tQ\u0001^1cY\u0016T!a\u0005\u000b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0019\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\t\u0003\u0005yV#\u0001\u0014\u0011\u0007\u001dbc&D\u0001)\u0015\tI#&A\u0005uKN$X\u000f^5mg*\u00111FE\u0001\u0005G>\u0014X-\u0003\u0002.Q\t\u0019R)Y2i\u0007\u0006dGNY1dW^\u0013\u0018\r\u001d9feB\u0011q&M\u0007\u0002a)\u0011Q\u0004E\u0005\u0003eA\u0012!\u0003T3hC\u000eL(k\\<FqR,gn]5p]\u0006\u0011q\f\t\u0015\u0003\u0007U\u0002\"AN \u000e\u0003]R!\u0001O\u001d\u0002\u0013\u0015DH/\u001a8tS>t'B\u0001\u001e<\u0003\r\t\u0007/\u001b\u0006\u0003yu\nqA[;qSR,'O\u0003\u0002?-\u0005)!.\u001e8ji&\u0011\u0001i\u000e\u0002\u0012%\u0016<\u0017n\u001d;fe\u0016CH/\u001a8tS>t\u0017A\u0005;fgR4\u0015\u000e\u001c;feB+8\u000f\u001b3po:$\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0005+:LG\u000f\u000b\u0002\u0005\u0015B\u00111\nT\u0007\u0002s%\u0011Q*\u000f\u0002\u0005)\u0016\u001cH/\u0001\fuKN$x+\u001b;i%\u0016TWm\u0019;fI\u001aKG\u000e^3sQ\t)!*\u0001\u0014uKN$\bK]8kK\u000e$x+\u001b;i/\u0006$XM]7be.4\u0015\u000e\u001c;feB+8\u000f\u001b3po:D#A\u0002&")
public class FilterableSourceITCase
extends StreamingTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testFilterPushdown() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(418).append("\n         | CREATE TABLE MyTable(\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   WATERMARK FOR c AS c\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'filterable-fields' = 'a;c;d',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String query = "SELECT * FROM MyTable WHERE a > 1";
        Seq expectedData = (Seq)new .colon.colon((Object)"2,3,2020-11-21T21:00:05.230", (List)Nil$.MODULE$);
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testWithRejectedFilter() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), LocalDateTime.parse("2020-11-21T19:00:05.23")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), LocalDateTime.parse("2020-11-21T21:00:05.23")})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(416).append("\n         | CREATE TABLE MyTable(\n         |   a INT,\n         |   b BIGINT,\n         |   c TIMESTAMP(3),\n         |   WATERMARK FOR c AS c\n         | ) WITH (\n         |   'connector' = 'values',\n         |   'enable-watermark-push-down' = 'true',\n         |   'filterable-fields' = 'c;d',\n         |   'bounded' = 'false',\n         |   'disable-lookup' = 'true',\n         |   'data-id' = '").append(dataId).append("'\n         | )\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String query = "SELECT * FROM MyTable WHERE a > 1";
        Seq expectedData = (Seq)new .colon.colon((Object)"2,3,2020-11-21T21:00:05.230", (List)Nil$.MODULE$);
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expectedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testProjectWithWatermarkFilterPushdown() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), "Hello", LocalDateTime.parse("2020-11-21T19:00:05.23")})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToLong((long)3L), "World", LocalDateTime.parse("2020-11-21T21:00:05.23")})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(432).append("\n         |CREATE TABLE TableWithWatermark (\n         |  a int,\n         |  b bigint,\n         |  c string,\n         |  d timestamp(3),\n         |  WATERMARK FOR d as d\n         |) WITH (\n         |  'connector' = 'values',\n         |  'filterable-fields' = 'c',\n         |  'enable-watermark-push-down' = 'true',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'false',\n         |  'disable-lookup' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select a,b from TableWithWatermark WHERE LOWER(c) = 'world'")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,3", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }
}

