/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.typeutils.Types$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendRowDataSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.MapDataSerializerTest;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\u0011\"\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004M\u0001\u0001\u0006Ia\u0010\u0005\u00065\u0002!\ta\u0017\u0005\u0006O\u0002!\ta\u0017\u0005\u0006S\u0002!\ta\u0017\u0005\u0006W\u0002!\ta\u0017\u0005\u0006[\u0002!\ta\u0017\u0005\u0006_\u0002!\ta\u0017\u0005\u0006c\u0002!\ta\u0017\u0005\u0006g\u0002!\ta\u0017\u0005\u0006k\u0002!\ta\u0017\u0005\u0006o\u0002!\ta\u0017\u0005\u0006s\u0002!\ta\u0017\u0005\u0006w\u0002!\ta\u0017\u0005\u0006{\u0002!\ta\u0017\u0005\u0006\u007f\u0002!\ta\u0017\u0005\u0007\u0003\u0007\u0001A\u0011A.\t\r\u0005\u001d\u0001\u0001\"\u0001\\\u0011\u0019\tY\u0001\u0001C\u00017\"1\u0011q\u0002\u0001\u0005\u0002mCa!a\u0005\u0001\t\u0003Y\u0006BBA\f\u0001\u0011\u00051\f\u0003\u0004\u0002\u001c\u0001!\ta\u0017\u0005\u0007\u0003?\u0001A\u0011A.\t\r\u0005\r\u0002\u0001\"\u0001\\\u0011\u0019\t9\u0003\u0001C\u00017\"1\u00111\u0006\u0001\u0005\u0002mCa!a\f\u0001\t\u0003Y\u0006BBA\u001a\u0001\u0011\u00051\f\u0003\u0004\u00028\u0001!\ta\u0017\u0002\u000b\u0007\u0006d7-\u0013+DCN,'B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\naa\u001d;sK\u0006l'B\u0001\u0014(\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001K\u0015\u0002\u000fAd\u0017M\u001c8fe*\u0011!fK\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003Y5\nQA\u001a7j].T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011C\u0001\u00014!\t!t'D\u00016\u0015\t1T%A\u0003vi&d7/\u0003\u00029k\t\t2\u000b\u001e:fC6Lgn\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005Y\u0004C\u0001\u001f\u0001\u001b\u0005\t\u0013!A0\u0016\u0003}\u00022\u0001Q#H\u001b\u0005\t%B\u0001\"D\u0003%!Xm\u001d;vi&d7O\u0003\u0002EW\u0005!1m\u001c:f\u0013\t1\u0015IA\nFC\u000eD7)\u00197mE\u0006\u001c7n\u0016:baB,'\u000f\u0005\u0002I\u00156\t\u0011J\u0003\u00027S%\u00111*\u0013\u0002\u0013\u0019\u0016<\u0017mY=S_^,\u0005\u0010^3og&|g.\u0001\u0002`A!\u00121A\u0014\t\u0003\u001fbk\u0011\u0001\u0015\u0006\u0003#J\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u0005M#\u0016aA1qS*\u0011QKV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9v&A\u0003kk:LG/\u0003\u0002Z!\n\t\"+Z4jgR,'/\u0012=uK:\u001c\u0018n\u001c8\u0002CQ,7\u000f^*fY\u0016\u001cGoV5uQ2+w-Y2z\u0007\u0006\u001cH/\u00138u)>$\u0015\r^3\u0015\u0003q\u0003\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013A!\u00168ji\"\u0012Aa\u0019\t\u0003I\u0016l\u0011AU\u0005\u0003MJ\u0013A\u0001V3ti\u0006\u0019C/Z:u\u0007\u0006\u001cHOT;nKJL7\rV8C_>dW-\u00198J]\u000e{g\u000eZ5uS>t\u0007FA\u0003d\u0003a!Xm\u001d;HK:,'/[2S_^\fe\u000e\u001a*po\u0012\u000bG/\u0019\u0015\u0003\r\r\f\u0011\u0003^3tiJ{w/\u00118e%><H)\u0019;bQ\t91-\u0001\u000buKN$x)\u001a8fe&\u001c'k\\<B]\u0012\u0014vn\u001e\u0015\u0003\u0011\r\fQ\u0002^3tiJ{w/\u00118e%><\bFA\u0005d\u0003Q!Xm\u001d;Qe&l\u0017\u000e^5wK6\u000b\u0007\u000fV=qK\"\u0012!bY\u0001\u0018i\u0016\u001cHOT8o!JLW.\u001b;jm\u0016l\u0015\r\u001d+za\u0016D#aC2\u0002;Q,7\u000f^*fY\u0016\u001cGo\u0015;be\u001a\u0013x.\u001c(fgR,G\rV1cY\u0016D#\u0001D2\u0002\rQ,7\u000f^%oQ\ti1-A\u0005uKN$hj\u001c;J]\"\u0012abY\u0001\u0017i\u0016\u001cH\u000fT8oOB\u0013xN[3di&|g\u000eT5ti\"\u0012qbY\u0001\u000fi\u0016\u001cH/\u00134Gk:\u001cG/[8oQ\t\u00012-\u0001\u0011uKN$8k\\;sG\u0016<\u0016\u000e\u001e5DkN$x.\\%oi\u0016\u0014h.\u00197ECR\f\u0007FA\td\u0003E!Xm\u001d;TS6\u0004H.\u001a)s_*,7\r\u001e\u0015\u0003%\r\f\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\t\u00192-\u0001\u0014uKN$H)Z2j[\u0006d\u0017I\u001d:bs^KG\u000f\u001b#jM\u001a,'/\u001a8u!J,7-[:j_:D#\u0001F2\u0002IQ,7\u000f\u001e#fG&l\u0017\r\\'ba^KG\u000f\u001b#jM\u001a,'/\u001a8u!J,7-[:j_:D#!F2\u0002)Q,7\u000f^\"veJ,g\u000e^,bi\u0016\u0014X.\u0019:lQ\t12-\u0001\u0016uKN$8)\u001e:sK:$x+\u0019;fe6\f'o\u001b$pe:{gNU8xi&lW-\u0011;ue&\u0014W\u000f^3)\u0005]\u0019\u0017a\n;fgR\u001cUO\u001d:f]R<\u0016\r^3s[\u0006\u00148nV5uQ>,H/\u00118z\u0003R$(/\u001b2vi\u0016D#\u0001G2\u0002MQ,7\u000f^\"sK\u0006$X\rV3na>\u0014\u0018M]=UC\ndWM\u0012:p[\u0012+7o\u0019:jaR|'\u000f\u000b\u0002\u001aG\u0006QA/Z:u'\u0016\f'o\u00195)\u0005i\u0019\u0017!\u0006;fgRlU\u000f\u001c;ja2,7i\\1mKN\u001cWm\u001d\u0015\u00037\r\f1\u0003^3ti\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016D#\u0001H2\u0002aQ,7\u000f\u001e'jW\u0016<\u0016\u000e\u001e5D_:$\u0017\u000e^5p]\u000e{g\u000e^1j]N$u.\u001e2mKF+x\u000e^1uS>tW*\u0019:lQ\ti2-\u0001\ruKN$hj\u001c8NKJ<W-\u00192mKJ\u000bg\u000eZ\"bY2D#AH2\u0002\u0015Q,7\u000f^%g\u001dVdG\u000e\u000b\u0002 G\u0002")
public class CalcITCase
extends StreamingTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testSelectWithLegacyCastIntToDate() {
        this.tEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR, (Object)ExecutionConfigOptions.LegacyCastBehaviour.ENABLED);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT CASE WHEN true THEN CAST(2 AS INT) ELSE CAST('2017-12-11' AS DATE) END")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1970-01-03", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCastNumericToBooleanInCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT * FROM MyTableRow WHERE b = CAST(1 AS BOOLEAN)\n         | UNION ALL\n         | SELECT * FROM MyTableRow WHERE b = CAST(0 AS BOOLEAN)\n         |")).stripMargin();
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData1.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToInteger((int)2));
        rowData2.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        .colon.colon data = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        InternalTypeInfo dataType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, dataType);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        this.tEnv().toDataStream(result, (AbstractDataType)outputType.getDataType()).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,true)", (List)new .colon.colon((Object)"+I(2,false)", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        this.tEnv().toDataStream(result, (AbstractDataType)outputType.getDataType()).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,1,1)", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, VarCharType.STRING_TYPE, new IntType()});
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        this.tEnv().toDataStream(result, (AbstractDataType)outputType.getDataType()).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(Hello,Worlds,1)", (List)new .colon.colon((Object)"+I(Hello again,Worlds,2)", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,1", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStreamSource ds = StreamingEnvUtil$.MODULE$.fromCollection(this.env(), data, tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Hello,Worlds,1", (List)new .colon.colon((Object)"Hello again,Worlds,2", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[b, 30, 10, a] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=30, 10=1}", (List)new .colon.colon((Object)"{2=30, 10=2}", (List)new .colon.colon((Object)"{2=30, 10=3}", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[a, c] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=Hi}", (List)new .colon.colon((Object)"{2=Hello}", (List)new .colon.colon((Object)"{3=Hello world}", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSelectStarFromNestedTable() {
        String sqlQuery = "SELECT * FROM MyTable";
        Table table = this.tEnv().fromDataStream(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), (Seq)new .colon.colon((Object)new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)"0"), (List)new .colon.colon((Object)new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)"1"), (List)new .colon.colon((Object)new Tuple2((Object)new Tuple2.mcII.sp(2, 2), (Object)"2"), (List)Nil$.MODULE$))), new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2"))}));
        this.tEnv().createTemporaryView("MyTable", table);
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestSinkUtil$.MODULE$.addValuesSink((TableEnvironment)this.tEnv(), "MySink", result, ChangelogMode.insertOnly());
        table.executeInsert("MySink").await();
        .colon.colon expected = new .colon.colon((Object)"0,0,0", (List)new .colon.colon((Object)"1,1,1", (List)new .colon.colon((Object)"2,2,2", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(TestValuesTableFactory.getResultsAsStrings("MySink")).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$11 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "4,3,Hello world, how are you?", "5,3,I am fine.", "6,3,Luke Skywalker", "7,4,Comment#1", "8,4,Comment#2", "9,4,Comment#3", "10,4,Comment#4", "11,5,Comment#5", "12,5,Comment#6", "13,5,Comment#7", "14,5,Comment#8", "15,5,Comment#9", "16,6,Comment#10", "17,6,Comment#11", "18,6,Comment#12", "19,6,Comment#13", "20,6,Comment#14", "21,6,Comment#15"}));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNotIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b not in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), TestData$.MODULE$.tupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$13 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLongProjectionList() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$15 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        String selectList = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> CalcITCase.$anonfun$testLongProjectionList$1(BoxesRunTime.unboxToInt((Object)i)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        String sqlQuery = new StringBuilder(20).append("select ").append(selectList).append(" from MyTable").toString();
        DataStream result2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result2.addSink((SinkFunction)sink);
        this.env().execute();
        String expected = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$1 -> CalcITCase.$anonfun$testLongProjectionList$2(BoxesRunTime.unboxToInt((Object)x$1)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        Assertions.assertThat((int)TestData$.MODULE$.smallTupleData3().size()).isEqualTo(sink.getAppendResults().size());
        sink.getAppendResults().foreach((Function1 & Serializable & scala.Serializable)result -> Assertions.assertThat((String)result).isEqualTo(expected));
    }

    @Test
    public void testIfFunction() {
        String testDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.data1());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(224).append("\n         |CREATE TABLE t (\n         |  a int,\n         |  b varchar,\n         |  c int\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(testDataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        .colon.colon expected = new .colon.colon((Object)"false,1", (List)new .colon.colon((Object)"false,2", (List)new .colon.colon((Object)"false,3", (List)new .colon.colon((Object)"true,4", (List)new .colon.colon((Object)"true,5", (List)new .colon.colon((Object)"true,6", (List)Nil$.MODULE$))))));
        List actual = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().executeSql("SELECT IF(a > 3, 'true', 'false'), a from t").collect()).map((Function1 & Serializable & scala.Serializable)r -> r.toString()).toList();
        Assertions.assertThat((Object)actual.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSourceWithCustomInternalData() {
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToLong((long)1L));
        rowData1.setField(1, (Object)CalcITCase.createMapData$1(1L, 2L));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToLong((long)2L));
        rowData2.setField(1, (Object)CalcITCase.createMapData$1(4L, 5L));
        .colon.colon values = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        String myTableDataId = TestValuesTableFactory.registerRowData((Seq<RowData>)values);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n         |CREATE TABLE CustomTable (\n         |  a bigint,\n         |  b map<bigint, bigint>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'register-internal-data' = 'true',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.env().getConfig().disableObjectReuse();
        this.tEnv().executeSql(ddl);
        TableResult result = this.tEnv().executeSql("select a, b from CustomTable");
        .colon.colon expected = new .colon.colon((Object)"1,{1=2}", (List)new .colon.colon((Object)"2,{4=5}", (List)Nil$.MODULE$));
        Buffer actual = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(CollectionUtil.iteratorToList((Iterator)result.collect())).map((Function1 & Serializable & scala.Serializable)r -> r.toString(), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertThat((Object)actual.sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleProject() {
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(233).append("\n         |CREATE TABLE SimpleTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select a, c from SimpleTable")).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,Hi", (List)new .colon.colon((Object)"2,Hello", (List)new .colon.colon((Object)"3,Hello world", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HI", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)111), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hi", BoxesRunTime.boxToInteger((int)1111)})), "tom"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)222), BoxesRunTime.boxToBoolean((boolean)false)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello", BoxesRunTime.boxToInteger((int)2222)})), "mary"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO WORLD", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)333), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello world", BoxesRunTime.boxToInteger((int)3333)})), "benji"})), (List)Nil$.MODULE$)));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(448).append("\n         |CREATE TABLE NestedTable (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'false',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |from NestedTable\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,HI,1111,true,111", (List)new .colon.colon((Object)"2,HELLO,2222,false,222", (List)new .colon.colon((Object)"3,HELLO WORLD,3333,true,333", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        String sqlQuery = "SELECT ARRAY[0.12, 0.5, 0.99]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"[0.12, 0.50, 0.99]", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        String sqlQuery = "SELECT Map['a', 0.12, 'b', 0.5]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{a=0.12, b=0.50}", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentWatermark() {
        Seq rows = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Instant.ofEpochSecond(644326662L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Instant.ofEpochSecond(1622466300L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Instant.ofEpochSecond(1622466300L)})), (List)Nil$.MODULE$)));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().getConfig().set("table.local-time-zone", "Europe/Berlin");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n                       |CREATE TABLE T (\n                       |  id INT,\n                       |  ts TIMESTAMP_LTZ(3),\n                       |  WATERMARK FOR ts AS ts\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().from("T").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.$("id"), org.apache.flink.table.api.package$.MODULE$.currentWatermark(org.apache.flink.table.api.package$.MODULE$.$("ts"))}).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result1), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT id, CURRENT_WATERMARK(ts) FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result2), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result3 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT id FROM T WHERE CURRENT_WATERMARK(ts) IS NULL OR ts > CURRENT_WATERMARK(ts)\n          |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result3), (String)new StringOps(Predef$.MODULE$.augmentString("1\n        |2\n        |")).stripMargin());
        List result4 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                  |SELECT\n                  |  TUMBLE_END(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |FROM T\n                  |GROUP BY\n                  |  TUMBLE(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result4), (String)new StringOps(Predef$.MODULE$.augmentString("1990-06-02T13:37:43,null\n        |2021-05-31T15:05:01,1990-06-02T11:37:42Z\n        |2021-05-31T15:05:01,2021-05-31T13:05:00Z\n        |")).stripMargin());
    }

    @Test
    public void testCurrentWatermarkForNonRowtimeAttribute() {
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Nil$.MODULE$));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                       |CREATE TABLE T (\n                       |  ts TIMESTAMP_LTZ(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        Assertions.assertThatThrownBy(() -> this.tEnv().sqlQuery("SELECT CURRENT_WATERMARK(ts) FROM T")).hasMessage("SQL validation failed. Invalid function call:\nCURRENT_WATERMARK(TIMESTAMP_LTZ(3))");
    }

    @Test
    public void testCurrentWatermarkWithoutAnyAttribute() {
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Nil$.MODULE$));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                       |CREATE TABLE T (\n                       |  ts TIMESTAMP_LTZ(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        Assertions.assertThatThrownBy(() -> this.tEnv().sqlQuery("SELECT ts, CURRENT_WATERMARK() FROM T")).hasMessage("SQL validation failed. From line 1, column 12 to line 1, column 30: No match found for function signature CURRENT_WATERMARK().\nSupported signatures are:\nCURRENT_WATERMARK(<TIMESTAMP_WITHOUT_TIME_ZONE *ROWTIME*>)\nCURRENT_WATERMARK(<TIMESTAMP_WITH_LOCAL_TIME_ZONE *ROWTIME*>)");
    }

    @Test
    public void testCreateTemporaryTableFromDescriptor() {
        Seq rows = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42)})), (List)Nil$.MODULE$);
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().createTemporaryTable("T", TableDescriptor.forConnector((String)"values").schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build()).option("data-id", tableId).option("bounded", "true").build());
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT * FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"42");
    }

    @Test
    public void testSearch() {
        DataStreamSource stream = this.env().fromElements((Object[])new String[]{"HC809", "H389N     "});
        this.tEnv().createTemporaryView("SimpleTable", (DataStream)stream, Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT upper(f0) from SimpleTable where upper(f0) in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"HC809", (List)new .colon.colon((Object)"H389N     ", (List)Nil$.MODULE$));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultipleCoalesces() {
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT COALESCE(1),\nCOALESCE(1, 2),\nCOALESCE(cast(NULL as int), 2),\nCOALESCE(1, cast(NULL as int)),\nCOALESCE(cast(NULL as int), cast(NULL as int), 3),\nCOALESCE(4, cast(NULL as int), cast(NULL as int), cast(NULL as int)),\nCOALESCE('1'),\nCOALESCE('1', '23'),\nCOALESCE(cast(NULL as varchar), '2'),\nCOALESCE('1', cast(NULL as varchar)),\nCOALESCE(cast(NULL as varchar), cast(NULL as varchar), '3'),\nCOALESCE('4', cast(NULL as varchar), cast(NULL as varchar), cast(NULL as varchar)),\nCOALESCE(1.0),\nCOALESCE(1.0, 2),\nCOALESCE(cast(NULL as double), 2.0),\nCOALESCE(cast(NULL as double), 2.0, 3.0),\nCOALESCE(2.0, cast(NULL as double), 3.0),\nCOALESCE(cast(NULL as double), cast(NULL as double))").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"1,1,2,1,3,4,1,1,2,1,3,4,1.0,1.0,2.0,2.0,2.0,null");
    }

    @Test
    public void testCurrentDatabase() {
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assertions.assertThat((Object)result1).isEqualTo((Object)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()})), (List)Nil$.MODULE$));
        ((Catalog)this.tEnv().getCatalog(this.tEnv().getCurrentCatalog()).get()).createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), "db1"), false);
        this.tEnv().useDatabase("db1");
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assertions.assertThat((Object)result2).isEqualTo((Object)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()})), (List)Nil$.MODULE$));
    }

    @Test
    public void testLikeWithConditionContainsDoubleQuotationMark() {
        Seq rows = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42), "abc"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "cbc\"ddd"})), (List)Nil$.MODULE$));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |CREATE TABLE MyTable (\n         |  a int,\n         |  b string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                  | SELECT * FROM MyTable WHERE b LIKE '%\"%'\n                  |")).stripMargin())).toDataStream();
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,cbc\"ddd", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonMergeableRandCall() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(StreamingEnvUtil$.MODULE$.fromCollection(this.env(), TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$17 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("SimpleTable", t);
        Table result = this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                   |SELECT b - a FROM (\n                   |  SELECT r + 5 AS a, r + 7 AS b FROM (\n                   |    SELECT RAND() AS r FROM SimpleTable\n                   |  ) t1\n                   |) t2\n                   |")).stripMargin());
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result, (AbstractDataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.DOUBLE()})).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2.0", (List)new .colon.colon((Object)"2.0", (List)new .colon.colon((Object)"2.0", (List)Nil$.MODULE$)));
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testIfNull() {
        Table result = this.tEnv().sqlQuery("SELECT IFNULL(JSON_VALUE('{\"a\":16}','$.a'),'0')");
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toDataStream(result, (AbstractDataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING()})).addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"16", (List)Nil$.MODULE$);
        Assertions.assertThat((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$1(int i) {
        return new StringBuilder(67).append("CASE WHEN a IS NOT NULL AND a > ").append(i).append(" THEN 0 WHEN a < 0 THEN 0 ELSE ").append(i).append(" END").toString();
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$2(int x$1) {
        return Integer.toString(x$1);
    }

    private static final MapData createMapData$1(long k, long v) {
        HashMap<Long, Long> mapData = new HashMap<Long, Long>();
        mapData.put(BoxesRunTime.boxToLong((long)k), BoxesRunTime.boxToLong((long)v));
        return new MapDataSerializerTest.CustomMapData(mapData);
    }
}

