/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.Func18$;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.runtime.batch.table.CorrelateITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.table.planner.utils.HierarchyTableFunction;
import org.apache.flink.table.planner.utils.PojoTableFunc;
import org.apache.flink.table.planner.utils.RichTableFunc1;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.planner.utils.TableFunc3;
import org.apache.flink.table.planner.utils.TableFunc4;
import org.apache.flink.table.planner.utils.VarArgsFunc0;
import org.apache.flink.table.utils.LegacyRowExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\r\u001a\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004D\u0001\u0001\u0006IA\u000e\u0005\u0006#\u0002!\tA\u0015\u0005\u0006=\u0002!\tA\u0015\u0005\u0006A\u0002!\tA\u0015\u0005\u0006E\u0002!\tA\u0015\u0005\u0006I\u0002!\tA\u0015\u0005\u0006M\u0002!\tA\u0015\u0005\u0006Q\u0002!\tA\u0015\u0005\u0006U\u0002!\tA\u0015\u0005\u0006Y\u0002!\tA\u0015\u0005\u0006]\u0002!\tA\u0015\u0005\u0006a\u0002!\tA\u0015\u0005\u0006e\u0002!\tA\u0015\u0005\u0006i\u0002!\tA\u0015\u0005\u0006m\u0002!\tA\u0015\u0005\u0006q\u0002!\tA\u0015\u0005\u0006u\u0002!\tA\u0015\u0005\u0006y\u0002!\tA\u0015\u0005\u0006}\u0002!\tA\u0015\u0005\u0007\u0003\u0003\u0001A\u0011\u0001*\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\ty1i\u001c:sK2\fG/Z%U\u0007\u0006\u001cXM\u0003\u0002\u001b7\u0005)A/\u00192mK*\u0011A$H\u0001\u0006E\u0006$8\r\u001b\u0006\u0003=}\tqA];oi&lWM\u0003\u0002!C\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u000e#\u0015\t\u0019C%A\u0003gY&t7N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R!!L\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005=b#!\u0004\"bi\u000eDG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u00023\u0005\tq,F\u00017!\r9DHP\u0007\u0002q)\u0011\u0011HO\u0001\ni\u0016\u001cH/\u001e;jYNT!a\u000f\u0012\u0002\t\r|'/Z\u0005\u0003{a\u00121#R1dQ\u000e\u000bG\u000e\u001c2bG.<&/\u00199qKJ\u0004\"aP!\u000e\u0003\u0001S!!L\u0011\n\u0005\t\u0003%A\u0005'fO\u0006\u001c\u0017PU8x\u000bb$XM\\:j_:\f!a\u0018\u0011)\u0005\r)\u0005C\u0001$P\u001b\u00059%B\u0001%J\u0003%)\u0007\u0010^3og&|gN\u0003\u0002K\u0017\u0006\u0019\u0011\r]5\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001d\u001a\nQA[;oSRL!\u0001U$\u0003#I+w-[:uKJ,\u0005\u0010^3og&|g.A\u0007uKN$8I]8tg*{\u0017N\u001c\u000b\u0002'B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n!QK\\5uQ\t!!\f\u0005\u0002\\96\t\u0011*\u0003\u0002^\u0013\n!A+Z:u\u0003\t\"Xm\u001d;MK\u001a$x*\u001e;fe*{\u0017N\\,ji\"|W\u000f\u001e)sK\u0012L7-\u0019;fg\"\u0012QAW\u0001\u001bi\u0016\u001cH\u000fT3gi>+H/\u001a:K_&tw+\u001b;i'Bd\u0017\u000e\u001e\u0015\u0003\ri\u000bq\u0004^3ti2+g\r^(vi\u0016\u0014(j\\5o/&$\b\u000e\u0015:fI&\u001c\u0017\r^3tQ\t9!,\u0001\buKN$x+\u001b;i\r&dG/\u001a:)\u0005!Q\u0016\u0001\u0006;fgR\u001cUo\u001d;p[J+G/\u001e:o)f\u0004X\r\u000b\u0002\n5\u0006\tB/Z:u\u0011&,'/\u0019:dQf$\u0016\u0010]3)\u0005)Q\u0016\u0001\u0004;fgR\u0004vN[8UsB,\u0007FA\u0006[\u00039\"Xm\u001d;Vg\u0016\u0014H)\u001a4j]\u0016$G+\u00192mK\u001a+hn\u0019;j_:<\u0016\u000e\u001e5TG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8)\u00051Q\u0016!\u000f;fgR,6/\u001a:EK\u001aLg.\u001a3UC\ndWMR;oGRLwN\\,ji\"\u001c6-\u00197be\u001a+hn\u0019;j_:LenQ8oI&$\u0018n\u001c8)\u00055Q\u0016\u0001\u0007;fgRduN\\4B]\u0012$V-\u001c9pe\u0006dG+\u001f9fg\"\u0012aBW\u0001\u001ci\u0016\u001cHOQ=uKNCwN\u001d;GY>\fG/\u0011:hk6,g\u000e^:)\u0005=Q\u0016!\u000b;fgR,6/\u001a:EK\u001aLg.\u001a3UC\ndWMR;oGRLwN\\,ji\"\u0004\u0016M]1nKR,'\u000f\u000b\u0002\u00115\u0006aD/Z:u+N,'\u000fR3gS:,G\rV1cY\u00164UO\\2uS>tw+\u001b;i'\u000e\fG.\u0019:Gk:\u001cG/[8o/&$\b\u000eU1sC6,G/\u001a:tQ\t\t\",\u0001\u0014uKN$H+\u00192mK\u001a+hn\u0019;j_:\u001cuN\\:ueV\u001cGo\u001c:XSRD\u0007+\u0019:b[ND#A\u0005.\u0002MQ,7\u000f\u001e+bE2,g)\u001e8di&|gnV5uQZ\u000b'/[1cY\u0016\f%oZ;nK:$8\u000f\u000b\u0002\u00145\u0006AB/Z:u\u0007>,h\u000e^*uCJ|enQ8se\u0016d\u0017\r^3)\u0005QQ\u0016\u0001\b;fgR\u001cu.\u001e8u'R\f'o\u00148MK\u001a$8i\u001c:sK2\fG/\u001a\u0015\u0003+i\u000b1\u0005^3tiR\u000b'\r\\3Gk:\u001cG/[8o\u0007>dG.Z2u_J|\u0005/\u001a8DY>\u001cX\r\u000b\u0002\u00175\u0006AA/Z:u\t\u0006$\u0018-\u0006\u0002\u0002\nA!\u00111BA\b\u001b\t\tiA\u0003\u0002KC%!\u0011\u0011CA\u0007\u0005\u0015!\u0016M\u00197f\u0001")
public class CorrelateITCase
extends BatchTestBase {
    @RegisterExtension
    private final EachCallbackWrapper<LegacyRowExtension> _ = new EachCallbackWrapper((CustomExtension)new LegacyRowExtension());

    private EachCallbackWrapper<LegacyRowExtension> _() {
        return this._;
    }

    @Test
    public void testCrossJoin() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc1 func1 = new TableFunc1();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack\nJack#22,22\nJohn#19,John\nJohn#19,19\nAnna#44,Anna\nAnna#44,44\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
        Table result2 = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.string2Literal("$")}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results2 = this.executeQuery(result2);
        String expected2 = "Jack#22,$Jack\nJack#22,$22\nJohn#19,$John\nJohn#19,$19\nAnna#44,$Anna\nAnna#44,$44\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results2).asJava()), (String)expected2);
    }

    @Test
    public void testLeftOuterJoinWithoutPredicates() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,4\nJack#22,22,2\nJohn#19,John,4\nJohn#19,19,2\nAnna#44,Anna,4\nAnna#44,44,2\nnosharp,null,null";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftOuterJoinWithSplit() {
        this.tEnv().getConfig().setMaxGeneratedCodeLength(Predef$.MODULE$.int2Integer(1));
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,4\nJack#22,22,2\nJohn#19,John,4\nJohn#19,19,2\nAnna#44,Anna,4\nAnna#44,44,2\nnosharp,null,null";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftOuterJoinWithPredicates() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Assertions.assertThatThrownBy(() -> {
            Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
            Seq<Row> results = this.executeQuery(result);
            String expected = "John#19,19,2\nnosharp,null,null";
            TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
        }).isInstanceOf(ValidationException.class);
    }

    @Test
    public void testWithFilter() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "age")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}).filter(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")).$greater(package$.MODULE$.int2Literal(20)));
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,22\nAnna#44,Anna,44\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCustomReturnType() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc2 func2 = new TableFunc2();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "len")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,4\nJack#22,22,2\nJohn#19,John,4\nJohn#19,19,2\nAnna#44,Anna,4\nAnna#44,44,2\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testHierarchyType() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        HierarchyTableFunction hierarchy = new HierarchyTableFunction();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)hierarchy).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "adult"), SymbolLiteral.bootstrap("apply", "len")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "adult")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "len"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,true,22\nJohn#19,John,false,19\nAnna#44,Anna,true,44\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testPojoType() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        PojoTableFunc pojo = new PojoTableFunc();
        Table result = in.joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)pojo).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,22\nAnna#44,Anna,44\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunction() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc1 func1 = new TableFunc1();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).substring((Object)package$.MODULE$.int2Literal(2))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,ack\nJack#22,22\nJohn#19,ohn\nJohn#19,19\nAnna#44,nna\nAnna#44,44\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionInCondition() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).where(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func18$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.string2Literal("J")}))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func1$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).$less(package$.MODULE$.int2Literal(3)))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func1$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))}))).$greater(package$.MODULE$.int2Literal(20)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Jack#22,Jack,22";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLongAndTemporalTypes() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        JavaUserDefinedTableFunctions.JavaTableFunc0 func0 = new JavaUserDefinedTableFunctions.JavaTableFunc0();
        Table result = in.where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.int2Literal(1))).select(new Expression[]{package$.MODULE$.LiteralSqlDateExpression(Date.valueOf("1990-10-14")).as((Symbol)SymbolLiteral.bootstrap("apply", "x"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.LiteralLongExpression(1000L).as((Symbol)SymbolLiteral.bootstrap("apply", "y"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.LiteralSqlTimestampExpression(Timestamp.valueOf("1990-10-14 12:10:10")).as((Symbol)SymbolLiteral.bootstrap("apply", "z"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "1000\n655906210000\n7591\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testByteShortFloatArguments() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc4 tFunc = new TableFunc4();
        Table result = in.select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.TINYINT())).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.SMALLINT())).as((Symbol)SymbolLiteral.bootstrap("apply", "b"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast(DataTypes.FLOAT())).as((Symbol)SymbolLiteral.bootstrap("apply", "c"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tFunc).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).ifNull((Object)package$.MODULE$.byte2Literal((byte)0)), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).ifNull((Object)package$.MODULE$.short2Literal((short)0)), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).ifNull((Object)package$.MODULE$.float2Literal(0.0f))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "a2"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "b2"), SymbolLiteral.bootstrap("apply", "c2")})));
        Seq<Row> results = this.executeQuery(result);
        String expected = ((TraversableOnce)new .colon.colon((Object)"1,1,1.0,Byte=1,Short=1,Float=1.0", (List)new .colon.colon((Object)"2,2,2.0,Byte=2,Short=2,Float=2.0", (List)new .colon.colon((Object)"3,3,2.0,Byte=3,Short=3,Float=2.0", (List)new .colon.colon((Object)"4,4,3.0,Byte=4,Short=4,Float=3.0", (List)Nil$.MODULE$))))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithParameter() {
        RichTableFunc1 richTableFunc1 = new RichTableFunc1();
        this.tEnv().createTemporarySystemFunction("RichTableFunc1", (UserDefinedFunction)richTableFunc1);
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)"#")}))));
        Table result = this.testData().joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)richTableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        String expected = "1,Jack\n1,22\n2,John\n2,19\n3,Anna\n3,44";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionWithParameters() {
        RichTableFunc1 richTableFunc1 = new RichTableFunc1();
        this.tEnv().createTemporarySystemFunction("RichTableFunc1", (UserDefinedFunction)richTableFunc1);
        RichFunc2 richFunc2 = new RichFunc2();
        this.tEnv().createTemporarySystemFunction("RichFunc2", (UserDefinedFunction)richFunc2);
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)"#"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"test")}))));
        Table result = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c").joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)richTableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.ScalarFunctionCall((ScalarFunction)richFunc2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        String expected = "1,Hi\n1,test\n2,Hello\n2,test\n3,Hello world\n3,test";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableFunctionConstructorWithParams() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc3 func30 = new TableFunc3(null);
        TableFunc3 func31 = new TableFunc3("OneConf_");
        TableFunc3 func32 = new TableFunc3("TwoConf_");
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func30).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func31).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "f"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "g")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func32).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "h"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "i")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))});
        Seq<Row> results = this.executeQuery(result);
        String expected = "Anna#44,Anna,OneConf_Anna,TwoConf_Anna,44,44,44\nJack#22,Jack,OneConf_Jack,TwoConf_Jack,22,22,22\nJohn#19,John,OneConf_John,TwoConf_John,19,19,19\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableFunctionWithVariableArguments() {
        VarArgsFunc0 varArgsFunc0 = new VarArgsFunc0();
        this.tEnv().createTemporarySystemFunction("VarArgsFunc0", (UserDefinedFunction)varArgsFunc0);
        Table result = this.testData().select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("1"), package$.MODULE$.string2Literal("2"), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
        String expected = "Anna#44,1\nAnna#44,2\nAnna#44,Anna#44\nJack#22,1\nJack#22,2\nJack#22,Jack#22\nJohn#19,1\nJohn#19,2\nJohn#19,John#19\nnosharp,1\nnosharp,2\nnosharp,nosharp";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
        Table result0 = this.testData().select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Nil$.MODULE$));
        Seq<Row> results0 = this.executeQuery(result0);
        Assertions.assertThat((boolean)results0.isEmpty()).isTrue();
    }

    @Test
    public void testCountStarOnCorrelate() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "age")}))).select(new Expression[]{(Expression)package$.MODULE$.LiteralIntExpression(0).count()});
        Seq<Row> results = this.executeQuery(result);
        String expected = "3";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCountStarOnLeftCorrelate() {
        Table in = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        Table result = in.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "age")}))).select(new Expression[]{(Expression)package$.MODULE$.LiteralIntExpression(0).count()});
        Seq<Row> results = this.executeQuery(result);
        String expected = "4";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableFunctionCollectorOpenClose() {
        Table t = this.testData().as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        FuncWithOpen func = new FuncWithOpen();
        Table result = t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)func).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))});
        Seq<Row> results = this.executeQuery(result);
        Seq expected = (Seq)new .colon.colon((Object)"Jack#22,Jack,22", (List)new .colon.colon((Object)"John#19,John,19", (List)new .colon.colon((Object)"Anna#44,Anna,44", (List)Nil$.MODULE$)));
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)((TraversableOnce)expected.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"));
    }

    private Table testData() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"));
        return BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.table.CorrelateITCase$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

