/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.batch.sql.join.SemiJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002\u001d:\u00011CQa\u0015\u0001\u0005\u0002QC\u0011b\u0016\u0001A\u0002\u0003\u0007I\u0011\u0001-\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00031\b\"C@\u0001\u0001\u0004\u0005\t\u0015)\u0003Z\u0011\u001d\tY\u0002\u0001C!\u0003;Aq!a\r\u0001\t\u0003\ti\u0002C\u0004\u0002>\u0001!\t!!\b\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002\u001e!9\u0011Q\t\u0001\u0005\u0002\u0005u\u0001bBA%\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003\u001b\u0002A\u0011AA\u000f\u0011\u001d\t\t\u0006\u0001C\u0001\u0003;Aq!!\u0016\u0001\t\u0003\ti\u0002C\u0004\u0002Z\u0001!\t!!\b\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\u001e!9\u0011\u0011\r\u0001\u0005\u0002\u0005u\u0001bBA3\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003S\u0002A\u0011AA\u000f\u0011\u001d\ti\u0007\u0001C\u0001\u0003;Aq!!\u001d\u0001\t\u0003\ti\u0002C\u0004\u0002v\u0001!\t!!\b\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\u001e!9\u0011Q\u0010\u0001\u0005\u0002\u0005u\u0001bBAA\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003\u000b\u0003A\u0011AA\u000f\u0011\u001d\tI\t\u0001C\u0001\u0003;Aq!!$\u0001\t\u0003\ti\u0002C\u0004\u0002\u0012\u0002!\t!!\b\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005u\u0001bBAO\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003C\u0003A\u0011AA\u000f\u0011\u001d\t)\u000b\u0001C\u0001\u0003;Aq!!+\u0001\t\u0003\ti\u0002C\u0004\u0002.\u0002!\t!!\b\t\u000f\u0005E\u0006\u0001\"\u0001\u0002\u001e!9\u0011Q\u0017\u0001\u0005\u0002\u0005u\u0001bBA]\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003{\u0003A\u0011AA\u000f\u0011\u001d\t\t\r\u0001C\u0001\u0003;Aq!!2\u0001\t\u0003\ti\u0002C\u0004\u0002J\u0002!\t!!\b\t\u000f\u00055\u0007\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u001b\u0001\u0005\u0002\u0005u\u0001bBAk\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u00033\u0004A\u0011AA\u000f\u0011\u001d\ti\u000e\u0001C\u0001\u0003;Aq!!9\u0001\t\u0003\tibB\u0004\u0002\u0000fB\tA!\u0001\u0007\raJ\u0004\u0012\u0001B\u0002\u0011\u0019\u0019&\u0007\"\u0001\u0003\f!9!Q\u0002\u001a\u0005\u0002\t=\u0001B\u0003B\u001be!\u0015\r\u0011\"\u0001\u00038!Q!\u0011\u000b\u001a\t\u0006\u0004%\tAa\u000e\t\u0015\tM#\u0007#b\u0001\n\u0003\u00119D\u0001\bTK6L'j\\5o\u0013R\u001b\u0015m]3\u000b\u0005iZ\u0014\u0001\u00026pS:T!\u0001P\u001f\u0002\u0007M\fHN\u0003\u0002?\u007f\u0005)!-\u0019;dQ*\u0011\u0001)Q\u0001\beVtG/[7f\u0015\t\u00115)A\u0004qY\u0006tg.\u001a:\u000b\u0005\u0011+\u0015!\u0002;bE2,'B\u0001$H\u0003\u00151G.\u001b8l\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\u0004\u0001M\u0011\u0001!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!~\nQ!\u001e;jYNL!AU(\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\u000b\u0005\u0002W\u00015\t\u0011(\u0001\tfqB,7\r^3e\u0015>Lg\u000eV=qKV\t\u0011\f\u0005\u0002[e:\u00111\f\u001d\b\u00039>t!!\u00188\u000f\u0005ykgBA0m\u001d\t\u00017N\u0004\u0002bU:\u0011!-\u001b\b\u0003G\"t!\u0001Z4\u000e\u0003\u0015T!AZ&\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0015B\u0001%J\u0013\t1u)\u0003\u0002E\u000b&\u0011!iQ\u0005\u0003\u0001\u0006K!AP \n\u0005qj\u0014B\u0001\u001e<\u0013\t\t\u0018(\u0001\u0005K_&tG+\u001f9f\u0013\t\u0019HO\u0001\u0005K_&tG+\u001f9f\u0015\t\t\u0018(\u0001\u000bfqB,7\r^3e\u0015>Lg\u000eV=qK~#S-\u001d\u000b\u0003ov\u0004\"\u0001_>\u000e\u0003eT\u0011A_\u0001\u0006g\u000e\fG.Y\u0005\u0003yf\u0014A!\u00168ji\"9apAA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005\tR\r\u001f9fGR,GMS8j]RK\b/\u001a\u0011)\u0007\u0011\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005]QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u001bA\f'/Y7fi\u0016\u0014\u0018N_3e\u0015\u0011\ti!a\u0004\u0002\u0015\u0015DH/\u001a8tS>t7O\u0003\u0003\u0002\u0012\u0005M\u0011!\u00026v]&$(bAA\u000b\u000b\u0006IA/Z:ukRLGn]\u0005\u0005\u00033\t9AA\u0005QCJ\fW.\u001a;fe\u00061!-\u001a4pe\u0016$\u0012a\u001e\u0015\u0004\u000b\u0005\u0005\u0002\u0003BA\u0012\u0003_i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0004CBL'\u0002BA\u0016\u0003[\tqA[;qSR,'OC\u0002\u0002\u0012%KA!!\r\u0002&\tQ!)\u001a4pe\u0016,\u0015m\u00195\u00027Q,7\u000f^*j]\u001edWmQ8oI&$\u0018n\u001c8MK\u001a$8+Z7jQ\r1\u0011q\u0007\t\u0005\u0003G\tI$\u0003\u0003\u0002<\u0005\u0015\"\u0001\u0004+fgR$V-\u001c9mCR,\u0017!\b;fgR\u001cu.\u001c9pg\u0016$7i\u001c8eSRLwN\u001c'fMR\u001cV-\\5)\u0007\u001d\t9$A\u000euKN$8+\u001b8hY\u0016\u001cuN\u001c3ji&|g\u000eT3gi\u0006sG/\u001b\u0015\u0004\u0011\u0005]\u0012!\t;fgR\u001c\u0016N\\4mKVs\u0017.];f\u0007>tG-\u001b;j_:dUM\u001a;B]RL\u0007fA\u0005\u00028\u0005iB/Z:u\u0007>l\u0007o\\:fI\u000e{g\u000eZ5uS>tG*\u001a4u\u0003:$\u0018\u000eK\u0002\u000b\u0003o\t1\u0005^3ti\u000e{W\u000e]8tK\u0012,f.[9vK\u000e{g\u000eZ5uS>tG*\u001a4u\u0003:$\u0018\u000eK\u0002\f\u0003o\tQ\u0003^3tiN+W.\u001b&pS:$&/\u00198ta>\u001cX\rK\u0002\r\u0003o\t1\u0004^3ti\u001aKG\u000e^3s!V\u001c\b\u000eR8x]2+g\r^*f[&\f\u0004fA\u0007\u00028\u0005YB/Z:u\r&dG/\u001a:QkNDGi\\<o\u0019\u00164GoU3nSJB3ADA\u001c\u0003m!Xm\u001d;GS2$XM\u001d)vg\"$un\u001e8MK\u001a$8+Z7jg!\u001aq\"a\u000e\u0002EQ,7\u000f\u001e&pS:\u001cuN\u001c3ji&|g\u000eU;tQ\u0012{wO\u001c'fMR\u001cV-\\52Q\r\u0001\u0012qG\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3giN+W.\u001b\u001a)\u0007E\t9$\u0001\u0012uKN$(j\\5o\u0007>tG-\u001b;j_:\u0004Vo\u001d5E_^tG*\u001a4u'\u0016l\u0017n\r\u0015\u0004%\u0005]\u0012a\u0007;fgR4\u0015\u000e\u001c;feB+8\u000f\u001b#po:dUM\u001a;B]RL\u0017\u0007K\u0002\u0014\u0003o\t1\u0004^3ti\u001aKG\u000e^3s!V\u001c\b\u000eR8x]2+g\r^!oi&\u0014\u0004f\u0001\u000b\u00028\u0005YB/Z:u\r&dG/\u001a:QkNDGi\\<o\u0019\u00164G/\u00118uSNB3!FA\u001c\u0003m!Xm\u001d;GS2$XM\u001d)vg\"$un\u001e8MK\u001a$\u0018I\u001c;ji!\u001aa#a\u000e\u0002EQ,7\u000f\u001e&pS:\u001cuN\u001c3ji&|g\u000eU;tQ\u0012{wO\u001c'fMR\fe\u000e^52Q\r9\u0012qG\u0001#i\u0016\u001cHOS8j]\u000e{g\u000eZ5uS>t\u0007+^:i\t><h\u000eT3gi\u0006sG/\u001b\u001a)\u0007a\t9$\u0001\u0012uKN$(j\\5o\u0007>tG-\u001b;j_:\u0004Vo\u001d5E_^tG*\u001a4u\u0003:$\u0018n\r\u0015\u00043\u0005]\u0012A\t;fgRTu.\u001b8D_:$\u0017\u000e^5p]B+8\u000f\u001b#po:dUM\u001a;B]RLG\u0007K\u0002\u001b\u0003o\tA\u0003^3ti&sw+\u001b;i\u0003\u001e<'/Z4bi\u0016\f\u0004fA\u000e\u00028\u0005!B/Z:u\u0013:<\u0016\u000e\u001e5BO\u001e\u0014XmZ1uKJB3\u0001HA\u001c\u0003Q!Xm\u001d;J]^KG\u000f[!hOJ,w-\u0019;fg!\u001aQ$a\u000e\u0002\u001fQ,7\u000f^%o/&$\bn\u0014<feFB3AHA\u001c\u0003=!Xm\u001d;J]^KG\u000f[(wKJ\u0014\u0004fA\u0010\u00028\u0005yA/Z:u\u0013:<\u0016\u000e\u001e5Pm\u0016\u00148\u0007K\u0002!\u0003o\tq\u0002^3ti&sw+\u001b;i\u001fZ,'\u000f\u000e\u0015\u0004C\u0005]\u0012a\u0005;fgR,\u00050[:ug^KG\u000f[(wKJ\f\u0004f\u0001\u0012\u00028\u0005\u0019B/Z:u\u000bbL7\u000f^:XSRDwJ^3se!\u001a1%a\u000e\u0002'Q,7\u000f^#ySN$8oV5uQ>3XM]\u001a)\u0007\u0011\n9$A\nuKN$X\t_5tiN<\u0016\u000e\u001e5Pm\u0016\u0014H\u0007K\u0002&\u0003o\t!\u0006^3ti&sw+\u001b;i\u001d>tW)];bY&$\u0018pQ8se\u0016d\u0017\r^5p]\u000e{g\u000eZ5uS>t\u0017\u0007K\u0002'\u0003o\t!\u0006^3ti&sw+\u001b;i\u001d>tW)];bY&$\u0018pQ8se\u0016d\u0017\r^5p]\u000e{g\u000eZ5uS>t'\u0007K\u0002(\u0003o\t!\u0006^3ti&sw+\u001b;i\u001d>tW)];bY&$\u0018pQ8se\u0016d\u0017\r^5p]\u000e{g\u000eZ5uS>t7\u0007K\u0002)\u0003o\t!\u0006^3ti&sw+\u001b;i\u001d>tW)];bY&$\u0018pQ8se\u0016d\u0017\r^5p]\u000e{g\u000eZ5uS>tG\u0007K\u0002*\u0003o\tQ\u0006^3ti\u0016C\u0018n\u001d;t/&$\bNT8o\u000bF,\u0018\r\\5us\u000e{'O]3mCRLwN\\\"p]\u0012LG/[8oQ\rQ\u0013qG\u0001*i\u0016\u001cHOU3xe&$XmU2bY\u0006\u0014\u0018+^3ss^KG\u000f[8vi\u000e{'O]3mCRLwN\\\u0019)\u0007-\n9$A\u0015uKN$(+Z<sSR,7kY1mCJ\fV/\u001a:z/&$\bn\\;u\u0007>\u0014(/\u001a7bi&|gN\r\u0015\u0004Y\u0005]\u0012!\u000b;fgR\u0014Vm\u001e:ji\u0016\u001c6-\u00197beF+XM]=XSRDw.\u001e;D_J\u0014X\r\\1uS>t7\u0007K\u0002.\u0003o\ta\u0005^3tiJ+wO]5uKN\u001b\u0017\r\\1s#V,'/_,ji\"\u001cuN\u001d:fY\u0006$\u0018n\u001c82Q\rq\u0013qG\u0001'i\u0016\u001cHOU3xe&$XmU2bY\u0006\u0014\u0018+^3ss^KG\u000f[\"peJ,G.\u0019;j_:\u0014\u0004fA\u0018\u00028\u00051C/Z:u%\u0016<(/\u001b;f'\u000e\fG.\u0019:Rk\u0016\u0014\u0018pV5uQ\u000e{'O]3mCRLwN\\\u001a)\u0007A\n9\u0004K\u0004\u0001\u0003O\f\u00190!>\u0011\t\u0005%\u0018q^\u0007\u0003\u0003WTA!!<\u0002&\u0005IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003c\fYO\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#!a>$\u0005\u0005e\b\u0003BA\u0003\u0003wLA!!@\u0002\b\tQ\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;FqR,gn]5p]\u0006q1+Z7j\u0015>Lg.\u0013+DCN,\u0007C\u0001,3'\r\u0011$Q\u0001\t\u0004q\n\u001d\u0011b\u0001B\u0005s\n1\u0011I\\=SK\u001a$\"A!\u0001\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0003\u0012A1!1\u0003B\u000f\u0005Ci!A!\u0006\u000b\t\t]!\u0011D\u0001\u0005kRLGN\u0003\u0002\u0003\u001c\u0005!!.\u0019<b\u0013\u0011\u0011yB!\u0006\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002y\u0005GI1A!\nz\u0005\r\te.\u001f\u0015\bi\t%\"q\u0006B\u0019!\u0011\t)Aa\u000b\n\t\t5\u0012q\u0001\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00028b[\u0016\f#Aa\r\u0002)\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,Wh\u001f\u0019~\u0003\u0015aWM\u001a;U+\t\u0011I\u0004\u0005\u0004\u0003<\t\u0005#QI\u0007\u0003\u0005{Q1Aa\u0010z\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0007\u0012iDA\u0002TKF\u0004BAa\u0012\u0003N5\u0011!\u0011\n\u0006\u0004\u0005\u0017*\u0015!\u0002;za\u0016\u001c\u0018\u0002\u0002B(\u0005\u0013\u00121AU8x\u0003\u0019\u0011\u0018n\u001a5u)\u0006y!/[4iiVs\u0017.];f\u0017\u0016LH\u000b")
public class SemiJoinITCase
extends BatchTestBase {
    @Parameter
    private Enumeration.Value expectedJoinType;

    public static Seq<Row> rightUniqueKeyT() {
        return SemiJoinITCase$.MODULE$.rightUniqueKeyT();
    }

    public static Seq<Row> rightT() {
        return SemiJoinITCase$.MODULE$.rightT();
    }

    public static Seq<Row> leftT() {
        return SemiJoinITCase$.MODULE$.leftT();
    }

    @Parameters(name="expectedJoinType={0}")
    public static Collection<Object> parameters() {
        return SemiJoinITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("leftT", (Iterable<Row>)SemiJoinITCase$.MODULE$.leftT(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "a, b");
        this.registerCollection("rightT", (Iterable<Row>)SemiJoinITCase$.MODULE$.rightT(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "c, d");
        this.registerCollection("rightUniqueKeyT", (Iterable<Row>)SemiJoinITCase$.MODULE$.rightUniqueKeyT(), (TypeInformation<Row>)TestData$.MODULE$.INT_DOUBLE(), "c, d");
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testSingleConditionLeftSemi() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComposedConditionLeftSemi() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT WHERE b < d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSingleConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSingleUniqueConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM (SELECT DISTINCT c FROM rightT) WHERE a = c)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComposedConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c AND b < d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testComposedUniqueConditionLeftAnti() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightUniqueKeyT WHERE a = c AND b < d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSemiJoinTranspose() {
        this.checkResult("SELECT a, b FROM (SELECT a, b, c FROM leftT, rightT WHERE a = c) lr WHERE lr.a > 0 AND lr.c IN (SELECT c FROM rightUniqueKeyT WHERE d > 1)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftSemi1() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT)) T WHERE T.b > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftSemi2() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT)) T WHERE T.b > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testFilterPushDownLeftSemi3() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftSemi1() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftSemi2() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftSemi3() {
        this.checkResult("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti1() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE c < 3)) T WHERE T.b > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti2() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT where c > 10)) T WHERE T.b > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti3() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b = d AND c < 3)) T WHERE T.b > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testFilterPushDownLeftAnti4() {
        this.checkResult("SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti1() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti2() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE b > 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti3() {
        this.checkResult("SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b = d AND b > 1)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$)))))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testJoinConditionPushDownLeftAnti4() {
        this.checkResult("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$)))))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithAggregate1() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) FROM leftT WHERE b = d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithAggregate2() {
        this.checkResult("SELECT * FROM leftT t1 WHERE a IN (SELECT DISTINCT a FROM leftT t2 WHERE t1.b = t2.b)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithAggregate3() {
        this.checkResult("SELECT * FROM rightT WHERE CAST(c/2 AS BIGINT) IN (SELECT COUNT(*) FROM leftT WHERE b = d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver1() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER (PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver2() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER(PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT GROUP BY a, b)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver3() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER (PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT WHERE b = d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithOver4() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT SUM(a) OVER(PARTITION BY b ORDER BY a ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) FROM leftT WHERE b = d GROUP BY a, b)", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @TestTemplate
    public void testExistsWithOver1() {
        this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b = d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testExistsWithOver2() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b > d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testExistsWithOver3() {
        this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b = d GROUP BY a)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testExistsWithOver4() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM rightT WHERE EXISTS (SELECT SUM(a) OVER() FROM leftT WHERE b>d GROUP BY a)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition1() {
        this.checkResult("SELECT * FROM rightT WHERE c IN (SELECT a FROM leftT WHERE b > d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)2.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition2() {
        this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM (SELECT MAX(c) AS c, d FROM rightT GROUP BY d) r WHERE leftT.b > r.d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition3() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM (SELECT MIN(c) OVER() AS c, d FROM rightT) r WHERE leftT.b <> r.d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testInWithNonEqualityCorrelationCondition4() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM leftT WHERE a IN (SELECT c FROM (SELECT MIN(c) OVER() AS c, d FROM rightT GROUP BY c, d) r WHERE leftT.b <> r.d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testExistsWithNonEqualityCorrelationCondition() {
        if (this.expectedJoinType() == JoinType$.MODULE$.NestedLoopJoin()) {
            this.checkResult("SELECT * FROM leftT WHERE EXISTS (SELECT c FROM rightT WHERE b > d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)5.0)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testRewriteScalarQueryWithoutCorrelation1() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT)"}))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.checkResult(x$1, SemiJoinITCase$.MODULE$.leftT(), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithoutCorrelation2() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 5) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE c > 5)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE c > 5)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE c > 5)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE c > 5)"}))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.checkResult(x$2, SemiJoinITCase$.MODULE$.leftT(), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithoutCorrelation3() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE c > 15) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE c > 15)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE c > 15)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE c > 15)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE c > 15)"}))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            this.checkResult(x$3, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithCorrelation1() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE a = c)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE a = c)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE a = c)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE a = c)"}))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            this.checkResult(x$4, (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)1.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToDouble((double)3.0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithCorrelation2() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 5)"}))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            this.checkResult(x$5, (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null})), (List)Nil$.MODULE$)), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }

    @TestTemplate
    public void testRewriteScalarQueryWithCorrelation3() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) > 0", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) > 0.9", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) >= 1", "SELECT * FROM leftT WHERE (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15) >= 0.1", "SELECT * FROM leftT WHERE 0 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)", "SELECT * FROM leftT WHERE 0.99 < (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)", "SELECT * FROM leftT WHERE 1 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)", "SELECT * FROM leftT WHERE 0.01 <= (SELECT COUNT(*) FROM rightT WHERE a = c AND c > 15)"}))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            this.checkResult(x$6, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
            return BoxedUnit.UNIT;
        });
    }
}

