/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.join.InnerJoinITCase$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u000b\u0016\u0001!BQa\f\u0001\u0005\u0002AB\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0006\"C.\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011!I\u0007\u0001#b\u0001\n\u0013Q\u0007\u0002C<\u0001\u0011\u000b\u0007I\u0011\u00026\t\u0011a\u0004\u0001R1A\u0005\n)D\u0001\"\u001f\u0001\t\u0006\u0004%IA\u001b\u0005\u0006u\u0002!\te\u001f\u0005\u0007\u0003\u001b\u0001A\u0011A>\t\r\u0005]\u0001\u0001\"\u0001|\u0011\u0019\tY\u0002\u0001C\u0001w\"1\u0011q\u0004\u0001\u0005\u0002mDa!a\t\u0001\t\u0003Y\bBBA\u0014\u0001\u0011\u00051pB\u0004\u0002FUA\t!a\u0012\u0007\rQ)\u0002\u0012AA%\u0011\u0019y\u0013\u0003\"\u0001\u0002R!9\u00111K\t\u0005\u0002\u0005U#aD%o]\u0016\u0014(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005Y9\u0012\u0001\u00026pS:T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)!-\u0019;dQ*\u0011A$H\u0001\beVtG/[7f\u0015\tqr$A\u0004qY\u0006tg.\u001a:\u000b\u0005\u0001\n\u0013!\u0002;bE2,'B\u0001\u0012$\u0003\u00151G.\u001b8l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003Ym\tQ!\u001e;jYNL!AL\u0016\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u00023\u00015\tQ#\u0001\tfqB,7\r^3e\u0015>Lg\u000eV=qKV\tQ\u0007\u0005\u00027\u001d:\u0011q\u0007\u0014\b\u0003q-s!!\u000f&\u000f\u0005iJeBA\u001eI\u001d\tatI\u0004\u0002>\r:\u0011a(\u0012\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!AQ\u0014\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0011adH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012B\u0001\f\u0018\u0013\tiU#\u0001\u0005K_&tG+\u001f9f\u0013\ty\u0005K\u0001\u0005K_&tG+\u001f9f\u0015\tiU#\u0001\u000bfqB,7\r^3e\u0015>Lg\u000eV=qK~#S-\u001d\u000b\u0003'f\u0003\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013A!\u00168ji\"9!lAA\u0001\u0002\u0004)\u0014a\u0001=%c\u0005\tR\r\u001f9fGR,GMS8j]RK\b/\u001a\u0011)\u0005\u0011i\u0006C\u00010h\u001b\u0005y&B\u00011b\u00035\u0001\u0018M]1nKR,'/\u001b>fI*\u0011!mY\u0001\u000bKb$XM\\:j_:\u001c(B\u00013f\u0003\u0015QWO\\5u\u0015\t1\u0017%A\u0005uKN$X\u000f^5mg&\u0011\u0001n\u0018\u0002\n!\u0006\u0014\u0018-\\3uKJ\fq\"\\=VaB,'oQ1tK\u0012\u000bG/Y\u000b\u0002WB\u0019An\\9\u000e\u00035T!A\\+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002q[\n\u00191+Z9\u0011\u0005I,X\"A:\u000b\u0005Q\f\u0013!\u0002;za\u0016\u001c\u0018B\u0001<t\u0005\r\u0011vn^\u0001\u0010[fdun^3s\u0007\u0006\u001cX\rR1uC\u0006YQ.\u001f+fgR$\u0015\r^12\u0003-i\u0017\u0010V3ti\u0012\u000bG/\u0019\u001a\u0002\r\t,gm\u001c:f)\u0005\u0019\u0006FA\u0005~!\rq\u0018\u0011B\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000b\t9!A\u0004kkBLG/\u001a:\u000b\u0005\u0011,\u0013bAA\u0006\u007f\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002%Q,7\u000f^(oK6\u000bGo\u00195QKJ\u0014vn\u001e\u0015\u0004\u0015\u0005E\u0001c\u0001@\u0002\u0014%\u0019\u0011QC@\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\u0002'Q,7\u000f^'vYRL\u0007\u000f\\3NCR\u001c\u0007.Z:)\u0007-\t\t\"A\u0007uKN$hj\\'bi\u000eDWm\u001d\u0015\u0004\u0019\u0005E\u0011\u0001\u0005;fgR$UmY5nC2\f5oS3zQ\ri\u0011\u0011C\u0001\u0010i\u0016\u001cHOQ5h\r>\u00148\u000b]5mY\"\u001aa\"!\u0005\u00029Q,7\u000f^*peRlUM]4f\u0015>LgnT;uaV$xJ\u001d3fe\"\u001aq\"!\u0005)\u000f\u0001\ti#!\u000f\u0002<A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024}\f\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005]\u0012\u0011\u0007\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GFAA\u001fG\t\ty\u0004E\u0002_\u0003\u0003J1!a\u0011`\u0005i\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^#yi\u0016t7/[8o\u0003=IeN\\3s\u0015>Lg.\u0013+DCN,\u0007C\u0001\u001a\u0012'\r\t\u00121\n\t\u0004)\u00065\u0013bAA(+\n1\u0011I\\=SK\u001a$\"!a\u0012\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002XA1\u0011\u0011LA2\u0003Oj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005kRLGN\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t)'a\u0017\u0003\u0015\r{G\u000e\\3di&|g\u000e\r\u0003\u0002j\u0005M\u0004#\u0002+\u0002l\u0005=\u0014bAA7+\n)\u0011I\u001d:bsB!\u0011\u0011OA:\u0019\u0001!1\"!\u001e\u0014\u0003\u0003\u0005\tQ!\u0001\u0002x\t\u0019q\fJ\u0019\u0012\t\u0005e\u0014q\u0010\t\u0004)\u0006m\u0014bAA?+\n9aj\u001c;iS:<\u0007c\u0001+\u0002\u0002&\u0019\u00111Q+\u0003\u0007\u0005s\u0017\u0010K\u0004\u0014\u0003\u000f\u000bi)a$\u0011\u0007y\u000bI)C\u0002\u0002\f~\u0013!\u0002U1sC6,G/\u001a:t\u0003\u0011q\u0017-\\3\"\u0005\u0005E\u0015aA>1{\u0002")
public class InnerJoinITCase
extends BatchTestBase {
    private Seq<Row> myUpperCaseData;
    private Seq<Row> myLowerCaseData;
    private Seq<Row> myTestData1;
    private Seq<Row> myTestData2;
    @Parameter
    private Enumeration.Value expectedJoinType;
    private volatile byte bitmap$0;

    @Parameters(name="{0}")
    public static Collection<Object> parameters() {
        return InnerJoinITCase$.MODULE$.parameters();
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    public void expectedJoinType_$eq(Enumeration.Value x$1) {
        this.expectedJoinType = x$1;
    }

    private Seq<Row> myUpperCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.myUpperCaseData = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "E"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "F"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "G"})), (List)Nil$.MODULE$)))))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.myUpperCaseData;
    }

    private Seq<Row> myUpperCaseData() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.myUpperCaseData$lzycompute();
        }
        return this.myUpperCaseData;
    }

    private Seq<Row> myLowerCaseData$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.myLowerCaseData = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "d"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, "e"})), (List)Nil$.MODULE$)))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.myLowerCaseData;
    }

    private Seq<Row> myLowerCaseData() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.myLowerCaseData$lzycompute();
        }
        return this.myLowerCaseData;
    }

    private Seq<Row> myTestData1$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.myTestData1 = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.myTestData1;
    }

    private Seq<Row> myTestData1() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.myTestData1$lzycompute();
        }
        return this.myTestData1;
    }

    private Seq<Row> myTestData2$lzycompute() {
        InnerJoinITCase innerJoinITCase = this;
        synchronized (innerJoinITCase) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.myTestData2 = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.myTestData2;
    }

    private Seq<Row> myTestData2() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.myTestData2$lzycompute();
        }
        return this.myTestData2;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("myUpperCaseData", this.myUpperCaseData(), TestData$.MODULE$.INT_STRING(), "N, L", new boolean[]{true, true});
        this.registerCollection("myLowerCaseData", this.myLowerCaseData(), TestData$.MODULE$.INT_STRING(), "n, l", new boolean[]{true, true});
        this.registerCollection("myTestData1", this.myTestData1(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        this.registerCollection("myTestData2", this.myTestData2(), TestData$.MODULE$.INT_INT(), "a, b", new boolean[]{true, true});
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @TestTemplate
    public void testOneMatchPerRow() {
        this.checkResult("SELECT * FROM myUpperCaseData u, myLowerCaseData l WHERE u.N = l.n", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "A", BoxesRunTime.boxToInteger((int)1), "a"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "B", BoxesRunTime.boxToInteger((int)2), "b"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "C", BoxesRunTime.boxToInteger((int)3), "c"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "D", BoxesRunTime.boxToInteger((int)4), "d"})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testMultipleMatches() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.NestedLoopJoin();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
            return;
        }
    }

    @TestTemplate
    public void testNoMatches() {
        this.checkResult("SELECT * FROM myTestData1 A, myTestData2 B WHERE A.a = B.a and A.a = 1 and B.a = 2", (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @TestTemplate
    public void testDecimalAsKey() {
        RowTypeInfo DEC_INT = new RowTypeInfo(new TypeInformation[]{BigDecimalTypeInfo.of((int)9, (int)0), BasicTypeInfo.INT_TYPE_INFO});
        this.registerCollection("leftTable", (Iterable<Row>)((Iterable)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(2), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)))), (TypeInformation<Row>)DEC_INT, "a, b");
        this.registerCollection("rightTable", (Iterable<Row>)((Iterable)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))), (TypeInformation<Row>)DEC_INT, "c, d");
        this.checkResult("SELECT * FROM leftTable, rightTable WHERE a = c", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @TestTemplate
    public void testBigForSpill() {
        this.tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
        this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
        this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.fill(16, (Function0 & Serializable & scala.Serializable)() -> row), Seq$.MODULE$.canBuildFrom())), this.checkResult$default$3());
    }

    @TestTemplate
    public void testSortMergeJoinOutputOrder() {
        Enumeration.Value value = this.expectedJoinType();
        Enumeration.Value value2 = JoinType$.MODULE$.SortMergeJoin();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.tableConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
            this.env().getConfig().setParallelism(1);
            Seq bigData = (Seq)Random$.MODULE$.shuffle((TraversableOnce)((SeqLike)((SeqLike)TestData$.MODULE$.bigIntStringData().union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom())).union(TestData$.MODULE$.bigIntStringData(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            this.registerCollection("bigData1", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "a, b");
            this.registerCollection("bigData2", (Iterable<Row>)bigData, (TypeInformation<Row>)TestData$.MODULE$.INT_STRING(), "c, d");
            this.checkResult("SELECT a, b FROM bigData1, bigData2 WHERE a = c", (Seq<Row>)((Seq)TestData$.MODULE$.bigIntStringData().flatMap((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.fill(16, (Function0 & Serializable & scala.Serializable)() -> row), Seq$.MODULE$.canBuildFrom())), true);
            return;
        }
    }
}

