/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.agg;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.batch.sql.agg.AggregateITCaseBase;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyNestedLongArrayUdaf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyNestedMapUdf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyNestedStringArrayUdaf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyObjectArrayUdaf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyObjectMapUdaf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyPojoAggFunction;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyPrimitiveArrayUdaf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.MyPrimitiveMapUdaf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.SimplePrimitiveArrayUdaf;
import org.apache.flink.table.planner.runtime.batch.sql.agg.VarArgsAggFunction;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.utils.CountAggFunction;
import org.apache.flink.table.planner.utils.IntSumAggFunction;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A\u0001F\u000b\u0001Q!)Q\u0006\u0001C\u0001]!)\u0001\u0007\u0001C!c!)\u0001\b\u0001C\u0001c!)A\t\u0001C\u0001c!)a\t\u0001C\u0001c!)\u0001\n\u0001C\u0001c!)!\n\u0001C\u0001c!)A\n\u0001C\u0001c!)a\n\u0001C\u0001c!)\u0001\u000b\u0001C\u0001c!)!\u000b\u0001C\u0001c!)A\u000b\u0001C\u0001c!)a\u000b\u0001C\u0001c!)\u0001\f\u0001C\u0001c!)!\f\u0001C\u0001c!)A\f\u0001C\u0001c!)a\f\u0001C\u0001c!)\u0001\r\u0001C\u0001c!)!\r\u0001C\u0001c\ti1k\u001c:u\u0003\u001e<\u0017\nV\"bg\u0016T!AF\f\u0002\u0007\u0005<wM\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!\u00022bi\u000eD'B\u0001\u000f\u001e\u0003\u001d\u0011XO\u001c;j[\u0016T!AH\u0010\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0001%I\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003E\r\nQA\u001a7j].T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011C\u0001\u0001*!\tQ3&D\u0001\u0016\u0013\taSCA\nBO\u001e\u0014XmZ1uK&#6)Y:f\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011!\u0006A\u0001\raJ,\u0007/\u0019:f\u0003\u001e<w\n\u001d\u000b\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t!QK\\5u\u0003i!Xm\u001d;CS\u001e$\u0015\r^1TS6\u0004H.Z!se\u0006LX\u000bR!GQ\t\u0019!\b\u0005\u0002<\u00056\tAH\u0003\u0002>}\u0005\u0019\u0011\r]5\u000b\u0005}\u0002\u0015a\u00026va&$XM\u001d\u0006\u0003\u0003\u0016\nQA[;oSRL!a\u0011\u001f\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/T;mi&\u001cV\r^!hO\n+hMZ3s\u000fJ|W\u000f\u001d\"zQ\t!!(A\fuKN$X\u000bR!H\u000f^KG\u000f[8vi\u001e\u0013x.\u001e9cs\"\u0012QAO\u0001\u0015i\u0016\u001cH/\u0016#B\u000f\u001e;\u0016\u000e\u001e5He>,\bOY=)\u0005\u0019Q\u0014\u0001\t;fgR,F)Q$H\u001dVdGn\u0012:pkB\\U-_!hOJ,w-\u0019;j_:D#a\u0002\u001e\u00027Q,7\u000f^\"p[BdW\r_+E\u0003\u001e;u+\u001b;i\u000fJ|W\u000f\u001d\"zQ\tA!(A\u0006uKN$H*[:u\u0003\u001e<\u0007FA\u0005;\u00035!Xm\u001d;Q_*|g)[3mI\"\u0012!BO\u0001\fi\u0016\u001cHOV1s\u0003J<7\u000f\u000b\u0002\fu\u0005iA/Z:u\u001b\u0006D8\u000b\u001e:j]\u001eD#\u0001\u0004\u001e\u0002)Q,7\u000f^'bqN#(/\u001b8h\u00032dg*\u001e7mQ\ti!(\u0001\fuKN$h)\u001b:tiZ\u000bG.^3P]N#(/\u001b8hQ\tq!(A\u0007uKN$\u0018I\u001d:bsV#\u0017M\u001a\u0015\u0003\u001fi\n1\u0002^3ti6\u000b\u0007/\u00163bM\"\u0012\u0001CO\u0001\u001di\u0016\u001cH/\u00119qe>D\u0018.\\1uK\u000e{WO\u001c;ESN$\u0018N\\2uQ\t\t\"(A\u0017uKN$(j]8o\u0003J\u0014\u0018-_!hO\u0006sGMS:p]>\u0013'.Z2u\u0003\u001e<w+\u001b;i\u001fRDWM]!hOND#A\u0005\u001e\u0002eQ,7\u000f^$s_V\u0004(j]8o\u0003J\u0014\u0018-_!hO\u0006sGMS:p]>\u0013'.Z2u\u0003\u001e<w+\u001b;i\u001fRDWM]!hOND#a\u0005\u001e")
public class SortAggITCase
extends AggregateITCaseBase {
    @Override
    public void prepareAggOp() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.tEnv().createTemporarySystemFunction("countFun", (UserDefinedFunction)new CountAggFunction());
        this.tEnv().createTemporarySystemFunction("intSumFun", (UserDefinedFunction)new IntSumAggFunction());
        this.registerTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset.class);
        this.tEnv().createTemporarySystemFunction("myPrimitiveArrayUdaf", (UserDefinedFunction)new MyPrimitiveArrayUdaf());
        this.tEnv().createTemporarySystemFunction("myObjectArrayUdaf", (UserDefinedFunction)new MyObjectArrayUdaf());
        this.tEnv().createTemporarySystemFunction("myNestedLongArrayUdaf", (UserDefinedFunction)new MyNestedLongArrayUdaf());
        this.registerTemporarySystemFunction("myNestedStringArrayUdaf", MyNestedStringArrayUdaf.class);
        this.tEnv().createTemporarySystemFunction("myPrimitiveMapUdaf", (UserDefinedFunction)new MyPrimitiveMapUdaf());
        this.tEnv().createTemporarySystemFunction("myObjectMapUdaf", (UserDefinedFunction)new MyObjectMapUdaf());
        this.registerTemporarySystemFunction("myNestedMapUdaf", MyNestedMapUdf.class);
    }

    @Test
    public void testBigDataSimpleArrayUDAF() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        this.tEnv().createTemporarySystemFunction("simplePrimitiveArrayUdaf", (UserDefinedFunction)new SimplePrimitiveArrayUdaf());
        this.registerRange("RangeT", 1000000L);
        this.env().setParallelism(1);
        this.checkResult("SELECT simplePrimitiveArrayUdaf(id) FROM RangeT", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)499999500000L)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testMultiSetAggBufferGroupBy() {
        this.checkResult("SELECT collect(b) FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)6))}), (Ordering)Ordering.Int$.MODULE$)).asJava()})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testUDAGGWithoutGroupby() {
        this.checkResult("SELECT countFun(c) FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)21)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testUDAGGWithGroupby() {
        this.checkResult("SELECT countFun(a), count(a), b FROM Table3 GROUP BY b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testUDAGGNullGroupKeyAggregation() {
        this.checkResult("SELECT intSumFun(d), d, count(d) FROM NullTable5 GROUP BY d", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)25), BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testComplexUDAGGWithGroupBy() {
        this.checkResult("SELECT b, weightedAvg(b, a) FROM Table3 GROUP BY b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)5)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6)})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testListAgg() {
        this.checkResult("SELECT LISTAGG(c, '-'), LISTAGG(c) FROM SmallTable3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi-Hello-Hello world", "Hi,Hello,Hello world"})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT LISTAGG(g, '-'), LISTAGG(g) FROM EmptyTable5", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT LISTAGG(c, '-'), LISTAGG(c) FROM AllNullTable3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testPojoField() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new UserDefinedFunctionTestUtils.MyPojo(5, 105)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new UserDefinedFunctionTestUtils.MyPojo(6, 11)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new UserDefinedFunctionTestUtils.MyPojo(7, 12)})), (List)Nil$.MODULE$)));
        this.registerCollection("MyTable", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{Types.INT(), TypeExtractor.createTypeInfo(UserDefinedFunctionTestUtils.MyPojo.class)}), "a, b");
        this.tEnv().createTemporarySystemFunction("pojoFunc", (UserDefinedFunction)new MyPojoAggFunction());
        this.checkResult("SELECT pojoFunc(b) FROM MyTable group by a", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UserDefinedFunctionTestUtils.MyPojo(128, 128)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testVarArgs() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), "5", "3"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)22L), "15", "13"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)33L), "25", "23"})), (List)Nil$.MODULE$)));
        this.registerCollection("MyTable", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING(), Types.STRING()}), "id, s, s1, s2");
        VarArgsAggFunction func = new VarArgsAggFunction();
        this.tEnv().createTemporaryFunction("func", (UserDefinedFunction)func);
        this.checkResult("SELECT func(s, s1, s2) FROM MyTable", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)140)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT id, func(s, s1, s2) FROM MyTable group by id", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)59)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)81)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @Test
    public void testMaxString() {
        this.checkResult("SELECT max(c) FROM Table3 GROUP BY b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#15"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#4"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment#9"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello world"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
        this.checkResult("SELECT max(c) FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Luke Skywalker"})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testMaxStringAllNull() {
        this.checkResult("SELECT max(c) FROM AllNullTable3 GROUP BY b", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT max(c) FROM AllNullTable3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testFirstValueOnString() {
        this.checkResult("SELECT first_value(c) over () FROM Table3", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hi"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testArrayUdaf() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)BoxesRunTime.boxToInteger((int)1));
        this.env().setParallelism(1);
        this.checkResult("SELECT myPrimitiveArrayUdaf(IFNULL(a, 0), IFNULL(b, 0)) FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new int[]{231, 91}})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myObjectArrayUdaf(c) FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String[]{"HHHHILCCCCCCCCCCCCCCC", "iod?.r123456789012345"}})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myNestedLongArrayUdaf(IFNULL(a, 0), IFNULL(b, 0))[2] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new int[]{91, 231}})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myNestedStringArrayUdaf(c)[2] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String[]{"iod?.r123456789012345", "HHHHILCCCCCCCCCCCCCCC"}})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testMapUdaf() {
        this.checkResult("SELECT myPrimitiveMapUdaf(IFNULL(a, 0), IFNULL(b, 0))[3] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)15)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myPrimitiveMapUdaf(IFNULL(a, 0), IFNULL(b, 0))[6] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)111)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myObjectMapUdaf(a, c)['Co'] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)210)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myObjectMapUdaf(a, c)['He'] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myNestedMapUdaf(a, b, c)[6]['Co'] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)111)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myNestedMapUdaf(a, b, c)[3]['He'] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
        this.checkResult("SELECT myNestedMapUdaf(a, b, c)[3]['Co'] FROM Table3", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"null"})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testApproximateCountDistinct() {
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.fullDataTypesData());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(788).append("\n         |CREATE TABLE MyTable (\n         |  `boolean` BOOLEAN,\n         |  `byte` TINYINT,\n         |  `short` SMALLINT,\n         |  `int` INT,\n         |  `long` BIGINT,\n         |  `float` FLOAT,\n         |  `double` DOUBLE,\n         |  `decimal52` DECIMAL(5, 2),\n         |  `decimal3010` DECIMAL(30, 10),\n         |  `string` VARCHAR(5),\n         |  `char` CHAR(5),\n         |  `date` DATE,\n         |  `time` TIME(0),\n         |  `timestamp` TIMESTAMP(9),\n         |  `timestamp_ltz` TIMESTAMP(9) WITH LOCAL TIME ZONE,\n         |  `array` ARRAY<BIGINT>,\n         |  `row` ROW<f1 BIGINT, f2 STRING, f3 DOUBLE>,\n         |  `map` MAP<STRING, INT>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n         |").toString())).stripMargin());
        this.checkResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        | APPROX_COUNT_DISTINCT(`byte`),\n        | APPROX_COUNT_DISTINCT(`short`),\n        | APPROX_COUNT_DISTINCT(`int`),\n        | APPROX_COUNT_DISTINCT(`long`),\n        | APPROX_COUNT_DISTINCT(`float`),\n        | APPROX_COUNT_DISTINCT(`double`),\n        | APPROX_COUNT_DISTINCT(`string`),\n        | APPROX_COUNT_DISTINCT(`date`),\n        | APPROX_COUNT_DISTINCT(`time`),\n        | APPROX_COUNT_DISTINCT(`timestamp`),\n        | APPROX_COUNT_DISTINCT(`timestamp_ltz`),\n        | APPROX_COUNT_DISTINCT(`decimal52`),\n        | APPROX_COUNT_DISTINCT(`decimal3010`)\n        | FROM MyTable\n      ")).stripMargin(), (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToLong((long)4L)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testJsonArrayAggAndJsonObjectAggWithOtherAggs() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  MAX(d), JSON_OBJECTAGG(g VALUE d), JSON_ARRAYAGG(d), JSON_ARRAYAGG(g)\n         |FROM Table5 WHERE d <= 3\n         |")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, {\"ABC\":3,\"BCD\":3,\"Hallo\":1,\"Hallo Welt\":2,\"Hallo Welt wie\":2,\"Hallo Welt wie gehts?\":3}, [1,2,2,3,3,3], [\"Hallo\",\"Hallo Welt\",\"Hallo Welt wie\",\"Hallo Welt wie gehts?\",\"ABC\",\"BCD\"]"})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testGroupJsonArrayAggAndJsonObjectAggWithOtherAggs() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  d, JSON_OBJECTAGG(g VALUE f), JSON_ARRAYAGG(g), JSON_ARRAYAGG(f), max(f)\n         |FROM Table5 WHERE d <= 3 GROUP BY d\n         |")).stripMargin();
        this.checkResult(sql, (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1, {\"Hallo\":0}, [\"Hallo\"], [0], 0"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2, {\"Hallo Welt\":1,\"Hallo Welt wie\":2}, [\"Hallo Welt\",\"Hallo Welt wie\"], [1,2], 2"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3, {\"ABC\":4,\"BCD\":5,\"Hallo Welt wie gehts?\":3}, [\"Hallo Welt wie gehts?\",\"ABC\",\"BCD\"], [3,4,5], 5"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    public SortAggITCase() {
        super("SortAggregate");
    }
}

