/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.Serializable;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u000f\u001f\u0001=BQA\u000e\u0001\u0005\u0002]B\u0011B\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001e\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0003)\u0005\"\u0003(\u0001\u0001\u0004\u0005\t\u0015)\u0003=\u0011%a\u0006\u00011AA\u0002\u0013\u0005Q\fC\u0005s\u0001\u0001\u0007\t\u0019!C\u0001g\"IQ\u000f\u0001a\u0001\u0002\u0003\u0006KA\u0018\u0005\u0006s\u0002!\tE\u001f\u0005\u0007\u0003\u0013\u0001A\u0011\u0001>\t\r\u0005M\u0001\u0001\"\u0001{\u0011\u0019\t9\u0002\u0001C\u0001u\"1\u00111\u0004\u0001\u0005\u0002iDa!a\b\u0001\t\u0003Q\bBBA\u0012\u0001\u0011\u0005!\u0010\u0003\u0004\u0002(\u0001!\tA\u001f\u0005\u0007\u0003W\u0001A\u0011\u0001>\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u001d9\u0011Q\f\u0010\t\u0002\u0005}cAB\u000f\u001f\u0011\u0003\t\t\u0007\u0003\u00047'\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003W\u001aB\u0011AA7\u0011\u001d\t)j\u0005C\u0001\u0003/C!\"a.\u0014\u0011\u000b\u0007I\u0011AA]\u0011)\tIm\u0005EC\u0002\u0013\u0005\u00111\u001a\u0005\u000b\u0003+\u001c\u0002R1A\u0005\u0002\u0005]\u0007BCAm'!\u0015\r\u0011\"\u0001\u0002X\"Q\u00111\\\n\t\u0006\u0004%\t!a6\t\u0015\u0005u7\u0003#b\u0001\n\u0003\t9NA\nNk2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f^%U\u0007\u0006\u001cXM\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!\u00022bi\u000eD'BA\u0012%\u0003\u001d\u0011XO\u001c;j[\u0016T!!\n\u0014\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0005K\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003S)\nQA\u001a7j].T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011C\u0001\u00011!\t\tD'D\u00013\u0015\t\u0019$%A\u0003vi&d7/\u0003\u00026e\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u001d\u0011\u0005e\u0002Q\"\u0001\u0010\u0002\u0017MDWO\u001a4mK6{G-Z\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005C\u0013aA1qS&\u00111I\u0010\u0002\u0011\u0005\u0006$8\r[*ik\u001a4G.Z'pI\u0016\fqb\u001d5vM\u001adW-T8eK~#S-\u001d\u000b\u0003\r2\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013A!\u00168ji\"9QjAA\u0001\u0002\u0004a\u0014a\u0001=%c\u0005a1\u000f[;gM2,Wj\u001c3fA!\u0012A\u0001\u0015\t\u0003#jk\u0011A\u0015\u0006\u0003'R\u000bQ\u0002]1sC6,G/\u001a:ju\u0016$'BA+W\u0003))\u0007\u0010^3og&|gn\u001d\u0006\u0003/b\u000bQA[;oSRT!!\u0017\u0015\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA.S\u0005%\u0001\u0016M]1nKR,'/A\u0007tG\",G-\u001e7feRK\b/Z\u000b\u0002=B\u0011ql\u001c\b\u0003A2t!!\u00196\u000f\u0005\tLgBA2i\u001d\t!w-D\u0001f\u0015\t1g&\u0001\u0004=e>|GOP\u0005\u0002[%\u00111\u0006L\u0005\u0003S)J!a\u001b\u0015\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\tig.A\tK_\nl\u0015M\\1hKJ|\u0005\u000f^5p]NT!a\u001b\u0015\n\u0005A\f(!D*dQ\u0016$W\u000f\\3s)f\u0004XM\u0003\u0002n]\u0006\t2o\u00195fIVdWM\u001d+za\u0016|F%Z9\u0015\u0005\u0019#\bbB'\u0007\u0003\u0003\u0005\rAX\u0001\u000fg\u000eDW\rZ;mKJ$\u0016\u0010]3!Q\u00119\u0001k\u001e=\u0002\u000bY\fG.^3\u001e\u0003\u0005\taAY3g_J,G#\u0001$)\u0005!a\bcA?\u0002\u00065\taP\u0003\u0002B\u007f*!\u0011\u0011AA\u0002\u0003\u001dQW\u000f]5uKJT!a\u0016\u0017\n\u0007\u0005\u001daP\u0001\u0006CK\u001a|'/Z#bG\"\fa\u0003^3ti\n\u000b7/[2Nk2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f\u001e\u0015\u0004\u0013\u00055\u0001cA?\u0002\u0010%\u0019\u0011\u0011\u0003@\u0003\u0019Q+7\u000f\u001e+f[Bd\u0017\r^3\u0002-Q,7\u000f^'b]flU\u000f\u001c;ja2,\u0017J\u001c9viND3ACA\u0007\u0003Y!Xm\u001d;K_&tw+\u001b;i\u0003\u001e<\u0017i\u001d)s_\n,\u0007fA\u0006\u0002\u000e\u0005AB/Z:u\u001d>\u0004&/[8sSRL8i\u001c8tiJ\f\u0017N\u001c;)\u00071\ti!A\tuKN$(+\u001a7bi\u0016$\u0017J\u001c9viND3!DA\u0007\u0003a!Xm\u001d;SK2\fG/\u001a3J]B,Ho],ji\"\fum\u001a\u0015\u0004\u001d\u00055\u0011A\n;fgR$U-\u00193m_\u000e\\7)Y;tK\u0012\u0014\u00150\u0012=dQ\u0006tw-Z%o\u0003:\u001cWm\u001d;pe\"\u001aq\"!\u0004\u0002-Q,7\u000f^'bqN+\b\u000f]8si\u0016$\u0017J\u001c9viND3\u0001EA\u0007\u0003a\u0019\u0007.Z2l\u001bVdG/\u001b9mK&s\u0007/\u001e;SKN,H\u000e\u001e\u000b\u0004\r\u0006M\u0002BB\u0010\u0012\u0001\u0004\t)\u0004\u0005\u0003\u00028\u0005}b\u0002BA\u001d\u0003w\u0001\"\u0001\u001a%\n\u0007\u0005u\u0002*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{A\u0005F\u0002\u0001\u0002H]\f\u0019\u0006\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tiE`\u0001\nKb$XM\\:j_:LA!!\u0015\u0002L\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5-\u0005\u0005U3EAA,!\r\t\u0016\u0011L\u0005\u0004\u00037\u0012&A\u0007)be\u0006lW\r^3sSj,G\rV3ti\u0016CH/\u001a8tS>t\u0017aE'vYRL\u0007\u000f\\3J]B,H/\u0013+DCN,\u0007CA\u001d\u0014'\r\u0019\u00121\r\t\u0004\u000f\u0006\u0015\u0014bAA4\u0011\n1\u0011I\\=SK\u001a$\"!a\u0018\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u0002pA)q)!\u001d\u0002v%\u0019\u00111\u000f%\u0003\u000b\u0005\u0013(/Y=\u0011\u000b\u001d\u000b\t(a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005!A.\u00198h\u0015\t\t\t)\u0001\u0003kCZ\f\u0017\u0002BAC\u0003w\u0012aa\u00142kK\u000e$\bfB\u000b\u0002\n\u0006=\u0015\u0011\u0013\t\u0004#\u0006-\u0015bAAG%\nQ\u0001+\u0019:b[\u0016$XM]:\u0002\t9\fW.Z\u0011\u0003\u0003'\u000bAe\u001d5vM\u001adW-T8eKj\u00023\u0010M?-AM\u001c\u0007.\u001a3vY\u0016\u0014H+\u001f9fu\u0001Z\u0018'`\u0001\u0013O\u0016tWM]1uKJ\u000bg\u000eZ8n\t\u0006$\u0018\r\u0006\u0002\u0002\u001aB1\u00111TAS\u0003WsA!!(\u0002\":\u0019A-a(\n\u0003%K1!a)I\u0003\u001d\u0001\u0018mY6bO\u0016LA!a*\u0002*\n\u00191+Z9\u000b\u0007\u0005\r\u0006\n\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t\fK\u0001\u0006if\u0004Xm]\u0005\u0005\u0003k\u000byKA\u0002S_^\fqA]8x)f\u0004X-\u0006\u0002\u0002<B!\u0011QXAc\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017!\u0003;za\u0016,H/\u001b7t\u0015\r\t\t\tQ\u0005\u0005\u0003\u000f\fyLA\u0006S_^$\u0016\u0010]3J]\u001a|\u0017!\u00038vY2\f'\r\\3t+\t\ti\rE\u0003H\u0003c\ny\rE\u0002H\u0003#L1!a5I\u0005\u001d\u0011un\u001c7fC:\fQ\u0001Z1uCb+\"!!'\u0002\u000b\u0011\fG/Y-\u0002\u000b\u0011\fG/\u0019.\u0002\u000b\u0011\fG/\u0019+")
public class MultipleInputITCase
extends BatchTestBase {
    @Parameter
    private BatchShuffleMode shuffleMode;
    @Parameter(value=1)
    private JobManagerOptions.SchedulerType schedulerType;

    public static Seq<Row> dataT() {
        return MultipleInputITCase$.MODULE$.dataT();
    }

    public static Seq<Row> dataZ() {
        return MultipleInputITCase$.MODULE$.dataZ();
    }

    public static Seq<Row> dataY() {
        return MultipleInputITCase$.MODULE$.dataY();
    }

    public static Seq<Row> dataX() {
        return MultipleInputITCase$.MODULE$.dataX();
    }

    public static boolean[] nullables() {
        return MultipleInputITCase$.MODULE$.nullables();
    }

    public static RowTypeInfo rowType() {
        return MultipleInputITCase$.MODULE$.rowType();
    }

    public static Seq<Row> generateRandomData() {
        return MultipleInputITCase$.MODULE$.generateRandomData();
    }

    @Parameters(name="shuffleMode: {0}, schedulerType: {1}")
    public static Object[][] parameters() {
        return MultipleInputITCase$.MODULE$.parameters();
    }

    public BatchShuffleMode shuffleMode() {
        return this.shuffleMode;
    }

    public void shuffleMode_$eq(BatchShuffleMode x$1) {
        this.shuffleMode = x$1;
    }

    public JobManagerOptions.SchedulerType schedulerType() {
        return this.schedulerType;
    }

    public void schedulerType_$eq(JobManagerOptions.SchedulerType x$1) {
        this.schedulerType = x$1;
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        this.tEnv().getConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode());
        this.tEnv().getConfig().set(JobManagerOptions.SCHEDULER, (Object)this.schedulerType());
    }

    @TestTemplate
    public void testBasicMultipleInput() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n                               |SELECT * FROM\n                               |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                               |  INNER JOIN\n                               |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                               |  ON T1.a = T2.d\n                               |")).stripMargin());
    }

    @TestTemplate
    public void testManyMultipleInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @TestTemplate
    public void testJoinWithAggAsProbe() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @TestTemplate
    public void testNoPriorityConstraint() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testRelatedInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testRelatedInputsWithAgg() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @TestTemplate
    public void testDeadlockCausedByExchangeInAncestor() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @TestTemplate
    public void testMaxSupportedInputs() {
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"})), (List)Nil$.MODULE$);
        boolean[] nullables = new boolean[]{true, true};
        this.registerCollection("left_table", data, rowType, "a, b", nullables);
        this.registerCollection("right_table", data, rowType, "c, d", nullables);
        int numJoins = 62;
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT t0.a, t0.b");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(10).append(", t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c, t").append(BoxesRunTime.unboxToInt((Object)i)).append(".d").toString()));
        sql.append(" from left_table as t0");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(53).append(" left join right_table as t").append(BoxesRunTime.unboxToInt((Object)i)).append(" on t0.a = t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c and t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c = 1").toString()));
        this.checkMultipleInputResult(sql.toString());
    }

    public void checkMultipleInputResult(String sql) {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.checkResult(sql, expected, this.checkResult$default$3());
    }
}

