/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u000193Aa\u0003\u0007\u0001;!)A\u0005\u0001C\u0001K!)\u0001\u0006\u0001C!S!)1\b\u0001C\u0001S!)\u0001\t\u0001C\u0001S!)!\t\u0001C\u0001S!)A\t\u0001C\u0001S!)a\t\u0001C\u0001S!)\u0001\n\u0001C\u0001S!)!\n\u0001C\u0001S!)A\n\u0001C\u0001S\t\u0011B*[7jiB\u0012V-\\8wK&#6)Y:f\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000b\t\fGo\u00195\u000b\u0005E\u0011\u0012a\u0002:v]RLW.\u001a\u0006\u0003'Q\tq\u0001\u001d7b]:,'O\u0003\u0002\u0016-\u0005)A/\u00192mK*\u0011q\u0003G\u0001\u0006M2Lgn\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#BA\u0011\u0011\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0003EA\u0007CCR\u001c\u0007\u000eV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u00031\taAY3g_J,G#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005E\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u0007\u0005\u0004\u0018N\u0003\u00027o\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001d\u001b\u0003\u0015QWO\\5u\u0013\tQ4G\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3tiNKW\u000e\u001d7f\u0019&l\u0017\u000e\u001e*f[>4X\r\u000b\u0002\u0004{A\u0011!GP\u0005\u0003\u007fM\u0012A\u0001V3ti\u0006QB/Z:u\u0019&l\u0017\u000e\u001e*f[>4XmV5uQ>\u0013H-\u001a:Cs\"\u0012A!P\u0001\u0018i\u0016\u001cH\u000fT5nSR\u0014V-\\8wK^KG\u000f\u001b&pS:D#!B\u001f\u0002+Q,7\u000f\u001e'j[&$(+Z7pm\u0016<\u0016\u000e\u001e5J]\"\u0012a!P\u0001\u0019i\u0016\u001cH\u000fT5nSR\u0014V-\\8wK^KG\u000f\u001b(pi&s\u0007FA\u0004>\u0003e!Xm\u001d;MS6LGOU3n_Z,w+\u001b;i\u000bbL7\u000f^:)\u0005!i\u0014\u0001\b;fgRd\u0015.\\5u%\u0016lwN^3XSRDgj\u001c;Fq&\u001cHo\u001d\u0015\u0003\u0013u\n\u0011\u0004^3ti2KW.\u001b;SK6|g/Z,ji\"\u001cV\r\\3di\"\u0012!\"\u0010")
public class Limit0RemoveITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        LazyRef numericData$lzy = new LazyRef();
        super.before();
        this.registerCollection("t1", (Iterable<Row>)Limit0RemoveITCase.numericData$1(numericData$lzy), (TypeInformation<Row>)TestData$.MODULE$.numericType(), "a, b, c, d, e");
        this.registerCollection("t2", (Iterable<Row>)Limit0RemoveITCase.numericData$1(numericData$lzy), (TypeInformation<Row>)TestData$.MODULE$.numericType(), "a, b, c, d, e");
    }

    @Test
    public void testSimpleLimitRemove() {
        String sqlQuery = "SELECT * FROM t1 LIMIT 0";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @Test
    public void testLimitRemoveWithOrderBy() {
        String sqlQuery = "SELECT * FROM t1 ORDER BY a LIMIT 0";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @Test
    public void testLimitRemoveWithJoin() {
        String sqlQuery = "SELECT * FROM t1 JOIN (SELECT * FROM t2 LIMIT 0) ON true";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @Test
    public void testLimitRemoveWithIn() {
        String sqlQuery = "SELECT * FROM t1 WHERE a IN (SELECT a FROM t2 LIMIT 0)";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @Test
    public void testLimitRemoveWithNotIn() {
        String sqlQuery = "SELECT a FROM t1 WHERE a NOT IN (SELECT a FROM t2 LIMIT 0)";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @Test
    public void testLimitRemoveWithExists() {
        String sqlQuery = "SELECT * FROM t1 WHERE EXISTS (SELECT a FROM t2 LIMIT 0)";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    @Test
    public void testLimitRemoveWithNotExists() {
        String sqlQuery = "SELECT a FROM t1 WHERE NOT EXISTS (SELECT a FROM t2 LIMIT 0)";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @Test
    public void testLimitRemoveWithSelect() {
        String sqlQuery = "SELECT * FROM (SELECT a FROM t2 LIMIT 0)";
        this.checkResult(sqlQuery, (Seq<Row>)((Seq)Nil$.MODULE$), this.checkResult$default$3());
    }

    private static final /* synthetic */ Seq numericData$lzycompute$1(LazyRef numericData$lzy$1) {
        Seq seq;
        LazyRef lazyRef = numericData$lzy$1;
        synchronized (lazyRef) {
            seq = numericData$lzy$1.initialized() ? (Seq)numericData$lzy$1.value() : (Seq)numericData$lzy$1.initialize((Object)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToFloat((float)1.0f), BoxesRunTime.boxToDouble((double)1.0), BigDecimal.valueOf(1L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null, BoxesRunTime.boxToFloat((float)2.0f), BoxesRunTime.boxToDouble((double)2.0), BigDecimal.valueOf(2L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)3L), null, BoxesRunTime.boxToDouble((double)3.0), BigDecimal.valueOf(3L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToFloat((float)4.0f), null, BigDecimal.valueOf(3L)})), (List)Nil$.MODULE$)))));
        }
        return seq;
    }

    private static final Seq numericData$1(LazyRef numericData$lzy$1) {
        if (numericData$lzy$1.initialized()) {
            return (Seq)numericData$lzy$1.value();
        }
        return Limit0RemoveITCase.numericData$lzycompute$1(numericData$lzy$1);
    }
}

