/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.runtime.batch.sql.BinaryStringTableFunc;
import org.apache.flink.table.planner.runtime.batch.sql.GenericTableFunc;
import org.apache.flink.table.planner.runtime.batch.sql.MyToPojoTableFunc;
import org.apache.flink.table.planner.runtime.batch.sql.StringUdFunc$;
import org.apache.flink.table.planner.runtime.batch.sql.TableFunctionITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4AAE\n\u0001I!)1\u0006\u0001C\u0001Y!)q\u0006\u0001C!a!)!\t\u0001C\u0001a!)q\t\u0001C\u0001a!)\u0011\n\u0001C\u0001a!)!\n\u0001C\u0001a!)A\n\u0001C\u0001a!)a\n\u0001C\u0001a!)\u0001\u000b\u0001C\u0001a!)!\u000b\u0001C\u0001a!)A\u000b\u0001C\u0001a!)a\u000b\u0001C\u0001a!)\u0001\f\u0001C\u0001a!)!\f\u0001C\u0001a!)A\f\u0001C\u0001a!)a\f\u0001C\u0001a!)\u0001\r\u0001C\u0001a\t\u00012i\u001c:sK2\fG/Z%U\u0007\u0006\u001cXM\r\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003cCR\u001c\u0007N\u0003\u0002\u00193\u00059!/\u001e8uS6,'B\u0001\u000e\u001c\u0003\u001d\u0001H.\u00198oKJT!\u0001H\u000f\u0002\u000bQ\f'\r\\3\u000b\u0005yy\u0012!\u00024mS:\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\u0011\u0001fF\u0001\u0006kRLGn]\u0005\u0003U\u001d\u0012QBQ1uG\"$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u0014\u0003\u0019\u0011WMZ8sKR\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0003V]&$\bF\u0001\u00029!\tI\u0004)D\u0001;\u0015\tYD(A\u0002ba&T!!\u0010 \u0002\u000f),\b/\u001b;fe*\u0011q(I\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0003j\u0012!BQ3g_J,W)Y2i\u0003a!Xm\u001d;KCZ\fw)\u001a8fe&\u001cG+\u00192mK\u001a+hn\u0019\u0015\u0003\u0007\u0011\u0003\"!O#\n\u0005\u0019S$\u0001\u0002+fgR\f\u0011\u0004^3tiN\u001b\u0017\r\\1HK:,'/[2UC\ndWMR;oG\"\u0012A\u0001R\u0001\u0015i\u0016\u001cHoR3oKJL7\rV1cY\u00164UO\\2\u0002+Q,7\u000f^\"p]N$\u0018M\u001c;UC\ndWMR;oG\"\u0012a\u0001R\u0001\u0017i\u0016\u001cHoQ8ogR\fg\u000e\u001e+bE2,g)\u001e8de!\u0012q\u0001R\u0001\u0017i\u0016\u001cHoQ8ogR\fg\u000e\u001e+bE2,g)\u001e8dg!\u0012\u0001\u0002R\u0001#i\u0016\u001cHoQ8ogR\fg\u000e\u001e+bE2,g)\u001e8d/&$\bnU;c'R\u0014\u0018N\\4)\u0005%!\u0015\u0001\u0005;fgR,FMZ!gi\u0016\u0014X\u000b\u001a;gQ\tQA)\u0001\u0014uKN$H*\u001a4u\u0013:\u0004X\u000f^!mYB\u0013xN[3di^KG\u000f[#naRLx*\u001e;qkRD#a\u0003#\u0002]Q,7\u000f\u001e'fMRTu.\u001b8MK\u001a$\u0018J\u001c9vi\u0006cG\u000e\u0015:pU\u0016\u001cGoV5uQ\u0016k\u0007\u000f^=PkR\u0004X\u000f\u001e\u0015\u0003\u0019\u0011\u000b!\u0006^3ti2+g\r^%oaV$\b+\u0019:uS\u0006d\u0007K]8kK\u000e$x+\u001b;i\u000b6\u0004H/_(viB,H\u000f\u000b\u0002\u000e\t\u0006\u0011D/Z:u\u0019\u00164GOS8j]2+g\r^%oaV$\b+\u0019:uS\u0006d\u0007K]8kK\u000e$x+\u001b;i\u000b6\u0004H/_(viB,H\u000f\u000b\u0002\u000f\t\u0006YC/Z:u\u0019\u00164G/\u00138qkR\u0004\u0016M\u001d;jC2\u0004&o\u001c6fGR<\u0016\u000e\u001e5F[B$\u0018pT;uaV$(\u0007\u000b\u0002\u0010\t\u0006\u0019D/Z:u\u0019\u00164GOS8j]2+g\r^%oaV$\b+\u0019:uS\u0006d\u0007K]8kK\u000e$x+\u001b;i\u000b6\u0004H/_(viB,HO\r\u0015\u0003!\u0011\u000b\u0011\u0005^3tiR\u000b'\r\\3Gk:\u001cG/[8o/&$\bNQ5oCJL8\u000b\u001e:j]\u001eD#!\u0005#")
public class CorrelateITCase2
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("inputT", (Iterable<Row>)TableFunctionITCase$.MODULE$.testData(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("inputTWithNull", (Iterable<Row>)TableFunctionITCase$.MODULE$.testDataWithNull(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("SmallTable3", (Iterable<Row>)TestData$.MODULE$.smallData3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
    }

    @Test
    public void testJavaGenericTableFunc() {
        this.tEnv().createTemporarySystemFunction("func0", new GenericTableFunc(DataTypes.INT()));
        this.tEnv().createTemporarySystemFunction("func1", new GenericTableFunc(DataTypes.STRING()));
        this.testGenericTableFunc();
    }

    @Test
    public void testScalaGenericTableFunc() {
        this.tEnv().createTemporarySystemFunction("func0", new GenericTableFunc(DataTypes.INT()));
        this.tEnv().createTemporarySystemFunction("func1", new GenericTableFunc(DataTypes.STRING()));
        this.testGenericTableFunc();
    }

    public void testGenericTableFunc() {
        this.checkResult("select a, s from inputT, LATERAL TABLE(func0(a)) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
        this.checkResult("select a, s from inputT, LATERAL TABLE(func1(a)) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @Test
    public void testConstantTableFunc() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("SELECT * FROM LATERAL TABLE(str_split()) as T0(d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.checkResult("SELECT * FROM LATERAL TABLE(str_split('Jack,John', ',')) as T0(d)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John"})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @Test
    public void testConstantTableFunc2() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("SELECT c, d FROM inputT, LATERAL TABLE(str_split()) AS T0(d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "c"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", "a"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", "b"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", "c"}))}))), this.checkResult$default$3());
        this.checkResult("SELECT c, d FROM inputT, LATERAL TABLE(str_split('Jack,John', ',')) AS T0(d)", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "John"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "Jack"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Jack"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "John"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", "Jack"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", "John"}))}))), this.checkResult$default$3());
        this.checkResult("SELECT c, d FROM inputT, LATERAL TABLE(str_split('Jack,John', ',')) AS T0(d) WHERE d = 'Jack'", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", "Jack"})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }

    @Test
    public void testConstantTableFunc3() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("SELECT c, d FROM inputT, LATERAL TABLE(str_split('Jack,John', ',', 1)) AS T0(d) WHERE SUBSTRING(c, 1, 4) = d", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John"})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testConstantTableFuncWithSubString() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("SELECT * FROM LATERAL TABLE(str_split(SUBSTRING('a,b,c', 2, 4), ',')) as T1(s), LATERAL TABLE(str_split('a,b,c', ',')) as T2(x)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", "a"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", "b"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", "c"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c", "a"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c", "b"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c", "c"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testUdfAfterUdtf() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)StringUdFunc$.MODULE$);
        this.checkResult("select func(s) from inputT, LATERAL TABLE(str_split(c, '#')) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"19"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"44"})), (List)Nil$.MODULE$)))))))), this.checkResult$default$3());
    }

    @Test
    public void testLeftInputAllProjectWithEmptyOutput() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("select s from inputTWithNull, LATERAL TABLE(str_split(c, '#')) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinLeftInputAllProjectWithEmptyOutput() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("select s from inputTWithNull left join LATERAL TABLE(str_split(c, '#')) as T(s) ON TRUE", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"22"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @Test
    public void testLeftInputPartialProjectWithEmptyOutput() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("select a, s from inputTWithNull, LATERAL TABLE(str_split(c, '#')) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "nosharp"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "22"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinLeftInputPartialProjectWithEmptyOutput() {
        this.tEnv().createTemporarySystemFunction("str_split", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.checkResult("select b, s from inputTWithNull left join LATERAL TABLE(str_split(c, '#')) as T(s) ON TRUE", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "nosharp"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "22"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), null})), (List)Nil$.MODULE$)))))), this.checkResult$default$3());
    }

    @Test
    public void testLeftInputPartialProjectWithEmptyOutput2() {
        this.tEnv().createTemporarySystemFunction("toPojo", (UserDefinedFunction)new MyToPojoTableFunc());
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)StringUdFunc$.MODULE$);
        this.checkResult("select a, s2 from inputTWithNull, LATERAL TABLE(toPojo(a)) as T(s1,s2) where a + s1 > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinLeftInputPartialProjectWithEmptyOutput2() {
        this.tEnv().createTemporarySystemFunction("toPojo", (UserDefinedFunction)new MyToPojoTableFunc());
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)StringUdFunc$.MODULE$);
        this.checkResult("select b, s1 from inputTWithNull left join LATERAL TABLE(toPojo(a)) as T(s1,s2) ON TRUE where a + s1 > 2", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testTableFunctionWithBinaryString() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new BinaryStringTableFunc());
        this.checkResult("select c, s1, s2 from inputT, LATERAL TABLE(func(c, 'haha')) as T(s1, s2)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack#22", "haha"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John#19", "haha"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", "nosharp", "haha"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna#44", "haha"})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }
}

