/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.Func18$;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.runtime.batch.sql.MyPojoTableFunc;
import org.apache.flink.table.planner.runtime.batch.sql.MyToPojoTableFunc;
import org.apache.flink.table.planner.runtime.batch.sql.TableFunctionITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$MyPojoFunc$;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.HierarchyTableFunction;
import org.apache.flink.table.planner.utils.PojoTableFunc;
import org.apache.flink.table.planner.utils.RichTableFunc1;
import org.apache.flink.table.planner.utils.RichTableFuncWithFinish;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.planner.utils.TableFunc3;
import org.apache.flink.table.planner.utils.VarArgsFunc0;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0005\n\u0001G!)!\u0006\u0001C\u0001W!)a\u0006\u0001C!_!)\u0011\t\u0001C\u0001_!)a\t\u0001C\u0001_!)\u0001\n\u0001C\u0001_!)!\n\u0001C\u0001_!)A\n\u0001C\u0001_!)a\n\u0001C\u0001_!)\u0001\u000b\u0001C\u0001_!)!\u000b\u0001C\u0001_!)A\u000b\u0001C\u0001_!)a\u000b\u0001C\u0001_!)\u0001\f\u0001C\u0001_!)!\f\u0001C\u0001_!)A\f\u0001C\u0001_!)a\f\u0001C\u0001_\ty1i\u001c:sK2\fG/Z%U\u0007\u0006\u001cXM\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012!\u00022bi\u000eD'BA\f\u0019\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0007\u000e\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0004H\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003;y\tQA\u001a7j].T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\t9c#A\u0003vi&d7/\u0003\u0002*M\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0017\u0011\u00055\u0002Q\"\u0001\n\u0002\r\t,gm\u001c:f)\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$\u0001B+oSRD#AA\u001c\u0011\u0005azT\"A\u001d\u000b\u0005iZ\u0014aA1qS*\u0011A(P\u0001\bUV\u0004\u0018\u000e^3s\u0015\tq\u0004%A\u0003kk:LG/\u0003\u0002As\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002#Q,7\u000f\u001e+bE2,g)\u001e8di&|g\u000e\u000b\u0002\u0004\u0007B\u0011\u0001\bR\u0005\u0003\u000bf\u0012A\u0001V3ti\u0006\tB/Z:u\u0019\u00164GoT;uKJTu.\u001b8)\u0005\u0011\u0019\u0015A\u0004;fgR<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003\u000b\r\u000b\u0011\u0003^3ti\"KWM]1sG\"LH+\u001f9fQ\t11)\u0001\u0007uKN$\bk\u001c6p)f\u0004X\r\u000b\u0002\b\u0007\u0006qC/Z:u+N,'\u000fR3gS:,G\rV1cY\u00164UO\\2uS>tw+\u001b;i'\u000e\fG.\u0019:Gk:\u001cG/[8oQ\tA1)A\u001duKN$Xk]3s\t\u00164\u0017N\\3e)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8XSRD7kY1mCJ4UO\\2uS>t\u0017J\\\"p]\u0012LG/[8oQ\tI1)\u0001\ruKN$Hj\u001c8h\u0003:$G+Z7q_J\fG\u000eV=qKND#AC\"\u0002SQ,7\u000f^+tKJ$UMZ5oK\u0012$\u0016M\u00197f\rVt7\r^5p]^KG\u000f\u001b)be\u0006lW\r^3sQ\tY1)\u0001\u001fuKN$Xk]3s\t\u00164\u0017N\\3e)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8XSRD7kY1mCJ4UO\\2uS>tw+\u001b;i!\u0006\u0014\u0018-\\3uKJ\u001c\bF\u0001\u0007D\u0003\u0019\"Xm\u001d;UC\ndWMR;oGRLwN\\\"p]N$(/^2u_J<\u0016\u000e\u001e5QCJ\fWn\u001d\u0015\u0003\u001b\r\u000ba\u0005^3tiR\u000b'\r\\3Gk:\u001cG/[8o/&$\bNV1sS\u0006\u0014G.Z!sOVlWM\u001c;tQ\tq1)A\u0007uKN$\bk\u001c6p\r&,G\u000e\u001a\u0015\u0003\u001f\r\u000b\u0011\u0005^3tiR\u000b'\r\\3Gk:\u001cG/[8o/&$\bNR5oSNDW*\u001a;i_\u0012D#\u0001E\"")
public class CorrelateITCase
extends BatchTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.registerCollection("inputT", (Iterable<Row>)TableFunctionITCase$.MODULE$.testData(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("inputTWithNull", (Iterable<Row>)TableFunctionITCase$.MODULE$.testDataWithNull(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
        this.registerCollection("SmallTable3", (Iterable<Row>)TestData$.MODULE$.smallData3(), (TypeInformation<Row>)TestData$.MODULE$.type3(), "a, b, c");
    }

    @Test
    public void testTableFunction() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc1());
        this.checkResult("select c, s from inputT, LATERAL TABLE(func(c)) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "22"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "19"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "44"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testLeftOuterJoin() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc2());
        this.checkResult("select c, s, l from inputT LEFT JOIN LATERAL TABLE(func(c)) as T(s, l) ON TRUE", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "22", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "19", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "44", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp", null, null})), (List)Nil$.MODULE$)))))))), this.checkResult$default$3());
    }

    @Test
    public void testWithFilter() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc0());
        this.checkResult("select c, name, age from inputT, LATERAL TABLE(func(c)) as T(name, age) WHERE T.age > 20", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)22)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToInteger((int)44)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @Test
    public void testHierarchyType() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new HierarchyTableFunction());
        this.checkResult("select c, name, adult, len from inputT, LATERAL TABLE(func(c)) as T(name, adult, len)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)22)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John", BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)19)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)44)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testPojoType() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new PojoTableFunc());
        this.checkResult("select c, name, age from inputT, LATERAL TABLE(func(c)) as T(name, age) WHERE T.age > 20", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)22)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", BoxesRunTime.boxToInteger((int)44)})), (List)Nil$.MODULE$))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunction() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc1());
        this.checkResult("select c, s from inputT, LATERAL TABLE(func(SUBSTRING(c, 2))) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "ack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "22"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "ohn"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "19"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "nna"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "44"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionInCondition() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new TableFunc0());
        this.tEnv().createTemporarySystemFunction("func18", (UserDefinedFunction)Func18$.MODULE$);
        this.tEnv().createTemporarySystemFunction("func1", (UserDefinedFunction)Func1$.MODULE$);
        this.checkResult("select c, name, age from inputT, LATERAL TABLE(func(c)) as T(name, age) where func18(name, 'J') and func1(a) < 3 and func1(age) > 20", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", BoxesRunTime.boxToInteger((int)22)})), (List)Nil$.MODULE$)), this.checkResult$default$3());
    }

    @Test
    public void testLongAndTemporalTypes() {
        this.registerCollection("myT", (Iterable<Row>)((Iterable)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateTimeTestUtil$.MODULE$.localDate("1990-10-14"), BoxesRunTime.boxToLong((long)1000L), DateTimeTestUtil$.MODULE$.localDateTime("1990-10-14 12:10:10")})), (List)Nil$.MODULE$)), (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{LocalTimeTypeInfo.LOCAL_DATE, BasicTypeInfo.LONG_TYPE_INFO, LocalTimeTypeInfo.LOCAL_DATE_TIME}), "x, y, z");
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new JavaUserDefinedTableFunctions.JavaTableFunc0());
        this.checkResult("select s from myT, LATERAL TABLE(func(x, y, z)) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1000L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)655906210000L)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)7591L)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithParameter() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new RichTableFunc1());
        Configuration conf = new Configuration();
        conf.setString("word_separator", "#");
        this.env().getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)conf);
        this.checkResult("select a, s from inputT, LATERAL TABLE(func(c)) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Jack"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "22"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "John"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "19"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Anna"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "44"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunctionWithParameters() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new RichTableFunc1());
        this.tEnv().createTemporarySystemFunction("func2", (UserDefinedFunction)new RichFunc2());
        Configuration conf = new Configuration();
        conf.setString("word_separator", "#");
        conf.setString("string.value", "test");
        this.env().getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)conf);
        this.checkResult("select a, s from SmallTable3, LATERAL TABLE(func(func2(c))) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "Hi"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Hello"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "test"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Hello world"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "test"})), (List)Nil$.MODULE$))))))), this.checkResult$default$3());
    }

    @Test
    public void testTableFunctionConstructorWithParams() {
        this.tEnv().createTemporarySystemFunction("func30", (UserDefinedFunction)new TableFunc3(null));
        this.tEnv().createTemporarySystemFunction("func31", (UserDefinedFunction)new TableFunc3("OneConf_"));
        this.tEnv().createTemporarySystemFunction("func32", (UserDefinedFunction)new TableFunc3("TwoConf_"));
        this.checkResult("select c, d, f, h, e, g, i from inputT, LATERAL TABLE(func30(c)) as T0(d, e), LATERAL TABLE(func31(c)) as T1(f, g),LATERAL TABLE(func32(c)) as T2(h, i)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44", "Anna", "OneConf_Anna", "TwoConf_Anna", BoxesRunTime.boxToInteger((int)44), BoxesRunTime.boxToInteger((int)44), BoxesRunTime.boxToInteger((int)44)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack", "OneConf_Jack", "TwoConf_Jack", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)22)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19", "John", "OneConf_John", "TwoConf_John", BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToInteger((int)19)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testTableFunctionWithVariableArguments() {
        this.tEnv().createTemporarySystemFunction("func", (UserDefinedFunction)new VarArgsFunc0());
        this.checkResult("select c, d from inputT, LATERAL TABLE(func('1', '2', c)) as T0(d) where c = 'Jack#22'", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22", "Jack#22"})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testPojoField() {
        Seq data = (Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UserDefinedFunctionTestUtils.MyPojo(5, 105)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UserDefinedFunctionTestUtils.MyPojo(6, 11)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UserDefinedFunctionTestUtils.MyPojo(7, 12)})), (List)Nil$.MODULE$)));
        this.registerCollection("MyTable", (Iterable<Row>)data, (TypeInformation<Row>)new RowTypeInfo(new TypeInformation[]{TypeExtractor.createTypeInfo(UserDefinedFunctionTestUtils.MyPojo.class)}), "a");
        this.tEnv().createTemporarySystemFunction("pojoTFunc", (UserDefinedFunction)new MyPojoTableFunc());
        this.checkResult("select s from MyTable, LATERAL TABLE(pojoTFunc(a)) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)105)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
        this.tEnv().createTemporarySystemFunction("pojoFunc", (UserDefinedFunction)UserDefinedFunctionTestUtils$MyPojoFunc$.MODULE$);
        this.tEnv().createTemporarySystemFunction("toPojoTFunc", (UserDefinedFunction)new MyToPojoTableFunc());
        this.checkResult("select b from MyTable, LATERAL TABLE(toPojoTFunc(pojoFunc(a))) as T(b, c)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)105)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11)})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12)})), (List)Nil$.MODULE$)))), this.checkResult$default$3());
    }

    @Test
    public void testTableFunctionWithFinishMethod() {
        this.registerTemporarySystemFunction("udtfWithFinish", RichTableFuncWithFinish.class);
        this.checkResult("select s from inputT, LATERAL TABLE(udtfWithFinish(c)) as T(s)", (Seq<Row>)((Seq)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack#22"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"John#19"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Anna#44"})), (List)new .colon.colon((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"nosharp"})), (List)Nil$.MODULE$))))), this.checkResult$default$3());
    }
}

