/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.table.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func0$;
import org.apache.flink.table.planner.expressions.utils.Func15$;
import org.apache.flink.table.planner.plan.stream.table.validation.CorrelateValidationTest$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.ObjectTableFunction$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q4A\u0001D\u0007\u0001?!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0001W!)Q\b\u0001C\u0001W!)q\b\u0001C\u0001W!)\u0011\t\u0001C\u0001W!)1\t\u0001C\u0001W!)Q\t\u0001C\u0001W!)q\t\u0001C\u0001W!)\u0011\n\u0001C\u0001W!)1\n\u0001C\u0005\u0019\"9a\u000fAI\u0001\n\u00139(aF\"peJ,G.\u0019;f-\u0006d\u0017\u000eZ1uS>tG+Z:u\u0015\tqq\"\u0001\u0006wC2LG-\u0019;j_:T!\u0001E\t\u0002\u000bQ\f'\r\\3\u000b\u0005I\u0019\u0012AB:ue\u0016\fWN\u0003\u0002\u0015+\u0005!\u0001\u000f\\1o\u0015\t1r#A\u0004qY\u0006tg.\u001a:\u000b\u0005AA\"BA\r\u001b\u0003\u00151G.\u001b8l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003GU\tQ!\u001e;jYNL!!\n\u0012\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\tQ\"A\u000fuKN$(+Z4jgR,'OR;oGRLwN\\#yG\u0016\u0004H/[8o)\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#\u0001B+oSRD#AA\u001a\u0011\u0005QZT\"A\u001b\u000b\u0005Y:\u0014aA1qS*\u0011\u0001(O\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQD$A\u0003kk:LG/\u0003\u0002=k\t!A+Z:u\u0003a!Xm\u001d;J]Z\fG.\u001b3UC\ndWMR;oGRLwN\u001c\u0015\u0003\u0007M\nq\u0004^3ti2+g\r^(vi\u0016\u0014(j\\5o/&$\b\u000e\u0015:fI&\u001c\u0017\r^3tQ\t!1'A\u0013uKN$\u0018J\u001c<bY&$W*\u00199Gk:\u001cG/[8o)f\u0004X-Q4he\u0016<\u0017\r^5p]\"\u0012QaM\u0001 i\u0016\u001cH/\u00138wC2LG-T1q\rVt7\r^5p]RK\b/Z+E\u0003\u001e;\u0005F\u0001\u00044\u0003\u0001\"Xm\u001d;J]Z\fG.\u001b3NCB4UO\\2uS>tG+\u001f9f+\u0012\u000bui\u0012\u001a)\u0005\u001d\u0019\u0014\u0001\u000b;fgRLeN^1mS\u0012l\u0015\r\u001d$v]\u000e$\u0018n\u001c8UsB,7kY1mCJ4UO\\2uS>t\u0007F\u0001\u00054\u00031\"Xm\u001d;J]Z\fG.\u001b3GY\u0006$X*\u00199Gk:\u001cG/[8o)f\u0004XMR5fY\u0012\u0014VMZ3sK:\u001cW\r\u000b\u0002\ng\u0005)R\r\u001f9fGR,\u0005pY3qi&|g\u000e\u00165s_^tG\u0003\u0002\u0017N%~CaA\u0014\u0006\u0005\u0002\u0004y\u0015\u0001\u00034v]\u000e$\u0018n\u001c8\u0011\u00075\u0002F&\u0003\u0002R]\tAAHY=oC6,g\bC\u0003T\u0015\u0001\u0007A+\u0001\u0005lKf<xN\u001d3t!\t)FL\u0004\u0002W5B\u0011qKL\u0007\u00021*\u0011\u0011LH\u0001\u0007yI|w\u000e\u001e \n\u0005ms\u0013A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!a\u0017\u0018\t\u000f\u0001T\u0001\u0013!a\u0001C\u0006)1\r\\1{uB\u0012!m\u001a\t\u0004+\u000e,\u0017B\u00013_\u0005\u0015\u0019E.Y:t!\t1w\r\u0004\u0001\u0005\u0013!|\u0016\u0011!A\u0001\u0006\u0003I'aA0%cE\u0011!.\u001c\t\u0003[-L!\u0001\u001c\u0018\u0003\u000f9{G\u000f[5oOB\u0011an\u001d\b\u0003_Ft!a\u00169\n\u0003=J!A\u001d\u0018\u0002\u000fA\f7m[1hK&\u0011A/\u001e\u0002\n)\"\u0014xn^1cY\u0016T!A\u001d\u0018\u0002?\u0015D\b/Z2u\u000bb\u001cW\r\u001d;j_:$\u0006N]8x]\u0012\"WMZ1vYR$3'F\u0001ya\tI8\u0010E\u0002VGj\u0004\"AZ>\u0005\u0013!\\\u0011\u0011!A\u0001\u0006\u0003I\u0007")
public class CorrelateValidationTest
extends TableTestBase {
    @Test
    public void testRegisterFunctionException() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        Table t = util.addTableSource((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.table.validation.CorrelateValidationTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTemporarySystemFunction("func3", (UserDefinedFunction)ObjectTableFunction$.MODULE$), "Could not register temporary system function 'func3' due to implementation errors.", this.expectExceptionThrown$default$3());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> t.joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)ObjectTableFunction$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.int2Literal(1)}))), "Scala object", this.expectExceptionThrown$default$3());
    }

    @Test
    public void testInvalidTableFunction() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        Table t = util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.table.validation.CorrelateValidationTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTemporarySystemFunction("udtf", (UserDefinedFunction)ObjectTableFunction$.MODULE$), "Could not register temporary system function 'udtf' due to implementation errors.", this.expectExceptionThrown$default$3());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTemporarySystemFunction("udtf", (UserDefinedFunction)ObjectTableFunction$.MODULE$), "Could not register temporary system function 'udtf' due to implementation errors.", this.expectExceptionThrown$default$3());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> t.joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)ObjectTableFunction$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.int2Literal(1)}))), "Scala object", this.expectExceptionThrown$default$3());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> t.joinLateral(package$.MODULE$.call("nonexist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}))), "Undefined function: nonexist", this.expectExceptionThrown$default$3());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.tableEnv().sqlQuery("SELECT * FROM MyTable, LATERAL TABLE(nonexist(a))"), "No match found for function signature nonexist(<NUMERIC>)", this.expectExceptionThrown$default$3());
        util.addTemporarySystemFunction("func0", (UserDefinedFunction)Func0$.MODULE$);
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.tableEnv().sqlQuery("SELECT * FROM MyTable, LATERAL TABLE(func0(a))"), null, ValidationException.class);
        util.addTemporarySystemFunction("func2", (UserDefinedFunction)new TableFunc2());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> t.joinLateral(package$.MODULE$.call("func2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))), "Invalid function call:\nfunc2(STRING, STRING)", this.expectExceptionThrown$default$3());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.tableEnv().sqlQuery("SELECT * FROM MyTable, LATERAL TABLE(func2(c, c))"), "No match found for function signature func2(<CHARACTER>, <CHARACTER>).", this.expectExceptionThrown$default$3());
    }

    @Test
    public void testLeftOuterJoinWithPredicates() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        Table table = util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.table.validation.CorrelateValidationTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        TableFunc1 function = new TableFunc1();
        util.addTemporarySystemFunction("func1", (UserDefinedFunction)function);
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Table result = table.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)function).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))}).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(10)));
            util.verifyExecPlan(result);
        }, null, this.expectExceptionThrown$default$3());
    }

    @Test
    public void testInvalidMapFunctionTypeAggregation() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int"))}), BasicTypeInfo.getInfoFor(Integer.TYPE)).flatMap((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")).sum()), null, this.expectExceptionThrown$default$3());
    }

    @Test
    public void testInvalidMapFunctionTypeUDAGG() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        JavaUserDefinedAggFunctions.WeightedAvg weightedAvg = new JavaUserDefinedAggFunctions.WeightedAvg();
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int"))}), BasicTypeInfo.getInfoFor(Integer.TYPE)).flatMap(package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)weightedAvg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int"))}))), null, this.expectExceptionThrown$default$3());
    }

    @Test
    public void testInvalidMapFunctionTypeUDAGG2() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        util.addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.WeightedAvg());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "int"))}), BasicTypeInfo.getInfoFor(Integer.TYPE)).flatMap(package$.MODULE$.call("weightedAvg", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"int"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"int"}))).$((Seq)Nil$.MODULE$)}))), null, this.expectExceptionThrown$default$3());
    }

    @Test
    public void testInvalidMapFunctionTypeScalarFunction() {
        StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "string"))}), BasicTypeInfo.getInfoFor(String.class)).flatMap(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func15$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "string"))}))), null, this.expectExceptionThrown$default$3());
    }

    @Test
    public void testInvalidFlatMapFunctionTypeFieldReference() {
        BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());
        this.expectExceptionThrown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> util.addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "string"))}), BasicTypeInfo.getInfoFor(String.class)).flatMap(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "string"))), null, this.expectExceptionThrown$default$3());
    }

    private void expectExceptionThrown(Function0<BoxedUnit> function, String keywords, Class<? extends Throwable> clazz) {
        ThrowableAssert.ThrowingCallable callable = () -> function.apply$mcV$sp();
        if (keywords != null) {
            Assertions.assertThatExceptionOfType(clazz).isThrownBy(callable).withMessageContaining(keywords);
            return;
        }
        Assertions.assertThatExceptionOfType(clazz).isThrownBy(callable);
    }

    private Class<? extends Throwable> expectExceptionThrown$default$3() {
        return ValidationException.class;
    }
}

