/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\u0016,\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004O\u0001\u0001\u0006Ia\u0013\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006E\u0002!\t\u0001\u0015\u0005\u0006I\u0002!\t\u0001\u0015\u0005\u0006M\u0002!\t\u0001\u0015\u0005\u0006Q\u0002!\t\u0001\u0015\u0005\u0006U\u0002!\t\u0001\u0015\u0005\u0006Y\u0002!\t\u0001\u0015\u0005\u0006]\u0002!\t\u0001\u0015\u0005\u0006a\u0002!\t\u0001\u0015\u0005\u0006e\u0002!\t\u0001\u0015\u0005\u0006i\u0002!\t\u0001\u0015\u0005\u0006m\u0002!\t\u0001\u0015\u0005\u0006q\u0002!\t\u0001\u0015\u0005\u0006u\u0002!\t\u0001\u0015\u0005\u0006y\u0002!\t\u0001\u0015\u0005\u0006}\u0002!\t\u0001\u0015\u0005\u0007\u0003\u0003\u0001A\u0011\u0001)\t\r\u0005\u0015\u0001\u0001\"\u0001Q\u0011\u0019\tI\u0001\u0001C\u0001!\"1\u0011Q\u0002\u0001\u0005\u0002ACa!!\u0005\u0001\t\u0003\u0001\u0006BBA\u000b\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002\u001a\u0001!\t\u0001\u0015\u0005\u0007\u0003;\u0001A\u0011\u0001)\t\r\u0005\u0005\u0002\u0001\"\u0001Q\u0011\u0019\t)\u0003\u0001C\u0001!\"1\u0011\u0011\u0006\u0001\u0005\u0002ACa!!\f\u0001\t\u0003\u0001\u0006BBA\u0019\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u00026\u0001!\t\u0001\u0015\u0005\u0007\u0003s\u0001A\u0011\u0001)\t\r\u0005u\u0002\u0001\"\u0001Q\u0011\u0019\t\t\u0005\u0001C\u0001!\"1\u0011Q\t\u0001\u0005\u0002ACa!!\u0013\u0001\t\u0003\u0001\u0006BBA'\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002R\u0001!\t\u0001\u0015\u0005\b\u0003+\u0002A\u0011AA,\u0005A9%o\\;qS:<7+\u001a;t)\u0016\u001cHO\u0003\u0002-[\u0005\u0019\u0011mZ4\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0007gR\u0014X-Y7\u000b\u0005I\u001a\u0014\u0001\u00029mC:T!\u0001N\u001b\u0002\u000fAd\u0017M\u001c8fe*\u0011agN\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003qe\nQA\u001a7j].T!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO\u000e\u00011C\u0001\u0001@!\t\u00015)D\u0001B\u0015\t\u00115'A\u0003vi&d7/\u0003\u0002E\u0003\niA+\u00192mKR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A$\u0011\u0005!\u0003Q\"A\u0016\u0002\tU$\u0018\u000e\\\u000b\u0002\u0017B\u0011\u0001\tT\u0005\u0003\u001b\u0006\u00131c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2\fQ!\u001e;jY\u0002\n\u0001\u0003^3ti\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:\u0015\u0003E\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013A!\u00168ji\"\u0012A\u0001\u0017\t\u00033\u0002l\u0011A\u0017\u0006\u00037r\u000b1!\u00199j\u0015\tif,A\u0004kkBLG/\u001a:\u000b\u0005}[\u0014!\u00026v]&$\u0018BA1[\u0005\u0011!Vm\u001d;\u0002#Q,7\u000f^$s_V\u0004\u0018N\\4TKR\u001c(\u0007\u000b\u0002\u00061\u0006\tB/Z:u\u000fJ|W\u000f]5oON+Go]\u001a)\u0005\u0019A\u0016A\t;fgR<%o\\;qS:<7+\u001a;t\u001fV$\b/\u001e;t\u001dVdG.\u00192jY&$\u0018\u0010\u000b\u0002\b1\u0006AA/Z:u\u0007V\u0014W\r\u000b\u0002\t1\u0006QA/Z:u%>dG.\u001e9)\u0005%A\u0016a\b;fgR<%o\\;qS:<7+\u001a;t/&$\bn\u00148f\u000fJ|W\u000f]5oO\"\u0012!\u0002W\u0001\u0016i\u0016\u001cHOQ1tS\u000e<%o\\;qS:<7+\u001a;tQ\tY\u0001,\u0001\u000fuKN$xI]8va&twmU3ug>sW\t\u001f9sKN\u001c\u0018n\u001c8)\u00051A\u0016A\u0004;fgR\u001c\u0016.\u001c9mK\u000e+(-\u001a\u0015\u0003\u001ba\u000b1\u0003^3tiJ{G\u000e\\;q\u001f:\f4i\u001c7v[:D#A\u0004-\u0002'Q,7\u000f\u001e*pY2,\bo\u001483\u0007>dW/\u001c8)\u0005=A\u0016a\u0007;fgR\u0014v\u000e\u001c7va>s7i\u001c7v[:<\u0016\u000e\u001e5Ok2d7\u000f\u000b\u0002\u00111\u0006)B/Z:u%>dG.\u001e9QYV\u001cxJ\u001d3fe\nK\bFA\tY\u0003i!Xm\u001d;S_2dW\u000f]\"beR,7/[1o!J|G-^2uQ\t\u0011\u0002,A\u001auKN$(k\u001c7mkB\u001c\u0015M\u001d;fg&\fg\u000e\u0015:pIV\u001cGo\u00144XSRDG+\u001e9mK^KG\u000f[#yaJ,7o]5p]\"\u00121\u0003W\u0001\u0015i\u0016\u001cHOU8mYV\u0004x+\u001b;i\u0011\u00064\u0018N\\4)\u0005QA\u0016a\u0005;fgR\u001cUOY3B]\u0012$\u0015n\u001d;j]\u000e$\bFA\u000bY\u0003=!Xm\u001d;Dk\n,\u0017I\u001c3K_&t\u0007F\u0001\fY\u0003!\"Xm\u001d;He>,\b/\u001b8h\u0013:\u001cV\r\\3di\u000ec\u0017-^:f\u001f\u001a<%o\\;q\u0005f\fV/\u001a:zQ\t9\u0002,A\u0013uKN$xI]8va&tw-\u00138TK2,7\r^\"mCV\u001cXm\u00144Dk\n,\u0017+^3ss\"\u0012\u0001\u0004W\u0001<i\u0016\u001cHo\u0012:pkBLgnZ$s_V\u0004x,\u001b3He>,\b/\u001b8h?&$\u0017J\\*fY\u0016\u001cGo\u00117bkN,wJZ$s_V\u0004()_)vKJL\bFA\rY\u0003\u0001#Xm\u001d;He>,\b/\u001b8h\u0003\u000e\u001cW\r\u001d;t\u001bVdG/\u001b9mK\u0006\u0013x-^7f]R\u001cx)\u001b<fgN\u000bW.\u001a*fgVdG/Q:He>,\b/\u001b8h?&$\u0007F\u0001\u000eY\u0003m!Xm\u001d;He>,\b/\u001b8h\u0013:|%\u000fZ3s\u0005f\u001cE.Y;tK\"\u00121\u0004W\u0001#i\u0016\u001cH\u000fR;qY&\u001c\u0017\r^3Be\u001e,X.\u001a8u)><%o\\;qS:<w,\u001b3)\u0005qA\u0016a\n;fgR<%o\\;qS:<\u0017J\\*fY\u0016\u001cGo\u00117bkN,wJ\u001a*pY2,\b/U;fefD#!\b-\u0002EQ,7\u000f^$s_V\u0004\u0018N\\4He>,\b/\u001b8h?&$\u0017I\u001c3He>,\boX5eQ\tq\u0002,\u0001\u000fuKN$\u0018\t\u001c7po\u0016C\bO]3tg&|g.\u00138S_2dW\u000f]\u0019)\u0005}A\u0016A\u0007;fgR\fE\u000e\\8x\u000bb\u0004(/Z:tS>t\u0017J\\\"vE\u0016\f\u0004F\u0001\u0011Y\u0003q!Xm\u001d;BY2|w/\u0012=qe\u0016\u001c8/[8o\u0013:\u0014v\u000e\u001c7vaJB#!\t-\u00025Q,7\u000f^!mY><X\t\u001f9sKN\u001c\u0018n\u001c8J]\u000e+(-\u001a\u001a)\u0005\tB\u0016\u0001\b;fgR\fE\u000e\\8x\u000bb\u0004(/Z:tS>t\u0017J\u001c*pY2,\bo\r\u0015\u0003Ga\u000bq\u0002^3ti\u000e\u000bEjQ%U\u000bFB$\u0007\u000e\u0015\u0003Ia\u000b\u0001\u0003^3ti\u001a\u0013x.\u001c\"m_\u001e\u001c\bo\u001c;)\u0005\u0015B\u0016A\u0006;fgR\u001cUOY3Bg\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:)\u0005\u0019B\u0016\u0001\u0007;fgR\u0014v\u000e\u001c7va\u0006\u001bxI]8va&twmU3ug\"\u0012q\u0005W\u0001(i\u0016\u001cHoQ1tK^CWM\u001c*fM\u001e\u0013x.\u001e9j]\u001e\u001cV\r^:Ok2d\u0017M\u00197f\u0007>d7\u000f\u000b\u0002)1\u0006\u0019b/\u001a:jMf\u0004F.\u00198JI\u0016tG/[2bYR)\u0011+!\u0017\u0002t!9\u00111L\u0015A\u0002\u0005u\u0013\u0001B:rYF\u0002B!a\u0018\u0002n9!\u0011\u0011MA5!\r\t\u0019gU\u0007\u0003\u0003KR1!a\u001a>\u0003\u0019a$o\\8u}%\u0019\u00111N*\u0002\rA\u0013X\rZ3g\u0013\u0011\ty'!\u001d\u0003\rM#(/\u001b8h\u0015\r\tYg\u0015\u0005\b\u0003kJ\u0003\u0019AA/\u0003\u0011\u0019\u0018\u000f\u001c\u001a")
public class GroupingSetsTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, AVG(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSets2() {
        this.util().verifyExecPlan("SELECT b, c, AVG(a) AS a FROM MyTable GROUP BY GROUPING SETS (b, c, ())");
    }

    @Test
    public void testGroupingSets3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid,\n        |    COUNT(*) AS cnt\n        |FROM MyTable\n        |     GROUP BY GROUPING SETS (b, c, ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsOutputsNullability() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  a int,\n         |  b varchar,\n         |  c varchar not null,\n         |  d bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/to/my/path1',\n         |  'format' = 'testcsv'\n         |)\n      ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        | a,\n        | b,\n        | coalesce(c, 'empty'),\n        | avg(d)\n        |FROM t1\n        |GROUP BY GROUPING SETS ((a, b), (a, b, c))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno,\n        |    AVG(age) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(deptno) AS gb,\n        |    GROUPING_ID(deptno) AS gib\n        |FROM emps GROUP BY GROUPING SETS (deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBasicGroupingSets() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno))");
    }

    @Test
    public void testGroupingSetsOnExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno + 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleCube() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testRollupOn1Column() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno)");
    }

    @Test
    public void testRollupOn2Column() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT gender, deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupOnColumnWithNulls() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender)");
    }

    @Test
    public void testRollupPlusOrderBy() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender) ORDER BY c DESC");
    }

    @Test
    public void testRollupCartesianProduct() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno), ROLLUP(gender)");
    }

    @Test
    public void testRollupCartesianProductOfWithTupleWithExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno / 2 + 1 AS half1, COUNT(*) AS c FROM emp\n        |GROUP BY ROLLUP(deptno / 2, gender), ROLLUP(substring(ename FROM 1 FOR 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupWithHaving() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) HAVING COUNT(*) > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAndDistinct() {
        this.util().verifyExecPlan("SELECT DISTINCT COUNT(*) FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testCubeAndJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT e.deptno, e.gender,\n        |    MIN(e.ename) AS min_name\n        |FROM emp AS e JOIN dept AS d USING (deptno)\n        |    GROUP BY CUBE(e.deptno, d.deptno, e.gender)\n        |    HAVING COUNT(*) > 2 OR gender = 'M' AND e.deptno = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfGroupByQuery() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c, GROUPING(deptno) AS g FROM emp GROUP BY deptno");
    }

    @Test
    public void testGroupingInSelectClauseOfCubeQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job,\n        |    COUNT(*) AS c,\n        |    GROUPING(deptno) AS d,\n        |    GROUPING(job) j,\n        |    GROUPING(deptno, job) AS x\n        |FROM scott_emp GROUP BY CUBE(deptno, job)\n        |\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGroup_idGrouping_idInSelectClauseOfGroupByQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) as c,\n        |    GROUPING(deptno) AS g,\n        |    GROUP_ID() AS gid,\n        |    GROUPING_ID(deptno) AS gd,\n        |    GROUPING_ID(gender) AS gg,\n        |    GROUPING_ID(gender, deptno) AS ggd,\n        |    GROUPING_ID(deptno, gender) AS gdg\n        |FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingAcceptsMultipleArgumentsGivesSameResultAsGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c,\n        |    GROUPING(deptno) AS gd,\n        |    GROUPING_ID(deptno) AS gid,\n        |    GROUPING(deptno, gender, deptno) AS gdgd,\n        |    GROUPING_ID(deptno, gender, deptno) AS gidgd\n        |FROM emp\n        |    GROUP BY ROLLUP(deptno, gender)\n        |    HAVING GROUPING(deptno) <= GROUPING_ID(deptno, gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInOrderByClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) ORDER BY GROUPING(deptno), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDuplicateArgumentToGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING_ID(deptno, gender, deptno),\n        |    COUNT(*) AS c\n        |FROM emp WHERE deptno = 10\n        |    GROUP BY ROLLUP(gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfRollupQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c, deptno, GROUPING(deptno) AS g FROM emp GROUP BY ROLLUP(deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGrouping_idAndGroup_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING(deptno) gd,\n        |    GROUPING(gender) gg,\n        |    GROUPING_ID(deptno, gender) dg,\n        |    GROUPING_ID(gender, deptno) gd,\n        |    GROUP_ID() gid,\n        |    COUNT(*) c\n        |FROM emp\n        |    GROUP BY CUBE(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, deptno + 1 - 1 AS d0, COUNT(*) AS c\n        |FROM emp GROUP BY ROLLUP (deptno + 1)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY CUBE(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY ROLLUP(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube2() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY CUBE(1)");
    }

    @Test
    public void testAllowExpressionInRollup3() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(1)");
    }

    @Test
    public void testCALCITE1824() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, GROUP_ID() AS g, COUNT(*) AS c\n        |FROM scott_emp GROUP BY GROUPING SETS (deptno, (), ())\n      ")).stripMargin();
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).hasMessageContaining("GROUPING SETS are currently not supported") instanceof TableException;
    }

    @Test
    public void testFromBlogspot() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job, empno, ename, SUM(sal) sumsal,\n        |    CASE GROUPING_ID(deptno, job, empno)\n        |    WHEN 0 THEN CAST('grouped by deptno,job,empno,ename' as varchar)\n        |    WHEN 1 THEN CAST('grouped by deptno,job' as varchar)\n        |    WHEN 3 THEN CAST('grouped by deptno' as varchar)\n        |    WHEN 7 THEN CAST('grouped by ()' as varchar)\n        |    END gr_text\n        |from scott_emp\n        |    GROUP BY ROLLUP(deptno, job, (empno,ename))\n        |    ORDER BY deptno, job, empno\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAsGroupingSets() {
        String cubeQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), (c), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(cubeQuery, groupingSetsQuery);
        this.util().verifyExecPlan(cubeQuery);
    }

    @Test
    public void testRollupAsGroupingSets() {
        String rollupQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(rollupQuery, groupingSetsQuery);
        this.util().verifyExecPlan(rollupQuery);
    }

    @Test
    public void testCaseWhenRefGroupingSetsNullableCols() {
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    case\n        |     when g1 = 1 then 'aaa'\n        |     when g2 = 1 then 'bbb'\n        |    end as gt,\n        |    b, c,\n        |    AVG(a) AS a\n        |FROM (select *, 1 g1, 1 g2 from MyTable) t\n        |    GROUP BY GROUPING SETS ((g1, b), (g2, b, c))\n      ")).stripMargin();
        this.util().verifyExecPlan(groupingSetsQuery);
    }

    public void verifyPlanIdentical(String sql1, String sql2) {
        Table table1 = this.util().tableEnv().sqlQuery(sql1);
        Table table2 = this.util().tableEnv().sqlQuery(sql2);
        RelNode optimized1 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table1));
        RelNode optimized2 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table2));
        Assertions.assertThat((String)FlinkRelOptUtil$.MODULE$.toString(optimized2, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).isEqualTo(FlinkRelOptUtil$.MODULE$.toString(optimized1, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
    }

    public GroupingSetsTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "dname"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emps", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "city")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empid")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "slacker")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "manager")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "joinedat"))}), new CaseClassTypeInfo<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> unused = new ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(this, fieldSerializers){

                    public Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date> createInstance(Object[] fields) {
                        return new Tuple10((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)((String)fields[4]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[5])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[6])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[7])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[8])), (Object)((Date)fields[9]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("scott_emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "job")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "mgr")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "hiredate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "sal")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "comm")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno"))}), new CaseClassTypeInfo<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, String, String, Object, Date, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Date)fields[4]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[6])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$9 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

