/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.GroupWindowTest$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001\u0002\u0014(\u0001iBQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013%a\t\u0003\u0004K\u0001\u0001\u0006Ia\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u0006=\u0002!\t\u0001\u0014\u0005\u0006A\u0002!\t\u0001\u0014\u0005\u0006E\u0002!\t\u0001\u0014\u0005\u0006I\u0002!\t\u0001\u0014\u0005\u0006M\u0002!\t\u0001\u0014\u0005\u0006Q\u0002!\t\u0001\u0014\u0005\u0006U\u0002!\t\u0001\u0014\u0005\u0006Y\u0002!\t\u0001\u0014\u0005\u0006]\u0002!\t\u0001\u0014\u0005\u0006a\u0002!\t\u0001\u0014\u0005\u0006e\u0002!\t\u0001\u0014\u0005\u0006i\u0002!\t\u0001\u0014\u0005\u0006m\u0002!\t\u0001\u0014\u0005\u0006q\u0002!\t\u0001\u0014\u0005\u0006u\u0002!\t\u0001\u0014\u0005\u0006y\u0002!\t\u0001\u0014\u0005\u0006}\u0002!\t\u0001\u0014\u0005\u0007\u0003\u0003\u0001A\u0011\u0001'\t\r\u0005\u0015\u0001\u0001\"\u0001M\u0011\u0019\tI\u0001\u0001C\u0001\u0019\"1\u0011Q\u0002\u0001\u0005\u00021Ca!!\u0005\u0001\t\u0003a\u0005BBA\u000b\u0001\u0011\u0005A\n\u0003\u0004\u0002\u001a\u0001!\t\u0001\u0014\u0005\u0007\u0003;\u0001A\u0011\u0001'\t\r\u0005\u0005\u0002\u0001\"\u0001M\u0011\u0019\t)\u0003\u0001C\u0001\u0019\"1\u0011\u0011\u0006\u0001\u0005\u00021Ca!!\f\u0001\t\u0003a\u0005BBA\u0019\u0001\u0011\u0005A\n\u0003\u0004\u00026\u0001!\t\u0001\u0014\u0005\u0007\u0003s\u0001A\u0011\u0001'\t\r\u0005u\u0002\u0001\"\u0001M\u0005=9%o\\;q/&tGm\\<UKN$(B\u0001\u0015*\u0003\r\twm\u001a\u0006\u0003U-\n1a]9m\u0015\taS&\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003]=\nA\u0001\u001d7b]*\u0011\u0001'M\u0001\ba2\fgN\\3s\u0015\t\u00114'A\u0003uC\ndWM\u0003\u00025k\u0005)a\r\\5oW*\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005yz\u0013!B;uS2\u001c\u0018B\u0001!>\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012a\u0011\t\u0003\t\u0002i\u0011aJ\u0001\u0005kRLG.F\u0001H!\ta\u0004*\u0003\u0002J{\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\u0006)Q\u000f^5mA\u0005AB/Z:u)Vl'\r\\3XS:$wn\u001e(p\u001f\u001a47/\u001a;\u0015\u00035\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013A!\u00168ji\"\u0012A\u0001\u0016\t\u0003+rk\u0011A\u0016\u0006\u0003/b\u000b1!\u00199j\u0015\tI&,A\u0004kkBLG/\u001a:\u000b\u0005m;\u0014!\u00026v]&$\u0018BA/W\u0005\u0011!Vm\u001d;\u0002+Q,7\u000f\u001e%pa^Kg\u000eZ8x\u001d>|eMZ:fi\"\u0012Q\u0001V\u0001\u001ai\u0016\u001cHoU3tg&|gnV5oI><hj\\(gMN,G\u000f\u000b\u0002\u0007)\u00061B/Z:u-\u0006\u0014\u0018.\u00192mK^Kg\u000eZ8x'&TX\r\u000b\u0002\b)\u0006QB/Z:u/&tGm\\<VI\u0006;w-\u00138wC2LG-\u0011:hg\"\u0012\u0001\u0002V\u0001\u001bi\u0016\u001cHoV5oI><\u0018iZ4XSRDwI]8vaN+Go\u001d\u0015\u0003\u0013Q\u000bq\u0004^3ti^Kg\u000eZ8x/J|gnZ,j]\u0012|w\u000fU1sC6,G/\u001a:2Q\tQA+A\u0010uKN$x+\u001b8e_^<&o\u001c8h/&tGm\\<QCJ\fW.\u001a;feJB#a\u0003+\u0002\u001fQ,7\u000f^%oi\u0016\u0014h/\u00197ECfD#\u0001\u0004+\u0002%Q,7\u000f\u001e+v[\ndWMR;oGRLwN\u001c\u0015\u0003\u001bQ\u000b1\u0004^3ti^Kg\u000eZ8x\u000fJ|W\u000f\u001d\"z\u001f:\u001cuN\\:uC:$\bF\u0001\bU\u0003y!Xm\u001d;Uk6\u0014G.\u001b8h/&tGm\\<XSRD\u0007K]8di&lW\r\u000b\u0002\u0010)\u0006\u0019B/Z:u\u001bVdG/\u001b%pa^Kg\u000eZ8xg\"\u0012\u0001\u0003V\u0001\u0018i\u0016\u001cH/T;mi&Du\u000e],j]\u0012|wo\u001d&pS:D#!\u0005+\u0002'Q,7\u000f\u001e%paBLgn\u001a$v]\u000e$\u0018n\u001c8)\u0005I!\u0016!\u0007;fgRDu\u000e],j]\u0012|woV5uQB\u0013xn\u0019;j[\u0016D#a\u0005+\u0002'Q,7\u000f^*fgNLwN\u001c$v]\u000e$\u0018n\u001c8)\u0005Q!\u0016!\b;fgR\u001cVm]:j_:<\u0016N\u001c3po^KG\u000f\u001b)s_\u000e$\u0018.\\3)\u0005U!\u0016!\t;fgR,\u0005\u0010\u001d:fgNLwN\\(o/&tGm\\<Bkb4UO\\2uS>t\u0007F\u0001\fU\u0003\u0005\"Xm\u001d;Nk2$\u0018nV5oI><8+\u001d7XSRD\u0017iZ4sK\u001e\fG/[8oQ\t9B+\u0001\fuKN$H+^7cY\u00164UO\\%o\u000fJ|W\u000f\u001d\"zQ\tAB+A\ruKN$H+^7cY\u00164UO\u001c(pi&swI]8va\nK\bFA\rU\u0003\u0019\"Xm\u001d;Uk6\u0014G.\u001a$v]\u0006sGMU3hk2\f'/Q4h\rVt\u0017J\\$s_V\u0004()\u001f\u0015\u00035Q\u000bQ\u0007^3tiJ+w-\u001e7be\u0006;wMR;o\u0013:<%o\\;q\u0005f\fe\u000e\u001a+v[\ndWMR;o\u0003:$gj\u001c;J]\u001e\u0013x.\u001e9Cs\"\u00121\u0004V\u0001\u001di\u0016\u001cH\u000fR3d_6\u0004xn]1cY\u0016\fum\u001a$v]\u000e$\u0018n\u001c8tQ\taB+\u0001\u0013uKN$X\t\u001f9sKN\u001c\u0018n\u001c8P]^Kg\u000eZ8x\u0011\u00064\u0018N\\4Gk:\u001cG/[8oQ\tiB+A\u0012uKN$(+\u001a;ve:$\u0016\u0010]3J]\u001a,'/\u001a8dK\u001a{'oV5oI><\u0018iZ4)\u0005y!\u0016a\n;fgR<\u0016N\u001c3po\u0006;wM]3hCR,w+\u001b;i\t&4g-\u001a:f]R<\u0016N\u001c3poND#a\b+\u0002?Q,7\u000f^,j]\u0012|w/Q4he\u0016<\u0017\r^3XSRDG*\u0019;f\r&\u0014X\r\u000b\u0002!)\u0006!C/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK^KG\u000f[!mY><H*\u0019;f]\u0016\u001c8\u000f\u000b\u0002\")\u0006YC/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK^KG\u000f[%om\u0006d\u0017\u000eZ!mY><H*\u0019;f]\u0016\u001c8\u000f\u000b\u0002#)\u0006AC/Z:u/&tGm\\<BO\u001e\u0014XmZ1uK^KG\u000f[!mY><H*\u0019;f]\u0016\u001c8o\u00148ms\"\u00121\u0005V\u0001#i\u0016\u001cHoV5oI><\u0018iZ4sK\u001e\fG/Z(o%\u0016$(/Y2u'R\u0014X-Y7)\u0005\u0011\"\u0016!\t;fgR<\u0016N\u001c3po\u0006;wM]3hCR,wJ\\+qg\u0016\u0014HoU8ve\u000e,\u0007FA\u0013U\u0001")
public class GroupWindowTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTumbleWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testHopWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY HOP(proctime, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testSessionWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY SESSION(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testVariableWindowSize() {
        String sql = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, c * INTERVAL '1' MINUTE)";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sql));
    }

    @Test
    public void testWindowUdAggInvalidArgs() {
        String sqlQuery = "SELECT SUM(a) AS sumA, weightedAvg(a, b) AS wAvg FROM MyTable GROUP BY TUMBLE(proctime(), INTERVAL '2' HOUR, TIME '10:00:00')";
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery));
    }

    @Test
    public void testWindowAggWithGroupSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable\n        |    GROUP BY rollup(TUMBLE(rowtime, INTERVAL '15' MINUTE), b)\n    ")).stripMargin();
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.util().verifyRelPlanNotExpected(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TUMBLE(rowtime"})));
    }

    @Test
    public void testWindowWrongWindowParameter1() {
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '1' MONTH)";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).withMessageContaining("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
    }

    @Test
    public void testWindowWrongWindowParameter2() {
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2-10' YEAR TO MONTH)";
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan(sqlQuery)).withMessageContaining("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
    }

    @Test
    public void testIntervalDay() {
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '35' DAY)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumbleFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowGroupByOnConstant() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY 'a', TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumblingWindowWithProctime() {
        String sql = "select sum(a), max(b) from MyTable1 group by TUMBLE(c, INTERVAL '1' SECOND)";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiHopWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR),\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR),\n        |   count(*),\n        |   sum(c)\n        |FROM MyTable\n        |GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR)\n        |UNION ALL\n        |SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY),\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY),\n        |   count(*),\n        |   sum(c)\n        |FROM MyTable\n        |GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiHopWindowsJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        | (SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR) as hs1,\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR) as he1,\n        |   count(*) as c1,\n        |   sum(c) as s1\n        | FROM MyTable\n        | GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' HOUR)) t1\n        |JOIN\n        | (SELECT\n        |   HOP_START(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY) as hs2,\n        |   HOP_END(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY) as he2,\n        |   count(*) as c2,\n        |   sum(c) as s2\n        | FROM MyTable\n        | GROUP BY HOP(rowtime, INTERVAL '1' MINUTE, INTERVAL '1' DAY)) t2 ON t1.he1 = t2.he2\n        |WHERE t1.s1 IS NOT NULL\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHoppingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    weightedAvg(c, a) AS wAvg,\n        |    HOP_START(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR),\n        |    HOP_END(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR)\n        |FROM MyTable\n        |    GROUP BY HOP(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testHopWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable1\n         |group by HOP(c, INTERVAL '1' SECOND, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSessionFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    COUNT(*), weightedAvg(c, a) AS wAvg,\n        |    SESSION_START(proctime, INTERVAL '15' MINUTE),\n        |    SESSION_END(proctime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY SESSION(proctime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSessionWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable1\n         |group by SESSION(c, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testExpressionOnWindowAuxFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultiWindowSqlWithAggregation() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  TUMBLE_ROWTIME(zzzzz, INTERVAL '0.004' SECOND),\n        |  TUMBLE_END(zzzzz, INTERVAL '0.004' SECOND),\n        |  COUNT(`a`) AS `a`\n        |FROM (\n        |  SELECT\n        |    COUNT(`a`) AS `a`,\n        |    TUMBLE_ROWTIME(rowtime, INTERVAL '0.002' SECOND) AS `zzzzz`\n        |  FROM MyTable\n        |  GROUP BY TUMBLE(rowtime, INTERVAL '0.002' SECOND)\n        |)\n        |GROUP BY TUMBLE(zzzzz, INTERVAL '0.004' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)\n        |     ) AS t1\n        | GROUP BY b, ping_start\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunNotInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumbleFunAndRegularAggFunInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c, count(*) d,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b, d, ping_start\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRegularAggFunInGroupByAndTumbleFunAndNotInGroupBy() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT weightedAvg(c, a) FROM\n        |    (SELECT a, b, c, count(*) d,\n        |        TUMBLE_START(rowtime, INTERVAL '15' MINUTE) as ping_start\n        |     FROM MyTable\n        |         GROUP BY a, b, c, TUMBLE(rowtime, INTERVAL '15' MINUTE)) AS t1\n        |GROUP BY b, d\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testDecomposableAggFunctions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |    VAR_POP(c),\n        |    VAR_SAMP(c),\n        |    STDDEV_POP(c),\n        |    STDDEV_SAMP(c),\n        |    TUMBLE_START(rowtime, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(rowtime, INTERVAL '15' MINUTE)\n        |FROM MyTable\n        |    GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testExpressionOnWindowHavingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        | FROM MyTable\n        |     GROUP BY HOP(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |     HAVING SUM(a) > 0 AND\n        |         QUARTER(HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testReturnTypeInferenceForWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  SUM(correct) AS s,\n        |  AVG(correct) AS a,\n        |  TUMBLE_START(rowtime, INTERVAL '15' MINUTE) AS wStart\n        |FROM (\n        |  SELECT CASE a\n        |      WHEN 1 THEN 1\n        |      ELSE 99\n        |    END AS correct, rowtime\n        |  FROM MyTable\n        |)\n        |GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowAggregateWithDifferentWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH window_1h AS (\n        |    SELECT 1\n        |    FROM MyTable\n        |    GROUP BY HOP(`rowtime`, INTERVAL '1' HOUR, INTERVAL '1' HOUR)\n        |),\n        |\n        |window_2h AS (\n        |    SELECT 1\n        |    FROM MyTable\n        |    GROUP BY HOP(`rowtime`, INTERVAL '1' HOUR, INTERVAL '2' HOUR)\n        |)\n        |\n        |(SELECT * FROM window_1h)\n        |UNION ALL\n        |(SELECT * FROM window_2h)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowAggregateWithLateFire() {
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().tableConfig().setIdleStateRetention(Duration.ofHours(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateWithAllowLateness() {
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofHours(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateWithInvalidAllowLateness() {
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY(), (Object)Duration.ofSeconds(5L));
        this.util().tableConfig().set(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS(), (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}))).withMessageContaining("Allow-lateness [1000ms] should not be smaller than Late-fire delay [5000ms] when enable late-fire emit strategy.");
    }

    @Test
    public void testWindowAggregateWithAllowLatenessOnly() {
        this.util().tableConfig().setIdleStateRetention(Duration.ofHours(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM MyTable\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateOnRetractStream() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(`rowtime`, INTERVAL '1' SECOND), COUNT(*) cnt\n        |FROM  (\n        | SELECT a, b, c, rowtime\n        | FROM (\n        |   SELECT *,\n        |   ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rowNum\n        |   FROM MyTable\n        | )\n        | WHERE rowNum = 1\n        |)\n        |GROUP BY TUMBLE(`rowtime`, INTERVAL '1' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testWindowAggregateOnUpsertSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE src (\n                    |  ts AS PROCTIME(),\n                    |  a INT,\n                    |  b DOUBLE,\n                    |  PRIMARY KEY (a) NOT ENFORCED\n                    |) WITH (\n                    |  'connector' = 'values',\n                    |  'changelog-mode' = 'UA,D'\n                    |)\n      ")).stripMargin());
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '10' SECOND), COUNT(*)\n        |FROM src\n        |GROUP BY TUMBLE(ts, INTERVAL '10' SECOND)\n        |")).stripMargin();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public GroupWindowTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.GroupWindowTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |create table MyTable1 (\n                              |  a int,\n                              |  b bigint,\n                              |  c as proctime()\n                              |) with (\n                              |  'connector' = 'COLLECTION'\n                              |)\n                              |")).stripMargin());
    }
}

