/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.DistinctAggregateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ExtendWith(value={ParameterizedTestExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u000f\u001f\u0001EB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\")\u0001\n\u0001C\u0001\u0013\"9a\n\u0001b\u0001\n#y\u0005BB*\u0001A\u0003%\u0001\u000bC\u0003U\u0001\u0011\u0005Q\u000bC\u0003d\u0001\u0011\u0005Q\u000bC\u0003i\u0001\u0011\u0005Q\u000bC\u0003k\u0001\u0011\u0005Q\u000bC\u0003m\u0001\u0011\u0005Q\u000bC\u0003o\u0001\u0011\u0005Q\u000bC\u0003q\u0001\u0011\u0005Q\u000bC\u0003s\u0001\u0011\u0005Q\u000bC\u0003u\u0001\u0011\u0005Q\u000bC\u0003w\u0001\u0011\u0005Q\u000bC\u0003y\u0001\u0011\u0005Q\u000bC\u0003{\u0001\u0011\u0005Q\u000bC\u0003}\u0001\u0011\u0005Q\u000bC\u0003\u007f\u0001\u0011\u0005Q\u000b\u0003\u0004\u0002\u0002\u0001!\t!\u0016\u0005\u0007\u0003\u000b\u0001A\u0011A+\t\r\u0005%\u0001\u0001\"\u0001V\u0011\u0019\ti\u0001\u0001C\u0001+\"1\u0011\u0011\u0003\u0001\u0005\u0002U;q!a\u0010\u001f\u0011\u0003\t\tE\u0002\u0004\u001e=!\u0005\u00111\t\u0005\u0007\u0011j!\t!a\u0013\t\u000f\u00055#\u0004\"\u0001\u0002P\t)B)[:uS:\u001cG/Q4he\u0016<\u0017\r^3UKN$(BA\u0010!\u0003\r\twm\u001a\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003K\u0019\nA\u0001\u001d7b]*\u0011q\u0005K\u0001\ba2\fgN\\3s\u0015\tI#&A\u0003uC\ndWM\u0003\u0002,Y\u0005)a\r\\5oW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U2\u0013!B;uS2\u001c\u0018BA\u001c5\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\u000692\u000f\u001d7ji\u0012K7\u000f^5oGR\fumZ#oC\ndW\r\u001a\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b\u0005>|G.Z1o\u0003A\twm\u001a)iCN,WI\u001c4pe\u000e,'\u000f\u0005\u0002B\r6\t!I\u0003\u0002D\t\u000611m\u001c8gS\u001eT!!\u0012\u0015\u0002\u0007\u0005\u0004\u0018.\u0003\u0002H\u0005\n1\u0012iZ4sK\u001e\fG/\u001a)iCN,7\u000b\u001e:bi\u0016<\u00170\u0001\u0004=S:LGO\u0010\u000b\u0004\u00152k\u0005CA&\u0001\u001b\u0005q\u0002\"\u0002\u001d\u0004\u0001\u0004I\u0004\"B \u0004\u0001\u0004\u0001\u0015\u0001B;uS2,\u0012\u0001\u0015\t\u0003gEK!A\u0015\u001b\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\u0002\u000bU$\u0018\u000e\u001c\u0011\u0002\r\t,gm\u001c:f)\u00051\u0006C\u0001\u001eX\u0013\tA6H\u0001\u0003V]&$\bF\u0001\u0004[!\tY\u0016-D\u0001]\u0015\t)UL\u0003\u0002_?\u00069!.\u001e9ji\u0016\u0014(B\u00011/\u0003\u0015QWO\\5u\u0013\t\u0011GL\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;w\r\u000b\u0002\bKB\u00111LZ\u0005\u0003Or\u0013A\u0002V3tiR+W\u000e\u001d7bi\u0016\fQ\u0003^3ti6+H\u000e^5ESN$\u0018N\\2u\u0003\u001e<7\u000f\u000b\u0002\tK\u0006aB/Z:u'&tw\r\\3NCb<\u0016\u000e\u001e5ESN$\u0018N\\2u\u0003\u001e<\u0007FA\u0005f\u0003\r\"Xm\u001d;TS:<G.\u001a$jeN$h+\u00197vK^KG\u000f\u001b#jgRLgn\u0019;BO\u001eD#AC3\u0002EQ,7\u000f^*j]\u001edW\rT1tiZ\u000bG.^3XSRDG)[:uS:\u001cG/Q4hQ\tYQ-\u0001\u0011uKN$8+\u001b8hY\u0016d\u0015n\u001d;BO\u001e<\u0016\u000e\u001e5ESN$\u0018N\\2u\u0003\u001e<\u0007F\u0001\u0007f\u0003)\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5BY2tuN\u001c#jgRLgn\u0019;BO\u001eD#!D3\u0002UQ,7\u000f\u001e+x_\u0012K7\u000f^5oGR\fum\u001a:fO\u0006$XmV5uQ:{g\u000eR5ti&t7\r^!hO\"\u0012a\"Z\u0001!i\u0016\u001cHoU5oO2,G)[:uS:\u001cG/Q4h/&$\bn\u0012:pkB\u0014\u0015\u0010\u000b\u0002\u0010K\u00061D/Z:u'&tw\r\\3ESN$\u0018N\\2u\u0003\u001e<w+\u001b;i\u0003:$gj\u001c8ESN$\u0018N\\2u\u0003\u001e<wJ\\*b[\u0016\u001cu\u000e\\;n]\"\u0012\u0001#Z\u0001+i\u0016\u001cHoU8nK\u000e{G.^7og\n{G\u000f[%o\t&\u001cH/\u001b8di\u0006;w-\u00118e\u000fJ|W\u000f\u001d\"zQ\t\tR-A\fuKN$\u0018iZ4XSRDg)\u001b7uKJ\u001cE.Y;tK\"\u0012!#Z\u0001\u0012i\u0016\u001cH/T;mi&<%o\\;q\u0005f\u001c\bFA\nf\u0003\u0001\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;XSRD'+\u001a;sC\u000e$\u0018n\u001c8)\u0005Q)\u0017a\u000b;fgR\u001cV/\\\"pk:$x+\u001b;i'&tw\r\\3ESN$\u0018N\\2u\u0003:$'+\u001a;sC\u000e$\u0018n\u001c8)\u0005U)\u0017\u0001\u0007;fgRl\u0015N\\'bq^KG\u000f\u001b*fiJ\f7\r^5p]\"\u0012a#Z\u0001&i\u0016\u001cHOR5sgR4\u0016\r\\;f\u0019\u0006\u001cHOV1mk\u0016<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;j_:D#aF3\u0002AQ,7\u000f\u001e'jgR\fumZ,ji\"$\u0015n\u001d;j]\u000e$X*\u001e7uS\u0006\u0013xm\u001d\u0015\u00031\u0015Ds\u0001AA\f\u0003G\t)\u0003\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\u0002X\u0001\nKb$XM\\:j_:LA!!\t\u0002\u001c\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\u0005\u001d2EAA\u0015!\u0011\tY#a\u000f\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tQ\u0002]1sC6,G/\u001a:ju\u0016$'\u0002BA\u001a\u0003k\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\r\u0001\u0017q\u0007\u0006\u0004\u0003sQ\u0013!\u0003;fgR,H/\u001b7t\u0013\u0011\ti$!\f\u00035A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8\u0002+\u0011K7\u000f^5oGR\fum\u001a:fO\u0006$X\rV3tiB\u00111JG\n\u00045\u0005\u0015\u0003c\u0001\u001e\u0002H%\u0019\u0011\u0011J\u001e\u0003\r\u0005s\u0017PU3g)\t\t\t%\u0001\u0006qCJ\fW.\u001a;feN$\"!!\u0015\u0011\r\u0005M\u00131LA0\u001b\t\t)FC\u0002O\u0003/R!!!\u0017\u0002\t)\fg/Y\u0005\u0005\u0003;\n)F\u0001\u0006D_2dWm\u0019;j_:\u0004RAOA1\u0003KJ1!a\u0019<\u0005\u0015\t%O]1z!\rQ\u0014qM\u0005\u0004\u0003SZ$aA!os\":A$!\u001c\u0002t\u0005U\u0004\u0003BA\u0016\u0003_JA!!\u001d\u0002.\tQ\u0001+\u0019:b[\u0016$XM]:\u0002\t9\fW.Z\u0011\u0003\u0003o\n\u0011g\u001d9mSR$\u0015n\u001d;j]\u000e$\u0018iZ4F]\u0006\u0014G.\u001a3>wBjH\u0006I1hOBC\u0017m]3F]\u001a|'oY3s{m\fT\u0010")
public class DistinctAggregateTest
extends TableTestBase {
    private final boolean splitDistinctAggEnabled;
    private final AggregatePhaseStrategy aggPhaseEnforcer;
    private final StreamTableTestUtil util;

    @Parameters(name="splitDistinctAggEnabled={0}, aggPhaseEnforcer={1}")
    public static Collection<Object[]> parameters() {
        return DistinctAggregateTest$.MODULE$.parameters();
    }

    public StreamTableTestUtil util() {
        return this.util;
    }

    @BeforeEach
    public void before() {
        this.util().tableEnv().getConfig().setIdleStateRetention(Duration.ofHours(1L));
        this.util().enableMiniBatch();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggPhaseEnforcer);
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.splitDistinctAggEnabled));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_INCREMENTAL_AGG_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @TestTemplate
    public void testSingleDistinctAgg() {
        this.util().verifyExecPlan("SELECT COUNT(DISTINCT c) FROM MyTable");
    }

    @TestTemplate
    public void testMultiDistinctAggs() {
        this.util().verifyExecPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable");
    }

    @TestTemplate
    public void testSingleMaxWithDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), MAX(c)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSingleFirstValueWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, FIRST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleLastValueWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, LAST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleListAggWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, LISTAGG(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleDistinctAggWithAllNonDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT c), SUM(b), AVG(b), MAX(b), MIN(b), COUNT(b), COUNT(*)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testTwoDistinctAggregateWithNonDistinctAgg() {
        this.util().verifyExecPlan("SELECT c, SUM(DISTINCT a), SUM(a), COUNT(DISTINCT b) FROM MyTable GROUP BY c");
    }

    @TestTemplate
    public void testSingleDistinctAggWithGroupBy() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT b), SUM(b), AVG(b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM MyTable GROUP BY a");
    }

    @TestTemplate
    public void testAggWithFilterClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  SUM(b) FILTER (WHERE NOT b = 2)\n         |FROM MyTable\n         |GROUP BY a\n       ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testMultiGroupBys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @TestTemplate
    public void testSingleDistinctWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), COUNT(1)\n        |FROM (\n        |  SELECT c, AVG(a) as a, AVG(b) as b\n        |  FROM MyTable\n        |  GROUP BY c\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testSumCountWithSingleDistinctAndRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  b, SUM(b1), COUNT(DISTINCT b1), COUNT(1)\n         |FROM(\n         |   SELECT\n         |     a, COUNT(b) as b, MAX(b) as b1\n         |   FROM MyTable\n         |   GROUP BY a\n         |) GROUP BY b\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testMinMaxWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testFirstValueLastValueWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  b, FIRST_VALUE(c), LAST_VALUE(c), COUNT(DISTINCT c)\n         |FROM(\n         |  SELECT\n         |    a, COUNT(DISTINCT b) as b, MAX(b) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY b\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @TestTemplate
    public void testListAggWithDistinctMultiArgs() {
        this.util().verifyExecPlan("SELECT a, LISTAGG(DISTINCT c, '#') FROM MyTable GROUP BY a");
    }

    public DistinctAggregateTest(boolean splitDistinctAggEnabled, AggregatePhaseStrategy aggPhaseEnforcer) {
        this.splitDistinctAggEnabled = splitDistinctAggEnabled;
        this.aggPhaseEnforcer = aggPhaseEnforcer;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.DistinctAggregateTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
    }
}

