/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\u0012$\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004G\u0001\u0001\u0006Ia\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\u00065\u0002!\t\u0001\u0013\u0005\u00069\u0002!\t\u0001\u0013\u0005\u0006=\u0002!\t\u0001\u0013\u0005\u0006A\u0002!\t\u0001\u0013\u0005\u0006E\u0002!\t\u0001\u0013\u0005\u0006I\u0002!\t\u0001\u0013\u0005\u0006M\u0002!\t\u0001\u0013\u0005\u0006Q\u0002!\t\u0001\u0013\u0005\u0006U\u0002!\t\u0001\u0013\u0005\u0006Y\u0002!\t\u0001\u0013\u0005\u0006]\u0002!\t\u0001\u0013\u0005\u0006a\u0002!\t\u0001\u0013\u0005\u0006e\u0002!\t\u0001\u0013\u0005\u0006i\u0002!\t\u0001\u0013\u0005\u0006m\u0002!\t\u0001\u0013\u0005\u0006q\u0002!\t\u0001\u0013\u0005\u0006u\u0002!\t\u0001\u0013\u0005\u0006y\u0002!\t\u0001\u0013\u0005\u0006}\u0002!\t\u0001\u0013\u0005\u0007\u0003\u0003\u0001A\u0011\u0001%\t\r\u0005\u0015\u0001\u0001\"\u0001I\u0011\u0019\tI\u0001\u0001C\u0001\u0011\"1\u0011Q\u0002\u0001\u0005\u0002!Ca!!\u0005\u0001\t\u0003A\u0005BBA\u000b\u0001\u0011\u0005\u0001\n\u0003\u0004\u0002\u001a\u0001!\t\u0001\u0013\u0005\u0007\u0003;\u0001A\u0011\u0001%\t\r\u0005\u0005\u0002\u0001\"\u0001I\u0011\u0019\t)\u0003\u0001C\u0001\u0011\ni\u0011iZ4sK\u001e\fG/\u001a+fgRT!\u0001J\u0013\u0002\u0007\u0005<wM\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013AB:ue\u0016\fWN\u0003\u0002+W\u0005!\u0001\u000f\\1o\u0015\taS&A\u0004qY\u0006tg.\u001a:\u000b\u00059z\u0013!\u0002;bE2,'B\u0001\u00192\u0003\u00151G.\u001b8l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u-\nQ!\u001e;jYNL!\u0001P\u001d\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tq\b\u0005\u0002A\u00015\t1%\u0001\u0003vi&dW#A\"\u0011\u0005a\"\u0015BA#:\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0003\u0015)H/\u001b7!\u0003y!Xm\u001d;He>,\b/\u001b8h\u001f:tuN\\#ySN$XM\u001c;GS\u0016dG\rF\u0001J!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0011)f.\u001b;)\u0005\u0011\u0001\u0006CA)Y\u001b\u0005\u0011&BA*U\u0003\r\t\u0007/\u001b\u0006\u0003+Z\u000bqA[;qSR,'O\u0003\u0002Xg\u0005)!.\u001e8ji&\u0011\u0011L\u0015\u0002\u0005)\u0016\u001cH/\u0001\u000fuKN$xI]8va&tw-\u00138wC2LGmU3mK\u000e$\u0018n\u001c8)\u0005\u0015\u0001\u0016\u0001\b;fgR\u001c\u0015M\u001c8pi\u000e{WO\u001c;P]6+H\u000e^5GS\u0016dGm\u001d\u0015\u0003\rA\u000bA\u0003^3ti\u0006;wmV5uQ6Kg.\u001b\"bi\u000eD\u0007FA\u0004Q\u0003%\"Xm\u001d;NS:L')\u0019;dQ\u0006;wmV5uQ:+w-\u0019;jm\u0016l\u0015N\\5CCR\u001c\u0007nU5{K\"\u0012\u0001\u0002U\u0001\u001fi\u0016\u001cH/Q4h\u0003\u001a$XM]+oS>tw+\u001b;i\u001b&t\u0017NQ1uG\"D#!\u0003)\u00021Q,7\u000f^$s_V\u0004()_,ji\"|W\u000f^,j]\u0012|w\u000f\u000b\u0002\u000b!\u0006aB/Z:u\u0019>\u001c\u0017\r\\$m_\n\fG.Q4h\u0003\u001a$XM]+oS>t\u0007FA\u0006Q\u0003]!Xm\u001d;BO\u001e<\u0016\u000e\u001e5GS2$XM]\"mCV\u001cX\r\u000b\u0002\r!\u00061C/Z:u\u0003\u001e<w+\u001b;i\r&dG/\u001a:DY\u0006,8/Z,ji\"dunY1m\u000f2|'-\u00197)\u00055\u0001\u0016a\u0006;fgR\fumZ(o\t&4g-\u001a:f]R$\u0016\u0010]3tQ\tq\u0001+A\fuKN$\u0018I^4P]\u0012KgMZ3sK:$H+\u001f9fg\"\u0012q\u0002U\u0001\u0013i\u0016\u001cH/\u0011<h/&$\bNU3ue\u0006\u001cG\u000f\u000b\u0002\u0011!\u00069A/Z:u'Vl\u0007FA\tQ\u0003I!Xm\u001d;Tk6<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;)\u0005I\u0001\u0016a\u0006;fgRl\u0015N\\(o\t&4g-\u001a:f]R$\u0016\u0010]3tQ\t\u0019\u0002+\u0001\nuKN$X*\u001b8XSRD'+\u001a;sC\u000e$\bF\u0001\u000bQ\u0003]!Xm\u001d;NCb|e\u000eR5gM\u0016\u0014XM\u001c;UsB,7\u000f\u000b\u0002\u0016!\u0006\u0011B/Z:u\u001b\u0006Dx+\u001b;i%\u0016$(/Y2uQ\t1\u0002+\u0001\u000euKN$xI]8va\nKx+\u001b;i\u0007>t7\u000f^1oi.+\u0017\u0010\u000b\u0002\u0018!\u0006aB/Z:u\u0007>dW/\u001c8J]R,'O^1m-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\rQ\u0003\u0011\"Xm\u001d;GS2$XM]3e\u0007>dW/\u001c8J]R,'O^1m-\u0006d\u0017\u000eZ1uS>t\u0007FA\rQ\u0003i!Xm\u001d;He>,\boS3z\u001d>$X*\u0019;dQNKgn\u001b)lQ\tQ\u0002+\u0001\u000buKN$xI]8va.+\u00170\u00138TS:\\\u0007k\u001b\u0015\u00037A\u000ba\u0005^3ti\u001e\u0013x.\u001e9SKN,H\u000e\u001e'pgR,\u0006o]3si.+\u0017pV5uQNKgn\u001b)lQ\ta\u0002+\u0001\u000fuKN$\u0018\t\u001d9s_bLW.\u0019;f\u0007>,h\u000e\u001e#jgRLgn\u0019;)\u0005u\u0001\u0016A\u0004;fgR\u001cu.\u001e8u'R\f'\u000f\u001e\u0015\u0003=A\u000b!\u0004^3ti\u000e{WO\u001c;Ti\u0006\u0014HoV5uQ6+G/\u00193bi\u0006D#a\b)\u0002=Q,7\u000f^\"pk:$8\u000b^1si^KG\u000f['fi\u0006$\u0017\r^1P]2L\bF\u0001\u0011Q\u0003m!Xm\u001d;D_VtGo\u0015;beR<\u0016\u000e\u001e5OKN$X\r\u001a*po\"\u0012\u0011\u0005\u0015")
public class AggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingOnNonExistentField() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT COUNT(*) FROM MyTable GROUP BY foo"));
    }

    @Test
    public void testGroupingInvalidSelection() {
        Assertions.assertThatExceptionOfType(ValidationException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT b FROM MyTable GROUP BY a"));
    }

    @Test
    public void testCannotCountOnMultiFields() {
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExecPlan("SELECT COUNT(a, c) FROM MyTable GROUP BY b")).hasMessageContaining("We now only support the count of one field") instanceof TableException;
    }

    @Test
    public void testAggWithMiniBatch() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)5000L));
        this.util().verifyExplain("SELECT b, COUNT(DISTINCT a), MAX(b), SUM(c) FROM MyTable GROUP BY b");
    }

    @Test
    public void testMiniBatchAggWithNegativeMiniBatchSize() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = "SELECT b, COUNT(DISTINCT a), MAX(b), SUM(c) FROM MyTable GROUP BY b";
        boolean cfr_ignored_0 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
        this.util().tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)-500L));
        boolean cfr_ignored_1 = Assertions.assertThatThrownBy(() -> this.util().verifyExplain(sql)).hasMessage("Key: 'table.exec.mini-batch.size' , default: -1 (fallback keys: []) must be > 0.") instanceof IllegalArgumentException;
    }

    @Test
    public void testAggAfterUnionWithMiniBatch() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, sum(b), count(distinct c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(query);
    }

    @Test
    public void testGroupByWithoutWindow() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testLocalGlobalAggAfterUnion() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b), COUNT(DISTINCT c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClause() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClauseWithLocalGlobal() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  COUNT(DISTINCT c) FILTER (WHERE b = 1),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggOnDifferentTypes() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(CAST(1 as INT)),\n        |  SUM(CAST(2 as BIGINT)),\n        |  SUM(CAST(3 as TINYINT)),\n        |  SUM(CAST(4 as SMALLINT)),\n        |  SUM(CAST(5 as FLOAT)),\n        |  SUM(CAST(6 as DECIMAL)),\n        |  SUM(CAST(7 as DOUBLE))\n        |FROM T GROUP BY a\n    ")).stripMargin();
        this.util().verifyRelPlanWithType(sql);
    }

    @Test
    public void testAvgOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT AVG(`byte`),\n                                 |       AVG(`short`),\n                                 |       AVG(`int`),\n                                 |       AVG(`long`),\n                                 |       AVG(`float`),\n                                 |       AVG(`double`),\n                                 |       AVG(`decimal3020`),\n                                 |       AVG(`decimal105`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testAvgWithRetract() {
        this.util().verifyRelPlan("SELECT AVG(a) FROM (SELECT AVG(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSum() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT SUM(`byte`),\n                                 |       SUM(`short`),\n                                 |       SUM(`int`),\n                                 |       SUM(`long`),\n                                 |       SUM(`float`),\n                                 |       SUM(`double`),\n                                 |       SUM(`decimal3020`),\n                                 |       SUM(`decimal105`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testSumWithRetract() {
        this.util().verifyRelPlan("SELECT SUM(a) FROM (SELECT SUM(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MIN(`byte`),\n                                 |       MIN(`short`),\n                                 |       MIN(`int`),\n                                 |       MIN(`long`),\n                                 |       MIN(`float`),\n                                 |       MIN(`double`),\n                                 |       MIN(`decimal3020`),\n                                 |       MIN(`decimal105`),\n                                 |       MIN(`boolean`),\n                                 |       MIN(`date`),\n                                 |       MIN(`time`),\n                                 |       MIN(`timestamp`),\n                                 |       MIN(`string`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMinWithRetract() {
        this.util().verifyRelPlan("SELECT MIN(a) FROM (SELECT MIN(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMaxOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MAX(`byte`),\n                                 |       MAX(`short`),\n                                 |       MAX(`int`),\n                                 |       MAX(`long`),\n                                 |       MAX(`float`),\n                                 |       MAX(`double`),\n                                 |       MAX(`decimal3020`),\n                                 |       MAX(`decimal105`),\n                                 |       MAX(`boolean`),\n                                 |       MAX(`date`),\n                                 |       MAX(`time`),\n                                 |       MAX(`timestamp`),\n                                 |       MAX(`string`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMaxWithRetract() {
        this.util().verifyRelPlan("SELECT MAX(a) FROM (SELECT MAX(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupByWithConstantKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, MAX(b), c FROM (SELECT a, 'test' AS c, b FROM T) t GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testColumnIntervalValidation() {
        this.util().verifyExecPlan("SELECT b, SUM(a) FROM MyTable WHERE a > 0.1 and a < 10 GROUP BY b");
    }

    @Test
    public void testFilteredColumnIntervalValidation() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                           |SELECT\n                           |  SUM(uv) FILTER (WHERE c = 'all') AS all_uv\n                           |FROM (\n                           |  SELECT\n                           |    c, COUNT(1) AS uv\n                           |  FROM T\n                           |  GROUP BY c\n                           |) t\n                           |")).stripMargin());
    }

    @Test
    public void testGroupKeyNotMatchSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | id VARCHAR,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (cnt) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT c, COUNT(*) cnt FROM T GROUP BY c\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupKeyInSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | a INT,\n                               | b BIGINT,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (a, b) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT a, MAX(b) b, COUNT(*) cnt FROM T GROUP BY a\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupResultLostUpsertKeyWithSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | id VARCHAR,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (id) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT c, COUNT(*) cnt FROM T GROUP BY a, c\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testApproximateCountDistinct() {
        Assertions.assertThatExceptionOfType(TableException.class).isThrownBy(() -> this.util().verifyExecPlan("SELECT APPROX_COUNT_DISTINCT(b) FROM MyTable"));
    }

    @Test
    public void testCountStart() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithMetadata() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithMetadataOnly() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR METADATA,\n                               | cnt BIGINT METADATA\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING,id:STRING,cnt:BIGINT'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithNestedRow() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | nested row<name string, `value` int>,\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    public AggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$1 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$1 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$3 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$5 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$7 org.apache.flink.api.common.typeutils.TypeSerializer[] org.apache.flink.api.common.serialization.SerializerConfig int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (AbstractDataType[])((Object[])new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.DATE(), DataTypes.TIME((int)0), DataTypes.TIMESTAMP((int)3), DataTypes.DECIMAL((int)30, (int)20), DataTypes.DECIMAL((int)10, (int)5)}), (String[])((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "string", "date", "time", "timestamp", "decimal3020", "decimal105"}));
    }
}

